/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.plane.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import de.maxhenkel.plane.corelib.inventory.ScreenBase;
import de.maxhenkel.plane.corelib.math.MathUtils;
import de.maxhenkel.plane.entity.EntityPlaneSoundBase;
import de.maxhenkel.plane.gui.ContainerPlane;
import java.util.ArrayList;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class PlaneScreen
extends ScreenBase<ContainerPlane> {
    private static final ResourceLocation CAR_GUI_TEXTURE = new ResourceLocation("plane", "textures/gui/gui_plane.png");
    private static final ITextComponent TEXT_FUEL = new TranslationTextComponent("gui.plane.fuel");
    private static final ITextComponent TEXT_DAMAGE = new TranslationTextComponent("gui.plane.damage");
    private static final ITextComponent TEXT_ENGINE = new TranslationTextComponent("gui.plane.throttle");
    private PlayerInventory playerInv;
    private EntityPlaneSoundBase plane;

    public PlaneScreen(ContainerPlane containerCar, PlayerInventory playerInv, ITextComponent title) {
        super(CAR_GUI_TEXTURE, containerCar, playerInv, title);
        this.playerInv = playerInv;
        this.plane = containerCar.getPlane();
        this.field_146999_f = 176;
        this.field_147000_g = 222;
    }

    @Override
    protected void func_230451_b_(MatrixStack matrixStack, int mouseX, int mouseY) {
        ArrayList<IReorderingProcessor> list;
        super.func_230451_b_(matrixStack, mouseX, mouseY);
        this.field_230712_o_.func_238422_b_(matrixStack, this.plane.func_200200_C_().func_241878_f(), 7.0f, 61.0f, 0x404040);
        this.field_230712_o_.func_238422_b_(matrixStack, this.playerInv.func_145748_c_().func_241878_f(), 8.0f, (float)(this.field_147000_g - 96 + 2), 0x404040);
        this.field_230712_o_.func_238422_b_(matrixStack, TEXT_FUEL.func_241878_f(), 7.0f, 9.0f, 0x404040);
        this.field_230712_o_.func_238422_b_(matrixStack, TEXT_DAMAGE.func_241878_f(), 95.0f, 9.0f, 0x404040);
        this.field_230712_o_.func_238422_b_(matrixStack, TEXT_ENGINE.func_241878_f(), 7.0f, 35.0f, 0x404040);
        if (mouseX >= this.field_147003_i + 8 && mouseX < this.field_147003_i + 80 && mouseY >= this.field_147009_r + 20 && mouseY < this.field_147009_r + 30) {
            list = new ArrayList<IReorderingProcessor>();
            list.add(new TranslationTextComponent("tooltip.plane.fuel", new Object[]{String.valueOf(this.plane.getFuel())}).func_241878_f());
            this.func_238654_b_(matrixStack, list, mouseX - this.field_147003_i, mouseY - this.field_147009_r);
        }
        if (mouseX >= this.field_147003_i + 96 && mouseX < this.field_147003_i + 168 && mouseY >= this.field_147009_r + 20 && mouseY < this.field_147009_r + 30) {
            list = new ArrayList();
            list.add(new TranslationTextComponent("tooltip.plane.damage", new Object[]{String.valueOf(MathUtils.round(this.plane.getPlaneDamage(), 2))}).func_241878_f());
            this.func_238654_b_(matrixStack, list, mouseX - this.field_147003_i, mouseY - this.field_147009_r);
        }
        if (mouseX >= this.field_147003_i + 8 && mouseX < this.field_147003_i + 80 && mouseY >= this.field_147009_r + 46 && mouseY < this.field_147009_r + 56) {
            list = new ArrayList();
            list.add(new TranslationTextComponent("tooltip.plane.throttle", new Object[]{String.valueOf(Math.round(this.plane.getEngineSpeed() * 100.0f))}).func_241878_f());
            this.func_238654_b_(matrixStack, list, mouseX - this.field_147003_i, mouseY - this.field_147009_r);
        }
    }

    @Override
    protected void func_230450_a_(MatrixStack matrixStack, float partialTicks, int mouseX, int mouseY) {
        super.func_230450_a_(matrixStack, partialTicks, mouseX, mouseY);
        this.drawFuel(matrixStack, (float)this.plane.getFuel() / (float)this.plane.getMaxFuel());
        this.drawDamage(matrixStack, (100.0f - Math.min(this.plane.getPlaneDamage(), 100.0f)) / 100.0f);
        this.drawThrottle(matrixStack, this.plane.getEngineSpeed());
    }

    public void drawFuel(MatrixStack matrixStack, float percent) {
        int scaled = (int)(72.0f * percent);
        int i = this.field_147003_i;
        int j = this.field_147009_r;
        this.func_238474_b_(matrixStack, i + 8, j + 20, 176, 0, scaled, 10);
    }

    public void drawThrottle(MatrixStack matrixStack, float percent) {
        int scaled = (int)(72.0f * percent);
        int i = this.field_147003_i;
        int j = this.field_147009_r;
        this.func_238474_b_(matrixStack, i + 8, j + 46, 176, 10, scaled, 10);
    }

    public void drawDamage(MatrixStack matrixStack, float percent) {
        int scaled = (int)(72.0f * percent);
        int i = this.field_147003_i;
        int j = this.field_147009_r;
        this.func_238474_b_(matrixStack, i + 96, j + 20, 176, 20, scaled, 10);
    }
}

