/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.plane;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.fluid.Fluid;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.commons.lang3.tuple.Pair;

public class Config {
    public static ForgeConfigSpec.ConfigValue<List<? extends String>> VALID_FUELS;
    public static List<Fluid> VALID_FUEL_LIST;
    public static ForgeConfigSpec.BooleanValue SHOW_PLANE_INFO;
    public static ForgeConfigSpec.DoubleValue PLANE_INFO_SCALE;
    public static ForgeConfigSpec.EnumValue<SpeedType> PLANE_INFO_SPEED_TYPE;
    public static final ServerConfig SERVER;
    public static final ForgeConfigSpec SERVER_SPEC;
    public static final ClientConfig CLIENT;
    public static final ForgeConfigSpec CLIENT_SPEC;

    public static void loadServer() {
        VALID_FUEL_LIST = ((List)VALID_FUELS.get()).stream().map(ResourceLocation::new).map(arg_0 -> ((IForgeRegistry)ForgeRegistries.FLUIDS).getValue(arg_0)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    static {
        VALID_FUEL_LIST = new ArrayList<Fluid>();
        Pair specPairServer = new ForgeConfigSpec.Builder().configure(ServerConfig::new);
        SERVER_SPEC = (ForgeConfigSpec)specPairServer.getRight();
        SERVER = (ServerConfig)specPairServer.getLeft();
        Pair specPairClient = new ForgeConfigSpec.Builder().configure(ClientConfig::new);
        CLIENT_SPEC = (ForgeConfigSpec)specPairClient.getRight();
        CLIENT = (ClientConfig)specPairClient.getLeft();
    }

    public static enum SpeedType {
        KILOMETERS_PER_HOUR("plane.speedtype.kmh", bpt -> bpt * 20.0 * 60.0 * 60.0 / 1000.0),
        BLOCKS_PER_SECOND("plane.speedtype.bps", bpt -> bpt * 20.0);

        private String translationKey;
        private Function<Double, Double> converterFunction;

        private SpeedType(String translationKey, Function<Double, Double> converterFunction) {
            this.translationKey = translationKey;
            this.converterFunction = converterFunction;
        }

        public ITextComponent getTextComponent(double bpt) {
            return new TranslationTextComponent(this.translationKey, new Object[]{Math.round(this.converterFunction.apply(bpt))});
        }
    }

    public static class ClientConfig {
        public ClientConfig(ForgeConfigSpec.Builder builder) {
            SHOW_PLANE_INFO = builder.define("plane_info.enabled", true);
            PLANE_INFO_SCALE = builder.defineInRange("plane_info.scale", 0.75, 0.1, 2.0);
            PLANE_INFO_SPEED_TYPE = builder.defineEnum("plane_info.speed_type", (Enum)SpeedType.KILOMETERS_PER_HOUR);
        }
    }

    public static class ServerConfig {
        public ServerConfig(ForgeConfigSpec.Builder builder) {
            VALID_FUELS = builder.defineList("valid_fuels", Arrays.asList("car:bio_diesel"), Objects::nonNull);
        }
    }
}

