/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.plane;

import de.maxhenkel.plane.Config;
import de.maxhenkel.plane.entity.EntityBushPlane;
import de.maxhenkel.plane.entity.EntityCargoPlane;
import de.maxhenkel.plane.entity.EntityPlane;
import de.maxhenkel.plane.entity.EntityPlaneSoundBase;
import de.maxhenkel.plane.entity.render.BushPlaneModel;
import de.maxhenkel.plane.entity.render.CargoPlaneModel;
import de.maxhenkel.plane.entity.render.PlaneModel;
import de.maxhenkel.plane.events.CapabilityEvents;
import de.maxhenkel.plane.events.InteractEvents;
import de.maxhenkel.plane.events.KeyEvents;
import de.maxhenkel.plane.events.RenderEvents;
import de.maxhenkel.plane.gui.ContainerPlane;
import de.maxhenkel.plane.gui.GuiPlane;
import de.maxhenkel.plane.integration.waila.PluginPlane;
import de.maxhenkel.plane.item.ModItems;
import de.maxhenkel.plane.loottable.CopyPlaneData;
import de.maxhenkel.plane.net.MessageControlPlane;
import de.maxhenkel.plane.net.MessagePlaneGui;
import de.maxhenkel.plane.sound.ModSounds;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.functions.ILootFunction;
import net.minecraft.world.storage.loot.functions.LootFunctionManager;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.network.IContainerFactory;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod(value="plane")
public class Main {
    public static final String MODID = "plane";
    public static SimpleChannel SIMPLE_CHANNEL;
    public static EntityType<EntityPlane> PLANE_ENTITY_TYPE;
    public static EntityType<EntityCargoPlane> CARGO_PLANE_ENTITY_TYPE;
    public static EntityType<EntityBushPlane> BUSH_PLANE_ENTITY_TYPE;
    public static KeyBinding PLANE_KEY;
    public static KeyBinding FORWARD_KEY;
    public static KeyBinding BACK_KEY;
    public static KeyBinding LEFT_KEY;
    public static KeyBinding RIGHT_KEY;
    public static KeyBinding UP_KEY;
    public static KeyBinding DOWN_KEY;
    public static KeyBinding START_KEY;
    public static KeyBinding BRAKE_KEY;
    public static ContainerType<ContainerPlane> PLANE_CONTAINER_TYPE;

    public Main() {
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(Item.class, this::registerItems);
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(Block.class, this::registerBlocks);
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(SoundEvent.class, this::registerSounds);
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(EntityType.class, this::registerEntities);
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(ContainerType.class, this::registerContainers);
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(TileEntityType.class, this::registerTileEntities);
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(IRecipeSerializer.class, this::registerRecipes);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::commonSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::configEvent);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, Config.SERVER_SPEC);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, Config.CLIENT_SPEC);
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> this.clientStart());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clientStart() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::clientSetup);
    }

    @SubscribeEvent
    public void configEvent(ModConfig.ModConfigEvent event) {
        if (event.getConfig().getType() == ModConfig.Type.SERVER) {
            Config.loadServer();
        }
    }

    @SubscribeEvent
    public void commonSetup(FMLCommonSetupEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)new InteractEvents());
        MinecraftForge.EVENT_BUS.register((Object)new CapabilityEvents());
        LootFunctionManager.func_186582_a((ILootFunction.Serializer)new CopyPlaneData.Serializer());
        SIMPLE_CHANNEL = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation(MODID, "default"), () -> "1.0.0", s -> true, s -> true);
        SIMPLE_CHANNEL.registerMessage(0, MessageControlPlane.class, (msg, buf) -> msg.toBytes((PacketBuffer)buf), buf -> new MessageControlPlane().fromBytes((PacketBuffer)buf), (msg, fun) -> msg.executeServerSide((NetworkEvent.Context)fun.get()));
        SIMPLE_CHANNEL.registerMessage(1, MessagePlaneGui.class, (msg, buf) -> msg.toBytes((PacketBuffer)buf), buf -> new MessagePlaneGui().fromBytes((PacketBuffer)buf), (msg, fun) -> msg.executeServerSide((NetworkEvent.Context)fun.get()));
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void clientSetup(FMLClientSetupEvent event) {
        ScreenManager.IScreenFactory factory = (container, playerInventory, name) -> new GuiPlane((ContainerPlane)container, playerInventory, name);
        ScreenManager.func_216911_a(PLANE_CONTAINER_TYPE, (ScreenManager.IScreenFactory)factory);
        PLANE_KEY = new KeyBinding("key.plane", 80, "category.plane");
        ClientRegistry.registerKeyBinding((KeyBinding)PLANE_KEY);
        FORWARD_KEY = new KeyBinding("key.plane_add_thrust", 73, "category.plane");
        ClientRegistry.registerKeyBinding((KeyBinding)FORWARD_KEY);
        BACK_KEY = new KeyBinding("key.plane_remove_thrust", 75, "category.plane");
        ClientRegistry.registerKeyBinding((KeyBinding)BACK_KEY);
        LEFT_KEY = new KeyBinding("key.plane_left", 65, "category.plane");
        ClientRegistry.registerKeyBinding((KeyBinding)LEFT_KEY);
        RIGHT_KEY = new KeyBinding("key.plane_right", 68, "category.plane");
        ClientRegistry.registerKeyBinding((KeyBinding)RIGHT_KEY);
        UP_KEY = new KeyBinding("key.plane_up", 83, "category.plane");
        ClientRegistry.registerKeyBinding((KeyBinding)UP_KEY);
        DOWN_KEY = new KeyBinding("key.plane_down", 87, "category.plane");
        ClientRegistry.registerKeyBinding((KeyBinding)DOWN_KEY);
        START_KEY = new KeyBinding("key.plane_start", 82, "category.plane");
        ClientRegistry.registerKeyBinding((KeyBinding)START_KEY);
        BRAKE_KEY = new KeyBinding("key.plane_brake", 66, "category.plane");
        ClientRegistry.registerKeyBinding((KeyBinding)BRAKE_KEY);
        MinecraftForge.EVENT_BUS.register((Object)new KeyEvents());
        MinecraftForge.EVENT_BUS.register((Object)new RenderEvents());
        try {
            Class.forName("mcp.mobius.waila.api.event.WailaRenderEvent");
            MinecraftForge.EVENT_BUS.register((Object)new PluginPlane());
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        RenderingRegistry.registerEntityRenderingHandler(PLANE_ENTITY_TYPE, manager -> new PlaneModel(manager));
        RenderingRegistry.registerEntityRenderingHandler(CARGO_PLANE_ENTITY_TYPE, manager -> new CargoPlaneModel(manager));
        RenderingRegistry.registerEntityRenderingHandler(BUSH_PLANE_ENTITY_TYPE, manager -> new BushPlaneModel(manager));
    }

    @SubscribeEvent
    public void registerItems(RegistryEvent.Register<Item> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])ModItems.PLANES);
        event.getRegistry().registerAll((IForgeRegistryEntry[])ModItems.CARGO_PLANES);
        event.getRegistry().registerAll((IForgeRegistryEntry[])ModItems.BUSH_PLANES);
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Item[]{ModItems.WRENCH, ModItems.PLANE_WHEEL, ModItems.PLANE_ENGINE});
    }

    @SubscribeEvent
    public void registerBlocks(RegistryEvent.Register<Block> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Block[0]);
    }

    @SubscribeEvent
    public void registerSounds(RegistryEvent.Register<SoundEvent> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])ModSounds.getAll().toArray(new SoundEvent[0]));
    }

    @SubscribeEvent
    public void registerEntities(RegistryEvent.Register<EntityType<?>> event) {
        PLANE_ENTITY_TYPE = EntityType.Builder.func_220322_a(EntityPlane::new, (EntityClassification)EntityClassification.MISC).setTrackingRange(256).setUpdateInterval(1).setShouldReceiveVelocityUpdates(true).func_220321_a(3.5f, 2.0f).setCustomClientFactory((spawnEntity, world) -> new EntityPlane((World)world)).func_206830_a("plane:plane");
        PLANE_ENTITY_TYPE.setRegistryName(new ResourceLocation(MODID, MODID));
        event.getRegistry().register(PLANE_ENTITY_TYPE);
        CARGO_PLANE_ENTITY_TYPE = EntityType.Builder.func_220322_a(EntityCargoPlane::new, (EntityClassification)EntityClassification.MISC).setTrackingRange(256).setUpdateInterval(1).setShouldReceiveVelocityUpdates(true).func_220321_a(3.5f, 2.0f).setCustomClientFactory((spawnEntity, world) -> new EntityCargoPlane((World)world)).func_206830_a("plane:cargo_plane");
        CARGO_PLANE_ENTITY_TYPE.setRegistryName(new ResourceLocation(MODID, "cargo_plane"));
        event.getRegistry().register(CARGO_PLANE_ENTITY_TYPE);
        BUSH_PLANE_ENTITY_TYPE = EntityType.Builder.func_220322_a(EntityBushPlane::new, (EntityClassification)EntityClassification.MISC).setTrackingRange(256).setUpdateInterval(1).setShouldReceiveVelocityUpdates(true).func_220321_a(3.5f, 2.0f).setCustomClientFactory((spawnEntity, world) -> new EntityBushPlane((World)world)).func_206830_a("plane:bush_plane");
        BUSH_PLANE_ENTITY_TYPE.setRegistryName(new ResourceLocation(MODID, "bush_plane"));
        event.getRegistry().register(BUSH_PLANE_ENTITY_TYPE);
    }

    @SubscribeEvent
    public void registerContainers(RegistryEvent.Register<ContainerType<?>> event) {
        PLANE_CONTAINER_TYPE = new ContainerType((ContainerType.IFactory)((IContainerFactory)(windowId, inv, data) -> {
            EntityPlaneSoundBase plane = Main.getPlaneByUUID(inv.field_70458_d, data.func_179253_g());
            if (plane == null) {
                return null;
            }
            return new ContainerPlane(windowId, plane, inv);
        }));
        PLANE_CONTAINER_TYPE.setRegistryName(new ResourceLocation(MODID, MODID));
        event.getRegistry().register(PLANE_CONTAINER_TYPE);
    }

    @Nullable
    public static EntityPlaneSoundBase getPlaneByUUID(PlayerEntity player, UUID uuid) {
        double distance = 10.0;
        return player.field_70170_p.func_175647_a(EntityPlaneSoundBase.class, new AxisAlignedBB(player.func_226277_ct_() - distance, player.func_226278_cu_() - distance, player.func_226281_cx_() - distance, player.func_226277_ct_() + distance, player.func_226278_cu_() + distance, player.func_226281_cx_() + distance), entity -> entity.func_110124_au().equals(uuid)).stream().findAny().orElse(null);
    }

    @SubscribeEvent
    public void registerTileEntities(RegistryEvent.Register<TileEntityType<?>> event) {
    }

    @SubscribeEvent
    public void registerRecipes(RegistryEvent.Register<IRecipeSerializer<?>> event) {
    }
}

