/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.plane.entity;

import de.maxhenkel.plane.Main;
import de.maxhenkel.plane.entity.EntityPlaneSoundBase;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class EntityBushPlane
extends EntityPlaneSoundBase {
    private static final DataParameter<Integer> TYPE = EntityDataManager.func_187226_a(EntityBushPlane.class, (IDataSerializer)DataSerializers.field_187192_b);

    public EntityBushPlane(World world) {
        this(Main.BUSH_PLANE_ENTITY_TYPE, world);
    }

    public EntityBushPlane(EntityType<?> type, World world) {
        super(type, world);
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74778_a("Type", this.getPlaneType().getTypeName());
    }

    @Override
    public float getPlayerScaleFactor() {
        return 0.8f;
    }

    @Override
    protected boolean isStalling(Vec3d motionVector) {
        return motionVector.func_216372_d(1.0, 0.0, 1.0).func_72433_c() < -motionVector.field_72448_b;
    }

    @Override
    public void openGUI(PlayerEntity player, boolean outside) {
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setPlaneType(Type.fromTypeName(compound.func_74779_i("Type")));
    }

    @Override
    public ResourceLocation getLootTable() {
        return new ResourceLocation("plane", "entities/bush_plane_" + this.getPlaneType().getTypeName());
    }

    @Override
    public float getMaxFuelUsage() {
        return 5.0f;
    }

    @Override
    public int getMaxFuel() {
        return 2000;
    }

    @Override
    public double getFallSpeed() {
        return 0.08;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(TYPE, (Object)0);
    }

    @Override
    public Vec3d[] getPlayerOffsets() {
        return new Vec3d[]{new Vec3d(0.0, 0.0, 0.5)};
    }

    public Type getPlaneType() {
        return Type.values()[(Integer)this.field_70180_af.func_187225_a(TYPE)];
    }

    public void setPlaneType(Type type) {
        this.field_70180_af.func_187227_b(TYPE, (Object)type.ordinal());
    }

    public static enum Type {
        OAK("oak"),
        SPRUCE("spruce"),
        BIRCH("birch"),
        JUNGLE("jungle"),
        ACACIA("acacia"),
        DARK_OAK("dark_oak");

        private String name;

        private Type(String name) {
            this.name = name;
        }

        public String getTypeName() {
            return this.name;
        }

        public static Type fromTypeName(String name) {
            for (Type type : Type.values()) {
                if (!type.getTypeName().equals(name)) continue;
                return type;
            }
            return OAK;
        }
    }
}

