/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.plane.entity;

import de.maxhenkel.plane.Config;
import de.maxhenkel.plane.entity.EntityPlaneControlBase;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityType;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.registries.ForgeRegistries;

public abstract class EntityPlaneFuelBase
extends EntityPlaneControlBase
implements IFluidHandler {
    private static final DataParameter<Integer> FUEL = EntityDataManager.func_187226_a(EntityPlaneControlBase.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<String> FUEL_TYPE = EntityDataManager.func_187226_a(EntityPlaneControlBase.class, (IDataSerializer)DataSerializers.field_187194_d);

    public EntityPlaneFuelBase(EntityType type, World worldIn) {
        super(type, worldIn);
    }

    public abstract float getMaxFuelUsage();

    public abstract int getMaxFuel();

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        this.fuelTick();
    }

    public void fuelTick() {
        if (!this.isStarted()) {
            return;
        }
        if (this.field_70170_p.func_82737_E() % 20L == 0L) {
            int consumeAmount = Math.max((int)Math.ceil(this.getEngineSpeed() * this.getMaxFuelUsage()), 1);
            this.setFuel(Math.max(this.getFuel() - consumeAmount, 0));
        }
    }

    @Override
    public boolean canEngineBeStarted() {
        if (this.getFuel() <= 0) {
            return false;
        }
        return super.canEngineBeStarted();
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(FUEL, (Object)0);
        this.field_70180_af.func_187214_a(FUEL_TYPE, (Object)"");
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setFuel(compound.func_74762_e("Fuel"));
        this.setFuelType(compound.func_74779_i("FuelType"));
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("Fuel", this.getFuel());
        Fluid fuel = this.getFuelType();
        compound.func_74778_a("FuelType", fuel == null ? "" : fuel.getRegistryName().toString());
    }

    @Nullable
    public Fluid getFuelType() {
        String type = (String)this.field_70180_af.func_187225_a(FUEL_TYPE);
        if (type.isEmpty()) {
            return null;
        }
        return (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(type));
    }

    public void setFuelType(Fluid fluid) {
        this.setFuelType(fluid.getRegistryName().toString());
    }

    public void setFuelType(String fluid) {
        this.field_70180_af.func_187227_b(FUEL_TYPE, (Object)fluid);
    }

    public int getFuel() {
        return (Integer)this.field_70180_af.func_187225_a(FUEL);
    }

    public void setFuel(int fuel) {
        this.field_70180_af.func_187227_b(FUEL, (Object)fuel);
    }

    public boolean isValidFuel(FluidStack fluid) {
        return Config.VALID_FUEL_LIST.contains(fluid.getFluid());
    }

    public int getTanks() {
        return 1;
    }

    @Nonnull
    public FluidStack getFluidInTank(int tank) {
        Fluid fluid = this.getFuelType();
        return new FluidStack(fluid == null ? Fluids.field_204541_a : fluid, this.getFuel());
    }

    public int getTankCapacity(int tank) {
        return this.getMaxFuel();
    }

    public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
        return this.isValidFuel(stack);
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        if (resource == null || !this.isValidFuel(resource)) {
            return 0;
        }
        Fluid fluid = this.getFuelType();
        if (fluid != null && this.getFuel() > 0 && !resource.getFluid().equals(fluid)) {
            return 0;
        }
        int amount = Math.min(resource.getAmount(), this.getMaxFuel() - this.getFuel());
        if (action.execute()) {
            int i = this.getFuel() + amount;
            if (i > this.getMaxFuel()) {
                i = this.getMaxFuel();
            }
            this.setFuel(i);
            this.setFuelType(resource.getFluid());
        }
        return amount;
    }

    @Nonnull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        return FluidStack.EMPTY;
    }

    @Nonnull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        return FluidStack.EMPTY;
    }
}

