/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.plane.entity;

import de.maxhenkel.plane.entity.EntityPlaneWheelBase;
import de.maxhenkel.plane.sound.ModSounds;
import de.maxhenkel.plane.sound.SoundLoopHigh;
import de.maxhenkel.plane.sound.SoundLoopIdle;
import de.maxhenkel.plane.sound.SoundLoopStart;
import de.maxhenkel.plane.sound.SoundLoopStarting;
import de.maxhenkel.plane.sound.SoundLoopStop;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.entity.EntityType;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class EntityPlaneSoundBase
extends EntityPlaneWheelBase {
    @OnlyIn(value=Dist.CLIENT)
    private SoundLoopStart startLoop;
    @OnlyIn(value=Dist.CLIENT)
    private SoundLoopIdle idleLoop;
    @OnlyIn(value=Dist.CLIENT)
    private SoundLoopHigh highLoop;
    @OnlyIn(value=Dist.CLIENT)
    private SoundLoopStarting startingLoop;
    @OnlyIn(value=Dist.CLIENT)
    private SoundLoopStop stopLoop;
    private int ticksSinceStarted = 0;

    public EntityPlaneSoundBase(EntityType type, World worldIn) {
        super(type, worldIn);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            this.updateSounds();
        }
    }

    private void updateSounds() {
        if (this.isStarted()) {
            if (this.ticksSinceStarted >= 20) {
                if (this.getEngineSpeed() <= 0.0f) {
                    this.checkIdleLoop();
                } else {
                    this.checkHighLoop();
                }
            } else {
                ++this.ticksSinceStarted;
            }
        } else {
            this.ticksSinceStarted = 0;
        }
        if (this.getStartTime() > 0) {
            this.checkStartingLoop();
        }
    }

    @Override
    public void setStarted(boolean started) {
        this.setStarted(started, true);
    }

    public void setStarted(boolean started, boolean playSound) {
        super.setStarted(started);
        if (this.field_70170_p.field_72995_K && playSound) {
            if (!started) {
                this.checkStopLoop();
            } else {
                this.checkStartLoop();
            }
        }
    }

    @Override
    public void damagePlane(double damage, boolean horizontal) {
        super.damagePlane(damage, horizontal);
        ModSounds.playSound(ModSounds.CRASH, this.field_70170_p, this.func_180425_c(), null, SoundCategory.NEUTRAL, 1.0f);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void checkIdleLoop() {
        if (!this.isSoundPlaying((ISound)this.idleLoop)) {
            this.idleLoop = new SoundLoopIdle(this, ModSounds.ENGINE_IDLE, SoundCategory.NEUTRAL);
            ModSounds.playSoundLoop(this.idleLoop, this.field_70170_p);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void checkHighLoop() {
        if (!this.isSoundPlaying((ISound)this.highLoop)) {
            this.highLoop = new SoundLoopHigh(this, ModSounds.ENGINE_HIGH, SoundCategory.NEUTRAL);
            ModSounds.playSoundLoop(this.highLoop, this.field_70170_p);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void checkStartLoop() {
        if (!this.isSoundPlaying((ISound)this.startLoop)) {
            this.startLoop = new SoundLoopStart(this, ModSounds.ENGINE_START, SoundCategory.NEUTRAL);
            ModSounds.playSoundLoop(this.startLoop, this.field_70170_p);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void checkStopLoop() {
        if (!this.isSoundPlaying((ISound)this.stopLoop)) {
            this.stopLoop = new SoundLoopStop(this, ModSounds.ENGINE_STOP, SoundCategory.NEUTRAL);
            ModSounds.playSoundLoop(this.stopLoop, this.field_70170_p);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void checkStartingLoop() {
        if (!this.isSoundPlaying((ISound)this.startingLoop)) {
            this.startingLoop = new SoundLoopStarting(this, ModSounds.ENGINE_STARTING, SoundCategory.NEUTRAL);
            ModSounds.playSoundLoop(this.startingLoop, this.field_70170_p);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isSoundPlaying(ISound sound) {
        if (sound == null) {
            return false;
        }
        return Minecraft.func_71410_x().func_147118_V().func_215294_c(sound);
    }
}

