/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.plane.entity;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.network.NetworkHooks;

public abstract class EntityVehicleBase
extends Entity {
    private int steps;
    private double clientX;
    private double clientY;
    private double clientZ;
    private double clientYaw;
    private double clientPitch;
    protected float deltaRotation;

    public EntityVehicleBase(EntityType type, World worldIn) {
        super(type, worldIn);
        this.field_70156_m = true;
        this.field_70138_W = 0.6f;
    }

    public void func_70071_h_() {
        this.func_184189_br();
        super.func_70071_h_();
        this.tickLerp();
    }

    protected void func_184225_p(Entity passenger) {
        super.func_184225_p(passenger);
        if (passenger instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)passenger;
            Direction facing = this.func_174811_aO();
            double offsetX = 0.0;
            double offsetZ = 0.0;
            for (int i = 0; i < 4; ++i) {
                AxisAlignedBB playerbb = player.func_174813_aQ();
                double playerHitboxWidth = (playerbb.field_72336_d - playerbb.field_72340_a) / 2.0;
                double carHitboxWidth = this.func_174813_aQ().func_216362_d() / 2.0;
                double offset = playerHitboxWidth + carHitboxWidth + 0.2;
                AxisAlignedBB aabb = player.func_174813_aQ().func_72317_d(offsetX += (double)facing.func_82601_c() * offset, 0.0, offsetZ += (double)facing.func_82599_e() * offset);
                if (!this.field_70170_p.func_72829_c(aabb)) break;
                offsetX = 0.0;
                offsetZ = 0.0;
                facing = facing.func_176746_e();
            }
            player.func_70634_a(this.func_226277_ct_() + offsetX, this.func_226278_cu_(), this.func_226281_cx_() + offsetZ);
        }
    }

    public PlayerEntity getDriver() {
        List passengers = this.func_184188_bt();
        if (passengers.size() <= 0) {
            return null;
        }
        if (passengers.get(0) instanceof PlayerEntity) {
            return (PlayerEntity)passengers.get(0);
        }
        return null;
    }

    protected void func_184200_o(Entity passenger) {
        List passengers;
        try {
            passengers = (List)ObfuscationReflectionHelper.getPrivateValue(Entity.class, (Object)((Object)this), (String)"field_184244_h");
        }
        catch (ObfuscationReflectionHelper.UnableToFindFieldException x1) {
            try {
                passengers = (List)ObfuscationReflectionHelper.getPrivateValue(Entity.class, (Object)((Object)this), (String)"passengers");
            }
            catch (ObfuscationReflectionHelper.UnableToFindFieldException e) {
                super.func_184200_o(passenger);
                e.printStackTrace();
                return;
            }
        }
        passengers.add(passenger);
    }

    public abstract int getPassengerSize();

    protected boolean func_184219_q(Entity passenger) {
        return this.func_184188_bt().size() < this.getPassengerSize();
    }

    private void tickLerp() {
        if (this.steps > 0 && !this.func_184186_bw()) {
            double x = this.func_226277_ct_() + (this.clientX - this.func_226277_ct_()) / (double)this.steps;
            double y = this.func_226278_cu_() + (this.clientY - this.func_226278_cu_()) / (double)this.steps;
            double z = this.func_226281_cx_() + (this.clientZ - this.func_226281_cx_()) / (double)this.steps;
            double d3 = MathHelper.func_76138_g((double)(this.clientYaw - (double)this.field_70177_z));
            this.field_70177_z = (float)((double)this.field_70177_z + d3 / (double)this.steps);
            this.field_70125_A = (float)((double)this.field_70125_A + (this.clientPitch - (double)this.field_70125_A) / (double)this.steps);
            --this.steps;
            this.func_70107_b(x, y, z);
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180426_a(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        this.clientX = x;
        this.clientY = y;
        this.clientZ = z;
        this.clientYaw = yaw;
        this.clientPitch = pitch;
        this.steps = 10;
    }

    protected void applyOriantationsToEntity(Entity entityToUpdate) {
        entityToUpdate.func_181013_g(this.field_70177_z);
        float f = MathHelper.func_76142_g((float)(entityToUpdate.field_70177_z - this.field_70177_z));
        float f1 = MathHelper.func_76131_a((float)f, (float)-130.0f, (float)130.0f);
        entityToUpdate.field_70126_B += f1 - f;
        entityToUpdate.field_70177_z += f1 - f;
        entityToUpdate.func_70034_d(entityToUpdate.field_70177_z);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_184190_l(Entity entityToUpdate) {
        this.applyOriantationsToEntity(entityToUpdate);
    }

    public abstract Vec3d[] getPlayerOffsets();

    public void func_184232_k(Entity passenger) {
        if (!this.func_184196_w(passenger)) {
            return;
        }
        List passengers = this.func_184188_bt();
        if (passengers.size() > 0) {
            int i = passengers.indexOf(passenger);
            Vec3d offset = this.getPlayerOffsets()[i];
            offset = offset.func_178785_b((float)(-Math.toRadians(this.field_70177_z)));
            passenger.func_70107_b(this.func_226277_ct_() + offset.field_72450_a, this.func_226278_cu_() + offset.field_72448_b, this.func_226281_cx_() + offset.field_72449_c);
            passenger.field_70177_z += this.deltaRotation;
            passenger.func_70034_d(passenger.func_70079_am() + this.deltaRotation);
        }
        this.applyOriantationsToEntity(passenger);
    }

    public Entity func_184179_bs() {
        return null;
    }

    @Nullable
    public AxisAlignedBB func_70114_g(Entity entityIn) {
        return null;
    }

    @Nullable
    public AxisAlignedBB func_70046_E() {
        return null;
    }

    public boolean func_70104_M() {
        return false;
    }

    public boolean func_70067_L() {
        return true;
    }

    protected boolean func_225502_at_() {
        return false;
    }

    public boolean func_184230_a(PlayerEntity player, Hand hand) {
        if (!player.func_225608_bj_()) {
            if (player.func_184187_bx() != this && !this.field_70170_p.field_72995_K) {
                player.func_184220_m((Entity)this);
            }
            return true;
        }
        return false;
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

