/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.plane.entity.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import de.maxhenkel.plane.entity.EntityPlane;
import de.maxhenkel.plane.entity.render.AbstractPlaneModel;
import de.maxhenkel.plane.entity.render.OBJModel;
import de.maxhenkel.plane.entity.render.OBJModelInstance;
import de.maxhenkel.plane.entity.render.OBJModelOptions;
import de.maxhenkel.plane.entity.render.Rotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;

public class PlaneModel
extends AbstractPlaneModel<EntityPlane> {
    private static final List<OBJModelInstance> MODELS = Arrays.asList(new OBJModelInstance(new OBJModel(new ResourceLocation("plane", "models/entity/wheel.obj")), new OBJModelOptions(new ResourceLocation("plane", "textures/entity/wheel.png"), new Vec3d(-0.625, 0.125, -1.09375), (plane, matrixStack, partialTicks) -> {
        matrixStack.func_227862_a_(0.0625f, 0.0625f, 0.0625f);
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(-plane.getWheelRotation(partialTicks)));
    })), new OBJModelInstance(new OBJModel(new ResourceLocation("plane", "models/entity/wheel.obj")), new OBJModelOptions(new ResourceLocation("plane", "textures/entity/wheel.png"), new Vec3d(0.625, 0.125, -1.09375), (plane, matrixStack, partialTicks) -> {
        matrixStack.func_227862_a_(0.0625f, 0.0625f, 0.0625f);
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(-plane.getWheelRotation(partialTicks)));
    })), new OBJModelInstance(new OBJModel(new ResourceLocation("plane", "models/entity/propeller.obj")), new OBJModelOptions(new ResourceLocation("textures/block/spruce_planks.png"), new Vec3d(0.0, 1.0, -1.84375), (plane, matrixStack, partialTicks) -> {
        matrixStack.func_227862_a_(0.0625f, 0.0625f, 0.0625f);
        matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(-plane.getPropellerRotation(partialTicks)));
    })));
    private static List<OBJModelInstance> OAK_MODEL = PlaneModel.getPlaneModel(new ResourceLocation("textures/block/oak_planks.png"));
    private static List<OBJModelInstance> DARK_OAK_MODEL = PlaneModel.getPlaneModel(new ResourceLocation("textures/block/dark_oak_planks.png"));
    private static List<OBJModelInstance> BIRCH_MODEL = PlaneModel.getPlaneModel(new ResourceLocation("textures/block/birch_planks.png"));
    private static List<OBJModelInstance> JUNGLE_MODEL = PlaneModel.getPlaneModel(new ResourceLocation("textures/block/jungle_planks.png"));
    private static List<OBJModelInstance> ACACIA_MODEL = PlaneModel.getPlaneModel(new ResourceLocation("textures/block/acacia_planks.png"));
    private static List<OBJModelInstance> SPRUCE_MODEL = PlaneModel.getPlaneModel(new ResourceLocation("textures/block/spruce_planks.png"));

    public PlaneModel(EntityRendererManager renderManager) {
        super(renderManager);
    }

    @Override
    protected void translateName(EntityPlane plane, MatrixStack matrixStack, boolean left) {
        if (left) {
            matrixStack.func_227861_a_(0.500625, -1.25, -1.0);
            matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(90.0f));
        } else {
            matrixStack.func_227861_a_(-0.500625, -1.25, -1.0);
            matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-90.0f));
        }
    }

    @Override
    public List<OBJModelInstance> getModels(EntityPlane entity) {
        return PlaneModel.getModelFromType(entity);
    }

    private static List<OBJModelInstance> getModelFromType(EntityPlane plane) {
        switch (plane.getPlaneType()) {
            default: {
                return OAK_MODEL;
            }
            case DARK_OAK: {
                return DARK_OAK_MODEL;
            }
            case SPRUCE: {
                return SPRUCE_MODEL;
            }
            case JUNGLE: {
                return JUNGLE_MODEL;
            }
            case BIRCH: {
                return BIRCH_MODEL;
            }
            case ACACIA: 
        }
        return ACACIA_MODEL;
    }

    private static List<OBJModelInstance> getPlaneModel(ResourceLocation texture) {
        ArrayList<OBJModelInstance> models = new ArrayList<OBJModelInstance>(MODELS);
        models.add(new OBJModelInstance(new OBJModel(new ResourceLocation("plane", "models/entity/plane.obj")), new OBJModelOptions(texture, new Vec3d(0.0, 0.5, 0.0), new Rotation(180.0f, Vector3f.field_229181_d_), (plane, matrixStack, partialTicks) -> matrixStack.func_227862_a_(0.0625f, 0.0625f, 0.0625f))));
        return models;
    }
}

