/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.plane.events;

import com.mojang.blaze3d.systems.RenderSystem;
import de.maxhenkel.plane.Config;
import de.maxhenkel.plane.MathTools;
import de.maxhenkel.plane.entity.EntityPlaneSoundBase;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@OnlyIn(value=Dist.CLIENT)
public class RenderEvents {
    private static final ResourceLocation PLANE_INFO_TEXTURE = new ResourceLocation("plane", "textures/gui/plane_info.png");
    private Minecraft mc = Minecraft.func_71410_x();
    private EntityPlaneSoundBase lastVehicle;
    private double cachedRelativeHeight = 0.0;

    @SubscribeEvent
    public void onRender(RenderGameOverlayEvent evt) {
        if (!evt.getType().equals((Object)RenderGameOverlayEvent.ElementType.EXPERIENCE)) {
            return;
        }
        ClientPlayerEntity player = this.mc.field_71439_g;
        Entity e = player.func_184187_bx();
        if (!(e instanceof EntityPlaneSoundBase)) {
            return;
        }
        EntityPlaneSoundBase plane = (EntityPlaneSoundBase)e;
        if (((Boolean)Config.SHOW_PLANE_INFO.get()).booleanValue()) {
            this.renderPlaneInfo(plane);
        }
    }

    public void renderPlaneInfo(EntityPlaneSoundBase plane) {
        RenderSystem.pushMatrix();
        this.mc.func_110434_K().func_110577_a(PLANE_INFO_TEXTURE);
        int texWidth = 110;
        int texHeight = 90;
        int height = this.mc.func_228018_at_().func_198087_p();
        int width = this.mc.func_228018_at_().func_198107_o();
        double scale = (Double)Config.PLANE_INFO_SCALE.get();
        RenderSystem.scaled((double)scale, (double)scale, (double)1.0);
        RenderSystem.translated((double)(-width), (double)(-height), (double)0.0);
        RenderSystem.translated((double)((double)width * (1.0 / scale)), (double)((double)height * (1.0 / scale)), (double)0.0);
        int padding = 3;
        int yStart = height - texHeight - padding;
        int xStart = width - texWidth - padding;
        this.mc.field_71456_v.blit(xStart, yStart, 0, 0, texWidth, texHeight);
        FontRenderer font = this.mc.field_71456_v.func_175179_f();
        Function<Integer, Integer> heightFunc = integer -> {
            font.getClass();
            return yStart + 8 + (9 + 2) * integer;
        };
        font.func_211126_b(new TranslationTextComponent("tooltip.plane.speed", new Object[]{((Config.SpeedType)((Object)Config.PLANE_INFO_SPEED_TYPE.get())).getTextComponent(plane.func_213322_ci().func_72433_c())}).func_150254_d(), (float)(xStart + 7), (float)heightFunc.apply(0).intValue(), 0);
        font.func_211126_b(new TranslationTextComponent("tooltip.plane.vertical_speed", new Object[]{((Config.SpeedType)((Object)Config.PLANE_INFO_SPEED_TYPE.get())).getTextComponent(plane.func_213322_ci().func_82617_b())}).func_150254_d(), (float)(xStart + 7), (float)heightFunc.apply(1).intValue(), 0);
        font.func_211126_b(new TranslationTextComponent("tooltip.plane.throttle", new Object[]{Math.round(plane.getEngineSpeed() * 100.0f)}).func_150254_d(), (float)(xStart + 7), (float)heightFunc.apply(2).intValue(), 0);
        font.func_211126_b(new TranslationTextComponent("tooltip.plane.height", new Object[]{Math.round(plane.func_226278_cu_())}).func_150254_d(), (float)(xStart + 7), (float)heightFunc.apply(3).intValue(), 0);
        font.func_211126_b(new TranslationTextComponent("tooltip.plane.relative_height", new Object[]{Math.round(this.cachedRelativeHeight)}).func_150254_d(), (float)(xStart + 7), (float)heightFunc.apply(4).intValue(), 0);
        font.func_211126_b(new TranslationTextComponent("tooltip.plane.fuel", new Object[]{plane.getFuel()}).func_150254_d(), (float)(xStart + 7), (float)heightFunc.apply(5).intValue(), 0);
        font.func_211126_b(new TranslationTextComponent("tooltip.plane.damage", new Object[]{Float.valueOf(MathTools.round(plane.getPlaneDamage(), 2))}).func_150254_d(), (float)(xStart + 7), (float)heightFunc.apply(6).intValue(), 0);
        RenderSystem.popMatrix();
    }

    private double getRelativeHeight(EntityPlaneSoundBase plane) {
        int highestBlock = (int)plane.func_226278_cu_();
        BlockPos.Mutable p = new BlockPos.Mutable(plane.func_226277_ct_(), plane.func_226278_cu_(), plane.func_226281_cx_());
        for (int y = highestBlock; y >= 0; --y) {
            p.func_185336_p(y);
            if (!plane.field_70170_p.func_180495_p((BlockPos)p).func_200132_m()) continue;
            highestBlock = y;
            break;
        }
        return plane.func_226278_cu_() - (double)(highestBlock + 1);
    }

    @SubscribeEvent
    public void renderPlayerPre(RenderPlayerEvent.Pre event) {
        PlayerEntity player = event.getPlayer();
        if (player.func_184187_bx() instanceof EntityPlaneSoundBase) {
            EntityPlaneSoundBase plane = (EntityPlaneSoundBase)event.getPlayer().func_184187_bx();
            event.getMatrixStack().func_227860_a_();
            event.getMatrixStack().func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-(plane.field_70177_z + (plane.field_70177_z - plane.field_70126_B) * event.getPartialRenderTick())));
            event.getMatrixStack().func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(plane.field_70125_A + (plane.field_70125_A - plane.field_70127_C) * event.getPartialRenderTick()));
            List passengers = plane.func_184188_bt();
            int i = passengers.indexOf(player);
            if (i >= 0) {
                Vec3d offset = plane.getPlayerOffsets()[i];
                offset = offset.func_178789_a((float)(-Math.toRadians(plane.field_70125_A)));
                event.getMatrixStack().func_227861_a_(0.0, offset.field_72448_b, 0.0);
            }
            event.getMatrixStack().func_227862_a_(plane.getPlayerScaleFactor(), plane.getPlayerScaleFactor(), plane.getPlayerScaleFactor());
            event.getMatrixStack().func_227861_a_(0.0, (double)((player.func_213302_cg() - player.func_213302_cg() * plane.getPlayerScaleFactor()) / 1.5f + (float)plane.getPlayerOffsets()[0].field_72448_b), 0.0);
            event.getMatrixStack().func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(plane.field_70177_z + (plane.field_70177_z - plane.field_70126_B) * event.getPartialRenderTick()));
        }
    }

    @SubscribeEvent
    public void renderPlayerPost(RenderPlayerEvent.Post event) {
        if (event.getPlayer().func_184187_bx() instanceof EntityPlaneSoundBase) {
            event.getMatrixStack().func_227865_b_();
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent evt) {
        if (!evt.player.equals((Object)this.mc.field_71439_g)) {
            return;
        }
        EntityPlaneSoundBase vehicle = this.getPlane();
        if (vehicle != null && evt.player.equals((Object)vehicle.getDriver())) {
            this.cachedRelativeHeight = this.getRelativeHeight(vehicle);
        }
        if (vehicle != null && this.lastVehicle == null) {
            this.mc.field_71474_y.field_74320_O = 1;
        } else if (vehicle == null && this.lastVehicle != null) {
            this.mc.field_71474_y.field_74320_O = 0;
        }
        this.lastVehicle = vehicle;
    }

    private EntityPlaneSoundBase getPlane() {
        if (this.mc.field_71439_g.func_184187_bx() instanceof EntityPlaneSoundBase) {
            return (EntityPlaneSoundBase)this.mc.field_71439_g.func_184187_bx();
        }
        return null;
    }
}

