/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.plane.gui;

import de.maxhenkel.plane.MathTools;
import de.maxhenkel.plane.entity.EntityPlaneSoundBase;
import de.maxhenkel.plane.gui.ContainerPlane;
import de.maxhenkel.plane.gui.GuiBase;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class GuiPlane
extends GuiBase<ContainerPlane> {
    private static final ResourceLocation CAR_GUI_TEXTURE = new ResourceLocation("plane", "textures/gui/gui_plane.png");
    private static final ITextComponent TEXT_FUEL = new TranslationTextComponent("gui.plane.fuel", new Object[0]);
    private static final ITextComponent TEXT_DAMAGE = new TranslationTextComponent("gui.plane.damage", new Object[0]);
    private static final ITextComponent TEXT_ENGINE = new TranslationTextComponent("gui.plane.throttle", new Object[0]);
    private PlayerInventory playerInv;
    private EntityPlaneSoundBase plane;

    public GuiPlane(ContainerPlane containerCar, PlayerInventory playerInv, ITextComponent title) {
        super(CAR_GUI_TEXTURE, containerCar, playerInv, title);
        this.playerInv = playerInv;
        this.plane = containerCar.getPlane();
        this.field_146999_f = 176;
        this.field_147000_g = 222;
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
        this.font.func_211126_b(this.plane.func_200200_C_().func_150254_d(), 7.0f, 61.0f, 0x404040);
        this.font.func_211126_b(this.playerInv.func_145748_c_().func_150254_d(), 8.0f, (float)(this.field_147000_g - 96 + 2), 0x404040);
        this.font.func_211126_b(TEXT_FUEL.func_150254_d(), 7.0f, 9.0f, 0x404040);
        this.font.func_211126_b(TEXT_DAMAGE.func_150254_d(), 95.0f, 9.0f, 0x404040);
        this.font.func_211126_b(TEXT_ENGINE.func_150254_d(), 7.0f, 35.0f, 0x404040);
        if (mouseX >= this.field_147003_i + 8 && mouseX < this.field_147003_i + 80 && mouseY >= this.field_147009_r + 20 && mouseY < this.field_147009_r + 30) {
            this.renderTooltip(new TranslationTextComponent("tooltip.plane.fuel", new Object[]{this.plane.getFuel()}).func_150254_d(), mouseX - this.field_147003_i, mouseY - this.field_147009_r);
        }
        if (mouseX >= this.field_147003_i + 96 && mouseX < this.field_147003_i + 168 && mouseY >= this.field_147009_r + 20 && mouseY < this.field_147009_r + 30) {
            this.renderTooltip(new TranslationTextComponent("tooltip.plane.damage", new Object[]{Float.valueOf(MathTools.round(this.plane.getPlaneDamage(), 2))}).func_150254_d(), mouseX - this.field_147003_i, mouseY - this.field_147009_r);
        }
        if (mouseX >= this.field_147003_i + 8 && mouseX < this.field_147003_i + 80 && mouseY >= this.field_147009_r + 46 && mouseY < this.field_147009_r + 56) {
            this.renderTooltip(new TranslationTextComponent("tooltip.plane.throttle", new Object[]{Math.round(this.plane.getEngineSpeed() * 100.0f)}).func_150254_d(), mouseX - this.field_147003_i, mouseY - this.field_147009_r);
        }
    }

    @Override
    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        super.func_146976_a(partialTicks, mouseX, mouseY);
        this.drawFuel((float)this.plane.getFuel() / (float)this.plane.getMaxFuel());
        this.drawDamage((100.0f - Math.min(this.plane.getPlaneDamage(), 100.0f)) / 100.0f);
        this.drawThrottle(this.plane.getEngineSpeed());
    }

    public void drawFuel(float percent) {
        int scaled = (int)(72.0f * percent);
        int i = this.field_147003_i;
        int j = this.field_147009_r;
        this.blit(i + 8, j + 20, 176, 0, scaled, 10);
    }

    public void drawThrottle(float percent) {
        int scaled = (int)(72.0f * percent);
        int i = this.field_147003_i;
        int j = this.field_147009_r;
        this.blit(i + 8, j + 46, 176, 10, scaled, 10);
    }

    public void drawDamage(float percent) {
        int scaled = (int)(72.0f * percent);
        int i = this.field_147003_i;
        int j = this.field_147009_r;
        this.blit(i + 96, j + 20, 176, 20, scaled, 10);
    }
}

