/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.plane.integration.waila;

import de.maxhenkel.plane.MathTools;
import de.maxhenkel.plane.entity.EntityPlaneSoundBase;
import java.util.List;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.api.IEntityAccessor;
import mcp.mobius.waila.api.IEntityComponentProvider;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.ITaggableList;
import mcp.mobius.waila.api.impl.config.WailaConfig;
import mcp.mobius.waila.utils.ModIdentification;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class HUDHandlerPlanes
implements IEntityComponentProvider {
    static final ResourceLocation OBJECT_NAME_TAG = new ResourceLocation("waila", "object_name");
    static final ResourceLocation CONFIG_SHOW_REGISTRY = new ResourceLocation("waila", "show_registry");
    static final ResourceLocation REGISTRY_NAME_TAG = new ResourceLocation("waila", "registry_name");
    static final HUDHandlerPlanes INSTANCE = new HUDHandlerPlanes();

    public void appendHead(List<ITextComponent> tip, IEntityAccessor accessor, IPluginConfig config) {
        ITaggableList tooltip = (ITaggableList)tip;
        tooltip.setTag((Object)OBJECT_NAME_TAG, (Object)new StringTextComponent(String.format(((WailaConfig)Waila.CONFIG.get()).getFormatting().getEntityName(), accessor.getEntity().func_145748_c_().func_150254_d())));
        if (config.get(CONFIG_SHOW_REGISTRY)) {
            tooltip.setTag((Object)REGISTRY_NAME_TAG, (Object)new StringTextComponent(String.format(((WailaConfig)Waila.CONFIG.get()).getFormatting().getRegistryName(), accessor.getEntity().func_145748_c_().func_150254_d())));
        }
    }

    public void appendBody(List<ITextComponent> tooltip, IEntityAccessor accessor, IPluginConfig config) {
        if (!(accessor.getEntity() instanceof EntityPlaneSoundBase)) {
            return;
        }
        EntityPlaneSoundBase plane = (EntityPlaneSoundBase)accessor.getEntity();
        tooltip.add(new TranslationTextComponent("tooltip.plane.fuel", new Object[]{new StringTextComponent(String.valueOf(plane.getFuel())).func_211708_a(TextFormatting.DARK_GRAY)}).func_211708_a(TextFormatting.GRAY));
        tooltip.add(new TranslationTextComponent("tooltip.plane.damage", new Object[]{new StringTextComponent(String.valueOf(MathTools.round(plane.getPlaneDamage(), 2))).func_211708_a(TextFormatting.DARK_GRAY)}).func_211708_a(TextFormatting.GRAY));
    }

    public void appendTail(List<ITextComponent> tooltip, IEntityAccessor accessor, IPluginConfig config) {
        tooltip.add((ITextComponent)new StringTextComponent(String.format(((WailaConfig)Waila.CONFIG.get()).getFormatting().getModName(), ModIdentification.getModInfo((Entity)accessor.getEntity()).getName())));
    }
}

