/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.plane.sound;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.TickableSound;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ModSounds {
    public static SoundEvent ENGINE_STOP = ModSounds.registerSound("engine_stop");
    public static SoundEvent ENGINE_STARTING = ModSounds.registerSound("engine_starting");
    public static SoundEvent ENGINE_START = ModSounds.registerSound("engine_start");
    public static SoundEvent ENGINE_IDLE = ModSounds.registerSound("engine_idle");
    public static SoundEvent ENGINE_HIGH = ModSounds.registerSound("engine_high");
    public static SoundEvent CRASH = ModSounds.registerSound("crash");
    public static SoundEvent RATCHET = ModSounds.registerSound("ratchet");

    public static List<SoundEvent> getAll() {
        ArrayList<SoundEvent> sounds = new ArrayList<SoundEvent>();
        for (Field field : ModSounds.class.getFields()) {
            try {
                Object obj = field.get(null);
                if (obj == null || !(obj instanceof SoundEvent)) continue;
                sounds.add((SoundEvent)obj);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return sounds;
    }

    public static SoundEvent registerSound(String soundName) {
        SoundEvent event = new SoundEvent(new ResourceLocation("plane", soundName));
        event.setRegistryName(new ResourceLocation("plane", soundName));
        return event;
    }

    public static void playSound(SoundEvent evt, World world, BlockPos pos, PlayerEntity entity, SoundCategory category, float volume) {
        ModSounds.playSound(evt, world, pos, entity, category, volume, 1.0f);
    }

    public static void playSound(SoundEvent evt, World world, BlockPos pos, PlayerEntity entity, SoundCategory category, float volume, float pitch) {
        if (entity != null) {
            world.func_184133_a(entity, pos, evt, category, volume, pitch);
        } else if (!world.field_72995_K) {
            world.func_184148_a(null, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, evt, category, volume, pitch);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void playSoundLoop(TickableSound loop, World world) {
        if (world.field_72995_K) {
            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)loop);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void playSoundLoopDelayed(TickableSound loop, World world, int delay) {
        if (world.field_72995_K) {
            Minecraft.func_71410_x().func_147118_V().func_147681_a((ISound)loop, delay);
        }
    }
}

