/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.plane.entity;

import de.maxhenkel.plane.Main;
import de.maxhenkel.plane.corelib.item.ItemUtils;
import de.maxhenkel.plane.entity.EntityPlaneSoundBase;
import de.maxhenkel.plane.gui.ContainerPlane;
import de.maxhenkel.plane.net.MessagePlaneGui;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.ChestContainer;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class EntityCargoPlane
extends EntityPlaneSoundBase {
    private static final DataParameter<Integer> TYPE = EntityDataManager.func_187226_a(EntityPlaneSoundBase.class, (IDataSerializer)DataSerializers.field_187192_b);
    private IInventory cargoInventory = new Inventory(54);

    public EntityCargoPlane(World world) {
        this(Main.CARGO_PLANE_ENTITY_TYPE, world);
    }

    public EntityCargoPlane(EntityType<?> type, World world) {
        super(type, world);
    }

    @Override
    public float getPlayerScaleFactor() {
        return 0.8f;
    }

    @Override
    public void destroyPlane(DamageSource source, PlayerEntity player) {
        InventoryHelper.func_180175_a((World)this.field_70170_p, (BlockPos)this.func_233580_cy_(), (IInventory)this.cargoInventory);
        this.cargoInventory.func_174888_l();
        super.destroyPlane(source, player);
    }

    @Override
    public void openGUI(PlayerEntity player, boolean outside) {
        if (player instanceof ServerPlayerEntity) {
            if (outside) {
                NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)new INamedContainerProvider(){

                    public ITextComponent func_145748_c_() {
                        return new TranslationTextComponent("gui.plane.cargo_inventory");
                    }

                    @Nullable
                    public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
                        return ChestContainer.func_216984_b((int)i, (PlayerInventory)playerInventory, (IInventory)EntityCargoPlane.this.cargoInventory);
                    }
                });
            } else {
                NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)new INamedContainerProvider(){

                    public ITextComponent func_145748_c_() {
                        return EntityCargoPlane.this.func_200200_C_();
                    }

                    @Nullable
                    public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
                        return new ContainerPlane(i, EntityCargoPlane.this, playerInventory);
                    }
                }, packetBuffer -> packetBuffer.func_179252_a(this.func_110124_au()));
            }
        } else {
            Main.SIMPLE_CHANNEL.sendToServer((Object)new MessagePlaneGui(player, outside));
        }
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setPlaneType(Type.fromTypeName(compound.func_74779_i("Type")));
        ItemUtils.readInventory(compound, "CargoInventory", this.cargoInventory);
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74778_a("Type", this.getPlaneType().getTypeName());
        ItemUtils.saveInventory(compound, "CargoInventory", this.cargoInventory);
    }

    @Override
    public float getMaxFuelUsage() {
        return 7.0f;
    }

    @Override
    public int getMaxFuel() {
        return 6000;
    }

    @Override
    public ResourceLocation getLootTable() {
        return new ResourceLocation("plane", "entities/cargo_plane_" + this.getPlaneType().getTypeName());
    }

    @Override
    public double getFallSpeed() {
        return 0.11;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(TYPE, (Object)0);
    }

    @Override
    public Vector3d[] getPlayerOffsets() {
        return new Vector3d[]{new Vector3d(0.5, 0.0, 0.8), new Vector3d(-0.5, 0.0, 0.8)};
    }

    public Type getPlaneType() {
        return Type.values()[(Integer)this.field_70180_af.func_187225_a(TYPE)];
    }

    public void setPlaneType(Type type) {
        this.field_70180_af.func_187227_b(TYPE, (Object)type.ordinal());
    }

    public static enum Type {
        OAK("oak"),
        SPRUCE("spruce"),
        BIRCH("birch"),
        JUNGLE("jungle"),
        ACACIA("acacia"),
        DARK_OAK("dark_oak"),
        WARPED("warped"),
        CRIMSON("crimson");

        private String name;

        private Type(String name) {
            this.name = name;
        }

        public String getTypeName() {
            return this.name;
        }

        public static Type fromTypeName(String name) {
            for (Type type : Type.values()) {
                if (!type.getTypeName().equals(name)) continue;
                return type;
            }
            return OAK;
        }
    }
}

