/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.polymorph.core.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_1159;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5348;
import top.theillusivec4.polymorph.core.client.gui.RecipeOutputWidget;
import top.theillusivec4.polymorph.loader.mixin.core.ScreenAccessor;

public class RecipeSelectorGui<I extends class_1263, R extends class_1860<I>>
extends class_332
implements class_4068,
class_364 {
    private final Consumer<R> select;
    private final I inventory;
    private final class_437 screen;
    private final List<RecipeOutputWidget<I, R>> buttons = new ArrayList<RecipeOutputWidget<I, R>>();
    private RecipeOutputWidget<I, R> hoveredButton;
    private boolean visible = false;
    private int x;
    private int y;
    private List<R> recipes = new ArrayList<R>();
    public static final int DEFAULT_BACKGROUND_COLOR = -267386864;
    public static final int DEFAULT_BORDER_COLOR_START = 0x505000FF;
    public static final int DEFAULT_BORDER_COLOR_END = 1344798847;

    public RecipeSelectorGui(int x, int y, I inventory, Consumer<R> select, class_437 screen) {
        this.setPosition(x, y);
        this.select = select;
        this.inventory = inventory;
        this.screen = screen;
    }

    public void setPosition(int x, int y) {
        this.x = x;
        this.y = y;
        this.updateButtonPositions();
    }

    public void highlightButton(String recipe) {
        this.buttons.forEach(button -> {
            String id = button.recipe.method_8114().toString();
            button.highlighted = id.equals(recipe);
        });
    }

    private void updateButtonPositions() {
        int size = this.recipes.size();
        int xOffset = (int)(-25.0 * Math.floor((float)size / 2.0f));
        if (size % 2 == 0) {
            xOffset += 13;
        }
        int[] pos = new int[]{this.x + xOffset, this.y};
        this.buttons.forEach(button -> {
            button.setPosition(pos[0], pos[1]);
            pos[0] = pos[0] + 25;
        });
    }

    public List<RecipeOutputWidget<I, R>> getButtons() {
        return this.buttons;
    }

    public void setRecipes(List<R> recipes) {
        this.recipes = recipes;
        this.buttons.clear();
        recipes.forEach(recipe -> this.buttons.add(new RecipeOutputWidget<I, class_1860>(this.inventory, (class_1860)recipe)));
        this.updateButtonPositions();
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void renderTooltip(class_4587 matrixStack, int p_193721_1_, int p_193721_2_) {
        class_310 mc = class_310.method_1551();
        if (mc.field_1755 != null && this.hoveredButton != null) {
            this.renderTooltip(this.hoveredButton.getOutput(), matrixStack, this.hoveredButton.getTooltipText(mc.field_1755), p_193721_1_, p_193721_2_);
        }
    }

    public void method_25394(class_4587 matrixStack, int p_render_1_, int p_render_2_, float p_render_3_) {
        if (this.isVisible()) {
            this.hoveredButton = null;
            this.buttons.forEach(button -> {
                button.method_25394(matrixStack, p_render_1_, p_render_2_, p_render_3_);
                if (button.field_22764 && button.method_25367()) {
                    this.hoveredButton = button;
                }
            });
            this.renderTooltip(matrixStack, p_render_1_, p_render_2_);
        }
    }

    public boolean method_25402(double p_mouseClicked_1_, double p_mouseClicked_3_, int p_mouseClicked_5_) {
        if (this.isVisible()) {
            for (RecipeOutputWidget<I, R> button : this.buttons) {
                if (!button.method_25402(p_mouseClicked_1_, p_mouseClicked_3_, p_mouseClicked_5_)) continue;
                this.select.accept(button.recipe);
                return true;
            }
        }
        return false;
    }

    public void renderTooltip(class_1799 stack, class_4587 p_243308_1_, List<class_2561> p_243308_2_, int p_243308_3_, int p_243308_4_) {
        RecipeSelectorGui.drawHoveringText(stack, p_243308_1_, p_243308_2_, p_243308_3_, p_243308_4_, this.screen.field_22789, this.screen.field_22790, -1, -267386864, 0x505000FF, 1344798847, ((ScreenAccessor)this.screen).getTextRenderer());
    }

    public static void drawHoveringText(class_1799 stack, class_4587 mStack, List<? extends class_5348> textLines, int mouseX, int mouseY, int screenWidth, int screenHeight, int maxTextWidth, int backgroundColor, int borderColorStart, int borderColorEnd, class_327 font) {
        if (!textLines.isEmpty()) {
            int n;
            RenderSystem.disableRescaleNormal();
            RenderSystem.disableDepthTest();
            int tooltipTextWidth = 0;
            for (class_5348 class_53482 : textLines) {
                int textLineWidth = font.method_27525(class_53482);
                if (textLineWidth <= tooltipTextWidth) continue;
                tooltipTextWidth = textLineWidth;
            }
            boolean needsWrap = false;
            boolean bl = true;
            int tooltipX = mouseX + 12;
            if (tooltipX + tooltipTextWidth + 4 > screenWidth && (tooltipX = mouseX - 16 - tooltipTextWidth) < 4) {
                tooltipTextWidth = mouseX > screenWidth / 2 ? mouseX - 12 - 8 : screenWidth - 16 - mouseX;
                needsWrap = true;
            }
            if (maxTextWidth > 0 && tooltipTextWidth > maxTextWidth) {
                tooltipTextWidth = maxTextWidth;
                needsWrap = true;
            }
            if (needsWrap) {
                int wrappedTooltipWidth = 0;
                ArrayList<? extends class_5348> wrappedTextLines = new ArrayList<class_5348>();
                for (int i = 0; i < textLines.size(); ++i) {
                    class_5348 textLine = textLines.get(i);
                    List wrappedLine = font.method_27527().method_27495(textLine, tooltipTextWidth, class_2583.field_24360);
                    if (i == 0) {
                        n = wrappedLine.size();
                    }
                    for (class_5348 line : wrappedLine) {
                        int lineWidth = font.method_27525(line);
                        if (lineWidth > wrappedTooltipWidth) {
                            wrappedTooltipWidth = lineWidth;
                        }
                        wrappedTextLines.add((class_5348)line);
                    }
                }
                tooltipTextWidth = wrappedTooltipWidth;
                textLines = wrappedTextLines;
                tooltipX = mouseX > screenWidth / 2 ? mouseX - 16 - tooltipTextWidth : mouseX + 12;
            }
            int tooltipY = mouseY - 12;
            int tooltipHeight = 8;
            if (textLines.size() > 1) {
                tooltipHeight += (textLines.size() - 1) * 10;
                if (textLines.size() > n) {
                    tooltipHeight += 2;
                }
            }
            if (tooltipY < 4) {
                tooltipY = 4;
            } else if (tooltipY + tooltipHeight + 4 > screenHeight) {
                tooltipY = screenHeight - tooltipHeight - 4;
            }
            int zLevel = 900;
            mStack.method_22903();
            class_1159 mat = mStack.method_23760().method_23761();
            RecipeSelectorGui.drawGradientRect(mat, 900, tooltipX - 3, tooltipY - 4, tooltipX + tooltipTextWidth + 3, tooltipY - 3, backgroundColor, backgroundColor);
            RecipeSelectorGui.drawGradientRect(mat, 900, tooltipX - 3, tooltipY + tooltipHeight + 3, tooltipX + tooltipTextWidth + 3, tooltipY + tooltipHeight + 4, backgroundColor, backgroundColor);
            RecipeSelectorGui.drawGradientRect(mat, 900, tooltipX - 3, tooltipY - 3, tooltipX + tooltipTextWidth + 3, tooltipY + tooltipHeight + 3, backgroundColor, backgroundColor);
            RecipeSelectorGui.drawGradientRect(mat, 900, tooltipX - 4, tooltipY - 3, tooltipX - 3, tooltipY + tooltipHeight + 3, backgroundColor, backgroundColor);
            RecipeSelectorGui.drawGradientRect(mat, 900, tooltipX + tooltipTextWidth + 3, tooltipY - 3, tooltipX + tooltipTextWidth + 4, tooltipY + tooltipHeight + 3, backgroundColor, backgroundColor);
            RecipeSelectorGui.drawGradientRect(mat, 900, tooltipX - 3, tooltipY - 3 + 1, tooltipX - 3 + 1, tooltipY + tooltipHeight + 3 - 1, borderColorStart, borderColorEnd);
            RecipeSelectorGui.drawGradientRect(mat, 900, tooltipX + tooltipTextWidth + 2, tooltipY - 3 + 1, tooltipX + tooltipTextWidth + 3, tooltipY + tooltipHeight + 3 - 1, borderColorStart, borderColorEnd);
            RecipeSelectorGui.drawGradientRect(mat, 900, tooltipX - 3, tooltipY - 3, tooltipX + tooltipTextWidth + 3, tooltipY - 3 + 1, borderColorStart, borderColorStart);
            RecipeSelectorGui.drawGradientRect(mat, 900, tooltipX - 3, tooltipY + tooltipHeight + 2, tooltipX + tooltipTextWidth + 3, tooltipY + tooltipHeight + 3, borderColorEnd, borderColorEnd);
            class_4597.class_4598 renderType = class_4597.method_22991((class_287)class_289.method_1348().method_1349());
            mStack.method_22904(0.0, 0.0, 900.0);
            for (int lineNumber = 0; lineNumber < textLines.size(); ++lineNumber) {
                class_5348 line;
                line = textLines.get(lineNumber);
                if (line != null) {
                    font.method_22942(class_2477.method_10517().method_30934(line), (float)tooltipX, (float)tooltipY, -1, true, mat, (class_4597)renderType, false, 0, 0xF000F0);
                }
                if (lineNumber + 1 == n) {
                    tooltipY += 2;
                }
                tooltipY += 10;
            }
            renderType.method_22993();
            mStack.method_22909();
            RenderSystem.enableDepthTest();
            RenderSystem.enableRescaleNormal();
        }
    }

    public static void drawGradientRect(class_1159 mat, int zLevel, int left, int top, int right, int bottom, int startColor, int endColor) {
        float startAlpha = (float)(startColor >> 24 & 0xFF) / 255.0f;
        float startRed = (float)(startColor >> 16 & 0xFF) / 255.0f;
        float startGreen = (float)(startColor >> 8 & 0xFF) / 255.0f;
        float startBlue = (float)(startColor & 0xFF) / 255.0f;
        float endAlpha = (float)(endColor >> 24 & 0xFF) / 255.0f;
        float endRed = (float)(endColor >> 16 & 0xFF) / 255.0f;
        float endGreen = (float)(endColor >> 8 & 0xFF) / 255.0f;
        float endBlue = (float)(endColor & 0xFF) / 255.0f;
        RenderSystem.enableDepthTest();
        RenderSystem.disableTexture();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.shadeModel((int)7425);
        class_289 tessellator = class_289.method_1348();
        class_287 buffer = tessellator.method_1349();
        buffer.method_1328(7, class_290.field_1576);
        buffer.method_22918(mat, (float)right, (float)top, (float)zLevel).method_22915(startRed, startGreen, startBlue, startAlpha).method_1344();
        buffer.method_22918(mat, (float)left, (float)top, (float)zLevel).method_22915(startRed, startGreen, startBlue, startAlpha).method_1344();
        buffer.method_22918(mat, (float)left, (float)bottom, (float)zLevel).method_22915(endRed, endGreen, endBlue, endAlpha).method_1344();
        buffer.method_22918(mat, (float)right, (float)bottom, (float)zLevel).method_22915(endRed, endGreen, endBlue, endAlpha).method_1344();
        tessellator.method_1350();
        RenderSystem.shadeModel((int)7424);
        RenderSystem.disableBlend();
        RenderSystem.enableTexture();
    }
}

