/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.polymorph.core.client.selector;

import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.class_1263;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_339;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_465;
import top.theillusivec4.polymorph.api.type.PolyProvider;
import top.theillusivec4.polymorph.api.type.RecipeSelector;
import top.theillusivec4.polymorph.core.Polymorph;
import top.theillusivec4.polymorph.core.client.gui.RecipeSelectorGui;
import top.theillusivec4.polymorph.core.client.gui.ToggleRecipeButton;
import top.theillusivec4.polymorph.loader.mixin.core.HandledScreenAccessor;

public abstract class AbstractRecipeSelector<I extends class_1263, R extends class_1860<I>>
implements RecipeSelector<I, R> {
    public static final class_2960 TOGGLE = new class_2960("polymorph", "textures/gui/toggle.png");
    private static final int SELECTOR_X_OFFSET = -4;
    private static final int SELECTOR_Y_OFFSET = -26;
    protected final RecipeSelectorGui<I, R> recipeSelectorGui;
    protected final class_339 toggleButton;
    protected final PolyProvider<I, R> provider;
    protected final class_465<?> parent;
    private boolean updatePosition = false;

    public AbstractRecipeSelector(class_465<?> screen, PolyProvider<I, R> provider) {
        this.parent = screen;
        this.provider = provider;
        int x = ((HandledScreenAccessor)screen).getX() + provider.getXPos();
        int y = ((HandledScreenAccessor)screen).getY() + provider.getYPos();
        this.recipeSelectorGui = new RecipeSelectorGui<I, class_1860>(x + -4, y + -26, provider.getInventory(), this::selectRecipe, (class_437)this.parent);
        this.toggleButton = new ToggleRecipeButton(x, y, 16, 16, 0, 0, 17, TOGGLE, clickWidget -> this.recipeSelectorGui.setVisible(!this.recipeSelectorGui.isVisible()));
        this.toggleButton.field_22764 = this.recipeSelectorGui.getButtons().size() > 1;
    }

    @Override
    public PolyProvider<I, R> getProvider() {
        return this.provider;
    }

    public void reposition() {
        int x = ((HandledScreenAccessor)this.parent).getX() + this.provider.getXPos();
        int y = ((HandledScreenAccessor)this.parent).getY() + this.provider.getYPos();
        this.recipeSelectorGui.setPosition(x + -4, y + -26);
        this.toggleButton.field_22760 = x;
        this.toggleButton.field_22761 = y;
    }

    @Override
    public void tick() {
        if (this.updatePosition) {
            this.updatePosition = false;
            this.reposition();
        }
    }

    public void clearRecipes(class_1937 world) {
        this.setRecipes(new ArrayList(), world, false, "");
    }

    protected void fetchRecipes() {
        Polymorph.getLoader().getPacketVendor().fetchRecipes();
    }

    @Override
    public void render(class_4587 matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.recipeSelectorGui.method_25394(matrixStack, mouseX, mouseY, partialTicks);
        this.toggleButton.method_25394(matrixStack, mouseX, mouseY, partialTicks);
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.toggleButton.method_25402(mouseX, mouseY, button)) {
            return true;
        }
        if (this.recipeSelectorGui.method_25402(mouseX, mouseY, button)) {
            this.recipeSelectorGui.setVisible(false);
            return true;
        }
        if (this.recipeSelectorGui.isVisible()) {
            if (!this.toggleButton.method_25402(mouseX, mouseY, button)) {
                this.recipeSelectorGui.setVisible(false);
            }
            return true;
        }
        return false;
    }

    @Override
    public void markUpdatePosition() {
        this.updatePosition = true;
    }

    static class RecipeOutput {
        private final class_1792 item;
        private final int count;
        private final class_2487 tag;

        public RecipeOutput(class_1799 stack) {
            this.item = stack.method_7909();
            this.count = stack.method_7947();
            this.tag = stack.method_7969();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RecipeOutput that = (RecipeOutput)o;
            return this.count == that.count && this.item.equals(that.item) && Objects.equals(this.tag, that.tag);
        }

        public int hashCode() {
            return Objects.hash(this.item, this.count, this.tag);
        }
    }
}

