/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.polymorph.core.client.selector;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1715;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_3955;
import net.minecraft.class_465;
import net.minecraft.class_638;
import net.minecraft.class_746;
import top.theillusivec4.polymorph.api.type.CraftingProvider;
import top.theillusivec4.polymorph.core.Polymorph;
import top.theillusivec4.polymorph.core.client.selector.AbstractRecipeSelector;
import top.theillusivec4.polymorph.core.client.selector.RecipeSelectorManager;

public class CraftingRecipeSelector
extends AbstractRecipeSelector<class_1715, class_3955> {
    private static class_1860<class_1715> lastPlacedRecipe;
    private static List<class_3955> lastRecipesList;
    private static class_1860<class_1715> lastSelectedRecipe;
    private boolean update = true;
    private boolean updatable = true;
    private static final int GLFW_LEFT_SHIFT = 340;
    private static final int GLFW_RIGHT_SHIFT = 344;

    public static void update() {
        RecipeSelectorManager.getSelector().ifPresent(selector -> {
            CraftingRecipeSelector craftingRecipeSelector;
            if (selector instanceof CraftingRecipeSelector && (craftingRecipeSelector = (CraftingRecipeSelector)selector).updatable()) {
                craftingRecipeSelector.markUpdate();
            }
        });
    }

    public static Optional<List<class_3955>> getLastRecipesList() {
        return Optional.ofNullable(lastRecipesList);
    }

    public static void setLastRecipesList(List<class_3955> recipesList) {
        lastRecipesList = recipesList;
    }

    public static Optional<class_1860<class_1715>> getLastPlacedRecipe() {
        return Optional.ofNullable(lastPlacedRecipe);
    }

    public static void setLastPlacedRecipe(class_1860<class_1715> recipe) {
        lastPlacedRecipe = recipe;
    }

    public static Optional<class_1860<class_1715>> getLastSelectedRecipe() {
        return Optional.ofNullable(lastSelectedRecipe);
    }

    public static void setLastSelectedRecipe(class_1860<class_1715> recipe) {
        lastSelectedRecipe = recipe;
    }

    public CraftingRecipeSelector(class_465<?> screen, CraftingProvider provider) {
        super(screen, provider);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.update) {
            class_638 world = class_310.method_1551().field_1687;
            this.update = false;
            if (world != null) {
                Optional<class_1860<class_1715>> maybeLast = CraftingRecipeSelector.getLastPlacedRecipe();
                maybeLast.ifPresent(recipe -> {
                    if (recipe.method_8115(this.provider.getInventory(), (class_1937)world)) {
                        List recipes = CraftingRecipeSelector.getLastRecipesList().orElse(new ArrayList());
                        this.setRecipes(recipes, (class_1937)world, false, "");
                    } else {
                        this.fetchRecipes();
                    }
                });
                if (!maybeLast.isPresent()) {
                    this.fetchRecipes();
                }
            }
        }
    }

    @Override
    public void setRecipes(List<class_3955> recipes, class_1937 world, boolean refresh, String selected) {
        if (refresh) {
            HashSet recipeOutputs = new HashSet();
            recipes.removeIf(rec -> !recipeOutputs.add(new AbstractRecipeSelector.RecipeOutput(rec.method_8116(this.provider.getInventory()))));
            if (!recipes.isEmpty()) {
                class_3955 defaultRecipe = recipes.get(0);
                CraftingRecipeSelector.setLastSelectedRecipe((class_1860<class_1715>)defaultRecipe);
                CraftingRecipeSelector.setLastPlacedRecipe((class_1860<class_1715>)defaultRecipe);
                CraftingRecipeSelector.setLastRecipesList(recipes);
            }
        }
        this.recipeSelectorGui.setRecipes(recipes);
        this.toggleButton.field_22764 = recipes.size() > 1;
        CraftingRecipeSelector.getLastSelectedRecipe().ifPresent(recipe -> {
            if (recipe.method_8115(this.provider.getInventory(), world)) {
                class_746 playerEntity = class_310.method_1551().field_1724;
                this.updatable = false;
                if (playerEntity != null) {
                    Polymorph.getLoader().getPacketVendor().sendSetCraftingRecipe(recipe.method_8114().toString());
                }
            }
        });
        RecipeSelectorManager.getPreferredRecipe().ifPresent(id -> {
            for (class_3955 recipe : recipes) {
                if (recipe.method_8114() != id) continue;
                RecipeSelectorManager.setPreferredRecipe(null);
                this.selectRecipe(recipe);
                return;
            }
        });
    }

    @Override
    public void selectRecipe(class_3955 recipe) {
        CraftingRecipeSelector.setLastSelectedRecipe((class_1860<class_1715>)recipe);
        class_746 playerEntity = class_310.method_1551().field_1724;
        if (playerEntity != null) {
            class_1799 stack = recipe.method_8116(this.provider.getInventory());
            this.provider.getOutputSlot().method_7673(stack.method_7972());
            Polymorph.getLoader().getPacketVendor().sendSetCraftingRecipe(recipe.method_8114().toString());
        }
    }

    @Override
    public void highlightRecipe(String recipe) {
    }

    @Override
    public void setRecipes(Set<String> recipeIds, class_1937 world, boolean refresh, String selected) {
        ArrayList<class_3955> recipes = new ArrayList<class_3955>();
        recipeIds.forEach(id -> world.method_8433().method_8130(new class_2960(id)).ifPresent(recipe -> {
            if (recipe instanceof class_3955) {
                recipes.add((class_3955)recipe);
            }
        }));
        recipes.sort(Comparator.comparing(recipe -> recipe.method_8110().method_7922()));
        this.setRecipes((List<class_3955>)recipes, world, refresh, selected);
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (!super.mouseClicked(mouseX, mouseY, button)) {
            class_1735 slot = this.provider.getOutputSlot();
            class_1735 focusedSlot = Polymorph.getClientLoader().getClientAccessor().getFocusedSlot(this.parent);
            if (this.toggleButton.field_22764 && slot == focusedSlot && CraftingRecipeSelector.isShiftKeyDown()) {
                return CraftingRecipeSelector.getLastSelectedRecipe().map(recipe -> {
                    Polymorph.getLoader().getPacketVendor().sendTransferRecipe(recipe.method_8114().toString());
                    return true;
                }).orElse(false);
            }
        }
        return false;
    }

    public boolean updatable() {
        return this.updatable;
    }

    public void setUpdatable(boolean flag) {
        this.updatable = flag;
    }

    public void markUpdate() {
        this.update = true;
    }

    private static boolean isShiftKeyDown() {
        long handle = class_310.method_1551().method_22683().method_4490();
        return class_3675.method_15987((long)handle, (int)340) || class_3675.method_15987((long)handle, (int)344);
    }
}

