/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.polymorph.loader.common;

import com.mojang.brigadier.CommandDispatcher;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v1.CommandRegistrationCallback;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2168;
import top.theillusivec4.polymorph.loader.common.integration.CompatibilityModule;
import top.theillusivec4.polymorph.loader.common.integration.fabricfurnaces.FabricFurnacesModule;
import top.theillusivec4.polymorph.loader.common.integration.ironfurnaces.IronFurnacesModule;
import top.theillusivec4.polymorph.loader.network.NetworkHandler;
import top.theillusivec4.polymorph.loader.server.PolymorphCommands;

public class PolymorphMod
implements ModInitializer {
    private static final Map<String, Supplier<CompatibilityModule>> INTEGRATIONS = new HashMap<String, Supplier<CompatibilityModule>>();
    private static final List<CompatibilityModule> ACTIVE_INTEGRATIONS = new ArrayList<CompatibilityModule>();
    public static boolean isFastFurnaceLoaded = false;

    public PolymorphMod() {
        FabricLoader loader = FabricLoader.getInstance();
        isFastFurnaceLoaded = loader.isModLoaded("fastfurnace");
        INTEGRATIONS.forEach((modid, supplier) -> {
            if (loader.isModLoaded(modid)) {
                ACTIVE_INTEGRATIONS.add((CompatibilityModule)supplier.get());
            }
        });
    }

    public void onInitialize() {
        NetworkHandler.setup();
        CommandRegistrationCallback.EVENT.register((commandDispatcher, b) -> PolymorphCommands.register((CommandDispatcher<class_2168>)commandDispatcher));
        ACTIVE_INTEGRATIONS.forEach(CompatibilityModule::setup);
    }

    static {
        INTEGRATIONS.put("ironfurnaces", IronFurnacesModule::new);
        INTEGRATIONS.put("fabric-furnaces", FabricFurnacesModule::new);
    }
}

