/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.polymorph.loader.common.integration.ironfurnaces;

import ironfurnaces.container.BlockIronFurnaceScreenHandler;
import ironfurnaces.container.BlockIronFurnaceScreenHandlerBase;
import ironfurnaces.tileentity.BlockIronFurnaceTileBase;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1263;
import net.minecraft.class_156;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1863;
import net.minecraft.class_1874;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3956;
import org.apache.commons.lang3.reflect.FieldUtils;
import top.theillusivec4.polymorph.api.PolymorphApi;
import top.theillusivec4.polymorph.api.type.FurnaceProvider;
import top.theillusivec4.polymorph.api.type.PersistentSelector;
import top.theillusivec4.polymorph.core.Polymorph;
import top.theillusivec4.polymorph.loader.common.integration.CompatibilityModule;

public class IronFurnacesModule
extends CompatibilityModule {
    @Override
    public void setup() {
        PolymorphApi.getInstance().addEntityProvider(blockEntity -> {
            if (blockEntity instanceof BlockIronFurnaceTileBase) {
                return new IronFurnaceSelector((BlockIronFurnaceTileBase)blockEntity);
            }
            return null;
        }, screenHandler -> {
            if (screenHandler instanceof BlockIronFurnaceScreenHandlerBase) {
                return new IronFurnaceProvider((class_1703)screenHandler);
            }
            return null;
        });
    }

    private static class IronFurnaceProvider
    implements FurnaceProvider {
        final class_1703 container;
        final class_1263 input;

        public IronFurnaceProvider(class_1703 container) {
            this.container = container;
            this.input = ((class_1735)container.field_7761.get((int)0)).field_7871;
        }

        private class_3956<? extends class_1874> getRecipeType() {
            if (this.input instanceof BlockIronFurnaceTileBase) {
                try {
                    return (class_3956)FieldUtils.readField((Object)this.input, (String)"recipeType", (boolean)true);
                }
                catch (IllegalAccessException e) {
                    Polymorph.LOGGER.error("Error accessing recipeType of Iron Furnaces!");
                    e.printStackTrace();
                }
            }
            return class_3956.field_17546;
        }

        @Override
        public class_1703 getScreenHandler() {
            return this.container;
        }

        @Override
        public class_1263 getInventory() {
            return this.input;
        }

        @Override
        public List<? extends class_1874> getRecipes(class_1937 world, class_1863 recipeManager) {
            return recipeManager.method_17877(this.getRecipeType(), this.getInventory(), world);
        }

        @Override
        public class_1735 getOutputSlot() {
            return (class_1735)this.container.field_7761.get(2);
        }
    }

    private static class IronFurnaceSelector
    implements PersistentSelector {
        private final BlockIronFurnaceTileBase parent;
        private class_1874 selectedRecipe;
        private class_1799 lastFailedInput = class_1799.field_8037;
        private String savedRecipe = "";

        public IronFurnaceSelector(BlockIronFurnaceTileBase tileEntity) {
            this.parent = tileEntity;
        }

        @Override
        public Optional<class_1860<?>> fetchRecipe(class_1937 world) {
            Optional<class_1860<?>> maybeRecipe;
            class_1799 input = this.parent.method_5438(0);
            if (input == this.lastFailedInput) {
                return Optional.empty();
            }
            if (!this.savedRecipe.isEmpty()) {
                Optional saved = world.method_8433().method_8130(new class_2960(this.savedRecipe));
                if (!saved.isPresent() || !((class_1860)saved.get()).method_8115((class_1263)this.parent, world)) {
                    this.savedRecipe = "";
                } else {
                    this.setSelectedRecipe((class_1860)saved.get());
                    this.savedRecipe = "";
                    return saved;
                }
            }
            if (!(maybeRecipe = world.method_8433().method_8126().stream().filter(val -> val.method_17716() == this.getRecipeType()).flatMap(val -> class_156.method_17815((Optional)this.getRecipeType().method_17725(val, world, (class_1263)this.parent))).min(Comparator.comparing(recipe -> recipe.method_8110().method_7922())).map(val -> {
                this.setSelectedRecipe((class_1860<?>)val);
                return val;
            })).isPresent()) {
                this.lastFailedInput = input;
            }
            return maybeRecipe;
        }

        @Override
        public class_3956<? extends class_1860<?>> getRecipeType() {
            try {
                return (class_3956)FieldUtils.readField((Object)this.parent, (String)"recipeType", (boolean)true);
            }
            catch (IllegalAccessException e) {
                Polymorph.LOGGER.error("Error accessing recipeType of Iron Furnaces!");
                e.printStackTrace();
                return class_3956.field_17546;
            }
        }

        public Optional<class_1860<?>> getSelectedRecipe() {
            return Optional.ofNullable(this.selectedRecipe);
        }

        @Override
        public void setSavedRecipe(String recipe) {
            this.savedRecipe = recipe;
        }

        @Override
        public void setSelectedRecipe(class_1860<?> recipe) {
            this.selectedRecipe = (class_1874)recipe;
            class_1937 world = this.parent.method_10997();
            if (world instanceof class_3218) {
                ((class_3218)world).method_18456().forEach(player -> {
                    if (player.field_7512 instanceof BlockIronFurnaceScreenHandler && ((class_1735)player.field_7512.field_7761.get((int)0)).field_7871 == this.parent) {
                        Polymorph.getLoader().getPacketVendor().highlightRecipe(recipe.method_8114().toString(), (class_3222)player);
                    }
                });
            }
        }

        @Override
        public class_2586 getParent() {
            return this.parent;
        }

        public void readFromNbt(class_2487 compoundTag) {
            if (compoundTag.method_10545("SelectedRecipe")) {
                this.setSavedRecipe(compoundTag.method_10558("SelectedRecipe"));
            }
        }

        public void writeToNbt(class_2487 compoundTag) {
            if (this.selectedRecipe != null) {
                compoundTag.method_10582("SelectedRecipe", this.selectedRecipe.method_8114().toString());
            }
        }
    }
}

