/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.polymorph.loader.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.class_1263;
import net.minecraft.class_1703;
import net.minecraft.class_1715;
import net.minecraft.class_1731;
import net.minecraft.class_1735;
import net.minecraft.class_1860;
import net.minecraft.class_1874;
import net.minecraft.class_2586;
import net.minecraft.class_3955;
import net.minecraft.class_465;
import top.theillusivec4.polymorph.api.PolymorphApi;
import top.theillusivec4.polymorph.api.type.CraftingProvider;
import top.theillusivec4.polymorph.api.type.FurnaceProvider;
import top.theillusivec4.polymorph.api.type.PersistentSelector;
import top.theillusivec4.polymorph.api.type.PolyProvider;
import top.theillusivec4.polymorph.api.type.RecipeSelector;
import top.theillusivec4.polymorph.core.client.selector.CraftingRecipeSelector;
import top.theillusivec4.polymorph.core.client.selector.FurnaceRecipeSelector;

public class PolymorphApiImpl
implements PolymorphApi {
    public static final PolymorphApi INSTANCE = new PolymorphApiImpl();
    private static final List<Function<class_1703, PolyProvider<? extends class_1263, ? extends class_1860<?>>>> providerFunctions = new ArrayList();
    private static final List<Function<class_2586, PersistentSelector>> entityFunctions = new ArrayList<Function<class_2586, PersistentSelector>>();

    @Override
    public void addProvider(Function<class_1703, PolyProvider<?, ?>> providerFunction) {
        providerFunctions.add(providerFunction);
    }

    @Override
    public void addEntityProvider(Function<class_2586, PersistentSelector> entityFunction, Function<class_1703, PolyProvider<?, ?>> providerFunction) {
        this.addProvider(providerFunction);
        entityFunctions.add(entityFunction);
    }

    @Override
    public Optional<PersistentSelector> getSelector(class_2586 te) {
        for (Function<class_2586, PersistentSelector> entityFunction : entityFunctions) {
            PersistentSelector selector = entityFunction.apply(te);
            if (selector == null) continue;
            return Optional.of(selector);
        }
        return Optional.empty();
    }

    @Override
    public Optional<PolyProvider<?, ?>> getProvider(class_1703 container) {
        for (Function<class_1703, PolyProvider<class_1263, class_1860<?>>> function : providerFunctions) {
            PolyProvider<? extends class_1263, ? extends class_1860<?>> polyProvider = function.apply(container);
            if (polyProvider == null) continue;
            return Optional.of(polyProvider);
        }
        class_1735 resultSlot = null;
        class_1715 craftingInventory = null;
        for (class_1735 slot : container.field_7761) {
            if (resultSlot == null && slot.field_7871 instanceof class_1731) {
                resultSlot = slot;
            } else if (craftingInventory == null && slot.field_7871 instanceof class_1715) {
                craftingInventory = (class_1715)slot.field_7871;
            }
            if (resultSlot == null || craftingInventory == null) continue;
            break;
        }
        return Optional.ofNullable(resultSlot != null && craftingInventory != null ? new SimpleCraftingProvider(container, craftingInventory, resultSlot) : null);
    }

    @Override
    public RecipeSelector<class_1715, class_3955> createCraftingSelector(class_465<?> screen, CraftingProvider provider) {
        return new CraftingRecipeSelector(screen, provider);
    }

    @Override
    public RecipeSelector<class_1263, class_1874> createFurnaceSelector(class_465<?> screen, FurnaceProvider provider) {
        return new FurnaceRecipeSelector(screen, provider);
    }

    private static class SimpleCraftingProvider
    implements CraftingProvider {
        final class_1703 container;
        final class_1715 craftingInventory;
        final class_1735 resultSlot;

        public SimpleCraftingProvider(class_1703 container, class_1715 craftingInventory, class_1735 resultSlot) {
            this.container = container;
            this.craftingInventory = craftingInventory;
            this.resultSlot = resultSlot;
        }

        @Override
        public class_1703 getScreenHandler() {
            return this.container;
        }

        @Override
        public class_1715 getInventory() {
            return this.craftingInventory;
        }

        @Override
        public class_1735 getOutputSlot() {
            return this.resultSlot;
        }
    }
}

