/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.polymorph.loader.server;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.class_1662;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1869;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_3218;
import net.minecraft.class_3956;
import top.theillusivec4.polymorph.core.Polymorph;

public class PolymorphCommands {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        int opPermissionLevel = 4;
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)class_2170.method_9247((String)"polymorph").requires(player -> player.method_9259(4));
        command.then(class_2170.method_9247((String)"conflicts").executes(context -> PolymorphCommands.findConflicts((class_2168)context.getSource())));
        dispatcher.register(command);
    }

    private static int findConflicts(class_2168 source) {
        class_3218 world = source.method_9225();
        ArrayList lines = new ArrayList();
        HashSet processed = new HashSet();
        Collection recipes = world.method_8433().method_8126();
        class_1662 recipeItemHelper = new class_1662();
        IntArrayList first = new IntArrayList();
        IntArrayList second = new IntArrayList();
        AtomicInteger conflictCount = new AtomicInteger();
        source.method_9226((class_2561)new class_2588("commands.polymorph.conflicts.starting"), true);
        try {
            recipes.forEach(recipe -> {
                String id = recipe.method_8114().toString();
                ArrayList conflicts = new ArrayList();
                if (!processed.contains(id)) {
                    processed.add(id);
                    recipes.forEach(otherRecipe -> {
                        String otherId = otherRecipe.method_8114().toString();
                        if (!processed.contains(otherId) && !class_1799.method_7973((class_1799)otherRecipe.method_8110(), (class_1799)recipe.method_8110()) && recipe.method_17716() == class_3956.field_17545 && recipe.method_17716() == otherRecipe.method_17716() && !recipe.method_8118() && recipe.method_8118() == otherRecipe.method_8118() && PolymorphCommands.areSameShape(recipe, otherRecipe)) {
                            recipeItemHelper.method_7409();
                            recipe.method_8117().forEach(ingredient -> {
                                class_1799[] stacks;
                                for (class_1799 matchingStack : stacks = Polymorph.getLoader().getAccessor().getMatchingStacks((class_1856)ingredient)) {
                                    recipeItemHelper.method_7400(matchingStack);
                                }
                            });
                            second.clear();
                            if (recipeItemHelper.method_7402(recipe, (IntList)second)) {
                                recipeItemHelper.method_7409();
                                otherRecipe.method_8117().forEach(ingredient -> {
                                    class_1799[] stacks;
                                    for (class_1799 matchingStack : stacks = Polymorph.getLoader().getAccessor().getMatchingStacks((class_1856)ingredient)) {
                                        recipeItemHelper.method_7400(matchingStack);
                                    }
                                });
                                first.clear();
                                if (recipeItemHelper.method_7402(otherRecipe, (IntList)first) && first.equals(second)) {
                                    processed.add(otherId);
                                    conflicts.add(otherId);
                                }
                            }
                        }
                    });
                }
                if (!conflicts.isEmpty()) {
                    conflictCount.addAndGet(conflicts.size());
                    lines.add("Conflicts with " + id + ":");
                    lines.addAll(conflicts);
                    lines.add("");
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (!lines.isEmpty()) {
            try {
                Files.write(Paths.get(Polymorph.getLoader().getGameDirectory() + "/logs/conflicts.log", new String[0]), lines, StandardCharsets.UTF_8, new OpenOption[0]);
            }
            catch (IOException e) {
                Polymorph.LOGGER.error("Whoops! Something went wrong writing down your conflicts :(");
            }
        }
        source.method_9226((class_2561)new class_2588("commands.polymorph.conflicts.success", new Object[]{conflictCount.get()}), true);
        return 1;
    }

    private static boolean areSameShape(class_1860<?> recipe1, class_1860<?> recipe2) {
        if (recipe1 instanceof class_1869 && recipe2 instanceof class_1869) {
            class_1869 shapedRecipe1 = (class_1869)recipe1;
            class_1869 shapedRecipe2 = (class_1869)recipe2;
            return shapedRecipe1.method_8158() == shapedRecipe2.method_8158() && shapedRecipe1.method_8150() == shapedRecipe2.method_8150();
        }
        return true;
    }
}

