/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.polymorph.client.selector;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.util.InputMappings;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.PacketDistributor;
import top.theillusivec4.polymorph.api.type.ICraftingProvider;
import top.theillusivec4.polymorph.client.selector.RecipeSelector;
import top.theillusivec4.polymorph.client.selector.RecipeSelectorManager;
import top.theillusivec4.polymorph.common.network.NetworkManager;
import top.theillusivec4.polymorph.common.network.client.CPacketSetCraftingRecipe;
import top.theillusivec4.polymorph.common.network.client.CPacketTransferRecipe;

public class CraftingRecipeSelector
extends RecipeSelector<CraftingInventory, ICraftingRecipe> {
    private static IRecipe<CraftingInventory> lastPlacedRecipe;
    private static List<ICraftingRecipe> lastRecipesList;
    private static IRecipe<CraftingInventory> lastSelectedRecipe;
    private boolean update = true;
    private boolean updatable = true;
    private static final int GLFW_LEFT_SHIFT = 340;
    private static final int GLFW_RIGHT_SHIFT = 344;

    public static void update() {
        RecipeSelectorManager.getSelector().ifPresent(selector -> {
            CraftingRecipeSelector craftingRecipeSelector;
            if (selector instanceof CraftingRecipeSelector && (craftingRecipeSelector = (CraftingRecipeSelector)selector).updatable()) {
                craftingRecipeSelector.markUpdate();
            }
        });
    }

    public static Optional<List<ICraftingRecipe>> getLastRecipesList() {
        return Optional.ofNullable(lastRecipesList);
    }

    public static void setLastRecipesList(List<ICraftingRecipe> recipesList) {
        lastRecipesList = recipesList;
    }

    public static Optional<IRecipe<CraftingInventory>> getLastPlacedRecipe() {
        return Optional.ofNullable(lastPlacedRecipe);
    }

    public static void setLastPlacedRecipe(IRecipe<CraftingInventory> recipe) {
        lastPlacedRecipe = recipe;
    }

    public static Optional<IRecipe<CraftingInventory>> getLastSelectedRecipe() {
        return Optional.ofNullable(lastSelectedRecipe);
    }

    public static void setLastSelectedRecipe(IRecipe<CraftingInventory> recipe) {
        lastSelectedRecipe = recipe;
    }

    public CraftingRecipeSelector(ContainerScreen<?> screen, ICraftingProvider provider) {
        super(screen, provider);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.update) {
            ClientWorld world = Minecraft.func_71410_x().field_71441_e;
            this.update = false;
            if (world != null) {
                Optional<IRecipe<CraftingInventory>> maybeLast = CraftingRecipeSelector.getLastPlacedRecipe();
                maybeLast.ifPresent(recipe -> {
                    if (recipe.func_77569_a(this.provider.getInventory(), (World)world)) {
                        List recipes = CraftingRecipeSelector.getLastRecipesList().orElse(new ArrayList());
                        this.setRecipes(recipes, (World)world, false, "");
                    } else {
                        this.fetchRecipes();
                    }
                });
                if (!maybeLast.isPresent()) {
                    this.fetchRecipes();
                }
            }
        }
    }

    @Override
    public void setRecipes(List<ICraftingRecipe> recipes, World world, boolean refresh, String selected) {
        if (refresh) {
            HashSet recipeOutputs = new HashSet();
            recipes.removeIf(rec -> !recipeOutputs.add(new RecipeSelector.RecipeOutput(rec.func_77572_b(this.provider.getInventory()))));
            if (!recipes.isEmpty()) {
                ICraftingRecipe defaultRecipe = recipes.get(0);
                CraftingRecipeSelector.setLastSelectedRecipe((IRecipe<CraftingInventory>)defaultRecipe);
                CraftingRecipeSelector.setLastPlacedRecipe((IRecipe<CraftingInventory>)defaultRecipe);
                CraftingRecipeSelector.setLastRecipesList(recipes);
            }
        } else {
            CraftingRecipeSelector.getLastSelectedRecipe().ifPresent(recipe -> {
                if (recipe.func_77569_a(this.provider.getInventory(), world)) {
                    ClientPlayerEntity playerEntity = Minecraft.func_71410_x().field_71439_g;
                    this.updatable = false;
                    if (playerEntity != null) {
                        NetworkManager.INSTANCE.send(PacketDistributor.SERVER.noArg(), (Object)new CPacketSetCraftingRecipe(recipe.func_199560_c().toString()));
                    }
                }
            });
        }
        this.recipeSelectorGui.setRecipes(recipes);
        this.toggleButton.field_230694_p_ = recipes.size() > 1;
        RecipeSelectorManager.getPreferredRecipe().ifPresent(id -> {
            for (ICraftingRecipe recipe : recipes) {
                if (recipe.func_199560_c() != id) continue;
                RecipeSelectorManager.setPreferredRecipe(null);
                this.selectRecipe(recipe);
                return;
            }
        });
    }

    @Override
    public void selectRecipe(ICraftingRecipe recipe) {
        CraftingRecipeSelector.setLastSelectedRecipe((IRecipe<CraftingInventory>)recipe);
        ClientPlayerEntity playerEntity = Minecraft.func_71410_x().field_71439_g;
        if (playerEntity != null) {
            ItemStack stack = recipe.func_77572_b(this.provider.getInventory());
            this.provider.getOutputSlot().func_75215_d(stack.func_77946_l());
            NetworkManager.INSTANCE.send(PacketDistributor.SERVER.noArg(), (Object)new CPacketSetCraftingRecipe(recipe.func_199560_c().toString()));
        }
    }

    @Override
    public void highlightRecipe(String recipe) {
    }

    @Override
    public void setRecipes(Set<String> recipeIds, World world, boolean refresh, String selected) {
        ArrayList<ICraftingRecipe> recipes = new ArrayList<ICraftingRecipe>();
        recipeIds.forEach(id -> world.func_199532_z().func_215367_a(new ResourceLocation(id)).ifPresent(recipe -> {
            if (recipe instanceof ICraftingRecipe) {
                recipes.add((ICraftingRecipe)recipe);
            }
        }));
        recipes.sort(Comparator.comparing(recipe -> recipe.func_77571_b().func_77977_a()));
        this.setRecipes((List<ICraftingRecipe>)recipes, world, refresh, selected);
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (!super.mouseClicked(mouseX, mouseY, button)) {
            Slot slot = this.provider.getOutputSlot();
            if (this.toggleButton.field_230694_p_ && slot == this.parent.getSlotUnderMouse() && CraftingRecipeSelector.isShiftKeyDown()) {
                return CraftingRecipeSelector.getLastSelectedRecipe().map(recipe -> {
                    NetworkManager.INSTANCE.send(PacketDistributor.SERVER.noArg(), (Object)new CPacketTransferRecipe(recipe.func_199560_c().toString()));
                    return true;
                }).orElse(false);
            }
        }
        return false;
    }

    public boolean updatable() {
        return this.updatable;
    }

    public void setUpdatable(boolean flag) {
        this.updatable = flag;
    }

    public void markUpdate() {
        this.update = true;
    }

    private static boolean isShiftKeyDown() {
        long handle = Minecraft.func_71410_x().func_228018_at_().func_198092_i();
        return InputMappings.func_216506_a((long)handle, (int)340) || InputMappings.func_216506_a((long)handle, (int)344);
    }
}

