/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.block.tile;

import com.hrznstudio.titanium.api.IFactory;
import com.hrznstudio.titanium.api.client.IScreenAddon;
import com.hrznstudio.titanium.api.client.IScreenAddonProvider;
import com.hrznstudio.titanium.api.filter.IFilter;
import com.hrznstudio.titanium.block.BasicTileBlock;
import com.hrznstudio.titanium.block.RotatableBlock;
import com.hrznstudio.titanium.block.tile.BasicTile;
import com.hrznstudio.titanium.client.screen.asset.IAssetProvider;
import com.hrznstudio.titanium.client.screen.asset.IHasAssetProvider;
import com.hrznstudio.titanium.component.IComponentBundle;
import com.hrznstudio.titanium.component.button.ButtonComponent;
import com.hrznstudio.titanium.component.button.MultiButtonComponent;
import com.hrznstudio.titanium.component.filter.MultiFilterComponent;
import com.hrznstudio.titanium.component.fluid.FluidTankComponent;
import com.hrznstudio.titanium.component.fluid.MultiTankComponent;
import com.hrznstudio.titanium.component.inventory.InventoryComponent;
import com.hrznstudio.titanium.component.inventory.MultiInventoryComponent;
import com.hrznstudio.titanium.component.progress.MultiProgressBarHandler;
import com.hrznstudio.titanium.component.progress.ProgressBarComponent;
import com.hrznstudio.titanium.component.sideness.IFacingComponent;
import com.hrznstudio.titanium.component.sideness.IFacingComponentHarness;
import com.hrznstudio.titanium.container.BasicAddonContainer;
import com.hrznstudio.titanium.container.addon.IContainerAddon;
import com.hrznstudio.titanium.container.addon.IContainerAddonProvider;
import com.hrznstudio.titanium.network.IButtonHandler;
import com.hrznstudio.titanium.network.locator.LocatorFactory;
import com.hrznstudio.titanium.network.locator.instance.TileEntityLocatorInstance;
import com.hrznstudio.titanium.util.FacingUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.CapabilityItemHandler;

public abstract class ActiveTile<T extends ActiveTile<T>>
extends BasicTile<T>
implements IScreenAddonProvider,
ITickableTileEntity,
INamedContainerProvider,
IButtonHandler,
IFacingComponentHarness,
IContainerAddonProvider,
IHasAssetProvider {
    private MultiInventoryComponent<T> multiInventoryComponent;
    private MultiProgressBarHandler<T> multiProgressBarHandler;
    private MultiTankComponent<T> multiTankComponent;
    private MultiButtonComponent multiButtonComponent;
    private MultiFilterComponent multiFilterComponent;
    private List<IFactory<? extends IScreenAddon>> guiAddons = new ArrayList<IFactory<? extends IScreenAddon>>();
    private List<IFactory<? extends IContainerAddon>> containerAddons = new ArrayList<IFactory<? extends IContainerAddon>>();

    public ActiveTile(BasicTileBlock<T> base) {
        super(base);
    }

    @Override
    @ParametersAreNonnullByDefault
    public ActionResultType onActivated(PlayerEntity player, Hand hand, Direction facing, double hitX, double hitY, double hitZ) {
        if (this.multiTankComponent != null && FluidUtil.interactWithFluidHandler((PlayerEntity)player, (Hand)hand, (IFluidHandler)((IFluidHandler)this.multiTankComponent.getCapabilityForSide(null).orElse(new MultiTankComponent.MultiTankCapabilityHandler(new ArrayList()))))) {
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    @Override
    public void onNeighborChanged(Block blockIn, BlockPos fromPos) {
    }

    public void openGui(PlayerEntity player) {
        if (player instanceof ServerPlayerEntity) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)this, buffer -> LocatorFactory.writePacketBuffer(buffer, new TileEntityLocatorInstance(this.field_174879_c)));
        }
    }

    @Nullable
    public Container createMenu(int menu, PlayerInventory inventoryPlayer, PlayerEntity entityPlayer) {
        return new BasicAddonContainer(this, new TileEntityLocatorInstance(this.field_174879_c), this.getWorldPosCallable(), inventoryPlayer, menu);
    }

    @Nonnull
    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent(this.getBasicTileBlock().func_149739_a()).func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.DARK_GRAY));
    }

    public void addInventory(InventoryComponent<T> handler) {
        if (this.multiInventoryComponent == null) {
            this.multiInventoryComponent = new MultiInventoryComponent();
        }
        this.multiInventoryComponent.add(handler.setComponentHarness(this.getSelf()));
    }

    public void addProgressBar(ProgressBarComponent<T> progressBarComponent) {
        if (this.multiProgressBarHandler == null) {
            this.multiProgressBarHandler = new MultiProgressBarHandler();
        }
        this.multiProgressBarHandler.add(progressBarComponent.setComponentHarness(this.getSelf()));
    }

    public void addTank(FluidTankComponent<T> tank) {
        if (this.multiTankComponent == null) {
            this.multiTankComponent = new MultiTankComponent();
        }
        this.multiTankComponent.add(tank.setComponentHarness(this.getSelf()));
    }

    public void addButton(ButtonComponent button) {
        if (this.multiButtonComponent == null) {
            this.multiButtonComponent = new MultiButtonComponent();
        }
        this.multiButtonComponent.add(button);
    }

    public void addFilter(IFilter<?> filter) {
        if (this.multiFilterComponent == null) {
            this.multiFilterComponent = new MultiFilterComponent();
        }
        this.multiFilterComponent.add(filter);
    }

    public void addBundle(IComponentBundle bundle) {
        if (this.multiInventoryComponent == null) {
            this.multiInventoryComponent = new MultiInventoryComponent();
        }
        if (this.multiProgressBarHandler == null) {
            this.multiProgressBarHandler = new MultiProgressBarHandler();
        }
        if (this.multiTankComponent == null) {
            this.multiTankComponent = new MultiTankComponent();
        }
        if (this.multiButtonComponent == null) {
            this.multiButtonComponent = new MultiButtonComponent();
        }
        if (this.multiFilterComponent == null) {
            this.multiFilterComponent = new MultiFilterComponent();
        }
        bundle.accept(this.multiInventoryComponent, this.multiProgressBarHandler, this.multiTankComponent, this.multiButtonComponent, this.multiFilterComponent);
        bundle.getScreenAddons().forEach(this::addGuiAddonFactory);
        bundle.getContainerAddons().forEach(this::addContainerAddonFactory);
    }

    @Nonnull
    public <U> LazyOptional<U> getCapability(@Nonnull Capability<U> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && this.multiInventoryComponent != null) {
            return this.multiInventoryComponent.getCapabilityForSide(FacingUtil.getFacingRelative(this.getFacingDirection(), side)).cast();
        }
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && this.multiTankComponent != null) {
            return this.multiTankComponent.getCapabilityForSide(FacingUtil.getFacingRelative(this.getFacingDirection(), side)).cast();
        }
        return LazyOptional.empty();
    }

    public MultiInventoryComponent<T> getMultiInventoryComponent() {
        return this.multiInventoryComponent;
    }

    public void addGuiAddonFactory(IFactory<? extends IScreenAddon> factory) {
        this.guiAddons.add(factory);
    }

    public void addContainerAddonFactory(IFactory<? extends IContainerAddon> factory) {
        this.containerAddons.add(factory);
    }

    @Override
    public List<IFactory<? extends IScreenAddon>> getScreenAddons() {
        ArrayList<IFactory<? extends IScreenAddon>> addons = new ArrayList<IFactory<? extends IScreenAddon>>(this.guiAddons);
        if (this.multiInventoryComponent != null) {
            addons.addAll(this.multiInventoryComponent.getScreenAddons());
        }
        if (this.multiProgressBarHandler != null) {
            addons.addAll(this.multiProgressBarHandler.getScreenAddons());
        }
        if (this.multiTankComponent != null) {
            addons.addAll(this.multiTankComponent.getScreenAddons());
        }
        if (this.multiButtonComponent != null) {
            addons.addAll(this.multiButtonComponent.getScreenAddons());
        }
        if (this.multiFilterComponent != null) {
            addons.addAll(this.multiFilterComponent.getScreenAddons());
        }
        return addons;
    }

    @Override
    public List<IFactory<? extends IContainerAddon>> getContainerAddons() {
        ArrayList<IFactory<? extends IContainerAddon>> addons = new ArrayList<IFactory<? extends IContainerAddon>>(this.containerAddons);
        if (this.multiInventoryComponent != null) {
            addons.addAll(this.multiInventoryComponent.getContainerAddons());
        }
        if (this.multiProgressBarHandler != null) {
            addons.addAll(this.multiProgressBarHandler.getContainerAddons());
        }
        if (this.multiTankComponent != null) {
            addons.addAll(this.multiTankComponent.getContainerAddons());
        }
        return addons;
    }

    @Override
    public IAssetProvider getAssetProvider() {
        return IAssetProvider.DEFAULT_PROVIDER;
    }

    public void func_73660_a() {
        block6: {
            if (this.field_145850_b.field_72995_K) break block6;
            if (this.multiProgressBarHandler != null) {
                this.multiProgressBarHandler.update();
            }
            if (this.field_145850_b.func_82737_E() % (long)this.getFacingHandlerWorkTime() == 0L) {
                Iterator<IScreenAddonProvider> iterator;
                if (this.multiInventoryComponent != null) {
                    InventoryComponent inventoryHandler;
                    iterator = this.multiInventoryComponent.getInventoryHandlers().iterator();
                    while (!(!iterator.hasNext() || (inventoryHandler = (InventoryComponent)iterator.next()) instanceof IFacingComponent && ((IFacingComponent)((Object)inventoryHandler)).work(this.field_145850_b, this.field_174879_c, this.getFacingDirection(), this.getFacingHandlerWorkAmount()))) {
                    }
                }
                if (this.multiTankComponent != null) {
                    FluidTankComponent tank;
                    iterator = this.multiTankComponent.getTanks().iterator();
                    while (!(!iterator.hasNext() || (tank = (FluidTankComponent)iterator.next()) instanceof IFacingComponent && ((IFacingComponent)((Object)tank)).work(this.field_145850_b, this.field_174879_c, this.getFacingDirection(), this.getFacingHandlerWorkAmount()))) {
                    }
                }
            }
        }
    }

    public int getFacingHandlerWorkTime() {
        return 10;
    }

    public int getFacingHandlerWorkAmount() {
        return 4;
    }

    public MultiButtonComponent getMultiButtonComponent() {
        return this.multiButtonComponent;
    }

    public Direction getFacingDirection() {
        return this.field_145850_b.func_180495_p(this.field_174879_c).func_235901_b_((Property)RotatableBlock.FACING_ALL) ? (Direction)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((Property)RotatableBlock.FACING_ALL) : (this.field_145850_b.func_180495_p(this.field_174879_c).func_235901_b_((Property)RotatableBlock.FACING_HORIZONTAL) ? (Direction)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((Property)RotatableBlock.FACING_HORIZONTAL) : Direction.NORTH);
    }

    @Override
    public IFacingComponent getHandlerFromName(String string) {
        if (this.multiInventoryComponent != null) {
            for (InventoryComponent inventoryComponent : this.multiInventoryComponent.getInventoryHandlers()) {
                if (!(inventoryComponent instanceof IFacingComponent) || !inventoryComponent.getName().equalsIgnoreCase(string)) continue;
                return (IFacingComponent)((Object)inventoryComponent);
            }
        }
        if (this.multiTankComponent != null) {
            for (FluidTankComponent fluidTankComponent : this.multiTankComponent.getTanks()) {
                if (!(fluidTankComponent instanceof IFacingComponent) || !fluidTankComponent.getName().equalsIgnoreCase(string)) continue;
                return (IFacingComponent)((Object)fluidTankComponent);
            }
        }
        return null;
    }

    @Override
    public void handleButtonMessage(int id, PlayerEntity playerEntity, CompoundNBT compound) {
        if (id == -3 && !compound.func_74764_b("Invalid") && compound.func_74764_b("Fill") && !playerEntity.field_71071_by.func_70445_o().func_190926_b()) {
            boolean fill = compound.func_74767_n("Fill");
            String name = compound.func_74779_i("Name");
            if (this.multiTankComponent != null) {
                for (FluidTankComponent fluidTankComponent : this.multiTankComponent.getTanks()) {
                    if (!fluidTankComponent.getName().equalsIgnoreCase(name)) continue;
                    playerEntity.field_71071_by.func_70445_o().getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).ifPresent(iFluidHandlerItem -> {
                        if (fill) {
                            int amount = fluidTankComponent.fill(iFluidHandlerItem.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE), IFluidHandler.FluidAction.EXECUTE);
                            iFluidHandlerItem.drain(amount, IFluidHandler.FluidAction.EXECUTE);
                        } else {
                            int amount = iFluidHandlerItem.fill(fluidTankComponent.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE), IFluidHandler.FluidAction.EXECUTE);
                            fluidTankComponent.drain(amount, IFluidHandler.FluidAction.EXECUTE);
                        }
                        playerEntity.field_71071_by.func_70437_b(iFluidHandlerItem.getContainer().func_77946_l());
                        if (playerEntity instanceof ServerPlayerEntity) {
                            ((ServerPlayerEntity)playerEntity).func_71113_k();
                        }
                    });
                }
            }
        }
        if (id == -2) {
            String name = compound.func_74779_i("Name");
            if (this.multiFilterComponent != null) {
                for (IFilter filter : this.multiFilterComponent.getFilters()) {
                    if (!filter.getName().equals(name)) continue;
                    int slot = compound.func_74762_e("Slot");
                    filter.setFilter(slot, ItemStack.func_199557_a((CompoundNBT)compound.func_74775_l("Filter")));
                    this.markForUpdate();
                    break;
                }
            }
        }
        if (id == -1) {
            String name = compound.func_74779_i("Name");
            FacingUtil.Sideness facing = FacingUtil.Sideness.valueOf(compound.func_74779_i("Facing"));
            int faceMode = compound.func_74762_e("Next");
            if (this.multiInventoryComponent != null && this.multiInventoryComponent.handleFacingChange(name, facing, faceMode)) {
                this.markForUpdate();
            } else if (this.multiTankComponent != null && this.multiTankComponent.handleFacingChange(name, facing, faceMode)) {
                this.markForUpdate();
            }
        } else if (this.multiButtonComponent != null) {
            this.multiButtonComponent.clickButton(id, playerEntity, compound);
        }
    }

    @Nonnull
    public abstract T getSelf();

    @Override
    public World getComponentWorld() {
        return this.getSelf().func_145831_w();
    }

    @Override
    public void markComponentDirty() {
        super.func_70296_d();
    }

    @Override
    public void markComponentForUpdate(boolean referenced) {
        if (!referenced) {
            super.markForUpdate();
        } else {
            this.markComponentDirty();
        }
    }

    public IWorldPosCallable getWorldPosCallable() {
        return this.func_145831_w() != null ? IWorldPosCallable.func_221488_a((World)this.func_145831_w(), (BlockPos)this.func_174877_v()) : IWorldPosCallable.field_221489_a;
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        if (this.multiInventoryComponent != null) {
            this.multiInventoryComponent.getLazyOptionals().forEach(LazyOptional::invalidate);
        }
        if (this.multiTankComponent != null) {
            this.multiTankComponent.getLazyOptionals().forEach(LazyOptional::invalidate);
        }
    }

    @Override
    public boolean canInteract() {
        return this.field_145850_b.func_175625_s(this.field_174879_c) == this;
    }
}

