/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.portality.gui.button;

import com.buuz135.portality.Portality;
import com.buuz135.portality.data.PortalLinkData;
import com.buuz135.portality.gui.PortalsScreen;
import com.buuz135.portality.network.PortalLinkMessage;
import com.buuz135.portality.tile.ControllerTile;
import com.hrznstudio.titanium.client.screen.addon.BasicScreenAddon;
import com.hrznstudio.titanium.client.screen.addon.interfaces.IClickable;
import com.hrznstudio.titanium.client.screen.asset.IAssetProvider;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class PortalCallButton
extends BasicScreenAddon
implements IClickable {
    private final CallAction action;
    private final ControllerTile controller;
    private final PortalsScreen guiPortals;
    private int guiX;
    private int guiY;

    public PortalCallButton(int x, int y, ControllerTile tile, CallAction action, PortalsScreen guiPortals) {
        super(x, y);
        this.action = action;
        this.controller = tile;
        this.guiPortals = guiPortals;
        this.guiX = 0;
        this.guiY = 0;
    }

    public void drawBackgroundLayer(MatrixStack stack, Screen screen, IAssetProvider provider, int guiX, int guiY, int mouseX, int mouseY, float partialTicks) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(new ResourceLocation("portality", "textures/gui/portals.png"));
        screen.func_238474_b_(stack, this.getPosX(), this.getPosY(), 0, 187, this.getXSize(), this.getYSize());
        this.guiX = guiX;
        this.guiY = guiY;
    }

    public boolean isInside(Screen container, double mouseX, double mouseY) {
        return super.isInside(container, mouseX + (double)this.guiX, mouseY + (double)this.guiY);
    }

    public int getXSize() {
        return 51;
    }

    public int getYSize() {
        return 22;
    }

    public void drawForegroundLayer(MatrixStack stack, Screen screen, IAssetProvider provider, int guiX, int guiY, int mouseX, int mouseY) {
        Screen.func_238471_a_((MatrixStack)stack, (FontRenderer)Minecraft.func_71410_x().field_71466_p, (String)new TranslationTextComponent(this.action.getName()).getString(), (int)(this.getPosX() + 25), (int)(this.getPosY() + 7), (int)(this.isInside(screen, mouseX - guiX, mouseY - guiY) ? 0xFFFFA0 : -1));
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void handleClick(Screen tile, int guiX, int guiY, double mouseX, double mouseY, int button) {
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)new SimpleSound(SoundEvents.field_187909_gi, SoundCategory.PLAYERS, 1.0f, 1.0f, Minecraft.func_71410_x().field_71439_g.func_233580_cy_()));
        if (this.guiPortals.getSelectedPortal() != null) {
            Portality.NETWORK.get().sendToServer((Object)new PortalLinkMessage(this.action.getId(), new PortalLinkData((RegistryKey<World>)this.controller.func_145831_w().func_234923_W_(), this.controller.func_174877_v(), true), new PortalLinkData(this.guiPortals.getSelectedPortal().getDimension(), this.guiPortals.getSelectedPortal().getLocation(), false)));
            Minecraft.func_71410_x().func_147108_a(null);
        }
    }

    public static enum CallAction {
        OPEN(0, "portality.display.dial"),
        ONCE(1, "portality.display.dial_once"),
        FORCE(2, "portality.display.force");

        private int id;
        private String name;

        private CallAction(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public int getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }
    }
}

