/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.portality.handler;

import com.buuz135.portality.block.ControllerBlock;
import com.buuz135.portality.block.module.IPortalModule;
import com.buuz135.portality.proxy.PortalityConfig;
import com.buuz135.portality.tile.ControllerTile;
import com.buuz135.portality.tile.FrameTile;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;

public class StructureHandler {
    private int length = 0;
    private int width = 0;
    private int height = 0;
    private ControllerTile controller;
    private List<BlockPos> modules = new ArrayList<BlockPos>();
    private List<BlockPos> frameBlocks = new ArrayList<BlockPos>();
    private boolean shouldCheckForStructure;

    public StructureHandler(ControllerTile controllerTile) {
        this.controller = controllerTile;
        this.shouldCheckForStructure = true;
    }

    public boolean checkArea() {
        this.checkPortalSize();
        if (this.length < 3) {
            return false;
        }
        Direction facing = (Direction)this.controller.func_145831_w().func_180495_p(this.controller.func_174877_v()).func_177229_b((Property)ControllerBlock.FACING_HORIZONTAL);
        this.modules.clear();
        if (!this.checkFramesInTheBox(this.controller.func_174877_v().func_177967_a(facing.func_176746_e(), this.width), this.controller.func_174877_v().func_177967_a(facing.func_176735_f(), this.width).func_177967_a(facing.func_176734_d(), this.length - 1), false)) {
            return false;
        }
        if (!this.checkFramesInTheBox(this.controller.func_174877_v().func_177967_a(facing.func_176746_e(), this.width).func_177967_a(Direction.UP, this.height - 1), this.controller.func_174877_v().func_177967_a(facing.func_176735_f(), this.width).func_177967_a(facing.func_176734_d(), this.length - 1).func_177967_a(Direction.UP, this.height - 1), false)) {
            return false;
        }
        if (!this.checkFramesInTheBox(this.controller.func_174877_v().func_177967_a(facing.func_176746_e(), this.width).func_177967_a(Direction.UP, 1), this.controller.func_174877_v().func_177967_a(facing.func_176746_e(), this.width).func_177967_a(Direction.UP, this.height - 2).func_177967_a(facing.func_176734_d(), this.length - 1), false)) {
            return false;
        }
        if (!this.checkFramesInTheBox(this.controller.func_174877_v().func_177967_a(facing.func_176735_f(), this.width).func_177967_a(Direction.UP, 1), this.controller.func_174877_v().func_177967_a(facing.func_176735_f(), this.width).func_177967_a(Direction.UP, this.height - 2).func_177967_a(facing.func_176734_d(), this.length - 1), false)) {
            return false;
        }
        this.checkFramesInTheBox(this.controller.func_174877_v().func_177967_a(facing.func_176746_e(), this.width), this.controller.func_174877_v().func_177967_a(facing.func_176735_f(), this.width).func_177967_a(facing.func_176734_d(), this.length - 1), true);
        this.checkFramesInTheBox(this.controller.func_174877_v().func_177967_a(facing.func_176746_e(), this.width).func_177967_a(Direction.UP, this.height - 1), this.controller.func_174877_v().func_177967_a(facing.func_176735_f(), this.width).func_177967_a(facing.func_176734_d(), this.length - 1).func_177967_a(Direction.UP, this.height - 1), true);
        this.checkFramesInTheBox(this.controller.func_174877_v().func_177967_a(facing.func_176746_e(), this.width).func_177967_a(Direction.UP, 1), this.controller.func_174877_v().func_177967_a(facing.func_176746_e(), this.width).func_177967_a(Direction.UP, this.height - 2).func_177967_a(facing.func_176734_d(), this.length - 1), true);
        this.checkFramesInTheBox(this.controller.func_174877_v().func_177967_a(facing.func_176735_f(), this.width).func_177967_a(Direction.UP, 1), this.controller.func_174877_v().func_177967_a(facing.func_176735_f(), this.width).func_177967_a(Direction.UP, this.height - 2).func_177967_a(facing.func_176734_d(), this.length - 1), true);
        return true;
    }

    public boolean checkFramesInTheBox(BlockPos point1, BlockPos point2, boolean save) {
        for (BlockPos blockPos : BlockPos.func_218278_a((BlockPos)point1, (BlockPos)point2)) {
            TileEntity entity;
            if (!blockPos.equals((Object)this.controller.func_174877_v()) && !this.isValidFrame(blockPos)) {
                return false;
            }
            if (!save) continue;
            this.frameBlocks.add(blockPos.func_185334_h());
            if (this.controller.func_145831_w().func_180495_p(blockPos).func_177230_c() instanceof IPortalModule) {
                this.modules.add(blockPos.func_185334_h());
            }
            if (!((entity = this.controller.func_145831_w().func_175625_s(blockPos)) instanceof FrameTile)) continue;
            ((FrameTile)entity).setControllerPos(this.controller.func_174877_v());
            ((FrameTile)entity).setColor(this.controller.getColor());
            entity.func_70296_d();
        }
        return true;
    }

    private void checkPortalSize() {
        int length;
        int height;
        int width;
        Direction controllerFacing = (Direction)this.controller.func_145831_w().func_180495_p(this.controller.func_174877_v()).func_177229_b((Property)ControllerBlock.FACING_HORIZONTAL);
        if (controllerFacing.func_176740_k().func_200128_b()) {
            return;
        }
        Direction widthFacing = controllerFacing.func_176746_e();
        for (width = 1; this.isValidFrame(this.controller.func_174877_v().func_177967_a(widthFacing, width)) && !this.isValidFrame(this.controller.func_174877_v().func_177967_a(widthFacing, width).func_177972_a(Direction.UP)) && width <= PortalityConfig.MAX_PORTAL_WIDTH; ++width) {
        }
        for (height = 1; this.isValidFrame(this.controller.func_174877_v().func_177967_a(widthFacing, width).func_177967_a(Direction.UP, height)) && height <= PortalityConfig.MAX_PORTAL_HEIGHT; ++height) {
        }
        Direction lengthChecking = controllerFacing.func_176734_d();
        for (length = 1; this.isValidFrame(this.controller.func_174877_v().func_177967_a(lengthChecking, length)) && length <= PortalityConfig.MAX_PORTAL_LENGTH; ++length) {
        }
        this.width = width;
        this.height = height;
        this.length = length;
    }

    private boolean isValidFrame(BlockPos pos) {
        return this.controller.func_145831_w().func_175625_s(pos) instanceof FrameTile && (((FrameTile)this.controller.func_145831_w().func_175625_s(pos)).getControllerPos() == null || ((FrameTile)this.controller.func_145831_w().func_175625_s(pos)).getControllerPos().equals((Object)this.controller.func_174877_v()));
    }

    public void cancelFrameBlocks() {
        for (BlockPos frameBlock : this.frameBlocks) {
            TileEntity entity = this.controller.func_145831_w().func_175625_s(frameBlock);
            if (!(entity instanceof FrameTile)) continue;
            ((FrameTile)entity).setControllerPos(null);
            entity.func_70296_d();
        }
        this.frameBlocks.clear();
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public boolean shouldCheckForStructure() {
        return this.shouldCheckForStructure;
    }

    public void setShouldCheckForStructure(boolean shouldCheckForStructure) {
        this.shouldCheckForStructure = shouldCheckForStructure;
    }

    public List<BlockPos> getModules() {
        return this.modules;
    }

    public List<BlockPos> getFrameBlocks() {
        return this.frameBlocks;
    }
}

