/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.prettypipes.items;

import de.ellpeck.prettypipes.Registry;
import de.ellpeck.prettypipes.Utility;
import de.ellpeck.prettypipes.pipe.ConnectionType;
import de.ellpeck.prettypipes.pipe.PipeBlock;
import de.ellpeck.prettypipes.pipe.PipeTileEntity;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class WrenchItem
extends Item {
    public WrenchItem() {
        super(new Item.Properties().func_200917_a(1).func_200916_a(Registry.GROUP));
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        ItemStack offhand;
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        PlayerEntity player = context.func_195999_j();
        BlockState state = world.func_180495_p(pos);
        if (!(state.func_177230_c() instanceof PipeBlock)) {
            return ActionResultType.PASS;
        }
        PipeTileEntity tile = Utility.getTileEntity(PipeTileEntity.class, (IBlockReader)world, pos);
        if (tile == null) {
            return ActionResultType.FAIL;
        }
        if (player.func_225608_bj_()) {
            if (!world.field_72995_K) {
                if (tile.cover != null) {
                    tile.removeCover(player, context.func_221531_n());
                    Utility.sendTileEntityToClients(tile);
                } else {
                    PipeBlock.dropItems(world, pos, player);
                    Block.func_220054_a((BlockState)state, (World)world, (BlockPos)pos, (TileEntity)tile, null, (ItemStack)ItemStack.field_190927_a);
                    world.func_217377_a(pos, false);
                }
                world.func_184133_a(null, pos, SoundEvents.field_187629_cO, SoundCategory.PLAYERS, 1.0f, 1.0f);
            }
            return ActionResultType.func_233537_a_((boolean)world.field_72995_K);
        }
        if (tile.cover == null && (offhand = player.func_184592_cb()).func_77973_b() instanceof BlockItem) {
            if (!world.field_72995_K) {
                BlockItemUseContext blockContext = new BlockItemUseContext(context);
                Block block = ((BlockItem)offhand.func_77973_b()).func_179223_d();
                BlockState cover = block.func_196258_a(blockContext);
                if (cover != null && !block.hasTileEntity(cover)) {
                    tile.cover = cover;
                    Utility.sendTileEntityToClients(tile);
                    offhand.func_190918_g(1);
                    world.func_184133_a(null, pos, SoundEvents.field_187620_cL, SoundCategory.PLAYERS, 1.0f, 1.0f);
                }
            }
            return ActionResultType.func_233537_a_((boolean)world.field_72995_K);
        }
        for (Map.Entry<Direction, VoxelShape> entry : PipeBlock.DIR_SHAPES.entrySet()) {
            EnumProperty<ConnectionType> prop;
            ConnectionType curr;
            AxisAlignedBB box = entry.getValue().func_197752_a().func_186670_a(pos).func_186662_g((double)0.001f);
            if (!box.func_72318_a(context.func_221532_j()) || (curr = (ConnectionType)((Object)state.func_177229_b(prop = PipeBlock.DIRECTIONS.get(entry.getKey())))) == ConnectionType.DISCONNECTED) continue;
            if (!world.field_72995_K) {
                ConnectionType newType = curr == ConnectionType.BLOCKED ? ConnectionType.CONNECTED : ConnectionType.BLOCKED;
                BlockPos otherPos = pos.func_177972_a(entry.getKey());
                BlockState otherState = world.func_180495_p(otherPos);
                if (otherState.func_177230_c() instanceof PipeBlock) {
                    otherState = (BlockState)otherState.func_206870_a((Property)PipeBlock.DIRECTIONS.get(entry.getKey().func_176734_d()), (Comparable)((Object)newType));
                    world.func_175656_a(otherPos, otherState);
                    PipeBlock.onStateChanged(world, otherPos, otherState);
                }
                BlockState newState = (BlockState)state.func_206870_a(prop, (Comparable)((Object)newType));
                world.func_175656_a(pos, newState);
                PipeBlock.onStateChanged(world, pos, newState);
                world.func_184133_a(null, pos, SoundEvents.field_187632_cP, SoundCategory.PLAYERS, 1.0f, 1.0f);
            }
            return ActionResultType.func_233537_a_((boolean)world.field_72995_K);
        }
        return ActionResultType.PASS;
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        Utility.addTooltip(this.getRegistryName().func_110623_a(), tooltip);
    }

    public boolean func_77616_k(ItemStack stack) {
        return true;
    }

    public int getItemEnchantability(ItemStack stack) {
        return 1;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment == Enchantments.field_185306_r;
    }
}

