/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.prettypipes.misc;

import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class ItemEquality {
    public static final ItemEquality DAMAGE = new ItemEquality((stack, filter) -> stack.func_77952_i() == filter.func_77952_i(), false, Type.DAMAGE);
    public static final ItemEquality NBT = new ItemEquality(ItemStack::func_77970_a, false, Type.NBT);
    public static final ItemEquality MOD = new ItemEquality((stack, filter) -> stack.func_77973_b().getCreatorModId(stack).equals(filter.func_77973_b().getCreatorModId(filter)), true, Type.MOD);
    public final Type type;
    private final BiFunction<ItemStack, ItemStack, Boolean> filter;
    private final boolean ignoreItemEquality;

    ItemEquality(BiFunction<ItemStack, ItemStack, Boolean> filter, boolean ignoreItemEquality, Type type) {
        this.filter = filter;
        this.ignoreItemEquality = ignoreItemEquality;
        this.type = type;
    }

    public static ItemEquality tag(ResourceLocation tag) {
        return new ItemEquality((stack, filter) -> stack.func_77973_b().getTags().contains(tag), true, Type.TAG);
    }

    public static boolean compareItems(ItemStack stack, ItemStack filter, ItemEquality ... types) {
        boolean equal = ItemStack.func_179545_c((ItemStack)stack, (ItemStack)filter);
        if (types.length <= 0) {
            return equal;
        }
        for (ItemEquality type : types) {
            if (!type.ignoreItemEquality && !equal) {
                return false;
            }
            if (type.filter.apply(stack, filter).booleanValue()) continue;
            return false;
        }
        return true;
    }

    public static enum Type {
        DAMAGE(() -> DAMAGE),
        NBT(() -> NBT),
        MOD(() -> MOD),
        TAG(null);

        private final Supplier<ItemEquality> defaultInstance;

        private Type(Supplier<ItemEquality> defaultInstance) {
            this.defaultInstance = defaultInstance;
        }

        public ItemEquality getDefaultInstance() {
            return this.defaultInstance.get();
        }
    }
}

