/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.prettypipes.packets;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import de.ellpeck.prettypipes.Utility;
import de.ellpeck.prettypipes.terminal.CraftingTerminalTileEntity;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketGhostSlot {
    private BlockPos pos;
    private ListMultimap<Integer, ItemStack> stacks;

    public PacketGhostSlot(BlockPos pos, ListMultimap<Integer, ItemStack> stacks) {
        this.pos = pos;
        this.stacks = stacks;
    }

    private PacketGhostSlot() {
    }

    public static PacketGhostSlot fromBytes(PacketBuffer buf) {
        PacketGhostSlot packet = new PacketGhostSlot();
        packet.pos = buf.func_179259_c();
        packet.stacks = ArrayListMultimap.create();
        for (int i = buf.readInt(); i > 0; --i) {
            packet.stacks.put((Object)buf.readInt(), (Object)buf.func_150791_c());
        }
        return packet;
    }

    public static void toBytes(PacketGhostSlot packet, PacketBuffer buf) {
        buf.func_179255_a(packet.pos);
        buf.writeInt(packet.stacks.size());
        for (Map.Entry entry : packet.stacks.entries()) {
            buf.writeInt(((Integer)entry.getKey()).intValue());
            buf.func_150788_a((ItemStack)entry.getValue());
        }
    }

    public static void onMessage(PacketGhostSlot message, Supplier<NetworkEvent.Context> ctx) {
        final Consumer<PlayerEntity> doIt = p -> {
            CraftingTerminalTileEntity tile = Utility.getTileEntity(CraftingTerminalTileEntity.class, (IBlockReader)p.field_70170_p, message.pos);
            if (tile != null) {
                tile.setGhostItems(message.stacks);
            }
        };
        ServerPlayerEntity player = ctx.get().getSender();
        if (player == null) {
            ctx.get().enqueueWork(new Runnable(){

                @Override
                public void run() {
                    doIt.accept(Minecraft.func_71410_x().field_71439_g);
                }
            });
        } else {
            ctx.get().enqueueWork(new Runnable((PlayerEntity)player){
                final /* synthetic */ PlayerEntity val$player;
                {
                    this.val$player = playerEntity;
                }

                @Override
                public void run() {
                    doIt.accept(this.val$player);
                }
            });
        }
        ctx.get().setPacketHandled(true);
    }
}

