/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.prettypipes.pipe;

import com.mojang.blaze3d.matrix.MatrixStack;
import de.ellpeck.prettypipes.network.NetworkEdge;
import de.ellpeck.prettypipes.network.PipeItem;
import de.ellpeck.prettypipes.pipe.PipeTileEntity;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.function.BiFunction;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.INBTSerializable;
import org.jgrapht.GraphPath;

public interface IPipeItem
extends INBTSerializable<CompoundNBT> {
    public static final Map<ResourceLocation, BiFunction<ResourceLocation, CompoundNBT, IPipeItem>> TYPES = new HashMap<ResourceLocation, BiFunction<ResourceLocation, CompoundNBT, IPipeItem>>(Collections.singletonMap(PipeItem.TYPE, PipeItem::new));

    public ItemStack getContent();

    public void setDestination(BlockPos var1, BlockPos var2, GraphPath<BlockPos, NetworkEdge> var3);

    public void updateInPipe(PipeTileEntity var1);

    public void drop(World var1, ItemStack var2);

    public BlockPos getDestPipe();

    public BlockPos getCurrentPipe();

    public BlockPos getDestInventory();

    public int getItemsOnTheWay(BlockPos var1);

    @OnlyIn(value=Dist.CLIENT)
    public void render(PipeTileEntity var1, MatrixStack var2, Random var3, float var4, int var5, int var6, IRenderTypeBuffer var7);

    public static IPipeItem load(CompoundNBT nbt) {
        ResourceLocation type;
        BiFunction<ResourceLocation, CompoundNBT, IPipeItem> func;
        if (!nbt.func_74764_b("type")) {
            nbt.func_74778_a("type", PipeItem.TYPE.toString());
        }
        return (func = TYPES.get(type = new ResourceLocation(nbt.func_74779_i("type")))) != null ? func.apply(type, nbt) : null;
    }
}

