/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.prettypipes.pipe.containers;

import com.mojang.blaze3d.matrix.MatrixStack;
import de.ellpeck.prettypipes.Registry;
import de.ellpeck.prettypipes.items.IModule;
import de.ellpeck.prettypipes.packets.PacketButton;
import de.ellpeck.prettypipes.packets.PacketHandler;
import de.ellpeck.prettypipes.pipe.containers.AbstractPipeContainer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;

public abstract class AbstractPipeGui<T extends AbstractPipeContainer<?>>
extends ContainerScreen<T> {
    protected static final ResourceLocation TEXTURE = new ResourceLocation("prettypipes", "textures/gui/pipe.png");
    private final List<Tab> tabs = new ArrayList<Tab>();
    private final ItemStack[] lastItems;

    public AbstractPipeGui(T screenContainer, PlayerInventory inv, ITextComponent titleIn) {
        super(screenContainer, inv, titleIn);
        this.lastItems = new ItemStack[((AbstractPipeContainer)this.field_147002_h).tile.modules.getSlots()];
        this.field_146999_f = 176;
        this.field_147000_g = 203;
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        this.initTabs();
    }

    public void func_231023_e_() {
        super.func_231023_e_();
        boolean changed = false;
        for (int i = 0; i < ((AbstractPipeContainer)this.field_147002_h).tile.modules.getSlots(); ++i) {
            ItemStack stack = ((AbstractPipeContainer)this.field_147002_h).tile.modules.getStackInSlot(i);
            if (stack == this.lastItems[i]) continue;
            this.lastItems[i] = stack;
            changed = true;
        }
        if (changed) {
            this.initTabs();
        }
    }

    public void func_230430_a_(MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(matrix);
        super.func_230430_a_(matrix, mouseX, mouseY, partialTicks);
        for (Widget widget : this.field_230710_m_) {
            if (!widget.func_230449_g_()) continue;
            widget.func_230443_a_(matrix, mouseX, mouseY);
        }
        this.func_230459_a_(matrix, mouseX, mouseY);
    }

    protected void func_230451_b_(MatrixStack matrix, int mouseX, int mouseY) {
        this.field_230712_o_.func_238421_b_(matrix, this.field_213127_e.func_145748_c_().getString(), 8.0f, (float)(this.field_147000_g - 96 + 2), 0x404040);
        this.field_230712_o_.func_238421_b_(matrix, this.field_230704_d_.getString(), 8.0f, 38.0f, 0x404040);
        for (Tab tab : this.tabs) {
            tab.drawForeground(matrix, mouseX, mouseY);
        }
    }

    protected void func_230450_a_(MatrixStack matrix, float partialTicks, int mouseX, int mouseY) {
        this.getMinecraft().func_110434_K().func_110577_a(TEXTURE);
        this.func_238474_b_(matrix, this.field_147003_i, this.field_147009_r + 32, 0, 0, 176, 171);
        for (Tab tab : this.tabs) {
            tab.draw(matrix);
        }
        for (Slot slot : ((AbstractPipeContainer)this.field_147002_h).field_75151_b) {
            if (slot.field_75224_c == this.field_213127_e) continue;
            this.func_238474_b_(matrix, this.field_147003_i + slot.field_75223_e - 1, this.field_147009_r + slot.field_75221_f - 1, 176, 62, 18, 18);
        }
    }

    public boolean func_231044_a_(double x, double y, int button) {
        for (Tab tab : this.tabs) {
            if (!tab.onClicked(x, y, button)) continue;
            return true;
        }
        return super.func_231044_a_(x, y, button);
    }

    private void initTabs() {
        this.tabs.clear();
        this.tabs.add(new Tab(new ItemStack((IItemProvider)Registry.pipeBlock), 0, -1));
        for (int i = 0; i < ((AbstractPipeContainer)this.field_147002_h).tile.modules.getSlots(); ++i) {
            IModule module;
            ItemStack stack = ((AbstractPipeContainer)this.field_147002_h).tile.modules.getStackInSlot(i);
            if (stack.func_190926_b() || !(module = (IModule)stack.func_77973_b()).hasContainer(stack, ((AbstractPipeContainer)this.field_147002_h).tile)) continue;
            this.tabs.add(new Tab(stack, this.tabs.size(), i));
        }
    }

    private class Tab {
        private final ItemStack moduleStack;
        private final int index;
        private final int x;
        private final int y;

        public Tab(ItemStack moduleStack, int tabIndex, int index) {
            this.moduleStack = moduleStack;
            this.index = index;
            this.x = AbstractPipeGui.this.field_147003_i + 5 + tabIndex * 28;
            this.y = AbstractPipeGui.this.field_147009_r;
        }

        private void draw(MatrixStack matrix) {
            int y = 2;
            int v = 0;
            int height = 30;
            int itemOffset = 9;
            if (this.index == ((AbstractPipeContainer)((AbstractPipeGui)AbstractPipeGui.this).field_147002_h).moduleIndex) {
                y = 0;
                v = 30;
                height = 32;
                itemOffset = 7;
            }
            AbstractPipeGui.this.func_238474_b_(matrix, this.x, this.y + y, 176, v, 28, height);
            AbstractPipeGui.this.field_230707_j_.func_175042_a(this.moduleStack, this.x + 6, this.y + itemOffset);
            AbstractPipeGui.this.getMinecraft().func_110434_K().func_110577_a(TEXTURE);
        }

        private void drawForeground(MatrixStack matrix, int mouseX, int mouseY) {
            if (mouseX < this.x || mouseY < this.y || mouseX >= this.x + 28 || mouseY >= this.y + 32) {
                return;
            }
            AbstractPipeGui.this.func_238652_a_(matrix, this.moduleStack.func_200301_q(), mouseX - AbstractPipeGui.this.field_147003_i, mouseY - AbstractPipeGui.this.field_147009_r);
        }

        private boolean onClicked(double mouseX, double mouseY, int button) {
            if (this.index == ((AbstractPipeContainer)((AbstractPipeGui)AbstractPipeGui.this).field_147002_h).moduleIndex) {
                return false;
            }
            if (button != 0) {
                return false;
            }
            if (mouseX < (double)this.x || mouseY < (double)this.y || mouseX >= (double)(this.x + 28) || mouseY >= (double)(this.y + 32)) {
                return false;
            }
            PacketHandler.sendToServer(new PacketButton(((AbstractPipeContainer)((AbstractPipeGui)AbstractPipeGui.this).field_147002_h).tile.func_174877_v(), PacketButton.ButtonResult.PIPE_TAB, this.index));
            AbstractPipeGui.this.getMinecraft().func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
            return true;
        }
    }
}

