/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo;

import com.feed_the_beast.ftbquests.quest.task.TaskType;
import com.mojang.brigadier.CommandDispatcher;
import harmonised.pmmo.commands.PmmoCommand;
import harmonised.pmmo.config.Config;
import harmonised.pmmo.config.JsonConfig;
import harmonised.pmmo.events.ChunkDataHandler;
import harmonised.pmmo.events.EventHandler;
import harmonised.pmmo.events.RegisterHandler;
import harmonised.pmmo.events.WorldTickHandler;
import harmonised.pmmo.network.NetworkHandler;
import harmonised.pmmo.pmmo_saved_data.PmmoSavedData;
import harmonised.pmmo.proxy.ClientHandler;
import harmonised.pmmo.skills.AttributeHandler;
import harmonised.pmmo.util.XP;
import net.minecraft.command.CommandSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.GameRules;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.server.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.simple.SimpleChannel;

@Mod(value="pmmo")
public class ProjectMMOMod {
    private static String PROTOCOL_VERSION = "1";
    public static SimpleChannel HANDLER = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("pmmo", "main_channel")).clientAcceptedVersions(PROTOCOL_VERSION::equals).serverAcceptedVersions(PROTOCOL_VERSION::equals).networkProtocolVersion(() -> PROTOCOL_VERSION).simpleChannel();

    public ProjectMMOMod() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::modsLoading);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::clientLoading);
        if (ModList.get().isLoaded("ftbquests")) {
            FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(TaskType.class, RegisterHandler::handleFTBQRegistry);
        }
        MinecraftForge.EVENT_BUS.addListener(this::serverAboutToStart);
        MinecraftForge.EVENT_BUS.addListener(this::serverStart);
        PmmoCommand.init();
        Config.init();
    }

    private void modsLoading(FMLCommonSetupEvent event) {
        XP.initValues();
        NetworkHandler.registerPackets();
        MinecraftForge.EVENT_BUS.register(EventHandler.class);
        MinecraftForge.EVENT_BUS.register(AttributeHandler.class);
        JsonConfig.init();
    }

    private void clientLoading(FMLClientSetupEvent event) {
        ClientHandler.init();
    }

    private void serverAboutToStart(FMLServerAboutToStartEvent event) {
        if (Config.forgeConfig.autoGenerateValuesEnabled.get().booleanValue()) {
            JsonConfig.setAutoValues();
        }
        ChunkDataHandler.init();
    }

    private void serverStart(FMLServerStartingEvent event) {
        PmmoSavedData.init(event.getServer());
        Config.initServer();
        PmmoCommand.register((CommandDispatcher<CommandSource>)event.getCommandDispatcher());
        WorldTickHandler.refreshVein();
        AttributeHandler.init();
        if (Config.forgeConfig.craftReqEnabled.get().booleanValue()) {
            ((GameRules.BooleanValue)event.getServer().func_200252_aR().func_223585_a(GameRules.field_223618_u)).func_223570_a(true, event.getServer());
        }
    }
}

