/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.commands;

import com.mojang.brigadier.context.CommandContext;
import harmonised.pmmo.party.Party;
import harmonised.pmmo.party.PartyMemberInfo;
import harmonised.pmmo.pmmo_saved_data.PmmoSavedData;
import harmonised.pmmo.util.DP;
import harmonised.pmmo.util.XP;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.text.TranslationTextComponent;

public class PartyCommand {
    public static int execute(CommandContext<CommandSource> context) throws CommandException {
        PlayerEntity player = (PlayerEntity)((CommandSource)context.getSource()).func_197022_f();
        UUID uuid = player.func_110124_au();
        PmmoSavedData pmmoSavedData = PmmoSavedData.get();
        Party party = pmmoSavedData.getParty(uuid);
        if (party == null) {
            player.func_146105_b(new TranslationTextComponent("pmmo.youAreNotInAParty", new Object[0]).func_150255_a(XP.textStyle.get("red")), false);
        } else {
            Set<PartyMemberInfo> membersInfo = party.getAllMembersInfo();
            Set membersInRangeUUID = party.getOnlineMembersInRange((ServerPlayerEntity)player).stream().map(playerToMap -> playerToMap.func_110124_au()).collect(Collectors.toSet());
            double totalXpGained = party.getTotalXpGained();
            player.func_146105_b(new TranslationTextComponent("pmmo.youAreInAParty", new Object[0]).func_150255_a(XP.textStyle.get("green")), false);
            player.func_146105_b(new TranslationTextComponent("pmmo.totalMembersOutOfMax", new Object[]{party.getPartySize(), Party.getMaxPartyMembers()}).func_150255_a(XP.textStyle.get("green")), false);
            player.func_146105_b(new TranslationTextComponent("pmmo.partyTotalXpGained", new Object[]{DP.dpSoft(totalXpGained)}).func_150255_a(XP.textStyle.get("green")), false);
            player.func_146105_b(new TranslationTextComponent("pmmo.partyXpBonus", new Object[]{DP.dpSoft(party.getMultiplier(membersInRangeUUID.size()))}).func_150255_a(XP.textStyle.get("green")), false);
            for (PartyMemberInfo memberInfo : membersInfo) {
                String xpGainedPercentage = DP.dpSoft(memberInfo.xpGained / totalXpGained * 100.0);
                String color = "yellow";
                if (!memberInfo.uuid.equals(uuid)) {
                    color = membersInRangeUUID.contains(memberInfo.uuid) ? "green" : "dark_green";
                }
                player.func_146105_b(new TranslationTextComponent("pmmo.partyMemberListEntry", new Object[]{pmmoSavedData.getName(memberInfo.uuid), DP.dpSoft(memberInfo.xpGained), totalXpGained == 0.0 ? "0" : xpGainedPercentage, memberInfo.xpGained}).func_150255_a(XP.textStyle.get(color)), false);
            }
        }
        return 1;
    }
}

