/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.commands;

import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import harmonised.pmmo.skills.Skill;
import harmonised.pmmo.util.XP;
import java.util.Arrays;
import java.util.Collection;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandSource;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SetCommand {
    private static final Logger LOGGER = LogManager.getLogger();

    public static int execute(CommandContext<CommandSource> context) throws CommandException {
        Object[] args = context.getInput().split(" ");
        String skillName = StringArgumentType.getString(context, (String)"Skill").toLowerCase();
        String type = StringArgumentType.getString(context, (String)"Level|Xp").toLowerCase();
        Skill skill = Skill.getSkill(skillName);
        ServerPlayerEntity sender = null;
        try {
            sender = ((CommandSource)context.getSource()).func_197035_h();
        }
        catch (CommandSyntaxException commandSyntaxException) {
            // empty catch block
        }
        if (skillName.equals("power")) {
            sender.func_146105_b((ITextComponent)new TranslationTextComponent("pmmo.invalidChoice", new Object[]{skillName}), false);
            return 1;
        }
        if (skill != Skill.INVALID_SKILL) {
            try {
                Collection players = EntityArgument.func_197090_e(context, (String)"target");
                for (ServerPlayerEntity player : players) {
                    String playerName = player.func_145748_c_().getString();
                    double newValue = DoubleArgumentType.getDouble(context, (String)"New Value");
                    if (type.equals("level")) {
                        skill.setLevel(player, newValue);
                    } else if (type.equals("xp")) {
                        skill.setXp(player, newValue);
                    } else {
                        LOGGER.error("PMMO Command Set: Invalid 6th Element in command (level|xp) " + Arrays.toString(args));
                        if (sender != null) {
                            sender.func_146105_b(new TranslationTextComponent("pmmo.invalidChoice", new Object[]{args[5]}).func_150255_a(XP.textStyle.get("red")), false);
                        }
                    }
                    LOGGER.info("PMMO Command Set: " + playerName + " " + (String)args[4] + " has been set to " + (String)args[5] + " " + (String)args[6]);
                }
            }
            catch (CommandSyntaxException e) {
                LOGGER.error("PMMO Command Set: Failed to get Players [" + Arrays.toString(args) + "]", (Throwable)e);
            }
        } else {
            LOGGER.error("PMMO Command Set: Invalid 5th Element in command (skill name) " + Arrays.toString(args));
            if (sender != null) {
                sender.func_146105_b(new TranslationTextComponent("pmmo.invalidSkill", new Object[]{skillName}).func_150255_a(XP.textStyle.get("red")), false);
            }
        }
        return 1;
    }
}

