/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.config;

import harmonised.pmmo.config.ConfigHelper;
import harmonised.pmmo.pmmo_saved_data.PmmoSavedData;
import harmonised.pmmo.skills.Skill;
import harmonised.pmmo.util.XP;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Config {
    public static final Logger LOGGER = LogManager.getLogger();
    public static Map<String, Double> localConfig = new HashMap<String, Double>();
    private static Map<String, Double> config = new HashMap<String, Double>();
    private static final Map<String, Double> abilities = new HashMap<String, Double>();
    private static Map<String, Double> preferences = new HashMap<String, Double>();
    private static Map<String, Map<Skill, Double>> xpBoosts = new HashMap<String, Map<Skill, Double>>();
    public static ConfigImplementation forgeConfig;

    public static void init() {
        forgeConfig = ConfigHelper.register(ModConfig.Type.COMMON, ConfigImplementation::new);
    }

    public static void initServer() {
        if (Config.forgeConfig.veiningAllowed.get().booleanValue()) {
            localConfig.put("veiningAllowed", 1.0);
        } else {
            localConfig.put("veiningAllowed", 0.0);
        }
        if (Config.forgeConfig.useExponentialFormula.get().booleanValue()) {
            localConfig.put("useExponentialFormula", 1.0);
        } else {
            localConfig.put("useExponentialFormula", 0.0);
        }
        if (Config.forgeConfig.strictReqTool.get().booleanValue()) {
            localConfig.put("strictReqTool", 1.0);
        } else {
            localConfig.put("strictReqTool", 0.0);
        }
        localConfig.put("maxLevel", (double)Config.forgeConfig.maxLevel.get());
        localConfig.put("baseXp", (double)Config.forgeConfig.baseXp.get());
        localConfig.put("xpIncreasePerLevel", (double)Config.forgeConfig.xpIncreasePerLevel.get());
        localConfig.put("exponentialBaseXp", Config.forgeConfig.exponentialBaseXp.get());
        localConfig.put("exponentialBase", Config.forgeConfig.exponentialBase.get());
        localConfig.put("exponentialRate", Config.forgeConfig.exponentialRate.get());
        localConfig.put("maxXp", XP.xpAtLevel(Config.forgeConfig.maxLevel.get()));
        localConfig.put("biomePenaltyMultiplier", Config.forgeConfig.biomePenaltyMultiplier.get());
        localConfig.put("nightvisionUnlockLevel", (double)Config.forgeConfig.nightvisionUnlockLevel.get());
        localConfig.put("speedBoostPerLevel", Config.forgeConfig.speedBoostPerLevel.get());
        localConfig.put("maxSpeedBoost", Config.forgeConfig.maxSpeedBoost.get());
        localConfig.put("maxJumpBoost", Config.forgeConfig.maxJumpBoost.get());
        localConfig.put("maxFallSaveChance", Config.forgeConfig.maxFallSaveChance.get());
        localConfig.put("saveChancePerLevel", Config.forgeConfig.saveChancePerLevel.get());
        localConfig.put("levelsPerCrouchJumpBoost", Config.forgeConfig.levelsPerCrouchJumpBoost.get());
        localConfig.put("levelsPerSprintJumpBoost", Config.forgeConfig.levelsPerSprintJumpBoost.get());
        localConfig.put("levelsPerDamage", Config.forgeConfig.levelsPerDamage.get());
        localConfig.put("levelsPerOneReach", Config.forgeConfig.levelsPerOneReach.get());
        localConfig.put("endurancePerLevel", Config.forgeConfig.endurancePerLevel.get());
        localConfig.put("maxEndurance", Config.forgeConfig.maxEndurance.get());
        localConfig.put("levelsPerHeart", Config.forgeConfig.levelsPerHeart.get());
        localConfig.put("maxExtraHeartBoost", (double)Config.forgeConfig.maxExtraHeartBoost.get());
        localConfig.put("maxExtraReachBoost", Config.forgeConfig.maxExtraReachBoost.get());
        localConfig.put("maxExtraDamageBoost", Config.forgeConfig.maxExtraDamageBoost.get());
        localConfig.put("levelsPerHardnessMining", Config.forgeConfig.levelsPerHardnessMining.get());
        localConfig.put("levelsPerHardnessWoodcutting", Config.forgeConfig.levelsPerHardnessWoodcutting.get());
        localConfig.put("levelsPerHardnessExcavation", Config.forgeConfig.levelsPerHardnessExcavation.get());
        localConfig.put("levelsPerHardnessFarming", Config.forgeConfig.levelsPerHardnessFarming.get());
        localConfig.put("levelsPerHardnessCrafting", Config.forgeConfig.levelsPerHardnessCrafting.get());
        localConfig.put("minVeinCost", Config.forgeConfig.minVeinCost.get());
        localConfig.put("minVeinHardness", Config.forgeConfig.minVeinHardness.get());
        localConfig.put("maxVeinCharge", Config.forgeConfig.maxVeinCharge.get());
        localConfig.put("veinMaxBlocks", (double)Config.forgeConfig.veinMaxBlocks.get());
        config = localConfig;
    }

    public static double getConfig(String key) {
        if (config.containsKey(key)) {
            return config.get(key);
        }
        if (localConfig.containsKey(key)) {
            return localConfig.get(key);
        }
        LOGGER.error("UNABLE TO READ PMMO CONFIG \"" + key + "\" PLEASE REPORT (This is normal during boot if JEI is installed)");
        return -1.0;
    }

    public static Map<Skill, Double> getXpMap(PlayerEntity player) {
        if (player.field_70170_p.func_201670_d()) {
            return XP.getOfflineXpMap(player.func_110124_au());
        }
        return PmmoSavedData.get().getXpMap(player.func_110124_au());
    }

    public static Map<String, Double> getConfigMap() {
        return config;
    }

    public static void setConfigMap(Map<String, Double> inMap) {
        config = inMap;
    }

    public static Map<String, Double> getPreferencesMap(PlayerEntity player) {
        if (player.field_70170_p.func_201670_d()) {
            return preferences;
        }
        return PmmoSavedData.get().getPreferencesMap(player.func_110124_au());
    }

    public static Map<String, Double> getPreferencesMapOffline() {
        return preferences;
    }

    public static Map<String, Double> getAbilitiesMap(PlayerEntity player) {
        if (player.field_70170_p.func_201670_d()) {
            return abilities;
        }
        return PmmoSavedData.get().getAbilitiesMap(player.func_110124_au());
    }

    public static void setPreferencesMap(Map<String, Double> newPreferencesMap) {
        preferences = newPreferencesMap;
    }

    public static Map<String, Map<Skill, Double>> getXpBoostsMap(PlayerEntity player) {
        if (player.field_70170_p.func_201670_d()) {
            return xpBoosts;
        }
        return PmmoSavedData.get().getPlayerXpBoostsMap(player.func_110124_au());
    }

    public static Map<Skill, Double> getXpBoostMap(PlayerEntity player, UUID xpBoostUUID) {
        if (player.field_70170_p.func_201670_d()) {
            return xpBoosts.getOrDefault(xpBoostUUID, new HashMap());
        }
        return PmmoSavedData.get().getPlayerXpBoostMap(player.func_110124_au(), xpBoostUUID);
    }

    public static double getPlayerXpBoost(PlayerEntity player, Skill skill) {
        double xpBoost = 0.0;
        for (Map.Entry<String, Map<Skill, Double>> entry : Config.getXpBoostsMap(player).entrySet()) {
            xpBoost += entry.getValue().getOrDefault((Object)skill, 0.0).doubleValue();
        }
        return xpBoost;
    }

    public static void setPlayerXpBoost(ServerPlayerEntity player, String xpBoostKey, Map<Skill, Double> newXpBoosts) {
        PmmoSavedData.get().setPlayerXpBoost(player.func_110124_au(), xpBoostKey, newXpBoosts);
    }

    public void removePlayerXpBoost(ServerPlayerEntity player, String xpBoostKey) {
        PmmoSavedData.get().removePlayerXpBoost(player.func_110124_au(), xpBoostKey);
    }

    public void removeAllPlayerXpBoosts(ServerPlayerEntity player) {
        PmmoSavedData.get().removeAllPlayerXpBoosts(player.func_110124_au());
    }

    public static void setPlayerXpBoostsMaps(PlayerEntity player, Map<String, Map<Skill, Double>> newBoosts) {
        if (player.field_70170_p.func_201670_d()) {
            xpBoosts = newBoosts;
        } else {
            PmmoSavedData.get().setPlayerXpBoostsMaps(player.func_110124_au(), newBoosts);
        }
    }

    public static class ConfigImplementation {
        public ConfigHelper.ConfigValueListener<Boolean> showWelcome;
        public ConfigHelper.ConfigValueListener<Boolean> showPatreonWelcome;
        public ConfigHelper.ConfigValueListener<Double> partyRange;
        public ConfigHelper.ConfigValueListener<Integer> partyMaxMembers;
        public ConfigHelper.ConfigValueListener<Double> partyXpIncreasePerPlayer;
        public ConfigHelper.ConfigValueListener<Double> maxPartyXpBonus;
        public ConfigHelper.ConfigValueListener<Double> partyFriendlyFireAmount;
        public ConfigHelper.ConfigValueListener<Boolean> autoLeavePartyOnDisconnect;
        public ConfigHelper.ConfigValueListener<Boolean> veiningAllowed;
        public ConfigHelper.ConfigValueListener<Boolean> veinWoodTopToBottom;
        public ConfigHelper.ConfigValueListener<Boolean> sleepRechargesAllPlayersVeinCharge;
        public ConfigHelper.ConfigValueListener<Boolean> veiningOtherPlayerBlocksAllowed;
        public ConfigHelper.ConfigValueListener<Integer> veinMaxBlocks;
        public ConfigHelper.ConfigValueListener<Integer> veinSpeed;
        public ConfigHelper.ConfigValueListener<Double> veinMaxDistance;
        public ConfigHelper.ConfigValueListener<Double> minVeinCost;
        public ConfigHelper.ConfigValueListener<Double> minVeinHardness;
        public ConfigHelper.ConfigValueListener<Double> maxVeinCharge;
        public ConfigHelper.ConfigValueListener<Double> exhaustionPerBlock;
        public ConfigHelper.ConfigValueListener<Double> levelsPerHardnessMining;
        public ConfigHelper.ConfigValueListener<Double> levelsPerHardnessWoodcutting;
        public ConfigHelper.ConfigValueListener<Double> levelsPerHardnessExcavation;
        public ConfigHelper.ConfigValueListener<Double> levelsPerHardnessFarming;
        public ConfigHelper.ConfigValueListener<Double> levelsPerHardnessCrafting;
        public ConfigHelper.ConfigValueListener<Double> maxMobSpeedBoost;
        public ConfigHelper.ConfigValueListener<Double> mobSpeedBoostPerPowerLevel;
        public ConfigHelper.ConfigValueListener<Double> maxMobHPBoost;
        public ConfigHelper.ConfigValueListener<Double> mobHPBoostPerPowerLevel;
        public ConfigHelper.ConfigValueListener<Double> maxMobDamageBoost;
        public ConfigHelper.ConfigValueListener<Double> mobDamageBoostPerPowerLevel;
        public ConfigHelper.ConfigValueListener<Boolean> biomeMobMultiplierEnabled;
        public ConfigHelper.ConfigValueListener<Boolean> wearReqEnabled;
        public ConfigHelper.ConfigValueListener<Boolean> toolReqEnabled;
        public ConfigHelper.ConfigValueListener<Boolean> weaponReqEnabled;
        public ConfigHelper.ConfigValueListener<Boolean> killReqEnabled;
        public ConfigHelper.ConfigValueListener<Boolean> killXpEnabled;
        public ConfigHelper.ConfigValueListener<Boolean> mobRareDropEnabled;
        public ConfigHelper.ConfigValueListener<Boolean> useReqEnabled;
        public ConfigHelper.ConfigValueListener<Boolean> placeReqEnabled;
        public ConfigHelper.ConfigValueListener<Boolean> breakReqEnabled;
        public ConfigHelper.ConfigValueListener<Boolean> biomeReqEnabled;
        public ConfigHelper.ConfigValueListener<Boolean> craftReqEnabled;
        public ConfigHelper.ConfigValueListener<Boolean> negativeBiomeEffectEnabled;
        public ConfigHelper.ConfigValueListener<Boolean> positiveBiomeEffectEnabled;
        public ConfigHelper.ConfigValueListener<Boolean> biomeXpBonusEnabled;
        public ConfigHelper.ConfigValueListener<Boolean> xpValueBreakingEnabled;
        public ConfigHelper.ConfigValueListener<Boolean> xpValueGeneralEnabled;
        public ConfigHelper.ConfigValueListener<Boolean> oreEnabled;
        public ConfigHelper.ConfigValueListener<Boolean> logEnabled;
        public ConfigHelper.ConfigValueListener<Boolean> plantEnabled;
        public ConfigHelper.ConfigValueListener<Boolean> salvageEnabled;
        public ConfigHelper.ConfigValueListener<Boolean> fishPoolEnabled;
        public ConfigHelper.ConfigValueListener<Boolean> fishEnchantPoolEnabled;
        public ConfigHelper.ConfigValueListener<Boolean> levelUpCommandEnabled;
        public ConfigHelper.ConfigValueListener<Boolean> heldItemXpBoostEnabled;
        public ConfigHelper.ConfigValueListener<Boolean> wornItemXpBoostEnabled;
        public ConfigHelper.ConfigValueListener<Boolean> loadDefaultConfig;
        public ConfigHelper.ConfigValueListener<Boolean> strictReqTool;
        public ConfigHelper.ConfigValueListener<Boolean> strictReqKill;
        public ConfigHelper.ConfigValueListener<Boolean> strictReqWeapon;
        public ConfigHelper.ConfigValueListener<Boolean> strictReqWear;
        public ConfigHelper.ConfigValueListener<Integer> maxLevel;
        public ConfigHelper.ConfigValueListener<Integer> baseXp;
        public ConfigHelper.ConfigValueListener<Integer> xpIncreasePerLevel;
        public ConfigHelper.ConfigValueListener<Integer> levelsPerMilestone;
        public ConfigHelper.ConfigValueListener<Boolean> wipeAllSkillsUponDeathPermanently;
        public ConfigHelper.ConfigValueListener<Boolean> broadcastMilestone;
        public ConfigHelper.ConfigValueListener<Boolean> levelUpFirework;
        public ConfigHelper.ConfigValueListener<Boolean> milestoneLevelUpFirework;
        public ConfigHelper.ConfigValueListener<Boolean> useExponentialFormula;
        public ConfigHelper.ConfigValueListener<Double> exponentialBaseXp;
        public ConfigHelper.ConfigValueListener<Double> exponentialBase;
        public ConfigHelper.ConfigValueListener<Double> exponentialRate;
        public ConfigHelper.ConfigValueListener<Double> globalMultiplier;
        public ConfigHelper.ConfigValueListener<Double> peacefulMultiplier;
        public ConfigHelper.ConfigValueListener<Double> easyMultiplier;
        public ConfigHelper.ConfigValueListener<Double> normalMultiplier;
        public ConfigHelper.ConfigValueListener<Double> hardMultiplier;
        public ConfigHelper.ConfigValueListener<Double> biomePenaltyMultiplier;
        public ConfigHelper.ConfigValueListener<Double> deathXpPenaltyMultiplier;
        public ConfigHelper.ConfigValueListener<Double> barOffsetX;
        public ConfigHelper.ConfigValueListener<Double> barOffsetY;
        public ConfigHelper.ConfigValueListener<Double> veinBarOffsetX;
        public ConfigHelper.ConfigValueListener<Double> veinBarOffsetY;
        public ConfigHelper.ConfigValueListener<Double> xpDropOffsetX;
        public ConfigHelper.ConfigValueListener<Double> xpDropOffsetY;
        public ConfigHelper.ConfigValueListener<Double> xpDropSpawnDistance;
        public ConfigHelper.ConfigValueListener<Double> xpDropOpacityPerTime;
        public ConfigHelper.ConfigValueListener<Double> xpDropMaxOpacity;
        public ConfigHelper.ConfigValueListener<Double> xpDropDecayAge;
        public ConfigHelper.ConfigValueListener<Double> minXpGrow;
        public ConfigHelper.ConfigValueListener<Boolean> showSkillsListAtCorner;
        public ConfigHelper.ConfigValueListener<Boolean> showXpDrops;
        public ConfigHelper.ConfigValueListener<Boolean> stackXpDrops;
        public ConfigHelper.ConfigValueListener<Boolean> xpDropsAttachedToBar;
        public ConfigHelper.ConfigValueListener<Boolean> xpBarAlwaysOn;
        public ConfigHelper.ConfigValueListener<Boolean> xpLeftDisplayAlwaysOn;
        public ConfigHelper.ConfigValueListener<Boolean> lvlUpScreenshot;
        public ConfigHelper.ConfigValueListener<Boolean> lvlUpScreenshotShowSkills;
        public ConfigHelper.ConfigValueListener<Boolean> xpDropsShowXpBar;
        public ConfigHelper.ConfigValueListener<Double> minBreakSpeed;
        public ConfigHelper.ConfigValueListener<Double> blocksToUnbreakableY;
        public ConfigHelper.ConfigValueListener<Double> miningBonusSpeed;
        public ConfigHelper.ConfigValueListener<Double> woodcuttingBonusSpeed;
        public ConfigHelper.ConfigValueListener<Double> excavationBonusSpeed;
        public ConfigHelper.ConfigValueListener<Double> farmingBonusSpeed;
        public ConfigHelper.ConfigValueListener<Double> blockHardnessLimitForBreaking;
        public ConfigHelper.ConfigValueListener<Double> levelsPerOneReach;
        public ConfigHelper.ConfigValueListener<Double> maxExtraReachBoost;
        public ConfigHelper.ConfigValueListener<Double> blockHardnessLimitForPlacing;
        public ConfigHelper.ConfigValueListener<Boolean> xpValuePlacingEnabled;
        public ConfigHelper.ConfigValueListener<Boolean> treasureEnabled;
        public ConfigHelper.ConfigValueListener<Boolean> tamingXpEnabled;
        public ConfigHelper.ConfigValueListener<Boolean> growingXpEnabled;
        public ConfigHelper.ConfigValueListener<Double> defaultBreedingXp;
        public ConfigHelper.ConfigValueListener<Double> defaultCropGrowXp;
        public ConfigHelper.ConfigValueListener<Double> defaultSaplingGrowXp;
        public ConfigHelper.ConfigValueListener<Double> maxFallSaveChance;
        public ConfigHelper.ConfigValueListener<Double> saveChancePerLevel;
        public ConfigHelper.ConfigValueListener<Double> maxJumpBoost;
        public ConfigHelper.ConfigValueListener<Double> maxSpeedBoost;
        public ConfigHelper.ConfigValueListener<Double> speedBoostPerLevel;
        public ConfigHelper.ConfigValueListener<Double> levelsPerCrouchJumpBoost;
        public ConfigHelper.ConfigValueListener<Double> levelsPerSprintJumpBoost;
        public ConfigHelper.ConfigValueListener<Double> endurancePerLevel;
        public ConfigHelper.ConfigValueListener<Double> maxEndurance;
        public ConfigHelper.ConfigValueListener<Double> levelsPerHeart;
        public ConfigHelper.ConfigValueListener<Integer> maxExtraHeartBoost;
        public ConfigHelper.ConfigValueListener<Double> levelsPerDamage;
        public ConfigHelper.ConfigValueListener<Double> maxExtraDamageBoost;
        public ConfigHelper.ConfigValueListener<Boolean> anvilHandlingEnabled;
        public ConfigHelper.ConfigValueListener<Double> maxSalvageEnchantChance;
        public ConfigHelper.ConfigValueListener<Double> enchantSaveChancePerLevel;
        public ConfigHelper.ConfigValueListener<Boolean> bypassEnchantLimit;
        public ConfigHelper.ConfigValueListener<Integer> levelsPerOneEnchantBypass;
        public ConfigHelper.ConfigValueListener<Integer> maxEnchantmentBypass;
        public ConfigHelper.ConfigValueListener<Integer> maxEnchantLevel;
        public ConfigHelper.ConfigValueListener<Double> upgradeChance;
        public ConfigHelper.ConfigValueListener<Double> failedUpgradeKeepLevelChance;
        public ConfigHelper.ConfigValueListener<Boolean> alwaysUseUpgradeChance;
        public ConfigHelper.ConfigValueListener<Double> anvilCostReductionPerLevel;
        public ConfigHelper.ConfigValueListener<Double> extraChanceToNotBreakAnvilPerLevel;
        public ConfigHelper.ConfigValueListener<Double> anvilFinalItemBonusRepaired;
        public ConfigHelper.ConfigValueListener<Integer> anvilFinalItemMaxCostToAnvil;
        public ConfigHelper.ConfigValueListener<Boolean> smeltingXpEnabled;
        public ConfigHelper.ConfigValueListener<Boolean> smeltingEnabled;
        public ConfigHelper.ConfigValueListener<Boolean> cookingXpEnabled;
        public ConfigHelper.ConfigValueListener<Boolean> cookingEnabled;
        public ConfigHelper.ConfigValueListener<Boolean> brewingXpEnabled;
        public ConfigHelper.ConfigValueListener<Boolean> brewingEnabled;
        public ConfigHelper.ConfigValueListener<Integer> nightvisionUnlockLevel;
        public ConfigHelper.ConfigValueListener<Double> fishPoolBaseChance;
        public ConfigHelper.ConfigValueListener<Double> fishPoolChancePerLevel;
        public ConfigHelper.ConfigValueListener<Double> fishPoolMaxChance;
        public ConfigHelper.ConfigValueListener<Boolean> xpValueCraftingEnabled;
        public ConfigHelper.ConfigValueListener<Double> defaultCraftingXp;
        public ConfigHelper.ConfigValueListener<Double> passiveMobHunterXp;
        public ConfigHelper.ConfigValueListener<Double> aggresiveMobSlayerXp;
        public ConfigHelper.ConfigValueListener<Boolean> breedingXpEnabled;
        public ConfigHelper.ConfigValueListener<Double> defaultTamingXp;
        public ConfigHelper.ConfigValueListener<Double> jesusXp;
        public ConfigHelper.ConfigValueListener<Boolean> autoGenerateValuesEnabled;
        public ConfigHelper.ConfigValueListener<Boolean> autoGenerateExtraChanceEnabled;
        public ConfigHelper.ConfigValueListener<Double> defaultExtraChanceOre;
        public ConfigHelper.ConfigValueListener<Double> defaultExtraChanceLog;
        public ConfigHelper.ConfigValueListener<Double> defaultExtraChancePlant;
        public ConfigHelper.ConfigValueListener<Boolean> autoGenerateWearReqEnabled;
        public ConfigHelper.ConfigValueListener<Boolean> autoGenerateWeaponReqEnabled;
        public ConfigHelper.ConfigValueListener<Boolean> autoGenerateToolReqEnabled;
        public ConfigHelper.ConfigValueListener<Boolean> autoGenerateCraftingXpEnabled;
        public ConfigHelper.ConfigValueListener<Double> autoGeneratedCraftingXpValueMultiplierCrafting;
        public ConfigHelper.ConfigValueListener<Double> autoGeneratedCraftingXpValueMultiplierSmithing;
        public ConfigHelper.ConfigValueListener<Double> armorReqScale;
        public ConfigHelper.ConfigValueListener<Double> armorToughnessReqScale;
        public ConfigHelper.ConfigValueListener<Double> attackDamageReqScale;
        public ConfigHelper.ConfigValueListener<Double> toolReqScaleLog;
        public ConfigHelper.ConfigValueListener<Double> toolReqScaleOre;
        public ConfigHelper.ConfigValueListener<Double> toolReqScaleDirt;

        public ConfigImplementation(ForgeConfigSpec.Builder builder, ConfigHelper.Subscriber subscriber) {
            builder.push("Miscellaneous");
            this.showWelcome = subscriber.subscribe(builder.comment("Should the Welcome message come up?").translation("pmmo.showWelcome").define("showWelcome", true));
            this.showPatreonWelcome = subscriber.subscribe(builder.comment("Should your personal Donator Welcome message come up?").translation("pmmo.showPatreonWelcome").define("showPatreonWelcome", true));
            builder.pop();
            builder.push("Party");
            this.partyRange = subscriber.subscribe(builder.comment("In what range do Party members have to be to benefit from the other members?").translation("pmmo.partyRange").defineInRange("partyRange", 64.0, 1.0, 1.0E9));
            this.partyMaxMembers = subscriber.subscribe(builder.comment("How many Members can a party have?").translation("pmmo.partyMaxMembers").defineInRange("partyMaxMembers", 10, 1, 1000000000));
            this.partyXpIncreasePerPlayer = subscriber.subscribe(builder.comment("How much bonus xp a Party gains extra, per player? (5 = 1 player -> 5% xp bonus, 2 players -> 10% xp bonus").translation("pmmo.partyXpIncreasePerPlayer").defineInRange("partyXpIncreasePerPlayer", 5.0, 0.0, 1.0E9));
            this.maxPartyXpBonus = subscriber.subscribe(builder.comment("How much bonus xp is the maximum that a Party can receive? (50 = 50% increase max. If partyXpIncreasePerPlayer is 5, and there are 20 members, the xp bonus caps at 50%, at 10 members)").translation("pmmo.maxPartyXpBonus").defineInRange("maxPartyXpBonus", 50.0, 0.0, 1.0E9));
            this.partyFriendlyFireAmount = subscriber.subscribe(builder.comment("How much damage you can deal to people in the same Party (0 = no damage, 100 = full damage)").translation("pmmo.partyFriendlyFireAmount").defineInRange("partyFriendlyFireAmount", 33.333333333333336, 0.0, 100.0));
            this.autoLeavePartyOnDisconnect = subscriber.subscribe(builder.comment("Should players leave their party if they disconnect?").translation("pmmo.autoLeavePartyOnDisconnect").define("autoLeavePartyOnDisconnect", false));
            builder.pop();
            builder.push("Vein Mining");
            this.veiningAllowed = subscriber.subscribe(builder.comment("Is vein mining allowed? true = on, false = off").translation("pmmo.veiningAllowed").define("veiningAllowed", true));
            this.veinWoodTopToBottom = subscriber.subscribe(builder.comment("Should veining wood material blocks start from the highest block?").translation("pmmo.veinWoodTopToBottom").define("veinWoodTopToBottom", true));
            this.sleepRechargesAllPlayersVeinCharge = subscriber.subscribe(builder.comment("Should a succesful sleep recharge every player currently in that world Vein Charge?").translation("pmmo.sleepRechargesAllPlayersVeinCharge").define("sleepRechargesAllPlayersVeinCharge", true));
            this.veiningOtherPlayerBlocksAllowed = subscriber.subscribe(builder.comment("Should players be allowed to vein blocks that they did not place?").translation("pmmo.veiningOtherPlayerBlocksAllowed").define("veiningOtherPlayerBlocksAllowed", false));
            this.veinMaxDistance = subscriber.subscribe(builder.comment("What is the maximum distance a player's vein can reach?").translation("pmmo.veinMaxDistance").defineInRange("veinMaxDistance", 1000.0, 1.0, 1.0E9));
            this.veinMaxBlocks = subscriber.subscribe(builder.comment("How many blocks max can be veined?").translation("pmmo.veinMaxBlocks").defineInRange("veinMaxBlocks", 10000, 1, 1000000));
            this.veinSpeed = subscriber.subscribe(builder.comment("How many blocks get broken every tick?").translation("pmmo.veinSpeed").defineInRange("veinSpeed", 1, 1, 10000));
            this.minVeinCost = subscriber.subscribe(builder.comment("How much is the lowest cost for each block veined? (1 = 1 charge, 1 charge regens per second)").translation("pmmo.minVeinCost").defineInRange("minVeinCost", 0.5, 0.01, 10000.0));
            this.minVeinHardness = subscriber.subscribe(builder.comment("What is the lowest hardness for each block veined? (Crops have 0 hardness, this makes crops not infinitely veined)").translation("pmmo.minVeinHardness").defineInRange("minVeinHardness", 0.5, 0.0, 10000.0));
            this.levelsPerHardnessMining = subscriber.subscribe(builder.comment("Every how many levels does 1 charge become worth +1 hardness? (If this is set to 32, your level is 50, and you have 64 charge, you can vein (50 / 160) * 320 = 100 hardness worth of blocks, which is 2.0 Obsidian, or 33.3 Coal Ore)").translation("pmmo.levelsPerHardnessMining").defineInRange("levelsPerHardnessMining", 160.0, 0.01, 10000.0));
            this.levelsPerHardnessWoodcutting = subscriber.subscribe(builder.comment("Every how many levels does 1 charge become worth +1 hardness? (If this is set to 32, your level is 50, and you have 64 charge, you can vein (50 / 160) * 320 = 100 hardness worth of logs, which is 50 Logs)").translation("pmmo.levelsPerHardnessWoodcutting").defineInRange("levelsPerHardnessWoodcutting", 160.0, 0.01, 10000.0));
            this.levelsPerHardnessExcavation = subscriber.subscribe(builder.comment("Every how many levels does 1 charge become worth +1 hardness? (If this is set to 16, your level is 50, and you have 64 charge, you can vein (50 / 320) * 320 = 50 hardness worth of ground, which is 100 Dirt)").translation("pmmo.levelsPerHardnessExcavation").defineInRange("levelsPerHardnessExcavation", 320.0, 0.01, 10000.0));
            this.levelsPerHardnessFarming = subscriber.subscribe(builder.comment("Every how many levels does 1 charge become worth +1 hardness? Plants have no hardness, but there is a minimum hardness while veining config in here, which is 0.5 by default, making it 200 plants at level 50 farming, with 320 charge, if this is set to 160").translation("pmmo.levelsPerHardnessFarming").defineInRange("levelsPerHardnessFarming", 160.0, 0.1, 10000.0));
            this.levelsPerHardnessCrafting = subscriber.subscribe(builder.comment("Every how many levels does 1 charge become worth +1 hardness? (If this is set to 80, your level is 50, and you have 320 charge, you can vein (50 / 80) * 320 = 200 hardness worth of Crafting Related (Such as wool, carpet, bed) blocks, which depends on how hard they are)").translation("pmmo.levelsPerHardnessCrafting").defineInRange("levelsPerHardnessCrafting", 160.0, 0.1, 10000.0));
            this.maxVeinCharge = subscriber.subscribe(builder.comment("How much vein charge can a player hold at max? (1 recharges every second)").translation("pmmo.maxVeinCharge").defineInRange("maxVeinCharge", 320.0, 0.0, 100000.0));
            this.exhaustionPerBlock = subscriber.subscribe(builder.comment("How much hunger should be exhausted per block veined?").translation("pmmo.exhaustionPerBlock").defineInRange("exhaustionPerBlock", 0.2, 0.0, 20.0));
            builder.pop();
            builder.push("Mob Scaling");
            this.maxMobDamageBoost = subscriber.subscribe(builder.comment("What is the maximum amount an aggressive mob's damage will be boosted?").translation("pmmo.maxMobDamageBoost").defineInRange("maxMobDamageBoost", 100.0, 0.0, 1.0E9));
            this.mobDamageBoostPerPowerLevel = subscriber.subscribe(builder.comment("How much an aggresive mob's damage will increase per one Power Level?").translation("pmmo.mobDamageBoostPerPowerLevel").defineInRange("mobDamageBoostPerPowerLevel", 1.0, 0.0, 10.0));
            this.maxMobHPBoost = subscriber.subscribe(builder.comment("What is the maximum amount an aggressive mob's HP will be boosted?").translation("pmmo.maxMobHPBoost").defineInRange("maxMobHPBoost", 1000.0, 0.0, 1024.0));
            this.mobHPBoostPerPowerLevel = subscriber.subscribe(builder.comment("How much an aggresive mob's HP will increase per one Power Level?").translation("pmmo.mobHPBoostPerPowerLevel").defineInRange("mobHPBoostPerPowerLevel", 5.0, 0.0, 100.0));
            this.maxMobSpeedBoost = subscriber.subscribe(builder.comment("What is the maximum amount an aggressive mob's speed will be boosted?").translation("pmmo.maxMobSpeedBoost").defineInRange("maxMobSpeedBoost", 10.0, 0.0, 100.0));
            this.mobSpeedBoostPerPowerLevel = subscriber.subscribe(builder.comment("How much an aggresive mob's speed will increase per one Power Level?").translation("pmmo.mobSpeedBoostPerPowerLevel").defineInRange("mobSpeedBoostPerPowerLevel", 1.0, 0.0, 10.0));
            this.biomeMobMultiplierEnabled = subscriber.subscribe(builder.comment("Should mob xp multipliers inside of biomes be enabled? false means no multipliers").translation("pmmo.biomeMobMultiplierEnabled").define("biomeMobMultiplierEnabled", true));
            builder.pop();
            builder.push("Requirements");
            this.wearReqEnabled = subscriber.subscribe(builder.comment("Should wear requirements be enabled? false means no requirements").translation("pmmo.wearReqEnabled").define("wearReqEnabled", true));
            this.toolReqEnabled = subscriber.subscribe(builder.comment("Should tool requirements be enabled? false means no requirements").translation("pmmo.toolReqEnabled").define("toolReqEnabled", true));
            this.weaponReqEnabled = subscriber.subscribe(builder.comment("Should weapon requirements be enabled? false means no requirements").translation("pmmo.weaponReqEnabled").define("weaponReqEnabled", true));
            this.killReqEnabled = subscriber.subscribe(builder.comment("Should mob kill req be enabled? false means no requirements").translation("pmmo.killReqEnabled").define("killReqEnabled", true));
            this.killXpEnabled = subscriber.subscribe(builder.comment("Should mob kill xp be enabled? false means no requirements").translation("pmmo.killXpEnabled").define("killXpEnabled", true));
            this.mobRareDropEnabled = subscriber.subscribe(builder.comment("Should mob rare drops be enabled? false means no requirements").translation("pmmo.mobRareDropEnabled").define("mobRareDropEnabled", true));
            this.useReqEnabled = subscriber.subscribe(builder.comment("Should use requirements be enabled? false means no requirements").translation("pmmo.useReqEnabled").define("useReqEnabled", true));
            this.placeReqEnabled = subscriber.subscribe(builder.comment("Should place requirements be enabled? false means no requirements").translation("pmmo.placeReqEnabled").define("placeReqEnabled", true));
            this.breakReqEnabled = subscriber.subscribe(builder.comment("Should break requirements be enabled? false means no requirements").translation("pmmo.breakReqEnabled").define("breakReqEnabled", true));
            this.biomeReqEnabled = subscriber.subscribe(builder.comment("Should biome requirements be enabled? false means no requirements").translation("pmmo.biomeReqEnabled").define("biomeReqEnabled", true));
            this.craftReqEnabled = subscriber.subscribe(builder.comment("Should certain items be restricted from being crafted, without the level requirement?").translation("pmmo.craftReqEnabled").define("craftReqEnabled", true));
            this.negativeBiomeEffectEnabled = subscriber.subscribe(builder.comment("Should biome negative effects be enabled? false means no negative effects").translation("pmmo.negativeBiomeEffectEnabled").define("negativeBiomeEffectEnabled", true));
            this.positiveBiomeEffectEnabled = subscriber.subscribe(builder.comment("Should biome positive effects be enabled? false means no positive effects").translation("pmmo.positiveBiomeEffectEnabled").define("positiveBiomeEffectEnabled", true));
            this.biomeXpBonusEnabled = subscriber.subscribe(builder.comment("Should xp multipliers be enabled? false means no multipliers").translation("pmmo.biomeXpBonusEnabled").define("biomeXpBonusEnabled", true));
            this.xpValueGeneralEnabled = subscriber.subscribe(builder.comment("Should xp values for general things be enabled? (Such as catching fish)").translation("pmmo.xpValueGeneralEnabled").define("xpValueGeneralEnabled", true));
            this.xpValueBreakingEnabled = subscriber.subscribe(builder.comment("Should xp values for breaking things first time be enabled? false means only Hardness xp is awarded for breaking").translation("pmmo.xpValueBreakingEnabled").define("xpValueBreakingEnabled", true));
            this.oreEnabled = subscriber.subscribe(builder.comment("Should ores be enabled? false means no extra chance").translation("pmmo.oreEnabled").define("oreEnabled", true));
            this.logEnabled = subscriber.subscribe(builder.comment("Should logs be enabled? false means no extra chance").translation("pmmo.logEnabled").define("logEnabled", true));
            this.plantEnabled = subscriber.subscribe(builder.comment("Should plants be enabled? false means no extra chance").translation("pmmo.plantEnabled").define("plantEnabled", true));
            this.salvageEnabled = subscriber.subscribe(builder.comment("Is Salvaging items using the Repairing skill enabled? false = off").translation("pmmo.salvageEnabled").define("salvageEnabled", true));
            this.fishPoolEnabled = subscriber.subscribe(builder.comment("Is catching items from Fish Pool while Fishing enabled? false = off").translation("pmmo.fishPoolEnabled").define("fishPoolEnabled", true));
            this.fishEnchantPoolEnabled = subscriber.subscribe(builder.comment("Should fished items have a chance at being Enchanted? enabled? false = off").translation("pmmo.fishEnchantPoolEnabled").define("fishEnchantPoolEnabled", true));
            this.levelUpCommandEnabled = subscriber.subscribe(builder.comment("Commands being fired on specific level ups enabled? false = off").translation("pmmo.levelUpCommandEnabled").define("levelUpCommandEnabled", true));
            this.heldItemXpBoostEnabled = subscriber.subscribe(builder.comment("Main held items xp multiplier enabled? false = off").translation("pmmo.heldItemXpBoostEnabled").define("heldItemXpBoostEnabled", true));
            this.wornItemXpBoostEnabled = subscriber.subscribe(builder.comment("worn items xp boost enabled? false = off").translation("pmmo.wornItemXpBoostEnabled").define("wornItemXpBoostEnabled", true));
            this.loadDefaultConfig = subscriber.subscribe(builder.comment("Should config from default_data.json be loaded? false means only data.json is loaded").translation("pmmo.loadDefaultConfig").define("loadDefaultConfig", true));
            this.strictReqTool = subscriber.subscribe(builder.comment("When a Tool requirement is not met, should the player be stopped from breaking with it completely?").translation("pmmo.strictReqTool").define("strictReqTool", false));
            this.strictReqKill = subscriber.subscribe(builder.comment("When a Kill requirement is not met, should the player be stopped from dealing any damage?").translation("pmmo.strictReqKill").define("strictReqKill", false));
            this.strictReqWeapon = subscriber.subscribe(builder.comment("When a Weapon requirement is not met, should the player be stopped from dealing any damage?").translation("pmmo.strictReqWeapon").define("strictReqWeapon", false));
            this.strictReqWear = subscriber.subscribe(builder.comment("When a Wear requirement is not met, should the item be dropped?").translation("pmmo.strictReqWear").define("strictReqWear", false));
            builder.pop();
            builder.push("Levels");
            this.maxLevel = subscriber.subscribe(builder.comment("What is the global max level").translation("pmmo.maxLevel").defineInRange("maxLevel", 999, 1, 1000000));
            this.baseXp = subscriber.subscribe(builder.comment("What is the baseXp to reach level 2 ( baseXp + level * xpPerLevel )").translation("pmmo.baseXp").defineInRange("baseXp", 250, 1, 1000000));
            this.xpIncreasePerLevel = subscriber.subscribe(builder.comment("What is the xp increase per level ( baseXp + level * xpPerLevel )").translation("pmmo.xpIncreasePerLevel").defineInRange("xpIncreasePerLevel", 50, 1, 1000000));
            this.levelsPerMilestone = subscriber.subscribe(builder.comment("Every how many levels should a level up broadcast be sent to all players? (10 = every 10 levels)").translation("pmmo.levelsPerMilestone").defineInRange("levelsPerMilestone", 10, 1, 1000000));
            this.wipeAllSkillsUponDeathPermanently = subscriber.subscribe(builder.comment("Should a player have all their skills wiped to level 1 upon death?").translation("pmmo.wipeAllSkillsUponDeathPermanently").define("wipeAllSkillsUponDeathPermanently", false));
            this.broadcastMilestone = subscriber.subscribe(builder.comment("Should every 10th level up be broadcast to everyone?").translation("pmmo.broadcastMilestone").define("broadcastMilestone", true));
            this.levelUpFirework = subscriber.subscribe(builder.comment("Should fireworks appear on level up?").translation("pmmo.levelUpFirework").define("levelUpFirework", true));
            this.milestoneLevelUpFirework = subscriber.subscribe(builder.comment("Should fireworks appear on Milestone level up, to other players?").translation("pmmo.milestoneLevelUpFirework").define("milestoneLevelUpFirework", true));
            this.useExponentialFormula = subscriber.subscribe(builder.comment("Should levels be determined using an Exponential formula? (false = the original way)").translation("pmmo.useExponentialFormula").define("useExponentialFormula", false));
            this.exponentialBaseXp = subscriber.subscribe(builder.comment("What is the x in: x * ( exponentialBase^( exponentialRate * level ) )").translation("pmmo.exponentialBaseXp").defineInRange("exponentialBaseXp", 83.0, 1.0, 1000000.0));
            this.exponentialBase = subscriber.subscribe(builder.comment("What is the x in: exponentialBaseXp * ( x^( exponentialRate * level ) )").translation("pmmo.exponentialBase").defineInRange("exponentialBase", 1.104088404342588, 0.0, 1000000.0));
            this.exponentialRate = subscriber.subscribe(builder.comment("What is the x in: exponentialBaseXp * ( exponentialBase^( x * level ) )").translation("pmmo.exponentialRate").defineInRange("exponentialRate", 1.0, 0.0, 1000000.0));
            builder.pop();
            builder.push("Multipliers");
            this.globalMultiplier = subscriber.subscribe(builder.comment("How much xp everyone gains (1 = normal, 2 = twice as much)").translation("pmmo.globalMultiplier").defineInRange("globalMultiplier", 1.0, 0.0, 1000.0));
            this.peacefulMultiplier = subscriber.subscribe(builder.comment("How much xp everyone gains on Peaceful Difficulty (1 = normal, 2 = twice as much)").translation("pmmo.peacefulMultiplier").defineInRange("peacefulMultiplier", 0.3333333333333333, 0.0, 1000.0));
            this.easyMultiplier = subscriber.subscribe(builder.comment("How much xp everyone gains on Easy Difficulty (1 = normal, 2 = twice as much)").translation("pmmo.easyMultiplier").defineInRange("easyMultiplier", 0.6666666666666666, 0.0, 1000.0));
            this.normalMultiplier = subscriber.subscribe(builder.comment("How much xp everyone gains on Normal Difficulty (1 = normal, 2 = twice as much)").translation("pmmo.normalMultiplier").defineInRange("normalMultiplier", 1.0, 0.0, 1000.0));
            this.hardMultiplier = subscriber.subscribe(builder.comment("How much xp everyone gains on Hard Difficulty (1 = normal, 2 = twice as much)").translation("pmmo.hardMultiplier").defineInRange("hardMultiplier", 1.3333333333333333, 0.0, 1000.0));
            this.biomePenaltyMultiplier = subscriber.subscribe(builder.comment("How much xp you get in biomes you do not meet the requirements for (1 = Full xp, 0.5 = Half xp)").translation("pmmo.biomePenaltyMultiplier").defineInRange("biomePenaltyMultiplier", 0.5, 0.0, 1.0));
            this.deathXpPenaltyMultiplier = subscriber.subscribe(builder.comment("How much of the xp above whole level you loose (1 = 100% = from 5.5 to 5.0, 0.5 = 50% = from 5.5 to 5.25").translation("pmmo.deathXpPenaltyMultiplier").defineInRange("deathXpPenaltyMultiplier", 0.5, 0.0, 1.0));
            builder.pop();
            builder.push("GUI");
            this.barOffsetX = subscriber.subscribe(builder.comment("GUI bar position X (Width)").translation("pmmo.barOffsetX").defineInRange("barOffsetX", 0.5, 0.0, 100.0));
            this.barOffsetY = subscriber.subscribe(builder.comment("GUI bar position Y (Height, 0 is top, 1 is bottom (1 is probably invisible due to clipping) )").translation("pmmo.barOffsetY").defineInRange("barOffsetY", 0.0, 0.0, 100.0));
            this.veinBarOffsetX = subscriber.subscribe(builder.comment("GUI bar position X (Width)").translation("pmmo.veinBarOffsetX").defineInRange("veinBarOffsetX", 0.5, 0.0, 100.0));
            this.veinBarOffsetY = subscriber.subscribe(builder.comment("GUI bar position Y (Height, 0 is top, 1 is bottom (1 is probably invisible due to clipping) )").translation("pmmo.veinBarOffsetY").defineInRange("veinBarOffsetY", 0.65, 0.0, 100.0));
            this.xpDropOffsetX = subscriber.subscribe(builder.comment("GUI Xp drops position X (Width)").translation("pmmo.xpDropOffsetX").defineInRange("xpDropOffsetX", 0.5, 0.0, 100.0));
            this.xpDropOffsetY = subscriber.subscribe(builder.comment("GUI Xp drops position Y (Height, 0 is top, 1 is bottom (1 is probably invisible due to clipping) )").translation("pmmo.xpDropOffsetY").defineInRange("xpDropOffsetY", 0.0, 0.0, 1.0));
            this.xpDropSpawnDistance = subscriber.subscribe(builder.comment("How far away does the Xp Drop spawn").translation("pmmo.xpDropSpawnDistance").defineInRange("xpDropSpawnDistance", 50.0, 0.0, 1000.0));
            this.xpDropOpacityPerTime = subscriber.subscribe(builder.comment("How much out of MaxOpacity does the Xp Drop become visible per 1 distance").translation("pmmo.xpDropOpacityPerTime").defineInRange("xpDropOpacityPerTime", 5.0, 0.0, 255.0));
            this.xpDropMaxOpacity = subscriber.subscribe(builder.comment("How opaque (visible) can the xp drop get?").translation("pmmo.xpDropMaxOpacity").defineInRange("xpDropMaxOpacity", 200.0, 0.0, 255.0));
            this.xpDropDecayAge = subscriber.subscribe(builder.comment("At what age do xp drops start to decay?").translation("pmmo.xpDropDecayAge").defineInRange("xpDropDecayAge", 350.0, 0.0, 5000.0));
            this.minXpGrow = subscriber.subscribe(builder.comment("What is the minimum amount xp grows a set amount of time? (Default 0.2, increase to speed up growth)").translation("pmmo.minXpGrow").defineInRange("minXpGrow", 1.0, 0.01, 100.0));
            this.xpDropsAttachedToBar = subscriber.subscribe(builder.comment("Should xp drops sync up with the bar being open or closed? HIGHLY RECOMMEND TO KEEP FALSE IF YOU ARE MOVING XP DROP POSITIONS").translation("pmmo.xpDropsAttachedToBar").define("xpDropsAttachedToBar", true));
            this.showSkillsListAtCorner = subscriber.subscribe(builder.comment("If Off, The skills list at the top left corner will no longer appear (You still have the GUI to show you all of your skills info)").translation("pmmo.showSkillsListAtCorner").define("showSkillsListAtCorner", true));
            this.showXpDrops = subscriber.subscribe(builder.comment("If Off, xp drops will no longer appear").translation("pmmo.showXpDrops").define("showXpDrops", true));
            this.stackXpDrops = subscriber.subscribe(builder.comment("If Off, xp drops will no longer stack with each other").translation("pmmo.stackXpDrops").define("stackXpDrops", true));
            this.xpBarAlwaysOn = subscriber.subscribe(builder.comment("Should the Xp Bar always be on? false = only appears while holding Show GUI or when you gain xp").translation("pmmo.xpBarAlwaysOn").define("xpBarAlwaysOn", false));
            this.xpLeftDisplayAlwaysOn = subscriber.subscribe(builder.comment("Should the Xp left indicator always be on? false = only appears with Show GUI key").translation("pmmo.xpLeftDisplayAlwaysOn").define("xpLeftDisplayAlwaysOn", false));
            this.lvlUpScreenshot = subscriber.subscribe(builder.comment("Should a screenshot be taken everytime you level up?").translation("pmmo.lvlUpScreenshot").define("lvlUpScreenshot", false));
            this.lvlUpScreenshotShowSkills = subscriber.subscribe(builder.comment("When a screenshot is taken upon levelling up, should the skills list turn on automatically to be included in the screenshot?").translation("pmmo.lvlUpScreenshotShowSkills").define("lvlUpScreenshotShowSkills", false));
            this.xpDropsShowXpBar = subscriber.subscribe(builder.comment("Should Xp Drops make the Xp Bar pop up?").translation("pmmo.xpDropsShowXpBar").define("xpDropsShowXpBar", true));
            builder.pop();
            builder.push("Breaking Speed");
            this.minBreakSpeed = subscriber.subscribe(builder.comment("Minimum Breaking Speed (1 is Original speed, 0.5 is half)").translation("pmmo.minBreakSpeed").defineInRange("minBreakSpeed", 0.5, 0.0, 100.0));
            this.blocksToUnbreakableY = subscriber.subscribe(builder.comment("How many blocks it takes to reach 0 Break Speed (will get capped by Minimum Breaking Speed)").translation("pmmo.blocksToUnbreakableY").defineInRange("blocksToUnbreakableY", 1000.0, -1.7976931348623157E308, Double.MAX_VALUE));
            this.miningBonusSpeed = subscriber.subscribe(builder.comment("How much your mining speed increases per level (1 = 1% increase per level)").translation("pmmo.miningBonusSpeed").defineInRange("miningBonusSpeed", 1.0, 0.0, 10.0));
            this.woodcuttingBonusSpeed = subscriber.subscribe(builder.comment("How much your cutting speed increases per level in (1 = 1% increase per level)").translation("pmmo.woodcuttingBonusSpeed").defineInRange("woodcuttingBonusSpeed", 1.0, 0.0, 10.0));
            this.excavationBonusSpeed = subscriber.subscribe(builder.comment("How much your digging speed increases per level in (1 = 1% increase per level)").translation("pmmo.excavationBonusSpeed").defineInRange("excavationBonusSpeed", 1.0, 0.0, 10.0));
            this.farmingBonusSpeed = subscriber.subscribe(builder.comment("How much your farming speed increases per level in (1 = 1% increase per level)").translation("pmmo.farmingBonusSpeed").defineInRange("farmingBonusSpeed", 1.0, 0.0, 10.0));
            builder.pop();
            builder.push("Mining");
            this.blockHardnessLimitForBreaking = subscriber.subscribe(builder.comment("Hardest considered block (1 hardness = 1 remove xp. 0 = no xp for block hardness, 30 means obsidian caps at 30xp per block.)").translation("pmmo.blockHardnessLimitForBreaking").defineInRange("blockHardnessLimitForBreaking", 20.0, 0.0, 1000000.0));
            builder.pop();
            builder.push("Building");
            this.levelsPerOneReach = subscriber.subscribe(builder.comment("Every how many levels you gain an extra block of reach").translation("pmmo.levelsPerOneReach").defineInRange("levelsPerOneReach", 25.0, 0.0, 1.0E9));
            this.maxExtraReachBoost = subscriber.subscribe(builder.comment("What is the maximum reach a player can have").translation("pmmo.maxExtraReachBoost").defineInRange("maxExtraReachBoost", 20.0, 0.0, 1.0E9));
            this.blockHardnessLimitForPlacing = subscriber.subscribe(builder.comment("Hardest considered block (1 hardness = 1 build xp. 0 = no xp for block hardness, 30 means obsidian caps at 30xp per block.)").translation("pmmo.blockHardnessLimitForPlacing").defineInRange("blockHardnessLimitForPlacing", 20.0, 0.0, 1000000.0));
            this.xpValuePlacingEnabled = subscriber.subscribe(builder.comment("Should xp values for crafting be enabled? false means the hardness value is used").translation("pmmo.xpValuePlacingEnabled").define("xpValuePlacingEnabled", true));
            builder.pop();
            builder.push("Excavation");
            this.treasureEnabled = subscriber.subscribe(builder.comment("Do players find Treasure inside of blocks?").translation("pmmo.treasureEnabled").define("treasureEnabled", true));
            builder.pop();
            builder.push("Woodcutting");
            builder.pop();
            builder.push("Farming");
            this.breedingXpEnabled = subscriber.subscribe(builder.comment("Do players get xp for breeding animals?").translation("pmmo.breedingXpEnabled").define("breedingXpEnabled", true));
            this.defaultBreedingXp = subscriber.subscribe(builder.comment("How much xp should be awarded in Farming for breeding two animals? (Json Overrides this) (Set to 0 to disable default xp)").translation("pmmo.defaultBreedingXp").defineInRange("defaultBreedingXp", 10.0, 0.0, 1000000.0));
            this.defaultSaplingGrowXp = subscriber.subscribe(builder.comment("How much xp should be awarded in Farming for growing a sapling? (Json Overrides this) (Set to 0 to disable default xp)").translation("pmmo.defaultBreedingXp").defineInRange("defaultBreedingXp", 25.0, 0.0, 1000000.0));
            this.defaultCropGrowXp = subscriber.subscribe(builder.comment("How much xp should be awarded in Farming for growing crops? (Json Overrides this) (Set to 0 to disable default xp)").translation("pmmo.defaultBreedingXp").defineInRange("defaultBreedingXp", 15.0, 0.0, 1000000.0));
            builder.pop();
            builder.push("Agility");
            this.maxFallSaveChance = subscriber.subscribe(builder.comment("Maximum chance to save each point of fall damage (100 = no fall damage)").translation("pmmo.maxFallSaveChance").defineInRange("maxFallSaveChance", 64.0, 0.0, 100.0));
            this.saveChancePerLevel = subscriber.subscribe(builder.comment("How much your chance to save each point of fall damage increases per level (1 = 1% increase per Level)").translation("pmmo.saveChancePerLevel").defineInRange("saveChancePerLevel", 64.0, 0.0, 100.0));
            this.maxJumpBoost = subscriber.subscribe(builder.comment("How much jump boost can you gain max (above 0.33 makes you take fall damage)").translation("pmmo.maxJumpBoost").defineInRange("maxJumpBoost", 0.33, 0.0, 100.0));
            this.levelsPerCrouchJumpBoost = subscriber.subscribe(builder.comment("Every how many levels you gain an extra block of jumping height while Crouching").translation("pmmo.levelsPerCrouchJumpBoost").defineInRange("levelsPerCrouchJumpBoost", 33.0, 0.0, 1.0E9));
            this.levelsPerSprintJumpBoost = subscriber.subscribe(builder.comment("Every how many levels you gain an extra block of jumping height while Sprinting").translation("pmmo.levelsPerSprintJumpBoost").defineInRange("levelsPerSprintJumpBoost", 50.0, 0.0, 1.0E9));
            this.maxSpeedBoost = subscriber.subscribe(builder.comment("How much speed boost you can get from Agility (100 = 100% vanilla + 100% = twice as fast max)").translation("pmmo.maxSpeedBoost").defineInRange("maxSpeedBoost", 100.0, 0.0, 1.0E9));
            this.speedBoostPerLevel = subscriber.subscribe(builder.comment("How much speed boost you get from each level (Incredibly sensitive, default 0.0005)").translation("pmmo.speedBoostPerLevel").defineInRange("speedBoostPerLevel", 2.5E-4, 0.0, 10.0));
            builder.pop();
            builder.push("Endurance");
            this.maxEndurance = subscriber.subscribe(builder.comment("How much endurance is max (100 = god mode)").translation("pmmo.maxEndurance").defineInRange("maxEndurance", 50.0, 0.0, 100.0));
            this.endurancePerLevel = subscriber.subscribe(builder.comment("How much endurance you gain per level (1 = 1% per level)").translation("pmmo.endurancePerLevel").defineInRange("endurancePerLevel", 0.25, 0.0, 100.0));
            this.levelsPerHeart = subscriber.subscribe(builder.comment("Per how many levels you gain 1 Max Heart").translation("pmmo.levelsPerHeart").defineInRange("levelsPerHeart", 10.0, 0.0, 1.0E9));
            this.maxExtraHeartBoost = subscriber.subscribe(builder.comment("How many Max Hearts you can have (20 means 10 vanilla + 20 boosted)").translation("pmmo.maxExtraHeartBoost").defineInRange("maxExtraHeartBoost", 100, 0, 1000000000));
            builder.pop();
            builder.push("Combat");
            this.levelsPerDamage = subscriber.subscribe(builder.comment("Per how many levels you gain 1 Extra Damage").translation("pmmo.levelsPerDamage").defineInRange("levelsPerDamage", 20.0, 0.0, 1.0E9));
            this.maxExtraDamageBoost = subscriber.subscribe(builder.comment("How much extra damage can you get from the Combat skill max?").translation("pmmo.maxExtraDamageBoost").defineInRange("maxExtraDamageBoost", 100.0, 0.0, 1.0E9));
            builder.pop();
            builder.push("Archery");
            builder.pop();
            builder.push("Smithing");
            this.anvilHandlingEnabled = subscriber.subscribe(builder.comment("Should PMMO anvil handling be enabled? (xp rewards for repair, and also Enchantment handling) (some mod items break, if you experience lost enchantments, set this to false)").translation("pmmo.anvilHandlingEnabled").define("anvilHandlingEnabled", true));
            this.maxSalvageEnchantChance = subscriber.subscribe(builder.comment("Max Percentage chance to return each Enchantment Level").translation("pmmo.maxSalvageEnchantChance").defineInRange("maxSalvageEnchantChance", 90.0, 0.0, 100.0));
            this.enchantSaveChancePerLevel = subscriber.subscribe(builder.comment("Each Enchantment Save Chance per Level").translation("pmmo.enchantSaveChancePerLevel").defineInRange("enchantSaveChancePerLevel", 0.9, 0.0, 100.0));
            this.anvilCostReductionPerLevel = subscriber.subscribe(builder.comment("Vanilla starts at 50, hence: (50 - [this] * level)").translation("pmmo.anvilCostReductionPerLevel").defineInRange("anvilCostReductionPerLevel", 0.25, 0.0, 100.0));
            this.extraChanceToNotBreakAnvilPerLevel = subscriber.subscribe(builder.comment("Chance to not break anvil, 100 = twice the value, half the chance per Level.").translation("pmmo.extraChanceToNotBreakAnvilPerLevel").defineInRange("extraChanceToNotBreakAnvilPerLevel", 1.0, 0.0, 100.0));
            this.anvilFinalItemBonusRepaired = subscriber.subscribe(builder.comment("Bonus repair durability per level (100 = twice as much repair per level)").translation("pmmo.anvilFinalItemBonusRepaired").defineInRange("anvilFinalItemBonusRepaired", 1.0, 0.0, 100.0));
            this.anvilFinalItemMaxCostToAnvil = subscriber.subscribe(builder.comment("Vanilla caps at 50, at around 30 vanilla you can no longer anvil the item again. allows unlocking infinite Anvil uses.").translation("pmmo.anvilFinalItemMaxCostToAnvil").defineInRange("anvilFinalItemMaxCostToAnvil", 10, 0, 50));
            this.bypassEnchantLimit = subscriber.subscribe(builder.comment("Anvil combination limits enchantments to max level set in this config").translation("pmmo.bypassEnchantLimit").define("bypassEnchantLimit", true));
            this.levelsPerOneEnchantBypass = subscriber.subscribe(builder.comment("How many levels per each Enchantment Level Bypass above max level enchantment can support in vanilla").translation("pmmo.levelsPerOneEnchantBypass").defineInRange("levelsPerOneEnchantBypass", 50, 0, 1000000000));
            this.maxEnchantmentBypass = subscriber.subscribe(builder.comment("Max amount of levels enchants are able to go above max vanilla level").translation("pmmo.maxEnchantmentBypass").defineInRange("maxEnchantmentBypass", 10, 0, 1000000000));
            this.maxEnchantLevel = subscriber.subscribe(builder.comment("Anvil combination limits enchantments to this level").translation("pmmo.maxEnchantLevel").defineInRange("maxEnchantLevel", 255, 0, 255));
            this.upgradeChance = subscriber.subscribe(builder.comment("What is the chance to Bypass a max enchant level (provided you got the skill to do so)").translation("pmmo.upgradeChance").defineInRange("upgradeChance", 50.0, 0.0, 100.0));
            this.failedUpgradeKeepLevelChance = subscriber.subscribe(builder.comment("What is the chance to Reduce a level after a Upgrade chance fails (100 = everytime you fail bypass, enchant level goes down by 1)").translation("pmmo.failedUpgradeKeepLevelChance").defineInRange("failedUpgradeKeepLevelChance", 50.0, 0.0, 100.0));
            this.alwaysUseUpgradeChance = subscriber.subscribe(builder.comment("false = Upgrade Chance if only rolled if you are trying to upgrade your item ABOVE vanilla max level. true = you ALWAYS have an upgrade chance level.").translation("pmmo.alwaysUseUpgradeChance").define("alwaysUseUpgradeChance", false));
            this.smeltingXpEnabled = subscriber.subscribe(builder.comment("Do players get xp for Smelting items in a Furnace?").translation("pmmo.smeltingXpEnabled").define("smeltingXpEnabled", true));
            this.smeltingEnabled = subscriber.subscribe(builder.comment("Do Furnaces produce extra items according to Item Owner Smithing level?").translation("pmmo.smeltingEnabled").define("smeltingEnabled", true));
            builder.pop();
            builder.push("Cooking");
            this.cookingXpEnabled = subscriber.subscribe(builder.comment("Do players get xp for Cooking items in Furnaces/Smokers/Fireplaces?").translation("pmmo.cookingXpEnabled").define("cookingXpEnabled", true));
            this.cookingEnabled = subscriber.subscribe(builder.comment("Do Furnaces/Smokers/Fireplaces produce extra items according to Item Owner Cooking level?").translation("pmmo.cookingEnabled").define("cookingEnabled", true));
            builder.pop();
            builder.push("Alchemy");
            this.brewingXpEnabled = subscriber.subscribe(builder.comment("Do players get xp for Brewing potions in Brewing Stands?").translation("pmmo.brewingXpEnabled").define("brewingXpEnabled", true));
            this.brewingEnabled = subscriber.subscribe(builder.comment("Does Brewing provide a chance to produce Extra potions?").translation("pmmo.brewingEnabled").define("brewingEnabled", true));
            builder.pop();
            builder.push("Flying");
            builder.pop();
            builder.push("Swimming");
            this.nightvisionUnlockLevel = subscriber.subscribe(builder.comment("Underwater Nightvision Unlock Level").translation("pmmo.nightvisionUnlockLevel").defineInRange("nightvisionUnlockLevel", 25, 0, 1000000));
            builder.pop();
            builder.push("Fishing");
            this.fishPoolBaseChance = subscriber.subscribe(builder.comment("What is the chance on each successful fishing attempt to access the fish_pool").translation("pmmo.fishPoolBaseChance").defineInRange("fishPoolBaseChance", 0.0, 0.0, 100.0));
            this.fishPoolChancePerLevel = subscriber.subscribe(builder.comment("What is the increase per level to access the fish_pool").translation("pmmo.fishPoolChancePerLevel").defineInRange("fishPoolChancePerLevel", 0.25, 0.0, 100.0));
            this.fishPoolMaxChance = subscriber.subscribe(builder.comment("What is the max chance to access the fish_pool").translation("pmmo.fishPoolMaxChance").defineInRange("fishPoolMaxChance", 80.0, 0.0, 100.0));
            builder.pop();
            builder.push("Crafting");
            this.xpValueCraftingEnabled = subscriber.subscribe(builder.comment("Should xp values for crafting be enabled? false means the default value is used").translation("pmmo.xpValueCraftingEnabled").define("xpValueCraftingEnabled", true));
            this.defaultCraftingXp = subscriber.subscribe(builder.comment("How much xp should be awarded in Crafting for each item crafted? (Json Overrides this) (Set to 0 to disable default xp)").translation("pmmo.defaultCraftingXp").defineInRange("defaultCraftingXp", 1.0, 0.0, 1000000.0));
            builder.pop();
            builder.push("Slayer");
            this.aggresiveMobSlayerXp = subscriber.subscribe(builder.comment("How much slayer xp is awarded upon killing an aggresive mob by default").translation("pmmo.aggresiveMobSlayerXp").defineInRange("aggresiveMobSlayerXp", 0.0, 0.0, 10000.0));
            builder.pop();
            builder.push("Hunter");
            this.passiveMobHunterXp = subscriber.subscribe(builder.comment("How much hunter xp is awarded upon killing a passive mob by default").translation("pmmo.passiveMobHunterXp").defineInRange("passiveMobHunterXp", 0.0, 0.0, 10000.0));
            builder.pop();
            builder.push("Taming");
            this.tamingXpEnabled = subscriber.subscribe(builder.comment("Do players get xp for taming animals?").translation("pmmo.tamingXpEnabled").define("tamingXpEnabled", true));
            this.growingXpEnabled = subscriber.subscribe(builder.comment("Do players get xp for growing Plants? (Different from Harvest xp)").translation("pmmo.growingXpEnabledXpEnabled").define("growingXpEnabledXpEnabled", true));
            this.defaultTamingXp = subscriber.subscribe(builder.comment("How much xp should be awarded in Taming for Taming an animal? (Json Overrides this) (Set to 0 to disable default xp)").translation("pmmo.defaultTamingXp").defineInRange("defaultTamingXp", 0.0, 0.0, 1000000.0));
            builder.pop();
            builder.push("Easter Eggs");
            this.jesusXp = subscriber.subscribe(builder.comment("How much xp do you get for impersonating Jesus?").translation("pmmo.jesusXp").defineInRange("jesusXp", 0.075, 0.0, 1000000.0));
            builder.pop();
            builder.push("Auto Values");
            this.autoGenerateValuesEnabled = subscriber.subscribe(builder.comment("Automatically assign values for un-assigned items? (May be inaccurate)").translation("pmmo.autoGenerateValuesEnabled").define("autoGenerateValuesEnabled", true));
            this.autoGenerateExtraChanceEnabled = subscriber.subscribe(builder.comment("Automatically assign values for Extra Chance? (Works for Ores/Logs/Plants)").translation("pmmo.autoGenerateExtraChanceEnabled").define("autoGenerateExtraChanceEnabled", true));
            this.defaultExtraChanceOre = subscriber.subscribe(builder.comment("Valued used by autoGenerateExtraChanceEnabled, for Ores").translation("pmmo.defaultExtraChanceOre").defineInRange("defaultExtraChanceOre", 1.0, 0.0, 1000000.0));
            this.defaultExtraChanceLog = subscriber.subscribe(builder.comment("Valued used by autoGenerateExtraChanceEnabled, for Logs").translation("pmmo.defaultExtraChanceLog").defineInRange("defaultExtraChanceLog", 2.0, 0.0, 1000000.0));
            this.defaultExtraChancePlant = subscriber.subscribe(builder.comment("Valued used by autoGenerateExtraChanceEnabled, for Plants").translation("pmmo.defaultExtraChancePlant").defineInRange("defaultExtraChancePlant", 1.5, 0.0, 1000000.0));
            this.autoGenerateWearReqEnabled = subscriber.subscribe(builder.comment("Automatically assign values for Wear Requirement?").translation("pmmo.autoGenerateWearReqEnabled").define("autoGenerateWearReqEnabled", true));
            this.autoGenerateWeaponReqEnabled = subscriber.subscribe(builder.comment("Automatically assign values for Weapon Requirement?").translation("pmmo.autoGenerateWeaponReqEnabled").define("autoGenerateWeaponReqEnabled", true));
            this.autoGenerateToolReqEnabled = subscriber.subscribe(builder.comment("Automatically assign values for Tool Requirement?").translation("pmmo.autoGenerateToolReqEnabled").define("autoGenerateToolReqEnabled", true));
            this.autoGenerateCraftingXpEnabled = subscriber.subscribe(builder.comment("Automatically assign values for Crafting Experience? (Works for Armor/Tools/Weapons)").translation("pmmo.autoGenerateCraftingXpEnabled").define("autoGenerateCraftingXpEnabled", true));
            this.autoGeneratedCraftingXpValueMultiplierCrafting = subscriber.subscribe(builder.comment("Multiplier for the Auto Generated Crafting Xp Value, in the Crafting skill").translation("pmmo.autoGeneratedCraftingXpValueMultiplierCrafting").defineInRange("autoGeneratedCraftingXpValueMultiplierCrafting", 1.0, 0.0, 1000000.0));
            this.autoGeneratedCraftingXpValueMultiplierSmithing = subscriber.subscribe(builder.comment("Multiplier for the Auto Generated Crafting Xp Value, in the Smithing skill").translation("pmmo.autoGeneratedCraftingXpValueMultiplierSmithing").defineInRange("autoGeneratedCraftingXpValueMultiplierSmithing", 1.0, 0.0, 1000000.0));
            this.armorReqScale = subscriber.subscribe(builder.comment("How much the Armor value scales the Endurance Requirement for Armor").translation("pmmo.armorReqScale").defineInRange("armorReqScale", 4.0, 0.0, 1000000.0));
            this.armorToughnessReqScale = subscriber.subscribe(builder.comment("How much the Armor Toughness value scales the Endurance Requirement for Armor").translation("pmmo.armorToughnessReqScale").defineInRange("armorToughnessReqScale", 6.0, 0.0, 1000000.0));
            this.attackDamageReqScale = subscriber.subscribe(builder.comment("How much the Attack Damage values scales the Combat Requirement for Weapons").translation("pmmo.attackDamageReqScale").defineInRange("attackDamageReqScale", 4.0, 0.0, 1000000.0));
            this.toolReqScaleOre = subscriber.subscribe(builder.comment("How much the Speed of the tool scales the Requirement of Mining to Use the tool").translation("pmmo.toolReqScaleOre").defineInRange("toolReqScaleOre", 5.0, 0.0, 1000000.0));
            this.toolReqScaleLog = subscriber.subscribe(builder.comment("How much the Speed of the tool scales the Requirement of Woodcutting to Use the tool").translation("pmmo.toolReqScaleLog").defineInRange("toolReqScaleLog", 5.0, 0.0, 1000000.0));
            this.toolReqScaleDirt = subscriber.subscribe(builder.comment("How much the Speed of the tool scales the Requirement of Excavation to Use the tool").translation("pmmo.toolReqScaleDirt").defineInRange("toolReqScaleDirt", 5.0, 0.0, 1000000.0));
            builder.pop();
        }
    }
}

