/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.config;

import com.google.common.collect.Multimap;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import harmonised.pmmo.ProjectMMOMod;
import harmonised.pmmo.config.Config;
import harmonised.pmmo.config.JType;
import harmonised.pmmo.skills.Skill;
import harmonised.pmmo.util.XP;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.block.CropsBlock;
import net.minecraft.block.LogBlock;
import net.minecraft.block.OreBlock;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.potion.Effect;
import net.minecraft.potion.Potion;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JsonConfig {
    public static final Logger LOGGER = LogManager.getLogger();
    public static Gson gson = new Gson();
    public static final Type mapType = new TypeToken<Map<String, Map<String, Double>>>(){}.getType();
    public static final Type mapType2 = new TypeToken<Map<String, Map<String, Map<String, Double>>>>(){}.getType();
    public static Set<JType> jTypes;
    private static Map<JType, Map<String, Map<String, Double>>> rawData;
    private static Map<JType, Map<String, Map<String, Map<String, Double>>>> rawData2;
    public static Map<JType, Map<String, Map<String, Double>>> localData;
    public static Map<JType, Map<String, Map<String, Map<String, Double>>>> localData2;
    public static Map<JType, Map<String, Map<String, Double>>> data;
    public static Map<JType, Map<String, Map<String, Map<String, Double>>>> data2;
    private static final ArrayList<String> validAttributes;
    private static final ArrayList<String> validFishEnchantInfo;
    private static final String dataPath = "pmmo/";
    private static final String hardDataPath = "/assets/pmmo/util/";
    public static final Set<JType> jTypes2;

    public static void init() {
        jTypes2.add(JType.SALVAGE);
        jTypes2.add(JType.SALVAGE_FROM);
        jTypes2.add(JType.TREASURE);
        jTypes2.add(JType.TREASURE_FROM);
        validAttributes.add("speedBonus");
        validAttributes.add("hpBonus");
        validAttributes.add("damageBonus");
        JsonConfig.initMaps();
        JsonConfig.initJTypes();
        JsonConfig.initData();
        JsonConfig.readRawData();
        JsonConfig.processRawData();
        data = localData;
        data2 = localData2;
    }

    private static void initMaps() {
        JsonConfig.initMap(localData);
        JsonConfig.initMap(data);
        JsonConfig.initMap2(localData2);
        JsonConfig.initMap2(data2);
    }

    public static void initMap(Map<JType, Map<String, Map<String, Double>>> map) {
        for (Map.Entry<JType, Integer> entry : JType.jTypeMap.entrySet()) {
            if (jTypes2.contains((Object)entry.getKey())) continue;
            map.put(entry.getKey(), new HashMap());
        }
    }

    public static void initMap2(Map<JType, Map<String, Map<String, Map<String, Double>>>> map) {
        for (JType jType2 : jTypes2) {
            map.put(jType2, new HashMap());
        }
    }

    private static void initJTypes() {
        jTypes = new HashSet<JType>();
        if (Config.forgeConfig.wearReqEnabled.get().booleanValue()) {
            jTypes.add(JType.REQ_WEAR);
        }
        if (Config.forgeConfig.toolReqEnabled.get().booleanValue()) {
            jTypes.add(JType.REQ_TOOL);
        }
        if (Config.forgeConfig.weaponReqEnabled.get().booleanValue()) {
            jTypes.add(JType.REQ_WEAPON);
        }
        if (Config.forgeConfig.useReqEnabled.get().booleanValue()) {
            jTypes.add(JType.REQ_USE);
        }
        if (Config.forgeConfig.xpValueGeneralEnabled.get().booleanValue()) {
            jTypes.add(JType.XP_VALUE_GENERAL);
        }
        if (Config.forgeConfig.xpValueBreakingEnabled.get().booleanValue()) {
            jTypes.add(JType.XP_VALUE_BREAK);
        }
        if (Config.forgeConfig.xpValueCraftingEnabled.get().booleanValue()) {
            jTypes.add(JType.XP_VALUE_CRAFT);
        }
        if (Config.forgeConfig.xpValuePlacingEnabled.get().booleanValue()) {
            jTypes.add(JType.XP_VALUE_PLACE);
        }
        if (Config.forgeConfig.breedingXpEnabled.get().booleanValue()) {
            jTypes.add(JType.XP_VALUE_BREED);
        }
        if (Config.forgeConfig.tamingXpEnabled.get().booleanValue()) {
            jTypes.add(JType.XP_VALUE_TAME);
        }
        if (Config.forgeConfig.smeltingXpEnabled.get().booleanValue()) {
            jTypes.add(JType.XP_VALUE_SMELT);
        }
        if (Config.forgeConfig.cookingXpEnabled.get().booleanValue()) {
            jTypes.add(JType.XP_VALUE_COOK);
        }
        if (Config.forgeConfig.brewingXpEnabled.get().booleanValue()) {
            jTypes.add(JType.XP_VALUE_BREW);
        }
        if (Config.forgeConfig.growingXpEnabled.get().booleanValue()) {
            jTypes.add(JType.XP_VALUE_GROW);
        }
        if (Config.forgeConfig.placeReqEnabled.get().booleanValue()) {
            jTypes.add(JType.REQ_PLACE);
        }
        if (Config.forgeConfig.breakReqEnabled.get().booleanValue()) {
            jTypes.add(JType.REQ_BREAK);
        }
        if (Config.forgeConfig.biomeReqEnabled.get().booleanValue()) {
            jTypes.add(JType.REQ_BIOME);
        }
        if (Config.forgeConfig.negativeBiomeEffectEnabled.get().booleanValue()) {
            jTypes.add(JType.BIOME_EFFECT_NEGATIVE);
        }
        if (Config.forgeConfig.positiveBiomeEffectEnabled.get().booleanValue()) {
            jTypes.add(JType.BIOME_EFFECT_POSITIVE);
        }
        if (Config.forgeConfig.biomeXpBonusEnabled.get().booleanValue()) {
            jTypes.add(JType.XP_BONUS_BIOME);
        }
        if (Config.forgeConfig.biomeMobMultiplierEnabled.get().booleanValue()) {
            jTypes.add(JType.BIOME_MOB_MULTIPLIER);
        }
        if (Config.forgeConfig.oreEnabled.get().booleanValue()) {
            jTypes.add(JType.INFO_ORE);
        }
        if (Config.forgeConfig.logEnabled.get().booleanValue()) {
            jTypes.add(JType.INFO_LOG);
        }
        if (Config.forgeConfig.plantEnabled.get().booleanValue()) {
            jTypes.add(JType.INFO_PLANT);
        }
        if (Config.forgeConfig.smeltingEnabled.get().booleanValue()) {
            jTypes.add(JType.INFO_SMELT);
        }
        if (Config.forgeConfig.cookingEnabled.get().booleanValue()) {
            jTypes.add(JType.INFO_COOK);
        }
        if (Config.forgeConfig.brewingEnabled.get().booleanValue()) {
            jTypes.add(JType.INFO_BREW);
        }
        if (Config.forgeConfig.salvageEnabled.get().booleanValue()) {
            jTypes.add(JType.SALVAGE);
        }
        if (Config.forgeConfig.fishPoolEnabled.get().booleanValue()) {
            jTypes.add(JType.FISH_POOL);
        }
        if (Config.forgeConfig.fishEnchantPoolEnabled.get().booleanValue()) {
            jTypes.add(JType.FISH_ENCHANT_POOL);
        }
        if (Config.forgeConfig.killReqEnabled.get().booleanValue()) {
            jTypes.add(JType.REQ_KILL);
        }
        if (Config.forgeConfig.killXpEnabled.get().booleanValue()) {
            jTypes.add(JType.XP_VALUE_KILL);
        }
        if (Config.forgeConfig.mobRareDropEnabled.get().booleanValue()) {
            jTypes.add(JType.MOB_RARE_DROP);
        }
        if (Config.forgeConfig.levelUpCommandEnabled.get().booleanValue()) {
            jTypes.add(JType.LEVEL_UP_COMMAND);
        }
        if (Config.forgeConfig.heldItemXpBoostEnabled.get().booleanValue()) {
            jTypes.add(JType.XP_BONUS_HELD);
        }
        if (Config.forgeConfig.wornItemXpBoostEnabled.get().booleanValue()) {
            jTypes.add(JType.XP_BONUS_WORN);
        }
        if (Config.forgeConfig.craftReqEnabled.get().booleanValue()) {
            jTypes.add(JType.REQ_CRAFT);
        }
        if (Config.forgeConfig.treasureEnabled.get().booleanValue()) {
            jTypes.add(JType.TREASURE);
        }
        jTypes.add(JType.BLOCK_SPECIFIC);
        jTypes.add(JType.PLAYER_SPECIFIC);
        jTypes.add(JType.ITEM_SPECIFIC);
        jTypes.add(JType.VEIN_BLACKLIST);
        jTypes.add(JType.XP_VALUE_TRIGGER);
        jTypes.add(JType.XP_BONUS_DIMENSION);
        jTypes.add(JType.XP_MULTIPLIER_DIMENSION);
    }

    private static void initData() {
        for (JType jType : jTypes) {
            String fileName = jType.name().toLowerCase() + ".json";
            File dataFile = FMLPaths.CONFIGDIR.get().resolve(dataPath + fileName).toFile();
            if (dataFile.exists()) continue;
            JsonConfig.createData(dataFile, fileName);
        }
    }

    private static void readRawData() {
        rawData = new HashMap<JType, Map<String, Map<String, Double>>>();
        rawData2 = new HashMap<JType, Map<String, Map<String, Map<String, Double>>>>();
        for (JType jType : jTypes) {
            String fileName = jType.name().toLowerCase() + ".json";
            File file = FMLPaths.CONFIGDIR.get().resolve(dataPath + fileName).toFile();
            try {
                FileInputStream input = new FileInputStream(file.getPath());
                Throwable throwable = null;
                try {
                    BufferedReader reader = new BufferedReader(new InputStreamReader(input));
                    Throwable throwable2 = null;
                    try {
                        if (jTypes2.contains((Object)jType)) {
                            rawData2.put(jType, (Map<String, Map<String, Map<String, Double>>>)gson.fromJson((Reader)reader, mapType2));
                            continue;
                        }
                        rawData.put(jType, (Map<String, Map<String, Double>>)gson.fromJson((Reader)reader, mapType));
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (reader == null) continue;
                        if (throwable2 != null) {
                            try {
                                ((Reader)reader).close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        ((Reader)reader).close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (input == null) continue;
                    if (throwable != null) {
                        try {
                            ((InputStream)input).close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    ((InputStream)input).close();
                }
            }
            catch (Exception e) {
                LOGGER.error("ERROR READING PROJECT MMO CONFIG: Invalid JSON Structure of pmmo/" + fileName, (Throwable)e);
                if (jTypes2.contains((Object)jType)) {
                    rawData2.put(jType, new HashMap());
                    continue;
                }
                rawData.put(jType, new HashMap());
            }
        }
    }

    private static void processRawData() {
        if (jTypes.contains((Object)JType.REQ_WEAR)) {
            JsonConfig.updateDataSkills(JType.REQ_WEAR, false);
        }
        if (jTypes.contains((Object)JType.REQ_TOOL)) {
            JsonConfig.updateDataSkills(JType.REQ_TOOL, false);
        }
        if (jTypes.contains((Object)JType.REQ_WEAPON)) {
            JsonConfig.updateDataSkills(JType.REQ_WEAPON, false);
        }
        if (jTypes.contains((Object)JType.REQ_USE)) {
            JsonConfig.updateDataSkills(JType.REQ_USE, false);
        }
        if (jTypes.contains((Object)JType.REQ_PLACE)) {
            JsonConfig.updateDataSkills(JType.REQ_PLACE, false);
        }
        if (jTypes.contains((Object)JType.REQ_BREAK)) {
            JsonConfig.updateDataSkills(JType.REQ_BREAK, false);
        }
        if (jTypes.contains((Object)JType.REQ_BIOME)) {
            JsonConfig.updateDataSkills(JType.REQ_BIOME, false);
        }
        if (jTypes.contains((Object)JType.REQ_KILL)) {
            JsonConfig.updateDataSkills(JType.REQ_KILL, false);
        }
        if (jTypes.contains((Object)JType.REQ_CRAFT)) {
            JsonConfig.updateDataSkills(JType.REQ_CRAFT, false);
        }
        if (jTypes.contains((Object)JType.XP_VALUE_GENERAL)) {
            JsonConfig.updateDataSkills(JType.XP_VALUE_GENERAL, false);
        }
        if (jTypes.contains((Object)JType.XP_VALUE_BREAK)) {
            JsonConfig.updateDataSkills(JType.XP_VALUE_BREAK, false);
        }
        if (jTypes.contains((Object)JType.XP_VALUE_CRAFT)) {
            JsonConfig.updateDataSkills(JType.XP_VALUE_CRAFT, false);
        }
        if (jTypes.contains((Object)JType.XP_VALUE_PLACE)) {
            JsonConfig.updateDataSkills(JType.XP_VALUE_PLACE, false);
        }
        if (jTypes.contains((Object)JType.XP_VALUE_BREED)) {
            JsonConfig.updateDataSkills(JType.XP_VALUE_BREED, false);
        }
        if (jTypes.contains((Object)JType.XP_VALUE_TAME)) {
            JsonConfig.updateDataSkills(JType.XP_VALUE_TAME, false);
        }
        if (jTypes.contains((Object)JType.XP_VALUE_SMELT)) {
            JsonConfig.updateDataSkills(JType.XP_VALUE_SMELT, false);
        }
        if (jTypes.contains((Object)JType.XP_VALUE_COOK)) {
            JsonConfig.updateDataSkills(JType.XP_VALUE_COOK, false);
        }
        if (jTypes.contains((Object)JType.XP_VALUE_KILL)) {
            JsonConfig.updateDataSkills(JType.XP_VALUE_KILL, false);
        }
        if (jTypes.contains((Object)JType.XP_VALUE_BREW)) {
            JsonConfig.updateDataSkills(JType.XP_VALUE_BREW, false);
        }
        if (jTypes.contains((Object)JType.XP_VALUE_GROW)) {
            JsonConfig.updateDataSkills(JType.XP_VALUE_GROW, false);
        }
        if (jTypes.contains((Object)JType.XP_VALUE_TRIGGER)) {
            JsonConfig.updateDataSkills(JType.XP_VALUE_TRIGGER, true);
        }
        if (jTypes.contains((Object)JType.INFO_ORE)) {
            JsonConfig.updateDataExtra(rawData.get((Object)JType.INFO_ORE), localData.get((Object)JType.INFO_ORE));
        }
        if (jTypes.contains((Object)JType.INFO_LOG)) {
            JsonConfig.updateDataExtra(rawData.get((Object)JType.INFO_LOG), localData.get((Object)JType.INFO_LOG));
        }
        if (jTypes.contains((Object)JType.INFO_PLANT)) {
            JsonConfig.updateDataExtra(rawData.get((Object)JType.INFO_PLANT), localData.get((Object)JType.INFO_PLANT));
        }
        if (jTypes.contains((Object)JType.INFO_SMELT)) {
            JsonConfig.updateDataExtra(rawData.get((Object)JType.INFO_SMELT), localData.get((Object)JType.INFO_SMELT));
        }
        if (jTypes.contains((Object)JType.INFO_COOK)) {
            JsonConfig.updateDataExtra(rawData.get((Object)JType.INFO_COOK), localData.get((Object)JType.INFO_COOK));
        }
        if (jTypes.contains((Object)JType.INFO_BREW)) {
            JsonConfig.updateDataExtra(rawData.get((Object)JType.INFO_BREW), localData.get((Object)JType.INFO_BREW));
        }
        if (jTypes.contains((Object)JType.BIOME_EFFECT_NEGATIVE)) {
            JsonConfig.updateDataEffects(rawData.get((Object)JType.BIOME_EFFECT_NEGATIVE), localData.get((Object)JType.BIOME_EFFECT_NEGATIVE));
        }
        if (jTypes.contains((Object)JType.BIOME_EFFECT_POSITIVE)) {
            JsonConfig.updateDataEffects(rawData.get((Object)JType.BIOME_EFFECT_POSITIVE), localData.get((Object)JType.BIOME_EFFECT_POSITIVE));
        }
        if (jTypes.contains((Object)JType.BIOME_MOB_MULTIPLIER)) {
            JsonConfig.updateDataAttributes(rawData.get((Object)JType.BIOME_MOB_MULTIPLIER), localData.get((Object)JType.BIOME_MOB_MULTIPLIER));
        }
        if (jTypes.contains((Object)JType.XP_BONUS_BIOME)) {
            JsonConfig.updateDataSkills(JType.XP_BONUS_BIOME, false);
        }
        if (jTypes.contains((Object)JType.XP_BONUS_HELD)) {
            JsonConfig.updateDataSkills(JType.XP_BONUS_HELD, false);
        }
        if (jTypes.contains((Object)JType.XP_BONUS_WORN)) {
            JsonConfig.updateDataSkills(JType.XP_BONUS_WORN, false);
        }
        if (jTypes.contains((Object)JType.SALVAGE)) {
            JsonConfig.updateDataSalvage(rawData2.get((Object)JType.SALVAGE), localData2.get((Object)JType.SALVAGE));
        }
        if (jTypes.contains((Object)JType.FISH_POOL)) {
            JsonConfig.updateDataFishPool(rawData.get((Object)JType.FISH_POOL), localData.get((Object)JType.FISH_POOL));
        }
        if (jTypes.contains((Object)JType.FISH_ENCHANT_POOL)) {
            JsonConfig.updateDataFishEnchantPool(rawData.get((Object)JType.FISH_ENCHANT_POOL), localData.get((Object)JType.FISH_ENCHANT_POOL));
        }
        if (jTypes.contains((Object)JType.MOB_RARE_DROP)) {
            JsonConfig.updateDataEntityItem(rawData.get((Object)JType.MOB_RARE_DROP), localData.get((Object)JType.MOB_RARE_DROP));
        }
        if (jTypes.contains((Object)JType.LEVEL_UP_COMMAND)) {
            JsonConfig.updateDataCommand(rawData.get((Object)JType.LEVEL_UP_COMMAND), localData.get((Object)JType.LEVEL_UP_COMMAND));
        }
        if (jTypes.contains((Object)JType.TREASURE)) {
            JsonConfig.updateDataTreasure(rawData2.get((Object)JType.TREASURE), localData2.get((Object)JType.TREASURE));
        }
        if (jTypes.contains((Object)JType.BLOCK_SPECIFIC)) {
            JsonConfig.updateDataSpecific(rawData.get((Object)JType.BLOCK_SPECIFIC), localData.get((Object)JType.BLOCK_SPECIFIC));
        }
        if (jTypes.contains((Object)JType.PLAYER_SPECIFIC)) {
            JsonConfig.updateDataSpecific(rawData.get((Object)JType.PLAYER_SPECIFIC), localData.get((Object)JType.PLAYER_SPECIFIC));
        }
        if (jTypes.contains((Object)JType.ITEM_SPECIFIC)) {
            JsonConfig.updateDataSpecific(rawData.get((Object)JType.ITEM_SPECIFIC), localData.get((Object)JType.ITEM_SPECIFIC));
        }
        if (jTypes.contains((Object)JType.VEIN_BLACKLIST)) {
            JsonConfig.updateDataVein(rawData.get((Object)JType.VEIN_BLACKLIST), localData.get((Object)JType.VEIN_BLACKLIST));
        }
        if (jTypes.contains((Object)JType.XP_BONUS_DIMENSION)) {
            JsonConfig.updateDataSkills(JType.XP_BONUS_DIMENSION, true);
        }
        if (jTypes.contains((Object)JType.XP_MULTIPLIER_DIMENSION)) {
            JsonConfig.updateDataSkills(JType.XP_MULTIPLIER_DIMENSION, true);
        }
    }

    private static void createData(File dataFile, String fileName) {
        try {
            dataFile.getParentFile().mkdir();
            dataFile.createNewFile();
        }
        catch (IOException e) {
            LOGGER.error("Could not create template json config!", (Object)dataFile.getPath(), (Object)e);
        }
        try (InputStream inputStream = ProjectMMOMod.class.getResourceAsStream(hardDataPath + fileName);
             FileOutputStream outputStream = new FileOutputStream(dataFile);){
            LOGGER.debug("Copying over " + fileName + " json config to " + dataFile.getPath(), (Object)dataFile.getPath());
            IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
        }
        catch (IOException e) {
            LOGGER.error("Error copying over " + fileName + " json config to " + dataFile.getPath(), (Object)dataFile.getPath(), (Object)e);
        }
    }

    private static boolean checkValidSkills(Map<String, Double> theMap) {
        boolean anyValidSkills = false;
        for (String key : theMap.keySet()) {
            if (Skill.getInt(key) != 0) {
                anyValidSkills = true;
                continue;
            }
            LOGGER.debug("Invalid skill " + key + " level " + theMap.get(key));
        }
        return anyValidSkills;
    }

    private static boolean checkValidEffects(Map<String, Double> theMap) {
        boolean anyValidEffects = false;
        for (String key : theMap.keySet()) {
            Effect effect = (Effect)ForgeRegistries.POTIONS.getValue(XP.getResLoc(key));
            if (effect != null) {
                anyValidEffects = true;
                continue;
            }
            LOGGER.debug("Invalid effect " + key);
        }
        return anyValidEffects;
    }

    private static void updateDataSkills(JType jType, boolean ignoreValidCheck) {
        Map<String, Map<String, Double>> input = rawData.get((Object)jType);
        Map<String, Map<String, Double>> output = localData.get((Object)jType);
        LOGGER.debug("Processing PMMO Data: Skills, Type: " + (Object)((Object)jType));
        for (Map.Entry<String, Map<String, Double>> element : input.entrySet()) {
            if (ignoreValidCheck || !XP.getItem(element.getKey()).equals(Items.field_190931_a) || JsonConfig.validEntity(element.getKey()) || JsonConfig.validBiome(element.getKey())) {
                if (JsonConfig.checkValidSkills(element.getValue())) {
                    if (!output.containsKey(element.getKey())) {
                        output.put(element.getKey(), new HashMap());
                    }
                    for (Map.Entry<String, Double> entry : element.getValue().entrySet()) {
                        if (Skill.getInt(entry.getKey()) != 0) {
                            output.get(element.getKey()).put(entry.getKey(), entry.getValue());
                            continue;
                        }
                        LOGGER.debug(entry.getKey() + " is either not a valid skill, or not 1 or above!");
                    }
                    continue;
                }
                LOGGER.debug("No valid skills, cannot add " + element.getKey());
                continue;
            }
            LOGGER.debug("Inexistant key, cannot add " + element.getKey());
        }
    }

    private static void updateDataEffects(Map<String, Map<String, Double>> input, Map<String, Map<String, Double>> output) {
        for (Map.Entry<String, Map<String, Double>> element : input.entrySet()) {
            if (JsonConfig.checkValidEffects(element.getValue())) {
                if (!output.containsKey(element.getKey())) {
                    output.put(element.getKey(), new HashMap());
                }
                for (Map.Entry<String, Double> entry : element.getValue().entrySet()) {
                    Potion potion = (Potion)ForgeRegistries.POTION_TYPES.getValue(XP.getResLoc(entry.getKey()));
                    if (potion != null && entry.getValue() >= 0.0 && entry.getValue() < 255.0) {
                        output.get(element.getKey()).put(entry.getKey(), entry.getValue());
                        continue;
                    }
                    LOGGER.debug(entry.getKey() + " is either not a effect skill, or below 0, or above 255!");
                }
                continue;
            }
            LOGGER.debug("No valid effects, cannot add " + element.getKey());
        }
    }

    private static void updateDataExtra(Map<String, Map<String, Double>> input, Map<String, Map<String, Double>> output) {
        for (Map.Entry<String, Map<String, Double>> element : input.entrySet()) {
            if (!XP.getItem(element.getKey()).equals(Items.field_190931_a)) {
                if (!output.containsKey(element.getKey())) {
                    output.put(element.getKey(), new HashMap());
                }
                for (Map.Entry<String, Double> entry : element.getValue().entrySet()) {
                    if (entry.getKey().equals("extraChance") && entry.getValue() > 0.0) {
                        output.get(element.getKey()).put(entry.getKey(), entry.getValue());
                        continue;
                    }
                    LOGGER.debug(element.getKey() + " is either not \"extraChance\", or not above 0!");
                }
                continue;
            }
            LOGGER.debug("Could not load inexistant item " + element.getKey());
        }
    }

    private static void updateDataVein(Map<String, Map<String, Double>> input, Map<String, Map<String, Double>> output) {
        for (Map.Entry<String, Map<String, Double>> element : input.entrySet()) {
            Map<String, Double> inMap = element.getValue();
            if (!output.containsKey(element.getKey())) {
                output.put(element.getKey(), new HashMap());
            }
            for (Map.Entry<String, Double> entry : inMap.entrySet()) {
                if (XP.getItem(entry.getKey()).equals(Items.field_190931_a)) {
                    LOGGER.debug("Could not load inexistant item " + entry.getKey() + " into Vein Blacklist");
                    continue;
                }
                output.get(element.getKey()).put(entry.getKey(), entry.getValue());
            }
        }
    }

    private static void updateDataEntityItem(Map<String, Map<String, Double>> input, Map<String, Map<String, Double>> output) {
        for (Map.Entry<String, Map<String, Double>> element : input.entrySet()) {
            output.put(element.getKey(), new HashMap());
            for (Map.Entry<String, Double> entry : element.getValue().entrySet()) {
                if (!XP.getItem(entry.getKey()).equals(Items.field_190931_a)) {
                    output.get(element.getKey()).put(entry.getKey(), entry.getValue());
                    continue;
                }
                LOGGER.debug("Could not load inexistant item " + element.getKey());
            }
        }
    }

    private static void updateDataFishPool(Map<String, Map<String, Double>> input, Map<String, Map<String, Double>> output) {
        for (Map.Entry<String, Map<String, Double>> element : input.entrySet()) {
            Item item = XP.getItem(element.getKey());
            if (!item.equals(Items.field_190931_a)) {
                Map<String, Double> inMap = element.getValue();
                if (!inMap.containsKey("startWeight")) {
                    LOGGER.debug("Error loading Fish Pool Item " + element.getKey() + " \"startWeight\" is invalid, loading default value 1");
                    inMap.put("startWeight", 1.0);
                }
                if (!inMap.containsKey("startLevel")) {
                    LOGGER.debug("Error loading Fish Pool Item " + element.getKey() + " \"startLevel\" is invalid, loading default value level 1");
                    inMap.put("startLevel", 1.0);
                }
                if (!inMap.containsKey("endWeight")) {
                    LOGGER.debug("Error loading Fish Pool Item " + element.getKey() + " \"endWeight\" is invalid, loading default value 1");
                    inMap.put("endWeight", 1.0);
                }
                if (!inMap.containsKey("endLevel")) {
                    LOGGER.debug("Error loading Fish Pool Item " + element.getKey() + " \"endLevel\" is invalid, loading default value level 1");
                    inMap.put("endLevel", 1.0);
                }
                if (!inMap.containsKey("minCount")) {
                    inMap.put("minCount", 1.0);
                } else if (inMap.get("minCount") > (double)item.func_77639_j()) {
                    LOGGER.debug("Error loading Fish Pool Item " + element.getKey() + " \"minCount\" is above Max Stack Size, loading default value 1 item");
                    inMap.put("minCount", Double.valueOf(item.func_77639_j()));
                }
                if (!inMap.containsKey("maxCount")) {
                    inMap.put("maxCount", 1.0);
                } else if (inMap.get("maxCount") > (double)item.func_77639_j()) {
                    LOGGER.debug("Error loading Fish Pool Item " + element.getKey() + " \"maxCount\" is above Max Stack Size, loading default value 1 item");
                    inMap.put("maxCount", Double.valueOf(item.func_77639_j()));
                }
                if (!inMap.containsKey("enchantLevelReq")) {
                    LOGGER.debug("Error loading Fish Pool Item " + element.getKey() + " \"enchantLevelReq\" is invalid, loading default value level 1");
                    inMap.put("enchantLevelReq", 1.0);
                }
                if (!inMap.containsKey("xp")) {
                    LOGGER.debug("Error loading Fish Pool Item " + element.getKey() + " \"xp\" is invalid, loading default value 1xp");
                    inMap.put("xp", 1.0);
                }
                if (!output.containsKey(element.getKey())) {
                    output.put(element.getKey(), new HashMap());
                }
                Map<String, Double> outMap = output.get(element.getKey());
                double startWeight = inMap.get("startWeight");
                double startLevel = inMap.get("startLevel");
                double endWeight = inMap.get("endWeight");
                double endLevel = inMap.get("endLevel");
                double minCount = inMap.get("minCount");
                double maxCount = inMap.get("maxCount");
                double enchantLevelReq = inMap.get("enchantLevelReq");
                double xp = inMap.get("xp");
                if (endWeight < 0.0) {
                    outMap.put("endWeight", 0.0);
                } else {
                    outMap.put("endWeight", endWeight);
                }
                if (startWeight > endWeight) {
                    startWeight = endWeight;
                }
                if (startWeight < 0.0) {
                    outMap.put("startWeight", 0.0);
                } else {
                    outMap.put("startWeight", startWeight);
                }
                if (endLevel < 1.0) {
                    outMap.put("endLevel", 1.0);
                } else {
                    outMap.put("endLevel", endLevel);
                }
                if (startLevel > endLevel) {
                    startLevel = endLevel;
                }
                if (startLevel < 1.0) {
                    outMap.put("startLevel", 1.0);
                } else {
                    outMap.put("startLevel", startLevel);
                }
                if (maxCount < 1.0) {
                    outMap.put("maxCount", 1.0);
                } else {
                    outMap.put("maxCount", maxCount);
                }
                if (minCount > maxCount) {
                    minCount = maxCount;
                }
                if (minCount < 1.0) {
                    outMap.put("minCount", 1.0);
                } else {
                    outMap.put("minCount", minCount);
                }
                if (enchantLevelReq < 1.0) {
                    outMap.put("enchantLevelReq", 1.0);
                } else {
                    outMap.put("enchantLevelReq", enchantLevelReq);
                }
                if (xp < 0.0) {
                    outMap.put("xp", 0.0);
                    continue;
                }
                outMap.put("xp", xp);
                continue;
            }
            LOGGER.debug("Could not load inexistant item " + element.getKey());
        }
    }

    private static void updateDataFishEnchantPool(Map<String, Map<String, Double>> input, Map<String, Map<String, Double>> output) {
        for (Map.Entry<String, Map<String, Double>> element : input.entrySet()) {
            Enchantment enchant = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(XP.getResLoc(element.getKey()));
            if (enchant != null) {
                Map<String, Double> inMap = element.getValue();
                if (!inMap.containsKey("levelReq")) {
                    LOGGER.debug("Error loading Fish Enchant Pool Item " + element.getKey() + " \"levelReq\" is invalid, loading default value 1");
                    inMap.put("levelReq", 1.0);
                }
                if (!inMap.containsKey("levelPerLevel")) {
                    LOGGER.debug("Error loading Fish Enchant Pool Item " + element.getKey() + " \"levelPerLevel\" is invalid, loading default value 0");
                    inMap.put("levelPerLevel", 0.0);
                }
                if (!inMap.containsKey("chancePerLevel")) {
                    LOGGER.debug("Error loading Fish Enchant Pool Item " + element.getKey() + " \"chancePerLevel\" is invalid, loading default value 0");
                    inMap.put("chancePerLevel", 0.0);
                }
                if (!inMap.containsKey("maxChance")) {
                    LOGGER.debug("Error loading Fish Enchant Pool Item " + element.getKey() + " \"maxChance\" is invalid, loading default value 80%");
                    inMap.put("maxChance", 80.0);
                }
                if (!inMap.containsKey("maxLevel")) {
                    LOGGER.debug("Error loading Fish Enchant Pool Item " + element.getKey() + " \"maxLevel\" is invalid, loading default value " + enchant.func_77325_b());
                    inMap.put("maxLevel", Double.valueOf(enchant.func_77325_b()));
                }
                if (!output.containsKey(element.getKey())) {
                    output.put(element.getKey(), new HashMap());
                }
                Map<String, Double> outMap = output.get(element.getKey());
                double levelReq = inMap.get("levelReq");
                double levelPerLevel = inMap.get("levelPerLevel");
                double chancePerLevel = inMap.get("chancePerLevel");
                double maxChance = inMap.get("maxChance");
                double maxLevel = inMap.get("maxLevel");
                if (levelReq < 1.0) {
                    outMap.put("levelReq", 1.0);
                } else {
                    outMap.put("levelReq", levelReq);
                }
                if (levelPerLevel < 0.0) {
                    outMap.put("levelPerLevel", 0.0);
                } else {
                    outMap.put("levelPerLevel", levelPerLevel);
                }
                if (chancePerLevel < 0.0) {
                    outMap.put("chancePerLevel", 0.0);
                } else {
                    outMap.put("chancePerLevel", chancePerLevel);
                }
                if (maxChance < 0.0) {
                    outMap.put("maxChance", 0.0);
                } else if (maxChance > 100.0) {
                    outMap.put("maxChance", 100.0);
                } else {
                    outMap.put("maxChance", maxChance);
                }
                if (maxLevel < 1.0) {
                    outMap.put("maxLevel", Double.valueOf(enchant.func_77325_b()));
                    continue;
                }
                outMap.put("maxLevel", maxLevel);
                continue;
            }
            LOGGER.debug("Could not load inexistant enchant " + element.getKey());
        }
    }

    private static void updateDataAttributes(Map<String, Map<String, Double>> input, Map<String, Map<String, Double>> output) {
        for (Map.Entry<String, Map<String, Double>> element : input.entrySet()) {
            if (JsonConfig.checkValidAttributes(element.getValue())) {
                if (!output.containsKey(element.getKey())) {
                    output.put(element.getKey(), new HashMap());
                }
                for (Map.Entry<String, Double> entry : element.getValue().entrySet()) {
                    if (validAttributes.contains(entry.getKey())) {
                        output.get(element.getKey()).put(entry.getKey(), entry.getValue());
                        continue;
                    }
                    LOGGER.debug("Invalid attribute " + entry.getKey());
                }
                continue;
            }
            LOGGER.debug("No valid attributes, cannot add " + element.getKey());
        }
    }

    private static void updateDataCommand(Map<String, Map<String, Double>> input, Map<String, Map<String, Double>> output) {
        for (Map.Entry<String, Map<String, Double>> element : input.entrySet()) {
            if (Skill.getInt(element.getKey()) != 0) {
                if (!output.containsKey(element.getKey())) {
                    output.put(element.getKey(), new HashMap());
                }
                for (Map.Entry<String, Double> entry : element.getValue().entrySet()) {
                    if (entry.getValue() >= 1.0) {
                        output.get(element.getKey()).put(entry.getKey(), entry.getValue());
                        continue;
                    }
                    output.get(element.getKey()).put(entry.getKey(), 1.0);
                }
                continue;
            }
            LOGGER.debug("Invalid skill \"" + element.getKey() + "\" in Level Up Command");
        }
    }

    private static void updateDataSpecific(Map<String, Map<String, Double>> input, Map<String, Map<String, Double>> output) {
        for (Map.Entry<String, Map<String, Double>> element : input.entrySet()) {
            if (!output.containsKey(element.getKey())) {
                output.put(element.getKey(), new HashMap());
            }
            for (Map.Entry<String, Double> entry : element.getValue().entrySet()) {
                output.get(element.getKey()).put(entry.getKey(), entry.getValue());
            }
        }
    }

    private static boolean checkValidAttributes(Map<String, Double> theMap) {
        boolean anyValidAttributes = false;
        for (String key : theMap.keySet()) {
            if (validAttributes.contains(key)) {
                anyValidAttributes = true;
                continue;
            }
            LOGGER.debug("Invalid attribute " + key);
        }
        return anyValidAttributes;
    }

    private static void updateDataTreasure(Map<String, Map<String, Map<String, Double>>> input, Map<String, Map<String, Map<String, Double>>> output) {
        for (Map.Entry<String, Map<String, Map<String, Double>>> blockEntry : input.entrySet()) {
            ResourceLocation blockResLoc = XP.getResLoc(blockEntry.getKey());
            if (ForgeRegistries.BLOCKS.containsKey(blockResLoc)) {
                output.put(blockEntry.getKey(), new HashMap());
                Map<String, Map<String, Double>> outputBlockMap = output.get(blockEntry.getKey());
                for (Map.Entry<String, Map<String, Double>> itemEntry : blockEntry.getValue().entrySet()) {
                    Item item = XP.getItem(itemEntry.getKey());
                    if (!item.equals(Items.field_190931_a)) {
                        String itemResLoc = item.getRegistryName().toString();
                        Map<String, Double> inputItemMap = itemEntry.getValue();
                        if (!inputItemMap.containsKey("startChance")) {
                            LOGGER.debug("Invalid or Missing startChance Block:" + blockEntry.getKey() + ", Item: " + itemEntry.getKey() + " in Treasure. Loading Default Value 0.1");
                            inputItemMap.put("startChance", 0.1);
                        }
                        if (!inputItemMap.containsKey("endChance")) {
                            LOGGER.debug("Invalid or Missing endChance Block:" + blockEntry.getKey() + ", Item: " + itemEntry.getKey() + " in Treasure. Loading Default Value 1");
                            inputItemMap.put("endChance", 1.0);
                        }
                        if (!inputItemMap.containsKey("startLevel")) {
                            LOGGER.debug("Invalid or Missing startLevel Block:" + blockEntry.getKey() + ", Item: " + itemEntry.getKey() + " in Treasure. Loading Default Value 1");
                            inputItemMap.put("startLevel", 1.0);
                        }
                        if (!inputItemMap.containsKey("endLevel")) {
                            LOGGER.debug("Invalid or Missing endLevel Block:" + blockEntry.getKey() + ", Item: " + itemEntry.getKey() + " in Treasure. Loading Default Value 100");
                            inputItemMap.put("endLevel", 100.0);
                        }
                        if (!inputItemMap.containsKey("minCount")) {
                            LOGGER.debug("Invalid or Missing minCount Block:" + blockEntry.getKey() + ", Item: " + itemEntry.getKey() + " in Treasure. Loading Default Value 1");
                            inputItemMap.put("minCount", 1.0);
                        }
                        if (!inputItemMap.containsKey("maxCount")) {
                            LOGGER.debug("Invalid or Missing maxCount Block:" + blockEntry.getKey() + ", Item: " + itemEntry.getKey() + " in Treasure. Loading Default Value 1");
                            inputItemMap.put("maxCount", 1.0);
                        }
                        if (!inputItemMap.containsKey("xpPerItem")) {
                            LOGGER.debug("Invalid or Missing xpPerItem Block:" + blockEntry.getKey() + ", Item: " + itemEntry.getKey() + " in Treasure. Loading Default Value 1");
                            inputItemMap.put("xpPerItem", 1.0);
                        }
                        HashMap<String, Double> outputItemMap = new HashMap<String, Double>();
                        double startChance = inputItemMap.get("startChance");
                        double endChance = inputItemMap.get("endChance");
                        double startLevel = inputItemMap.get("startLevel");
                        double endLevel = inputItemMap.get("endLevel");
                        int minCount = (int)Math.floor(inputItemMap.get("minCount"));
                        int maxCount = (int)Math.floor(inputItemMap.get("maxCount"));
                        double xpPerItem = inputItemMap.get("xpPerItem");
                        outputItemMap.put("startChance", startChance);
                        outputItemMap.put("endChance", endChance);
                        outputItemMap.put("startLevel", startLevel);
                        outputItemMap.put("endLevel", endLevel);
                        outputItemMap.put("minCount", Double.valueOf(minCount));
                        outputItemMap.put("maxCount", Double.valueOf(maxCount));
                        outputItemMap.put("xpPerItem", xpPerItem);
                        outputBlockMap.put(itemEntry.getKey(), outputItemMap);
                        Map<String, Map<String, Map<String, Double>>> localSalvagesFrom = localData2.get((Object)JType.TREASURE_FROM);
                        if (!localSalvagesFrom.containsKey(itemResLoc)) {
                            localSalvagesFrom.put(itemResLoc, new HashMap());
                        }
                        localSalvagesFrom.get(itemResLoc).put(blockResLoc.toString(), outputItemMap);
                        continue;
                    }
                    LOGGER.debug("Inexistant Item " + itemEntry.getKey() + " in Treasure");
                }
                continue;
            }
            LOGGER.debug("Inexistant Block " + blockEntry.getKey() + " in Treasure");
        }
    }

    private static void updateDataSalvage(Map<String, Map<String, Map<String, Double>>> input, Map<String, Map<String, Map<String, Double>>> output) {
        for (Map.Entry<String, Map<String, Map<String, Double>>> inputSalvageFromItemEntry : input.entrySet()) {
            ResourceLocation salvageFromItemResLoc = XP.getResLoc(inputSalvageFromItemEntry.getKey());
            if (!XP.getItem(salvageFromItemResLoc).equals(Items.field_190931_a)) {
                output.put(salvageFromItemResLoc.toString(), new HashMap());
                Map<String, Map<String, Double>> outputSalvageFromItemMap = output.get(salvageFromItemResLoc.toString());
                for (Map.Entry<String, Map<String, Double>> inputSalvageToItemEntry : inputSalvageFromItemEntry.getValue().entrySet()) {
                    Item item = XP.getItem(inputSalvageToItemEntry.getKey());
                    String salvageToItemResLoc = item.getRegistryName().toString();
                    if (!item.equals(Items.field_190931_a)) {
                        Map<String, Double> salvageToItemMap = inputSalvageToItemEntry.getValue();
                        if (!salvageToItemMap.containsKey("salvageMax")) {
                            LOGGER.debug("Error loading Salvage Item " + inputSalvageToItemEntry.getKey() + " \"salvageMax\" is invalid, loading default value 1 item");
                            salvageToItemMap.put("salvageMax", 1.0);
                        }
                        if (!salvageToItemMap.containsKey("baseChance")) {
                            LOGGER.debug("Error loading Salvage Item " + inputSalvageToItemEntry.getKey() + " \"baseChance\" is invalid, loading default value 50%");
                            salvageToItemMap.put("baseChance", 50.0);
                        }
                        if (!salvageToItemMap.containsKey("chancePerLevel")) {
                            LOGGER.debug("Error loading Salvage Item " + inputSalvageToItemEntry.getKey() + " \"chancePerLevel\" is invalid, loading default value 0%");
                            salvageToItemMap.put("chancePerLevel", 0.0);
                        }
                        if (!salvageToItemMap.containsKey("maxChance")) {
                            LOGGER.debug("Error loading Salvage Item " + inputSalvageToItemEntry.getKey() + " \"maxChance\" is invalid, loading default value 80%");
                            salvageToItemMap.put("maxChance", 80.0);
                        }
                        if (!salvageToItemMap.containsKey("xpPerItem")) {
                            LOGGER.debug("Error loading Salvage Item " + inputSalvageToItemEntry.getKey() + " \"xpPerItem\" is invalid, loading default value 0xp");
                            salvageToItemMap.put("xpPerItem", 0.0);
                        }
                        if (!salvageToItemMap.containsKey("levelReq")) {
                            LOGGER.debug("Error loading Salvage Item " + inputSalvageToItemEntry.getKey() + " \"levelReq\" is invalid, loading default value 1 level");
                            salvageToItemMap.put("levelReq", 1.0);
                        }
                        if (!outputSalvageFromItemMap.containsKey(inputSalvageToItemEntry.getKey())) {
                            outputSalvageFromItemMap.put(inputSalvageToItemEntry.getKey(), new HashMap());
                        }
                        Map<String, Double> outMap = outputSalvageFromItemMap.get(inputSalvageToItemEntry.getKey());
                        double salvageMax = salvageToItemMap.get("salvageMax");
                        double levelReq = salvageToItemMap.get("levelReq");
                        double xpPerItem = salvageToItemMap.get("xpPerItem");
                        double baseChance = salvageToItemMap.get("baseChance");
                        double chancePerLevel = salvageToItemMap.get("chancePerLevel");
                        double maxChance = salvageToItemMap.get("maxChance");
                        if (salvageMax < 1.0) {
                            outMap.put("salvageMax", 1.0);
                        } else {
                            outMap.put("salvageMax", salvageMax);
                        }
                        if (levelReq < 1.0) {
                            outMap.put("levelReq", 1.0);
                        } else {
                            outMap.put("levelReq", levelReq);
                        }
                        if (xpPerItem < 0.0) {
                            outMap.put("xpPerItem", 0.0);
                        } else {
                            outMap.put("xpPerItem", xpPerItem);
                        }
                        if (baseChance < 0.0) {
                            outMap.put("baseChance", 0.0);
                        } else if (baseChance > 100.0) {
                            outMap.put("baseChance", 100.0);
                        } else {
                            outMap.put("baseChance", baseChance);
                        }
                        if (chancePerLevel < 0.0) {
                            outMap.put("chancePerLevel", 0.0);
                        } else if (chancePerLevel > 100.0) {
                            outMap.put("chancePerLevel", 100.0);
                        } else {
                            outMap.put("chancePerLevel", chancePerLevel);
                        }
                        if (maxChance < 0.0) {
                            outMap.put("maxChance", 0.0);
                        } else if (maxChance > 100.0) {
                            outMap.put("maxChance", 100.0);
                        } else {
                            outMap.put("maxChance", maxChance);
                        }
                        Map<String, Map<String, Map<String, Double>>> localSalvagesFrom = localData2.get((Object)JType.SALVAGE_FROM);
                        if (!localSalvagesFrom.containsKey(salvageToItemResLoc)) {
                            localSalvagesFrom.put(salvageToItemResLoc, new HashMap());
                        }
                        localSalvagesFrom.get(salvageToItemResLoc).put(salvageFromItemResLoc.toString(), outMap);
                        continue;
                    }
                    LOGGER.debug("Inexistant To Item " + inputSalvageToItemEntry.getKey() + " in Salvage");
                }
                continue;
            }
            LOGGER.debug("Inexistant From Item " + inputSalvageFromItemEntry.getKey() + " in Salvage");
        }
    }

    public static boolean validEntity(String regKey) {
        return ForgeRegistries.ENTITIES.containsKey(XP.getResLoc(regKey));
    }

    public static boolean validBiome(String regKey) {
        return ForgeRegistries.BIOMES.containsKey(XP.getResLoc(regKey));
    }

    private static Map<String, AttributeModifier> mergeMultimaps(Multimap<String, AttributeModifier> ... maps) {
        HashMap<String, AttributeModifier> output = new HashMap<String, AttributeModifier>();
        for (Multimap<String, AttributeModifier> map : maps) {
            for (Map.Entry entry : map.entries()) {
                output.put((String)entry.getKey(), (AttributeModifier)entry.getValue());
            }
        }
        return output;
    }

    private static void addJsonConfigValue(String resLoc, JType jType, Map<String, Double> values, boolean fillIfExists) {
        boolean hadEntry = localData.get((Object)jType).containsKey(resLoc);
        if (!hadEntry) {
            localData.get((Object)jType).put(resLoc, new HashMap());
        }
        if (!hadEntry || fillIfExists) {
            for (Map.Entry<String, Double> entry : values.entrySet()) {
                if (localData.get((Object)jType).get(resLoc).containsKey(entry.getKey())) continue;
                localData.get((Object)jType).get(resLoc).put(entry.getKey(), entry.getValue());
            }
        }
    }

    public static void setAutoValues() {
        if (Config.forgeConfig.autoGenerateValuesEnabled.get().booleanValue()) {
            for (Item item : ForgeRegistries.ITEMS) {
                try {
                    ItemStack itemStack = new ItemStack((IItemProvider)item);
                    String resLoc = item.getRegistryName().toString();
                    Set toolTypes = itemStack.getToolTypes();
                    Multimap mainHandAttributes = itemStack.func_111283_C(EquipmentSlotType.MAINHAND);
                    Multimap offHandAttributes = itemStack.func_111283_C(EquipmentSlotType.OFFHAND);
                    Multimap headHandAttributes = itemStack.func_111283_C(EquipmentSlotType.HEAD);
                    Multimap chestHandAttributes = itemStack.func_111283_C(EquipmentSlotType.CHEST);
                    Multimap legsHandAttributes = itemStack.func_111283_C(EquipmentSlotType.LEGS);
                    Multimap feetHandAttributes = itemStack.func_111283_C(EquipmentSlotType.FEET);
                    Map<String, AttributeModifier> attributes = JsonConfig.mergeMultimaps(mainHandAttributes, offHandAttributes, headHandAttributes, chestHandAttributes, legsHandAttributes, feetHandAttributes);
                    AttributeModifier armorAttribute = attributes.get("generic.armor");
                    AttributeModifier armorToughnessAttribute = attributes.get("generic.armorToughness");
                    AttributeModifier attackSpeedAttribute = attributes.get("generic.attackSpeed");
                    AttributeModifier attackDamageAttribute = attributes.get("generic.attackDamage");
                    double armor = armorAttribute == null ? 0.0 : armorAttribute.func_111164_d();
                    double armorToughness = armorToughnessAttribute == null ? 0.0 : armorToughnessAttribute.func_111164_d();
                    double attackSpeed = attackSpeedAttribute == null ? 0.0 : attackSpeedAttribute.func_111164_d();
                    double attackDamage = attackDamageAttribute == null ? 0.0 : attackDamageAttribute.func_111164_d();
                    double enduranceReq = 0.0;
                    double combatReq = 0.0;
                    double toolReq = 0.0;
                    double highestToolReq = 0.0;
                    HashMap<String, Double> reqWear = new HashMap<String, Double>();
                    HashMap<String, Double> reqWeapon = new HashMap<String, Double>();
                    HashMap<String, Double> reqTool = new HashMap<String, Double>();
                    if (attributes.size() > 0) {
                        enduranceReq = Math.ceil(armor * Config.forgeConfig.armorReqScale.get() + armorToughness * Config.forgeConfig.armorToughnessReqScale.get());
                        combatReq = Math.ceil(attackDamage * Config.forgeConfig.attackDamageReqScale.get() * (4.0 + attackSpeed));
                        reqWear.put(Skill.ENDURANCE.toString(), Math.max(1.0, enduranceReq));
                        reqWeapon.put(Skill.COMBAT.toString(), Math.max(1.0, combatReq));
                        if (Config.forgeConfig.wearReqEnabled.get().booleanValue() && Config.forgeConfig.autoGenerateWearReqEnabled.get().booleanValue() && reqWear.getOrDefault(Skill.ENDURANCE.toString(), 0.0) > 1.0) {
                            JsonConfig.addJsonConfigValue(resLoc, JType.REQ_WEAR, reqWear, false);
                        }
                        if (Config.forgeConfig.weaponReqEnabled.get().booleanValue() && Config.forgeConfig.autoGenerateWeaponReqEnabled.get().booleanValue() && reqWeapon.getOrDefault(Skill.COMBAT.toString(), 0.0) > 1.0) {
                            JsonConfig.addJsonConfigValue(resLoc, JType.REQ_WEAPON, reqWeapon, false);
                        }
                    }
                    for (ToolType toolType : toolTypes) {
                        double speed;
                        if (toolType.equals(ToolType.AXE)) {
                            speed = item.func_150893_a(itemStack, Blocks.field_196617_K.func_176223_P());
                            toolReq = Math.max(1.0, speed * Config.forgeConfig.toolReqScaleLog.get());
                            if (highestToolReq < toolReq) {
                                highestToolReq = toolReq;
                            }
                            reqTool.put(Skill.WOODCUTTING.toString(), toolReq);
                        }
                        if (toolType.equals(ToolType.PICKAXE)) {
                            speed = item.func_150893_a(itemStack, Blocks.field_150348_b.func_176223_P());
                            toolReq = Math.max(1.0, speed * Config.forgeConfig.toolReqScaleOre.get());
                            if (highestToolReq < toolReq) {
                                highestToolReq = toolReq;
                            }
                            reqTool.put(Skill.MINING.toString(), toolReq);
                        }
                        if (!toolType.equals(ToolType.SHOVEL)) continue;
                        speed = item.func_150893_a(itemStack, Blocks.field_150346_d.func_176223_P());
                        toolReq = Math.max(1.0, speed * Config.forgeConfig.toolReqScaleDirt.get());
                        if (highestToolReq < toolReq) {
                            highestToolReq = toolReq;
                        }
                        reqTool.put(Skill.EXCAVATION.toString(), toolReq);
                    }
                    if (Config.forgeConfig.toolReqEnabled.get().booleanValue() && Config.forgeConfig.autoGenerateToolReqEnabled.get().booleanValue()) {
                        JsonConfig.addJsonConfigValue(resLoc, JType.REQ_TOOL, reqTool, true);
                    }
                    if (!Config.forgeConfig.autoGenerateCraftingXpEnabled.get().booleanValue()) continue;
                    double craftingXp = 0.0;
                    double smithingXp = 0.0;
                    if (enduranceReq > 0.0 || combatReq > 0.0 || toolReq > 0.0) {
                        craftingXp = enduranceReq * 10.0 + Math.max(Math.max(combatReq - 10.0, 1.0) * 5.0, Math.max(toolReq - 10.0, 1.0) * 5.0);
                        smithingXp = Math.max(enduranceReq - 10.0, 1.0) * 5.0 + Math.max(Math.max(combatReq - 10.0, 1.0) * 2.0, Math.max(toolReq - 10.0, 1.0) * 2.0);
                        craftingXp *= Config.forgeConfig.autoGeneratedCraftingXpValueMultiplierCrafting.get().doubleValue();
                        smithingXp *= Config.forgeConfig.autoGeneratedCraftingXpValueMultiplierSmithing.get().doubleValue();
                    }
                    HashMap<String, Double> xpValueMap = new HashMap<String, Double>();
                    if (craftingXp > 0.0) {
                        xpValueMap.put(Skill.CRAFTING.toString(), craftingXp);
                    }
                    if (smithingXp > 0.0) {
                        xpValueMap.put(Skill.SMITHING.toString(), smithingXp);
                    }
                    JsonConfig.addJsonConfigValue(resLoc, JType.XP_VALUE_CRAFT, xpValueMap, true);
                }
                catch (Exception e) {
                    LOGGER.debug((Object)e);
                }
            }
            if (Config.forgeConfig.autoGenerateExtraChanceEnabled.get().booleanValue()) {
                for (Block block : ForgeRegistries.BLOCKS) {
                    try {
                        String resLoc = block.getRegistryName().toString();
                        Material material = block.func_176223_P().func_185904_a();
                        Skill skill = XP.getSkill(material);
                        JType jType = JType.NONE;
                        HashMap<String, Double> infoMap = new HashMap<String, Double>();
                        double chance = 0.0;
                        Set tags = block.getTags();
                        if (block instanceof OreBlock || tags.contains(new ResourceLocation("forge:ores"))) {
                            jType = JType.INFO_ORE;
                            chance = Config.forgeConfig.defaultExtraChanceOre.get();
                        } else if (block instanceof CropsBlock || tags.contains(new ResourceLocation("minecraft:crops"))) {
                            jType = JType.INFO_PLANT;
                            chance = Config.forgeConfig.defaultExtraChancePlant.get();
                        } else if (block instanceof LogBlock || tags.contains(new ResourceLocation("minecraft:logs"))) {
                            jType = JType.INFO_LOG;
                            chance = Config.forgeConfig.defaultExtraChanceLog.get();
                        }
                        if (!jType.equals((Object)JType.NONE)) {
                            infoMap.put("extraChance", chance);
                        }
                        if (infoMap.size() <= 0 || !(infoMap.getOrDefault("extraChance", 0.0) > 0.0)) continue;
                        JsonConfig.addJsonConfigValue(resLoc, jType, infoMap, false);
                    }
                    catch (Exception e) {
                        LOGGER.error((Object)e);
                    }
                }
            }
            data = localData;
        }
    }

    static {
        rawData = new HashMap<JType, Map<String, Map<String, Double>>>();
        rawData2 = new HashMap<JType, Map<String, Map<String, Map<String, Double>>>>();
        localData = new HashMap<JType, Map<String, Map<String, Double>>>();
        localData2 = new HashMap<JType, Map<String, Map<String, Map<String, Double>>>>();
        data = new HashMap<JType, Map<String, Map<String, Double>>>();
        data2 = new HashMap<JType, Map<String, Map<String, Map<String, Double>>>>();
        validAttributes = new ArrayList();
        validFishEnchantInfo = new ArrayList();
        jTypes2 = new HashSet<JType>();
    }
}

