/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.curios;

import java.util.stream.Stream;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.items.IItemHandler;
import top.theillusivec4.curios.api.CuriosAPI;

public class Curios {
    private static final boolean isCuriosLoaded = ModList.get().isLoaded("curios");

    public static boolean isLoaded() {
        return isCuriosLoaded;
    }

    public static Stream<IItemHandler> getCurios(PlayerEntity player) {
        return isCuriosLoaded ? ActualCurios.getCurios(player) : Stream.empty();
    }

    private static class ActualCurios {
        private ActualCurios() {
        }

        public static Stream<IItemHandler> getCurios(PlayerEntity player) {
            return (Stream)CuriosAPI.getCuriosHandler((LivingEntity)player).map(curiosHandler -> curiosHandler.getCurioMap().values().stream().map(c -> c)).orElse(Stream.empty());
        }
    }
}

