/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.events;

import harmonised.pmmo.config.Config;
import harmonised.pmmo.config.JType;
import harmonised.pmmo.config.JsonConfig;
import harmonised.pmmo.events.ChunkDataHandler;
import harmonised.pmmo.events.WorldTickHandler;
import harmonised.pmmo.network.MessageDoubleTranslation;
import harmonised.pmmo.network.NetworkHandler;
import harmonised.pmmo.skills.Skill;
import harmonised.pmmo.skills.VeinInfo;
import harmonised.pmmo.util.DP;
import harmonised.pmmo.util.XP;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SeaPickleBlock;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootParameters;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.world.BlockEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BlockBrokenHandler {
    public static final Logger LOGGER = LogManager.getLogger();

    public static void handleBroken(BlockEvent.BreakEvent event) {
        PlayerEntity player = event.getPlayer();
        if (!(player instanceof FakePlayer)) {
            BlockBrokenHandler.processReq(event);
        }
        ChunkDataHandler.delPos(event.getWorld().func_201675_m().func_186058_p().getRegistryName(), event.getPos());
    }

    private static void processReq(BlockEvent.BreakEvent event) {
        PlayerEntity player = event.getPlayer();
        BlockState blockState = event.getState();
        Block block = blockState.func_177230_c();
        World world = (World)event.getWorld();
        Material material = event.getState().func_185904_a();
        Block blockAbove = world.func_180495_p(event.getPos().func_177984_a()).func_177230_c();
        boolean passedBreakReq = true;
        if (JsonConfig.data.get((Object)JType.INFO_PLANT).containsKey(blockAbove.getRegistryName().toString()) && blockAbove instanceof IPlantable) {
            passedBreakReq = XP.checkReq(player, blockAbove.getRegistryName(), JType.REQ_BREAK);
        }
        if (!passedBreakReq) {
            block = blockAbove;
        } else {
            passedBreakReq = XP.checkReq(player, block.getRegistryName(), JType.REQ_BREAK);
        }
        if (passedBreakReq) {
            if (XP.checkReq(player, player.func_184614_ca().func_77973_b().getRegistryName(), JType.REQ_TOOL)) {
                BlockBrokenHandler.processBroken(event);
                ChunkDataHandler.delPos(world.field_73011_w.func_186058_p().getRegistryName(), event.getPos());
            }
        } else {
            if (XP.correctHarvestTool(material).equals("axe")) {
                NetworkHandler.sendToPlayer(new MessageDoubleTranslation("pmmo.notSkilledEnoughToChop", block.func_149739_a(), "", true, 2), (ServerPlayerEntity)player);
                NetworkHandler.sendToPlayer(new MessageDoubleTranslation("pmmo.notSkilledEnoughToChop", block.func_149739_a(), "", false, 2), (ServerPlayerEntity)player);
            } else if (JsonConfig.data.get((Object)JType.INFO_PLANT).containsKey(blockAbove.getRegistryName().toString()) || block instanceof IPlantable) {
                NetworkHandler.sendToPlayer(new MessageDoubleTranslation("pmmo.notSkilledEnoughToHarvest", block.func_149739_a(), "", true, 2), (ServerPlayerEntity)player);
                NetworkHandler.sendToPlayer(new MessageDoubleTranslation("pmmo.notSkilledEnoughToHarvest", block.func_149739_a(), "", false, 2), (ServerPlayerEntity)player);
            } else {
                NetworkHandler.sendToPlayer(new MessageDoubleTranslation("pmmo.notSkilledEnoughToBreak", block.func_149739_a(), "", true, 2), (ServerPlayerEntity)player);
                NetworkHandler.sendToPlayer(new MessageDoubleTranslation("pmmo.notSkilledEnoughToBreak", block.func_149739_a(), "", false, 2), (ServerPlayerEntity)player);
            }
            for (Map.Entry<String, Double> entry : JsonConfig.data.get((Object)JType.REQ_BREAK).get(block.getRegistryName().toString()).entrySet()) {
                double entryValue;
                int startLevel = Skill.getSkill(entry.getKey()).getLevel(player);
                if ((double)startLevel < (entryValue = entry.getValue().doubleValue())) {
                    NetworkHandler.sendToPlayer(new MessageDoubleTranslation("pmmo.levelDisplay", "pmmo." + entry.getKey(), "" + (int)Math.floor(entryValue), false, 2), (ServerPlayerEntity)player);
                    continue;
                }
                NetworkHandler.sendToPlayer(new MessageDoubleTranslation("pmmo.levelDisplay", "pmmo." + entry.getKey(), "" + (int)Math.floor(entryValue), false, 1), (ServerPlayerEntity)player);
            }
            event.setCanceled(true);
        }
    }

    private static void processBroken(BlockEvent.BreakEvent event) {
        int gap;
        int extraDrop;
        int guaranteedDrop;
        ItemStack theDropItem;
        List drops;
        boolean veiningAllowed;
        BlockState state = event.getState();
        Block block = state.func_177230_c();
        String regKey = block.getRegistryName().toString();
        Map<String, Double> xpMap = XP.getXp(regKey, JType.XP_VALUE_BREAK);
        World world = (World)event.getWorld();
        boolean isRemote = world.func_201670_d();
        PlayerEntity player = event.getPlayer();
        Map<String, Double> configMap = Config.getConfigMap();
        boolean bl = veiningAllowed = configMap.containsKey("veiningAllowed") && configMap.get("veiningAllowed") != 0.0;
        if (XP.isVeining.contains(player.func_110124_au()) && veiningAllowed && !WorldTickHandler.activeVein.containsKey(player)) {
            WorldTickHandler.scheduleVein(player, new VeinInfo(world, state, event.getPos(), player.func_184614_ca()));
        }
        if (!XP.isPlayerSurvival(player) || isRemote) {
            return;
        }
        Material material = event.getState().func_185904_a();
        double blockHardnessLimitForBreaking = Config.forgeConfig.blockHardnessLimitForBreaking.get();
        boolean wasPlaced = ChunkDataHandler.checkPos(world, event.getPos()) != null;
        ItemStack toolUsed = player.func_184614_ca();
        Skill skill = XP.getSkill(material);
        String skillName = skill.toString();
        double hardness = state.func_185887_b((IBlockReader)event.getWorld(), event.getPos());
        if (hardness > blockHardnessLimitForBreaking) {
            hardness = blockHardnessLimitForBreaking;
        }
        boolean isEffective = true;
        String awardMsg = "";
        switch (XP.getSkill(material)) {
            case MINING: {
                awardMsg = "Mining";
                break;
            }
            case WOODCUTTING: {
                awardMsg = "Chopping";
                break;
            }
            case EXCAVATION: {
                awardMsg = "Digging";
                break;
            }
            case FARMING: {
                awardMsg = "Harvesting";
                break;
            }
            default: {
                awardMsg = "Breaking";
            }
        }
        awardMsg = awardMsg + " " + block.getRegistryName();
        Map enchants = EnchantmentHelper.func_82781_a((ItemStack)player.func_184614_ca());
        int fortune = 0;
        if (enchants.get(Enchantments.field_185308_t) != null) {
            fortune = (Integer)enchants.get(Enchantments.field_185308_t);
        }
        boolean dropsItself = false;
        if (world instanceof ServerWorld) {
            LootContext.Builder builder = new LootContext.Builder((ServerWorld)world).func_216023_a(world.field_73012_v).func_216015_a(LootParameters.field_216286_f, (Object)player.func_180425_c()).func_216015_a(LootParameters.field_216289_i, (Object)toolUsed).func_216015_a(LootParameters.field_216281_a, (Object)player).func_216021_b(LootParameters.field_216288_h, (Object)world.func_175625_s(event.getPos()));
            if (fortune > 0) {
                builder.func_186469_a((float)fortune);
            }
            drops = block.func_220076_a(event.getState(), builder);
            if (EnchantmentHelper.func_82781_a((ItemStack)toolUsed).containsKey(Enchantments.field_185306_r)) {
                List noSilkDrops;
                ItemStack noEnchantTool = toolUsed.func_77946_l();
                noEnchantTool.func_196083_e("Enchantments");
                builder = new LootContext.Builder((ServerWorld)world).func_216023_a(world.field_73012_v).func_216015_a(LootParameters.field_216286_f, (Object)player.func_180425_c()).func_216015_a(LootParameters.field_216289_i, (Object)noEnchantTool).func_216015_a(LootParameters.field_216281_a, (Object)player).func_216021_b(LootParameters.field_216288_h, (Object)world.func_175625_s(event.getPos()));
                if (fortune > 0) {
                    builder.func_186469_a((float)fortune);
                }
                if ((noSilkDrops = block.func_220076_a(event.getState(), builder)).size() > 0 && ((ItemStack)noSilkDrops.get(0)).func_77973_b().equals(block.func_199767_j())) {
                    dropsItself = true;
                }
            }
        } else {
            drops = new ArrayList();
        }
        Map<String, Double> award = new HashMap<String, Double>();
        award.put(skillName, hardness);
        int dropItemCount = 0;
        if (drops.size() > 0) {
            dropItemCount = ((ItemStack)drops.get(0)).func_190916_E();
            if (((ItemStack)drops.get(0)).func_77973_b().equals(block.func_199767_j())) {
                dropsItself = true;
            }
        }
        if (!wasPlaced) {
            award = XP.addMaps(award, XP.multiplyMap(xpMap, Math.max(dropItemCount, 1)));
        }
        ItemStack itemStack = theDropItem = drops.size() > 0 ? (ItemStack)drops.get(0) : ItemStack.field_190927_a;
        if (JsonConfig.data.get((Object)JType.BLOCK_SPECIFIC).containsKey(regKey) && JsonConfig.data.get((Object)JType.BLOCK_SPECIFIC).get(regKey).containsKey("growsUpwards")) {
            Block baseBlock = event.getState().func_177230_c();
            BlockPos baseBlockPos = event.getPos();
            double extraChance = XP.getExtraChance(player.func_110124_au(), block.getRegistryName(), JType.INFO_PLANT, false) / 100.0;
            int totalDrops = 0;
            guaranteedDrop = 0;
            extraDrop = 0;
            int rewardable = 0;
            int guaranteedDropEach = (int)Math.floor(extraChance);
            extraChance = (extraChance - Math.floor(extraChance)) * 100.0;
            int height = 0;
            BlockPos curBlockPos = new BlockPos(baseBlockPos.func_177958_n(), baseBlockPos.func_177956_o() + height, baseBlockPos.func_177952_p());
            block = world.func_180495_p(curBlockPos).func_177230_c();
            boolean correctBlock = block.equals(baseBlock);
            while (correctBlock) {
                BlockPos nextPos;
                Block nextBlock;
                boolean bl2 = wasPlaced = ChunkDataHandler.checkPos(world, curBlockPos) != null;
                if (!wasPlaced) {
                    ++rewardable;
                    guaranteedDrop += guaranteedDropEach;
                    if (Math.ceil(Math.random() * 1000.0) <= extraChance * 10.0) {
                        ++extraDrop;
                    }
                }
                if ((nextBlock = world.func_180495_p(nextPos = new BlockPos(baseBlockPos.func_177958_n(), baseBlockPos.func_177956_o() + ++height, baseBlockPos.func_177952_p())).func_177230_c()).equals(baseBlock)) {
                    curBlockPos = nextPos;
                    block = nextBlock;
                    continue;
                }
                correctBlock = false;
            }
            int dropsLeft = guaranteedDrop + extraDrop;
            if (dropsLeft > 0) {
                XP.dropItems(dropsLeft, block.func_199767_j(), world, event.getPos());
                NetworkHandler.sendToPlayer(new MessageDoubleTranslation("pmmo.extraDrop", "" + dropsLeft, theDropItem.func_77977_a(), true, 1), (ServerPlayerEntity)player);
            }
            totalDrops = rewardable + dropsLeft;
            award.put(skillName, hardness);
            award = XP.addMaps(award, xpMap);
            XP.multiplyMap(award, totalDrops);
            awardMsg = "removing " + height + " + " + (guaranteedDrop + extraDrop) + " extra " + block.getRegistryName();
        } else if ((material.equals(Material.field_151585_k) || material.equals(Material.field_203243_f) || material.equals(Material.field_151582_l)) && drops.size() > 0) {
            award = new HashMap();
            award.put(skillName, hardness);
            int age = -1;
            int maxAge = -1;
            if (state.func_196959_b((IProperty)BlockStateProperties.field_222512_Y)) {
                age = (Integer)state.func_177229_b((IProperty)BlockStateProperties.field_222512_Y);
                maxAge = 1;
            } else if (state.func_196959_b((IProperty)BlockStateProperties.field_208167_T)) {
                age = (Integer)state.func_177229_b((IProperty)BlockStateProperties.field_208167_T);
                maxAge = 2;
            } else if (state.func_196959_b((IProperty)BlockStateProperties.field_208168_U)) {
                age = (Integer)state.func_177229_b((IProperty)BlockStateProperties.field_208168_U);
                maxAge = 3;
            } else if (state.func_196959_b((IProperty)BlockStateProperties.field_208169_V)) {
                age = (Integer)state.func_177229_b((IProperty)BlockStateProperties.field_208169_V);
                maxAge = 5;
            } else if (state.func_196959_b((IProperty)BlockStateProperties.field_208170_W)) {
                age = (Integer)state.func_177229_b((IProperty)BlockStateProperties.field_208170_W);
                maxAge = 7;
            } else if (state.func_196959_b((IProperty)BlockStateProperties.field_208171_X)) {
                age = (Integer)state.func_177229_b((IProperty)BlockStateProperties.field_208171_X);
                maxAge = 15;
            } else if (state.func_196959_b((IProperty)BlockStateProperties.field_208172_Y)) {
                age = (Integer)state.func_177229_b((IProperty)BlockStateProperties.field_208172_Y);
                maxAge = 25;
            } else if (state.func_196959_b((IProperty)BlockStateProperties.field_208135_aj)) {
                age = (Integer)state.func_177229_b((IProperty)BlockStateProperties.field_208135_aj);
                maxAge = 4;
                if (wasPlaced) {
                    return;
                }
            }
            if (age == maxAge && age >= 0 || block instanceof SeaPickleBlock) {
                double extraChance = XP.getExtraChance(player.func_110124_au(), block.getRegistryName(), JType.INFO_PLANT, false) / 100.0;
                guaranteedDrop = (int)extraChance;
                int totalExtraDrops = guaranteedDrop + (extraDrop = XP.rollChance(extraChance % 1.0) ? 1 : 0);
                if (totalExtraDrops > 0) {
                    XP.dropItems(guaranteedDrop + extraDrop, theDropItem.func_77973_b(), world, event.getPos());
                    NetworkHandler.sendToPlayer(new MessageDoubleTranslation("pmmo.extraDrop", "" + totalExtraDrops, theDropItem.func_77973_b().func_77658_a(), true, 1), (ServerPlayerEntity)player);
                }
                awardMsg = "harvesting " + dropItemCount + " + " + totalExtraDrops + " " + block.getRegistryName();
                XP.multiplyMap(XP.addMaps(award, xpMap), dropItemCount + totalExtraDrops);
            } else if (!wasPlaced) {
                awardMsg = "Breaking " + block.getRegistryName();
                XP.multiplyMap(XP.addMaps(award, xpMap), dropItemCount);
            }
        }
        if (XP.getExtraChance(player.func_110124_au(), block.getRegistryName(), JType.INFO_ORE, false) > 0.0) {
            boolean isSilk;
            award = new HashMap();
            award.put(skillName, hardness);
            boolean bl3 = isSilk = enchants.get(Enchantments.field_185306_r) != null;
            if (!wasPlaced && !isSilk) {
                award = XP.addMaps(award, XP.multiplyMap(XP.getXp(block.getRegistryName(), JType.XP_VALUE_BREAK), theDropItem.func_190916_E()));
            }
            if (dropsItself && !wasPlaced || !dropsItself && !isSilk) {
                double extraChance = XP.getExtraChance(player.func_110124_au(), block.getRegistryName(), JType.INFO_ORE, false) / 100.0;
                int guaranteedDrop2 = (int)extraChance;
                int extraDrop2 = XP.rollChance(extraChance % 1.0) ? 1 : 0;
                int totalExtraDrops = guaranteedDrop2 + extraDrop2;
                if (!dropsItself && wasPlaced) {
                    award = XP.addMaps(award, XP.multiplyMap(XP.getXp(block.getRegistryName(), JType.XP_VALUE_BREAK), theDropItem.func_190916_E()));
                }
                if (totalExtraDrops > 0) {
                    XP.dropItems(guaranteedDrop2 + extraDrop2, theDropItem.func_77973_b(), world, event.getPos());
                    NetworkHandler.sendToPlayer(new MessageDoubleTranslation("pmmo.extraDrop", "" + totalExtraDrops, theDropItem.func_77973_b().func_77658_a(), true, 1), (ServerPlayerEntity)player);
                }
                award = XP.addMaps(award, XP.multiplyMap(XP.getXp(block.getRegistryName(), JType.XP_VALUE_BREAK), totalExtraDrops));
            }
            awardMsg = "Mining " + block.getRegistryName();
        }
        if (XP.getExtraChance(player.func_110124_au(), block.getRegistryName(), JType.INFO_LOG, false) > 0.0 && isEffective) {
            if (!wasPlaced) {
                award = new HashMap();
                award.put(skillName, hardness);
                double extraChance = XP.getExtraChance(player.func_110124_au(), block.getRegistryName(), JType.INFO_LOG, false) / 100.0;
                int guaranteedDrop3 = (int)extraChance;
                int extraDrop3 = XP.rollChance(extraChance % 1.0) ? 1 : 0;
                int totalExtraDrops = guaranteedDrop3 + extraDrop3;
                if (totalExtraDrops > 0) {
                    XP.dropItems(guaranteedDrop3 + extraDrop3, theDropItem.func_77973_b(), world, event.getPos());
                    NetworkHandler.sendToPlayer(new MessageDoubleTranslation("pmmo.extraDrop", "" + totalExtraDrops, theDropItem.func_77973_b().func_77658_a(), true, 1), (ServerPlayerEntity)player);
                }
                XP.multiplyMap(XP.addMaps(award, xpMap), dropItemCount + totalExtraDrops);
            }
            awardMsg = "Chopping " + block.getRegistryName().toString();
        }
        if (JsonConfig.data2.get((Object)JType.TREASURE).containsKey(block.getRegistryName().toString()) && !wasPlaced) {
            Map<String, Map<String, Double>> treasurePool = JsonConfig.data2.get((Object)JType.TREASURE).get(block.getRegistryName().toString());
            int excavationLevel = Skill.EXCAVATION.getLevel(player);
            for (Map.Entry<String, Map<String, Double>> treasureItem : treasurePool.entrySet()) {
                boolean foundTreasure = false;
                Map<String, Double> treasureItemMap = treasureItem.getValue();
                double chance = BlockBrokenHandler.getTreasureItemChance(excavationLevel, treasureItemMap);
                if (Math.ceil(Math.random() * 10000.0) <= chance * 100.0) {
                    Item item = XP.getItem(treasureItem.getKey());
                    int minCount = (int)Math.floor(treasureItemMap.get("minCount"));
                    int maxCount = (int)Math.floor(treasureItemMap.get("maxCount"));
                    int count = (int)Math.floor(Math.random() * (double)maxCount + (double)minCount);
                    award.put(Skill.EXCAVATION.toString(), award.getOrDefault(Skill.EXCAVATION.toString(), 0.0) + treasureItemMap.get("xpPerItem") * (double)count);
                    ItemStack itemStack2 = new ItemStack((IItemProvider)item, count);
                    XP.dropItemStack(itemStack2, world, event.getPos());
                    foundTreasure = true;
                    player.func_146105_b(new TranslationTextComponent("pmmo.youFoundTreasureItem", new Object[]{count, new TranslationTextComponent(itemStack2.func_77977_a(), new Object[0])}).func_150255_a(XP.textStyle.get("green")), false);
                    LOGGER.debug(player.func_145748_c_().getString() + " found Treasure! " + count + " " + treasureItem.getKey() + " " + event.getPos());
                }
                if (!foundTreasure) continue;
                player.func_146105_b(new TranslationTextComponent("pmmo.youFoundTreasure", new Object[0]).func_150255_a(XP.textStyle.get("green")), true);
            }
        }
        if ((gap = XP.getSkillReqGap(player, player.func_184614_ca().func_77973_b().getRegistryName(), JType.REQ_TOOL)) > 0) {
            player.func_184614_ca().func_222118_a(gap - 1, (LivingEntity)player, a -> a.func_213334_d(Hand.MAIN_HAND));
        }
        for (String awardSkillName : award.keySet()) {
            Skill awardSkill = Skill.getSkill(awardSkillName);
            XP.awardXp((ServerPlayerEntity)player, awardSkill, awardMsg, award.get(awardSkillName) / (double)(gap + 1), !skill.equals((Object)awardSkill), false, false);
        }
    }

    public static double getTreasureItemChance(int level, Map<String, Double> map) {
        return DP.mapCapped(level, map.get("startLevel"), map.get("endLevel"), map.get("startChance"), map.get("endChance"));
    }
}

