/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.events;

import harmonised.pmmo.config.Config;
import harmonised.pmmo.config.JType;
import harmonised.pmmo.config.JsonConfig;
import harmonised.pmmo.events.ChunkDataHandler;
import harmonised.pmmo.network.MessageDoubleTranslation;
import harmonised.pmmo.network.MessageGrow;
import harmonised.pmmo.network.NetworkHandler;
import harmonised.pmmo.skills.Skill;
import harmonised.pmmo.util.XP;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.world.BlockEvent;

public class BlockPlacedHandler {
    private static final Map<UUID, BlockPos> lastPosPlaced = new HashMap<UUID, BlockPos>();

    public static void handlePlaced(BlockEvent.EntityPlaceEvent event) {
        ServerPlayerEntity player;
        if (event.getEntity() instanceof ServerPlayerEntity && !(event.getEntity() instanceof FakePlayer) && XP.isPlayerSurvival((PlayerEntity)(player = (ServerPlayerEntity)event.getEntity()))) {
            Block block = event.getPlacedBlock().func_177230_c();
            if (block.equals(Blocks.field_150355_j)) {
                XP.awardXp(player, Skill.MAGIC, "Walking on water -gasp-", Config.forgeConfig.jesusXp.get(), true, false, false);
                return;
            }
            if (XP.checkReq((PlayerEntity)player, block.getRegistryName(), JType.REQ_PLACE)) {
                double blockHardnessLimitForPlacing = Config.forgeConfig.blockHardnessLimitForPlacing.get();
                double blockHardness = event.getPlacedBlock().func_185887_b((IBlockReader)event.getWorld(), event.getPos());
                if (blockHardness > blockHardnessLimitForPlacing) {
                    blockHardness = blockHardnessLimitForPlacing;
                }
                String playerName = player.func_200200_C_().toString();
                BlockPos blockPos = event.getPos();
                UUID playerUUID = player.func_110124_au();
                Map<Object, Object> award = new HashMap();
                String sourceName = "Placing a Block";
                if (!(lastPosPlaced.containsKey(playerUUID) && lastPosPlaced.get(playerUUID).equals((Object)blockPos) || (award = XP.getXp(block.getRegistryName(), JType.XP_VALUE_PLACE)).size() != 0)) {
                    if (block.equals(Blocks.field_150458_ak)) {
                        award.put(Skill.FARMING.toString(), blockHardness);
                        sourceName = "Tilting Dirt";
                    } else {
                        award.put(Skill.BUILDING.toString(), blockHardness);
                    }
                }
                XP.awardXpMap(player.func_110124_au(), award, sourceName, false, false);
                if (lastPosPlaced.containsKey(playerName)) {
                    lastPosPlaced.replace(playerUUID, event.getPos());
                } else {
                    lastPosPlaced.put(playerUUID, blockPos);
                }
            } else {
                ItemStack mainItemStack = player.func_184614_ca();
                ItemStack offItemStack = player.func_184592_cb();
                if (mainItemStack.func_77973_b() instanceof BlockItem) {
                    NetworkHandler.sendToPlayer(new MessageGrow(0, mainItemStack.func_190916_E()), player);
                }
                if (offItemStack.func_77973_b() instanceof BlockItem) {
                    NetworkHandler.sendToPlayer(new MessageGrow(1, offItemStack.func_190916_E()), player);
                }
                if (JsonConfig.data.get((Object)JType.INFO_PLANT).containsKey(block.getRegistryName().toString()) || block instanceof IPlantable) {
                    NetworkHandler.sendToPlayer(new MessageDoubleTranslation("pmmo.notSkilledEnoughToPlant", block.func_149739_a(), "", true, 2), player);
                } else {
                    NetworkHandler.sendToPlayer(new MessageDoubleTranslation("pmmo.notSkilledEnoughToPlaceDown", block.func_149739_a(), "", true, 2), player);
                }
                event.setCanceled(true);
            }
            ChunkDataHandler.addPos(event.getWorld().func_201675_m().func_186058_p().getRegistryName(), event.getPos(), player.func_110124_au());
        }
    }
}

