/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.events;

import harmonised.pmmo.config.Config;
import harmonised.pmmo.config.JType;
import harmonised.pmmo.skills.Skill;
import harmonised.pmmo.util.XP;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.event.entity.player.PlayerEvent;

public class BreakSpeedHandler {
    public static void handleBreakSpeed(PlayerEvent.BreakSpeed event) {
        PlayerEntity player = event.getPlayer();
        String skill = XP.getSkill(event.getState().func_185904_a()).name().toLowerCase();
        int toolGap = XP.getSkillReqGap(player, player.func_184614_ca().func_77973_b().getRegistryName(), JType.REQ_TOOL);
        boolean reqMet = XP.checkReq(player, event.getState().func_177230_c().getRegistryName(), JType.REQ_BREAK);
        if (!reqMet) {
            player.func_146105_b(new TranslationTextComponent("pmmo.notSkilledEnoughToBreak", new Object[]{new TranslationTextComponent(event.getState().func_177230_c().func_149739_a(), new Object[0])}).func_150255_a(XP.textStyle.get("red")), true);
            event.setCanceled(true);
            return;
        }
        if (toolGap > 0) {
            player.func_146105_b(new TranslationTextComponent("pmmo.notSkilledEnoughToUseAsTool", new Object[]{new TranslationTextComponent(player.func_184614_ca().func_77977_a(), new Object[0])}).func_150255_a(XP.textStyle.get("red")), true);
            if (Config.getConfig("strictReqTool") == 1.0) {
                event.setCanceled(true);
                return;
            }
        }
        int startLevel = Skill.getSkill(skill).getLevel(player);
        switch (XP.correctHarvestTool(event.getState().func_185904_a())) {
            case "pickaxe": {
                double blocksToUnbreakableY;
                double heightMultiplier;
                float height = event.getPos().func_177956_o();
                if (height < 0.0f) {
                    height = -height;
                }
                if ((heightMultiplier = 1.0 - (double)height / (blocksToUnbreakableY = Config.forgeConfig.blocksToUnbreakableY.get().doubleValue())) < Config.forgeConfig.minBreakSpeed.get()) {
                    heightMultiplier = Config.forgeConfig.minBreakSpeed.get();
                }
                double speedBonus = Config.forgeConfig.miningBonusSpeed.get() / 100.0;
                event.setNewSpeed(event.getOriginalSpeed() * (1.0f + (float)(startLevel - toolGap) * (float)speedBonus) * (float)heightMultiplier);
                break;
            }
            case "axe": {
                double speedBonus = Config.forgeConfig.woodcuttingBonusSpeed.get() / 100.0;
                event.setNewSpeed(event.getOriginalSpeed() * (1.0f + (float)(startLevel - toolGap) * (float)speedBonus));
                break;
            }
            case "shovel": {
                double speedBonus = Config.forgeConfig.excavationBonusSpeed.get() / 100.0;
                event.setNewSpeed(event.getOriginalSpeed() * (1.0f + (float)(startLevel - toolGap) * (float)speedBonus));
                break;
            }
            case "hoe": {
                double speedBonus = Config.forgeConfig.farmingBonusSpeed.get() / 100.0;
                event.setNewSpeed(event.getOriginalSpeed() * (1.0f + (float)(startLevel - toolGap) * (float)speedBonus));
                break;
            }
            default: {
                event.setNewSpeed(event.getOriginalSpeed());
            }
        }
        event.setNewSpeed(event.getNewSpeed() / (float)(toolGap + 1));
    }
}

