/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.events;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraftforge.event.world.ChunkDataEvent;

public class ChunkDataHandler {
    private static Map<ResourceLocation, Map<ChunkPos, Map<BlockPos, UUID>>> placedMap = new HashMap<ResourceLocation, Map<ChunkPos, Map<BlockPos, UUID>>>();

    public static void init() {
        placedMap = new HashMap<ResourceLocation, Map<ChunkPos, Map<BlockPos, UUID>>>();
    }

    public static void handleChunkDataLoad(ChunkDataEvent.Load event) {
        CompoundNBT levelNBT = event.getData();
        if (levelNBT != null && levelNBT.func_74764_b("placedPos")) {
            CompoundNBT placedPosNBT;
            ResourceLocation dimResLoc = event.getWorld().func_201675_m().func_186058_p().getRegistryName();
            ChunkPos chunkPos = event.getChunk().func_76632_l();
            if (!placedMap.containsKey(dimResLoc)) {
                placedMap.put(dimResLoc, new HashMap());
            }
            if ((placedPosNBT = (CompoundNBT)levelNBT.func_74781_a("placedPos")) == null) {
                return;
            }
            Map<ChunkPos, Map<BlockPos, UUID>> chunkMap = placedMap.get(dimResLoc);
            HashMap blockMap = new HashMap();
            Set keySet = placedPosNBT.func_150296_c();
            keySet.forEach(key -> {
                CompoundNBT entry = placedPosNBT.func_74775_l(key);
                blockMap.put(NBTUtil.func_186861_c((CompoundNBT)entry.func_74775_l("pos")), NBTUtil.func_186860_b((CompoundNBT)entry.func_74775_l("UUID")));
            });
            chunkMap.remove(chunkPos);
            chunkMap.put(chunkPos, blockMap);
        }
    }

    public static void handleChunkDataSave(ChunkDataEvent.Save event) {
        ResourceLocation dimResLoc = event.getWorld().func_201675_m().func_186058_p().getRegistryName();
        if (placedMap.containsKey(dimResLoc)) {
            ChunkPos chunkPos = event.getChunk().func_76632_l();
            if (placedMap.get(dimResLoc).containsKey(chunkPos)) {
                CompoundNBT levelNBT = (CompoundNBT)event.getData().func_74781_a("Level");
                if (levelNBT == null) {
                    return;
                }
                CompoundNBT newPlacedNBT = new CompoundNBT();
                int i = 0;
                for (Map.Entry<BlockPos, UUID> entry : placedMap.get(dimResLoc).get(chunkPos).entrySet()) {
                    CompoundNBT insidesNBT = new CompoundNBT();
                    insidesNBT.func_218657_a("pos", (INBT)NBTUtil.func_186859_a((BlockPos)entry.getKey()));
                    insidesNBT.func_218657_a("UUID", (INBT)NBTUtil.func_186862_a((UUID)entry.getValue()));
                    newPlacedNBT.func_218657_a(i++ + "", (INBT)insidesNBT);
                }
                levelNBT.func_218657_a("placedPos", (INBT)newPlacedNBT);
            }
        }
    }

    public static void addPos(ResourceLocation dimResLoc, BlockPos blockPos, UUID uuid) {
        Map<ChunkPos, Map<BlockPos, UUID>> chunkMap;
        ChunkPos chunkPos = new ChunkPos(blockPos);
        if (!placedMap.containsKey(dimResLoc)) {
            placedMap.put(dimResLoc, new HashMap());
        }
        if (!(chunkMap = placedMap.get(dimResLoc)).containsKey(chunkPos)) {
            chunkMap.put(chunkPos, new HashMap());
        }
        Map<BlockPos, UUID> blockMap = chunkMap.get(chunkPos);
        blockMap.put(blockPos, uuid);
    }

    public static void delPos(ResourceLocation dimResLoc, BlockPos blockPos) {
        Map<ChunkPos, Map<BlockPos, UUID>> chunkMap;
        ChunkPos chunkPos = new ChunkPos(blockPos);
        if (!placedMap.containsKey(dimResLoc)) {
            placedMap.put(dimResLoc, new HashMap());
        }
        if (!(chunkMap = placedMap.get(dimResLoc)).containsKey(chunkPos)) {
            chunkMap.put(chunkPos, new HashMap());
        }
        Map<BlockPos, UUID> blockMap = chunkMap.get(chunkPos);
        blockMap.remove(blockPos);
    }

    public static UUID checkPos(World world, BlockPos pos) {
        return ChunkDataHandler.checkPos(world.func_201672_e().func_201675_m().func_186058_p().getRegistryName(), pos);
    }

    public static UUID checkPos(ResourceLocation dimResLoc, BlockPos blockPos) {
        return (UUID)((Map)((Map)placedMap.getOrDefault(dimResLoc, new HashMap())).getOrDefault(new ChunkPos(blockPos), new HashMap())).get(blockPos);
    }
}

