/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.events;

import harmonised.pmmo.config.Config;
import harmonised.pmmo.config.JType;
import harmonised.pmmo.config.JsonConfig;
import harmonised.pmmo.skills.Skill;
import harmonised.pmmo.util.XP;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.event.entity.player.ItemFishedEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class FishedHandler {
    public static void handleFished(ItemFishedEvent event) {
        if (!(event.getPlayer() instanceof ServerPlayerEntity)) {
            return;
        }
        ServerPlayerEntity player = (ServerPlayerEntity)event.getPlayer();
        int startLevel = Skill.FISHING.getLevel((PlayerEntity)player);
        NonNullList items = event.getDrops();
        double award = 10.0;
        for (ItemStack itemStack : items) {
            Map<String, Double> itemXp = XP.getXp(itemStack.func_77973_b().getRegistryName(), JType.XP_VALUE_GENERAL);
            if (!itemXp.containsKey("fishing")) continue;
            award = itemXp.get("fishing");
        }
        Map<String, Map<String, Double>> fishPool = JsonConfig.data.get((Object)JType.FISH_POOL);
        if (fishPool != null) {
            double fishPoolMaxChance;
            double fishPoolChancePerLevel;
            double fishPoolBaseChance = Config.forgeConfig.fishPoolBaseChance.get();
            double fishPoolChance = fishPoolBaseChance + (fishPoolChancePerLevel = Config.forgeConfig.fishPoolChancePerLevel.get().doubleValue()) * (double)startLevel;
            if (fishPoolChance > (fishPoolMaxChance = Config.forgeConfig.fishPoolMaxChance.get().doubleValue())) {
                fishPoolChance = fishPoolMaxChance;
            }
            if (Math.random() * 10000.0 < fishPoolChance * 100.0) {
                String matchKey = null;
                HashMap<Object, Object> match = new HashMap();
                double totalWeight = 0.0;
                double currentWeight = 0.0;
                for (Map.Entry<String, Map<String, Double>> entry : fishPool.entrySet()) {
                    totalWeight += XP.getWeight(startLevel, entry.getValue());
                }
                double result = Math.floor(Math.random() * (totalWeight + 1.0));
                for (Map.Entry<String, Map<String, Double>> entry : fishPool.entrySet()) {
                    double weight = XP.getWeight(startLevel, entry.getValue());
                    if (currentWeight < result && currentWeight + weight >= result) {
                        matchKey = entry.getKey();
                        match = new HashMap<String, Double>(entry.getValue());
                        break;
                    }
                    currentWeight += weight;
                }
                Item item = XP.getItem(matchKey);
                int minCount = (int)Math.floor((Double)match.get("minCount"));
                int maxCount = (int)Math.floor((Double)match.get("maxCount"));
                int count = (int)Math.floor(Math.random() * (double)maxCount + (double)minCount);
                ItemStack itemStack = new ItemStack((IItemProvider)item, count);
                if (itemStack.func_77984_f()) {
                    itemStack.func_196085_b((int)Math.floor(Math.random() * (double)itemStack.func_77958_k()));
                }
                if (itemStack.func_77956_u()) {
                    Map<String, Map<String, Double>> enchantMap = JsonConfig.data.get((Object)JType.FISH_ENCHANT_POOL);
                    HashMap<Enchantment, Integer> outEnchants = new HashMap<Enchantment, Integer>();
                    for (Map.Entry<String, Map<String, Double>> entry : enchantMap.entrySet()) {
                        double maxEnchantLevel;
                        double levelPerLevel;
                        int potentialEnchantLevel;
                        double maxChance;
                        int itemLevelReq;
                        int enchantLevelReq;
                        int totalLevelReq;
                        Enchantment enchant = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(XP.getResLoc(entry.getKey()));
                        Map<String, Double> enchantInfo = entry.getValue();
                        if (!enchant.func_92089_a(itemStack) || startLevel < (totalLevelReq = (enchantLevelReq = (int)Math.floor(enchantInfo.get("levelReq"))) + (itemLevelReq = (int)Math.floor((Double)match.get("enchantLevelReq"))))) continue;
                        int level = startLevel - totalLevelReq;
                        double chancePerLevel = enchantInfo.get("chancePerLevel");
                        double enchantChance = chancePerLevel * (double)level;
                        if (enchantChance > (maxChance = enchantInfo.get("maxChance").doubleValue())) {
                            enchantChance = maxChance;
                        }
                        if ((double)(potentialEnchantLevel = (levelPerLevel = enchantInfo.get("levelPerLevel").doubleValue()) > 0.0 ? (int)Math.floor((double)level / levelPerLevel) : (int)Math.floor(maxEnchantLevel)) > (maxEnchantLevel = enchantInfo.get("maxLevel").doubleValue())) {
                            potentialEnchantLevel = (int)Math.floor(maxEnchantLevel);
                        }
                        int enchantLevel = 0;
                        for (int i = 0; i < potentialEnchantLevel; ++i) {
                            if (!(Math.random() * 10000.0 < enchantChance * 100.0)) continue;
                            ++enchantLevel;
                        }
                        if (enchantLevel <= 0) continue;
                        outEnchants.put(enchant, enchantLevel);
                    }
                    if (outEnchants.size() > 0) {
                        EnchantmentHelper.func_82782_a(outEnchants, (ItemStack)itemStack);
                    }
                }
                XP.dropItemStack(itemStack, player.field_70170_p, player.func_213303_ch());
                player.func_146105_b(new TranslationTextComponent("pmmo.extraFished", new Object[]{count, new TranslationTextComponent(itemStack.func_77977_a(), new Object[0])}).func_150255_a(XP.textStyle.get("green")), true);
                player.func_146105_b(new TranslationTextComponent("pmmo.extraFished", new Object[]{count, new TranslationTextComponent(itemStack.func_77977_a(), new Object[0])}).func_150255_a(XP.textStyle.get("green")), false);
                award += (Double)match.get("xp") * (double)count;
            }
            XP.awardXp(player, Skill.FISHING, "catching " + items, award, false, false, false);
        }
    }
}

