/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.events;

import harmonised.pmmo.config.Config;
import harmonised.pmmo.pmmo_saved_data.PmmoSavedData;
import harmonised.pmmo.skills.Skill;
import harmonised.pmmo.util.XP;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PlayerConnectedHandler {
    public static final Logger LOGGER = LogManager.getLogger();
    public static List<UUID> lapisPatreons = new ArrayList<UUID>();
    public static List<UUID> dandelionPatreons = new ArrayList<UUID>();
    public static List<UUID> ironPatreons = new ArrayList<UUID>();

    public static void handlePlayerConnected(PlayerEvent.PlayerLoggedInEvent event) {
        PlayerEntity player = event.getPlayer();
        if (!player.field_70170_p.func_201670_d()) {
            UUID uuid = player.func_110124_au();
            boolean showWelcome = Config.forgeConfig.showWelcome.get();
            boolean showPatreonWelcome = Config.forgeConfig.showPatreonWelcome.get();
            PmmoSavedData.get().setName(player.func_145748_c_().getString(), uuid);
            PlayerConnectedHandler.migratePlayerDataToWorldSavedData(player);
            XP.syncPlayer(player);
            PlayerConnectedHandler.awardScheduledXp(uuid);
            if (lapisPatreons.contains(uuid)) {
                player.func_184102_h().func_184103_al().func_181057_v().forEach(thePlayer -> thePlayer.func_146105_b(new TranslationTextComponent("pmmo.lapisPatreonWelcome", new Object[]{thePlayer.func_145748_c_().getString()}).func_150255_a(XP.textStyle.get("cyan")), false));
            } else if (showPatreonWelcome) {
                if (dandelionPatreons.contains(uuid)) {
                    player.func_146105_b(new TranslationTextComponent("pmmo.dandelionPatreonWelcome", new Object[]{player.func_145748_c_().getString()}).func_150255_a(XP.textStyle.get("yellow")), false);
                } else if (ironPatreons.contains(uuid)) {
                    player.func_146105_b(new TranslationTextComponent("pmmo.ironPatreonWelcome", new Object[]{player.func_145748_c_().getString()}).func_150255_a(XP.textStyle.get("grey")), false);
                }
            }
            if (showWelcome) {
                player.func_146105_b((ITextComponent)new TranslationTextComponent("pmmo.welcome", new Object[0]), false);
            }
        }
    }

    private static void migratePlayerDataToWorldSavedData(PlayerEntity player) {
        if (player.getPersistentData().func_74764_b("pmmo")) {
            Map<String, Double> map;
            CompoundNBT tag;
            CompoundNBT pmmoTag = player.getPersistentData().func_74775_l("pmmo");
            UUID uuid = player.func_110124_au();
            LOGGER.info("Migrating Player " + player.func_145748_c_().getString() + " Pmmo Data from PlayerData to WorldSavedData");
            if (pmmoTag.func_74764_b("skills")) {
                tag = pmmoTag.func_74775_l("skills");
                for (String key : tag.func_150296_c()) {
                    Skill skill = Skill.getSkill(key);
                    if (skill == Skill.INVALID_SKILL) continue;
                    skill.setXp(uuid, skill.getXp(uuid) + tag.func_74769_h(key));
                    LOGGER.info("Adding " + tag.func_74769_h(key) + " xp in " + skill.toString());
                }
            }
            if (pmmoTag.func_74764_b("preferences")) {
                tag = pmmoTag.func_74775_l("preferences");
                map = Config.getPreferencesMap(player);
                for (String key : tag.func_150296_c()) {
                    map.put(key, tag.func_74769_h(key));
                }
            }
            if (pmmoTag.func_74764_b("abilities")) {
                tag = pmmoTag.func_74775_l("abilities");
                map = Config.getAbilitiesMap(player);
                for (String key : tag.func_150296_c()) {
                    map.put(key, tag.func_74769_h(key));
                }
            }
            player.getPersistentData().func_82580_o("pmmo");
            LOGGER.info("Migrated Player " + player.func_145748_c_().getString() + " Done");
            PmmoSavedData.get().func_76186_a(true);
        }
    }

    private static void awardScheduledXp(UUID uuid) {
        Map<Skill, Double> scheduledXp = PmmoSavedData.get().getScheduledXpMap(uuid);
        if (scheduledXp.size() > 0) {
            LOGGER.info("Awarding Scheduled Xp for: " + PmmoSavedData.get().getName(uuid));
        }
        for (Map.Entry<Skill, Double> entry : scheduledXp.entrySet()) {
            entry.getKey().addXp(uuid, (double)entry.getValue(), "scheduledXp", false, false);
            LOGGER.info("+" + entry.getValue() + " in " + entry.getKey().toString());
        }
        PmmoSavedData.get().removeScheduledXpUuid(uuid);
    }
}

