/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.events;

import harmonised.pmmo.config.Config;
import harmonised.pmmo.config.JType;
import harmonised.pmmo.config.JsonConfig;
import harmonised.pmmo.network.MessageTripleTranslation;
import harmonised.pmmo.network.NetworkHandler;
import harmonised.pmmo.skills.Skill;
import harmonised.pmmo.util.DP;
import harmonised.pmmo.util.XP;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PlayerInteractionHandler {
    public static final Logger LOGGER = LogManager.getLogger();

    public static void handlePlayerInteract(PlayerInteractEvent event) {
        try {
            if (event instanceof PlayerInteractEvent.RightClickBlock || event instanceof PlayerInteractEvent.RightClickItem) {
                PlayerEntity player = event.getPlayer();
                ItemStack itemStack = event.getItemStack();
                Item item = itemStack.func_77973_b();
                Block goldBlock = Blocks.field_150340_R;
                Block smithBlock = Blocks.field_222429_lR;
                if (item.getRegistryName() == null) {
                    return;
                }
                String regKey = item.getRegistryName().toString();
                boolean isRemote = player.field_70170_p.func_201670_d();
                if (event instanceof PlayerInteractEvent.RightClickItem && XP.isPlayerSurvival(player) && JsonConfig.data2.get((Object)JType.SALVAGE).containsKey(regKey)) {
                    boolean matched = XP.scanBlock(smithBlock, 1, player);
                    if (!matched) {
                        matched = XP.scanBlock(goldBlock, 1, player);
                    }
                    if (matched) {
                        event.setCanceled(true);
                    }
                }
                if (item instanceof BlockItem) {
                    if (!XP.checkReq(player, item.getRegistryName(), JType.REQ_PLACE)) {
                        event.setCanceled(true);
                        if (isRemote) {
                            player.func_146105_b(new TranslationTextComponent("pmmo.notSkilledEnoughToPlaceDown", new Object[]{new TranslationTextComponent(item.func_77658_a(), new Object[0])}).func_150255_a(XP.textStyle.get("red")), true);
                        }
                    }
                } else if (!XP.checkReq(player, item.getRegistryName(), JType.REQ_USE)) {
                    event.setCanceled(true);
                    if (isRemote) {
                        player.func_146105_b(new TranslationTextComponent("pmmo.notSkilledEnoughToUse", new Object[]{new TranslationTextComponent(item.func_77658_a(), new Object[0])}).func_150255_a(XP.textStyle.get("red")), true);
                    }
                }
                if (event instanceof PlayerInteractEvent.RightClickBlock) {
                    Block block = player.field_70170_p.func_180495_p(event.getPos()).func_177230_c();
                    if (!XP.checkReq(player, block.getRegistryName(), JType.REQ_USE)) {
                        if (XP.isPlayerSurvival(player)) {
                            event.setCanceled(true);
                            if (isRemote && event.getHand().equals((Object)Hand.MAIN_HAND)) {
                                player.func_146105_b(new TranslationTextComponent("pmmo.notSkilledEnoughToUse", new Object[]{new TranslationTextComponent(block.func_149739_a(), new Object[0])}).func_150255_a(XP.textStyle.get("red")), true);
                                player.func_146105_b(new TranslationTextComponent("pmmo.notSkilledEnoughToUse", new Object[]{new TranslationTextComponent(block.func_149739_a(), new Object[0])}).func_150255_a(XP.textStyle.get("red")), false);
                                for (Map.Entry<String, Double> entry : JsonConfig.data.get((Object)JType.REQ_USE).get(block.getRegistryName().toString()).entrySet()) {
                                    double entryValue;
                                    int startLevel = Skill.getSkill(entry.getKey()).getLevel(player);
                                    if ((double)startLevel < (entryValue = entry.getValue().doubleValue())) {
                                        player.func_146105_b(new TranslationTextComponent("pmmo.levelDisplay", new Object[]{new TranslationTextComponent("pmmo." + entry.getKey(), new Object[0]), "" + DP.dpSoft(entryValue)}).func_150255_a(XP.textStyle.get("red")), false);
                                        continue;
                                    }
                                    player.func_146105_b(new TranslationTextComponent("pmmo.levelDisplay", new Object[]{new TranslationTextComponent("pmmo." + entry.getKey(), new Object[0]), "" + DP.dpSoft(entryValue)}).func_150255_a(XP.textStyle.get("green")), false);
                                }
                            }
                        }
                    } else {
                        event.setCanceled(false);
                        int startSmithingLevel = Skill.SMITHING.getLevel(player);
                        Integer lowestReqLevel = null;
                        if (player.func_213453_ef() && (block.equals(goldBlock) || block.equals(smithBlock))) {
                            if (item.equals(Items.field_190931_a)) {
                                return;
                            }
                            if (isRemote) {
                                return;
                            }
                            if (!event.getHand().equals((Object)Hand.OFF_HAND)) {
                                return;
                            }
                            itemStack = player.func_184592_cb();
                            item = itemStack.func_77973_b();
                            if (!JsonConfig.data2.get((Object)JType.SALVAGE).containsKey(item.getRegistryName().toString())) {
                                player.func_146105_b(new TranslationTextComponent("pmmo.cannotSalvage", new Object[]{new TranslationTextComponent(item.func_77658_a(), new Object[0])}).func_150255_a(XP.textStyle.get("red")), true);
                                return;
                            }
                            event.setCanceled(true);
                            if (!(XP.getHorizontalDistance(player.func_213303_ch(), XP.blockToMiddleVec(event.getPos())) < 2.0)) {
                                player.func_146105_b(new TranslationTextComponent("pmmo.tooFarAwayToSalvage", new Object[0]).func_150255_a(XP.textStyle.get("red")), true);
                                return;
                            }
                            if (!XP.isPlayerSurvival(player)) {
                                player.func_146105_b(new TranslationTextComponent("pmmo.survivalOnlyWarning", new Object[0]).func_150255_a(XP.textStyle.get("red")), true);
                                return;
                            }
                            Map<String, Map<String, Double>> salvageFromItemMap = JsonConfig.data2.get((Object)JType.SALVAGE).get(regKey);
                            boolean ableToSalvageAny = false;
                            double award = 0.0;
                            for (Map.Entry<String, Map<String, Double>> salvageToItemEntry : salvageFromItemMap.entrySet()) {
                                int smithingLevel = startSmithingLevel;
                                Item salvageToItem = XP.getItem(salvageToItemEntry.getKey());
                                Map<String, Double> salvageToItemMap = salvageToItemEntry.getValue();
                                double baseChance = salvageToItemMap.get("baseChance");
                                double chancePerLevel = salvageToItemMap.get("chancePerLevel");
                                double maxSalvageMaterialChance = salvageToItemMap.get("maxChance");
                                int reqLevel = (int)Math.floor(salvageToItemMap.get("levelReq"));
                                int salvageMax = (int)Math.floor(salvageToItemMap.get("salvageMax"));
                                smithingLevel -= reqLevel;
                                if (lowestReqLevel == null || lowestReqLevel > reqLevel) {
                                    lowestReqLevel = reqLevel;
                                }
                                if (smithingLevel < 0) continue;
                                ableToSalvageAny = true;
                                double chance = baseChance + chancePerLevel * (double)smithingLevel;
                                if (chance > maxSalvageMaterialChance) {
                                    chance = maxSalvageMaterialChance;
                                }
                                double startDmg = itemStack.func_77952_i();
                                double maxDmg = itemStack.func_77958_k();
                                double displayDurabilityPercent = (1.0 - startDmg / maxDmg) * 100.0;
                                double durabilityPercent = 1.0 - startDmg / maxDmg;
                                if (Double.isNaN(durabilityPercent)) {
                                    durabilityPercent = 1.0;
                                }
                                int potentialReturnAmount = (int)Math.floor((double)salvageMax * durabilityPercent);
                                int returnAmount = 0;
                                for (int i = 0; i < potentialReturnAmount; ++i) {
                                    if (!(Math.ceil(Math.random() * 10000.0) <= chance * 100.0)) continue;
                                    ++returnAmount;
                                }
                                award += salvageToItemMap.get("xpPerItem") * (double)returnAmount;
                                if (returnAmount > 0) {
                                    XP.dropItems(returnAmount, salvageToItem, event.getWorld(), event.getPos());
                                }
                                if (returnAmount == potentialReturnAmount) {
                                    NetworkHandler.sendToPlayer(new MessageTripleTranslation("pmmo.salvageMessage", "" + returnAmount, "" + potentialReturnAmount, salvageToItem.func_77658_a(), false, 1), (ServerPlayerEntity)player);
                                    continue;
                                }
                                if (returnAmount > 0) {
                                    NetworkHandler.sendToPlayer(new MessageTripleTranslation("pmmo.salvageMessage", "" + returnAmount, "" + potentialReturnAmount, salvageToItem.func_77658_a(), false, 3), (ServerPlayerEntity)player);
                                    continue;
                                }
                                NetworkHandler.sendToPlayer(new MessageTripleTranslation("pmmo.salvageMessage", "" + returnAmount, "" + potentialReturnAmount, salvageToItem.func_77658_a(), true, 2), (ServerPlayerEntity)player);
                            }
                            if (ableToSalvageAny) {
                                Map enchants = EnchantmentHelper.func_82781_a((ItemStack)itemStack);
                                double maxSalvageEnchantChance = Config.forgeConfig.maxSalvageEnchantChance.get();
                                double enchantSaveChancePerLevel = Config.forgeConfig.enchantSaveChancePerLevel.get();
                                double enchantChance = (double)(startSmithingLevel - lowestReqLevel) * enchantSaveChancePerLevel;
                                if (enchantChance > maxSalvageEnchantChance) {
                                    enchantChance = maxSalvageEnchantChance;
                                }
                                if (enchants.size() > 0) {
                                    ItemStack salvagedBook = new ItemStack((IItemProvider)Items.field_151134_bR);
                                    Set enchantKeys = enchants.keySet();
                                    HashMap<Enchantment, Integer> newEnchantMap = new HashMap<Enchantment, Integer>();
                                    boolean fullEnchants = true;
                                    for (Enchantment enchant : enchantKeys) {
                                        int enchantLevel = 0;
                                        for (int i = 1; i <= (Integer)enchants.get(enchant); ++i) {
                                            if (Math.floor(Math.random() * 100.0) < enchantChance) {
                                                enchantLevel = i;
                                                continue;
                                            }
                                            fullEnchants = false;
                                        }
                                        if (enchantLevel <= 0) continue;
                                        newEnchantMap.put(enchant, enchantLevel);
                                    }
                                    if (newEnchantMap.size() > 0) {
                                        EnchantmentHelper.func_82782_a(newEnchantMap, (ItemStack)salvagedBook);
                                        Block.func_180635_a((World)event.getWorld(), (BlockPos)event.getPos(), (ItemStack)salvagedBook);
                                        if (fullEnchants) {
                                            player.func_146105_b(new TranslationTextComponent("pmmo.savedAllEnchants", new Object[0]).func_150255_a(XP.textStyle.get("green")), false);
                                        } else {
                                            player.func_146105_b(new TranslationTextComponent("pmmo.savedSomeEnchants", new Object[0]).func_150255_a(XP.textStyle.get("yellow")), false);
                                        }
                                    }
                                }
                                if (award > 0.0) {
                                    XP.awardXp((ServerPlayerEntity)player, Skill.SMITHING, item.getRegistryName().toString(), award, false, false, false);
                                }
                                player.func_184592_cb().func_190918_g(1);
                                player.func_213334_d(Hand.OFF_HAND);
                            } else {
                                player.func_146105_b(new TranslationTextComponent("pmmo.cannotSalvageLackLevelLonger", new Object[]{lowestReqLevel, new TranslationTextComponent(item.func_77658_a(), new Object[0])}).func_150255_a(XP.textStyle.get("red")), true);
                            }
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)e);
        }
    }
}

