/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.events;

import harmonised.pmmo.config.JType;
import harmonised.pmmo.config.JsonConfig;
import harmonised.pmmo.gui.GlossaryScreen;
import harmonised.pmmo.proxy.ClientHandler;
import harmonised.pmmo.skills.Skill;
import harmonised.pmmo.util.DP;
import harmonised.pmmo.util.XP;
import java.util.List;
import java.util.Map;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TooltipHandler {
    public static final Logger LOGGER = LogManager.getLogger();
    public static boolean tooltipOn = true;
    private static String lastKey = "";
    private static int salvageFromArrayPos = 0;
    private static int salvageFromArrayLength;
    private static int salvageToArrayPos;
    private static int salvageToArrayLength;
    private static int treasureFromArrayPos;
    private static int treasureFromArrayLength;
    private static int treasureToArrayPos;
    private static int treasureToArrayLength;
    private static long lastTime;
    private static Object[] salvageFromArray;
    private static Object[] salvageToArray;
    private static Object[] treasureFromArray;
    private static Object[] treasureToArray;

    public static void handleTooltip(ItemTooltipEvent event) {
        if (!tooltipOn) {
            return;
        }
        PlayerEntity player = event.getPlayer();
        if (player != null) {
            String key;
            Map<String, Double> salvageToItemMap;
            int level;
            double dValue;
            ItemStack itemStack = event.getItemStack();
            Item item = itemStack.func_77973_b();
            List tooltip = event.getToolTip();
            if (item.getRegistryName() == null) {
                return;
            }
            String regKey = item.getRegistryName().toString();
            Material material = null;
            if (ClientHandler.OPEN_MENU.func_151470_d()) {
                GlossaryScreen.setButtonsToKey(regKey);
                Minecraft.func_71410_x().func_147108_a((Screen)new GlossaryScreen(Minecraft.func_71410_x().field_71439_g.func_110124_au(), (ITextComponent)new TranslationTextComponent("pmmo.glossary", new Object[0]), false));
                return;
            }
            Map<String, Double> craftReq = JsonConfig.data.get((Object)JType.REQ_CRAFT).get(regKey);
            Map<String, Double> wearReq = JsonConfig.data.get((Object)JType.REQ_WEAR).get(regKey);
            Map<String, Double> toolReq = JsonConfig.data.get((Object)JType.REQ_TOOL).get(regKey);
            Map<String, Double> weaponReq = JsonConfig.data.get((Object)JType.REQ_WEAPON).get(regKey);
            Map<String, Double> useReq = JsonConfig.data.get((Object)JType.REQ_USE).get(regKey);
            Map<String, Double> placeReq = JsonConfig.data.get((Object)JType.REQ_PLACE).get(regKey);
            Map<String, Double> breakReq = JsonConfig.data.get((Object)JType.REQ_BREAK).get(regKey);
            Map<String, Double> xpValueGeneral = JsonConfig.data.get((Object)JType.XP_VALUE_GENERAL).get(regKey);
            Map<String, Double> xpValueBreaking = JsonConfig.data.get((Object)JType.XP_VALUE_BREAK).get(regKey);
            Map<String, Double> xpValueCrafting = JsonConfig.data.get((Object)JType.XP_VALUE_CRAFT).get(regKey);
            Map<String, Double> xpValueSmelting = JsonConfig.data.get((Object)JType.XP_VALUE_SMELT).get(regKey);
            Map<String, Double> xpValueCooking = JsonConfig.data.get((Object)JType.XP_VALUE_COOK).get(regKey);
            Map<String, Double> xpValueBrewing = JsonConfig.data.get((Object)JType.XP_VALUE_BREW).get(regKey);
            Map<String, Double> xpValueGrowing = JsonConfig.data.get((Object)JType.XP_VALUE_GROW).get(regKey);
            Map<String, Map<String, Double>> salvageInfo = JsonConfig.data2.get((Object)JType.SALVAGE).get(regKey);
            Map<String, Map<String, Double>> salvageFrom = JsonConfig.data2.get((Object)JType.SALVAGE_FROM).get(regKey);
            Map<String, Map<String, Double>> treasureInfo = JsonConfig.data2.get((Object)JType.TREASURE).get(regKey);
            Map<String, Map<String, Double>> treasureFromInfo = JsonConfig.data2.get((Object)JType.TREASURE_FROM).get(regKey);
            Map<String, Double> heldItemXpBoost = JsonConfig.data.get((Object)JType.XP_BONUS_HELD).get(regKey);
            Map<String, Double> wornItemXpBoost = JsonConfig.data.get((Object)JType.XP_BONUS_WORN).get(regKey);
            if (item instanceof BlockItem) {
                material = ((BlockItem)item).func_179223_d().func_176223_P().func_185904_a();
                float hardness = ((BlockItem)item).func_179223_d().func_176223_P().func_185887_b(null, null);
                if (hardness > 0.0f) {
                    tooltip.add(new TranslationTextComponent("pmmo.levelDisplay", new Object[]{" " + new TranslationTextComponent("pmmo.hardness", new Object[]{DP.dp(Float.valueOf(hardness))}).getString()}));
                }
            }
            if (xpValueGeneral != null && xpValueGeneral.size() > 0) {
                tooltip.add(new TranslationTextComponent("pmmo.xpValue", new Object[0]));
                for (String key2 : xpValueGeneral.keySet()) {
                    dValue = xpValueGeneral.get(key2);
                    tooltip.add(new TranslationTextComponent("pmmo.levelDisplay", new Object[]{" " + new TranslationTextComponent("pmmo." + key2, new Object[0]).getString(), DP.dp(dValue)}).func_150255_a(XP.getSkillStyle(Skill.getSkill(key2))));
                }
            }
            if (xpValueBreaking != null && xpValueBreaking.size() > 0) {
                tooltip.add(new TranslationTextComponent("pmmo.xpValueBreak", new Object[0]));
                for (String key2 : xpValueBreaking.keySet()) {
                    dValue = xpValueBreaking.get(key2);
                    tooltip.add(new TranslationTextComponent("pmmo.levelDisplay", new Object[]{" " + new TranslationTextComponent("pmmo." + key2, new Object[0]).getString(), DP.dp(dValue)}).func_150255_a(XP.getSkillStyle(Skill.getSkill(key2))));
                }
            }
            if (xpValueCrafting != null && xpValueCrafting.size() > 0) {
                tooltip.add(new TranslationTextComponent("pmmo.xpValueCraft", new Object[0]));
                for (String key2 : xpValueCrafting.keySet()) {
                    dValue = xpValueCrafting.get(key2);
                    tooltip.add(new TranslationTextComponent("pmmo.levelDisplay", new Object[]{" " + new TranslationTextComponent("pmmo." + key2, new Object[0]).getString(), DP.dp(dValue)}).func_150255_a(XP.getSkillStyle(Skill.getSkill(key2))));
                }
            }
            if (xpValueSmelting != null && xpValueSmelting.size() > 0) {
                tooltip.add(new TranslationTextComponent("pmmo.xpValueSmelt", new Object[0]));
                for (String key2 : xpValueSmelting.keySet()) {
                    dValue = xpValueSmelting.get(key2);
                    tooltip.add(new TranslationTextComponent("pmmo.levelDisplay", new Object[]{" " + new TranslationTextComponent("pmmo." + key2, new Object[0]).getString(), DP.dp(dValue)}).func_150255_a(XP.getSkillStyle(Skill.getSkill(key2))));
                }
            }
            if (xpValueCooking != null && xpValueCooking.size() > 0) {
                tooltip.add(new TranslationTextComponent("pmmo.xpValueCook", new Object[0]));
                for (String key2 : xpValueCooking.keySet()) {
                    dValue = xpValueCooking.get(key2);
                    tooltip.add(new TranslationTextComponent("pmmo.levelDisplay", new Object[]{" " + new TranslationTextComponent("pmmo." + key2, new Object[0]).getString(), DP.dp(dValue)}).func_150255_a(XP.getSkillStyle(Skill.getSkill(key2))));
                }
            }
            if (xpValueBrewing != null && xpValueBrewing.size() > 0) {
                tooltip.add(new TranslationTextComponent("pmmo.xpValueBrew", new Object[0]));
                for (String key2 : xpValueBrewing.keySet()) {
                    dValue = xpValueBrewing.get(key2);
                    tooltip.add(new TranslationTextComponent("pmmo.levelDisplay", new Object[]{" " + new TranslationTextComponent("pmmo." + key2, new Object[0]).getString(), DP.dp(dValue)}).func_150255_a(XP.getSkillStyle(Skill.getSkill(key2))));
                }
            }
            if (xpValueGrowing != null && xpValueGrowing.size() > 0) {
                tooltip.add(new TranslationTextComponent("pmmo.xpValueGrow", new Object[0]));
                for (String key2 : xpValueGrowing.keySet()) {
                    dValue = xpValueGrowing.get(key2);
                    tooltip.add(new TranslationTextComponent("pmmo.levelDisplay", new Object[]{" " + new TranslationTextComponent("pmmo." + key2, new Object[0]).getString(), DP.dp(dValue)}).func_150255_a(XP.getSkillStyle(Skill.getSkill(key2))));
                }
            }
            if (craftReq != null && craftReq.size() > 0) {
                TooltipHandler.addTooltipTextSkill("pmmo.toCraft", JType.REQ_CRAFT, craftReq, event);
            }
            if (wearReq != null && wearReq.size() > 0) {
                TooltipHandler.addTooltipTextSkill("pmmo.toWear", JType.REQ_WEAR, wearReq, event);
            }
            if (wornItemXpBoost != null && wornItemXpBoost.size() > 0) {
                TooltipHandler.addTooltipTextSkillPercentage("pmmo.itemXpBoostWorn", wornItemXpBoost, event);
            }
            if (toolReq != null && toolReq.size() > 0) {
                TooltipHandler.addTooltipTextSkill("pmmo.tool", JType.REQ_TOOL, toolReq, event);
            }
            if (weaponReq != null && weaponReq.size() > 0) {
                TooltipHandler.addTooltipTextSkill("pmmo.weapon", JType.REQ_WEAPON, weaponReq, event);
            }
            if (heldItemXpBoost != null && heldItemXpBoost.size() > 0) {
                TooltipHandler.addTooltipTextSkillPercentage("pmmo.itemXpBoostHeld", heldItemXpBoost, event);
            }
            if (useReq != null && useReq.size() > 0) {
                TooltipHandler.addTooltipTextSkill("pmmo.use", JType.REQ_USE, useReq, event);
            }
            if (placeReq != null && placeReq.size() > 0) {
                if (JsonConfig.data.get((Object)JType.INFO_PLANT).containsKey(item.getRegistryName().toString()) || item instanceof IPlantable) {
                    TooltipHandler.addTooltipTextSkill("pmmo.plant", JType.REQ_PLACE, placeReq, event);
                } else {
                    TooltipHandler.addTooltipTextSkill("pmmo.place", JType.REQ_PLACE, placeReq, event);
                }
            }
            if (breakReq != null && breakReq.size() > 0) {
                if (XP.correctHarvestTool(material).equals("axe")) {
                    TooltipHandler.addTooltipTextSkill("pmmo.chop", JType.REQ_BREAK, breakReq, event);
                } else if (JsonConfig.data.get((Object)JType.INFO_PLANT).containsKey(item.getRegistryName().toString()) || item instanceof IPlantable) {
                    TooltipHandler.addTooltipTextSkill("pmmo.harvest", JType.REQ_BREAK, breakReq, event);
                } else {
                    TooltipHandler.addTooltipTextSkill("pmmo.break", JType.REQ_BREAK, breakReq, event);
                }
            }
            if (JsonConfig.data.get((Object)JType.INFO_ORE).containsKey(regKey) && JsonConfig.data.get((Object)JType.INFO_ORE).get(regKey).containsKey("extraChance")) {
                dValue = XP.getExtraChance(player.func_110124_au(), item.getRegistryName(), JType.INFO_ORE, true);
                if (dValue > 0.0) {
                    tooltip.add(new TranslationTextComponent("pmmo.oreExtraDrop", new Object[]{DP.dp(dValue / 100.0)}).func_150255_a(XP.textStyle.get("green")));
                } else {
                    tooltip.add(new TranslationTextComponent("pmmo.oreExtraDrop", new Object[]{0}).func_150255_a(XP.textStyle.get("red")));
                }
            }
            if (JsonConfig.data.get((Object)JType.INFO_LOG).containsKey(regKey) && JsonConfig.data.get((Object)JType.INFO_LOG).get(regKey).containsKey("extraChance")) {
                dValue = XP.getExtraChance(player.func_110124_au(), item.getRegistryName(), JType.INFO_LOG, true);
                if (dValue > 0.0) {
                    tooltip.add(new TranslationTextComponent("pmmo.logExtraDrop", new Object[]{DP.dp(dValue / 100.0)}).func_150255_a(XP.textStyle.get("green")));
                } else {
                    tooltip.add(new TranslationTextComponent("pmmo.logExtraDrop", new Object[]{0}).func_150255_a(XP.textStyle.get("red")));
                }
            }
            if (JsonConfig.data.get((Object)JType.INFO_PLANT).containsKey(regKey) && JsonConfig.data.get((Object)JType.INFO_PLANT).get(regKey).containsKey("extraChance")) {
                dValue = XP.getExtraChance(player.func_110124_au(), item.getRegistryName(), JType.INFO_PLANT, true);
                if (dValue > 0.0) {
                    tooltip.add(new TranslationTextComponent("pmmo.plantExtraDrop", new Object[]{DP.dp(dValue / 100.0)}).func_150255_a(XP.textStyle.get("green")));
                } else {
                    tooltip.add(new TranslationTextComponent("pmmo.plantExtraDrop", new Object[]{0}).func_150255_a(XP.textStyle.get("red")));
                }
            }
            if (JsonConfig.data.get((Object)JType.INFO_SMELT).containsKey(regKey) && JsonConfig.data.get((Object)JType.INFO_SMELT).get(regKey).containsKey("extraChance")) {
                dValue = XP.getExtraChance(player.func_110124_au(), item.getRegistryName(), JType.INFO_SMELT, true);
                if (dValue > 0.0) {
                    tooltip.add(new TranslationTextComponent("pmmo.smeltExtraDrop", new Object[]{DP.dp(dValue / 100.0)}).func_150255_a(XP.textStyle.get("green")));
                } else {
                    tooltip.add(new TranslationTextComponent("pmmo.smeltExtraDrop", new Object[]{0}).func_150255_a(XP.textStyle.get("red")));
                }
            }
            if (JsonConfig.data.get((Object)JType.INFO_COOK).containsKey(regKey) && JsonConfig.data.get((Object)JType.INFO_COOK).get(regKey).containsKey("extraChance")) {
                dValue = XP.getExtraChance(player.func_110124_au(), item.getRegistryName(), JType.INFO_COOK, true);
                if (dValue > 0.0) {
                    tooltip.add(new TranslationTextComponent("pmmo.cookExtraDrop", new Object[]{DP.dp(dValue / 100.0)}).func_150255_a(XP.textStyle.get("green")));
                } else {
                    tooltip.add(new TranslationTextComponent("pmmo.cookExtraDrop", new Object[]{0}).func_150255_a(XP.textStyle.get("red")));
                }
            }
            if (JsonConfig.data.get((Object)JType.INFO_BREW).containsKey(regKey) && JsonConfig.data.get((Object)JType.INFO_BREW).get(regKey).containsKey("extraChance")) {
                dValue = XP.getExtraChance(player.func_110124_au(), item.getRegistryName(), JType.INFO_BREW, true);
                if (dValue > 0.0) {
                    tooltip.add(new TranslationTextComponent("pmmo.brewExtraDrop", new Object[]{DP.dp(dValue / 100.0)}).func_150255_a(XP.textStyle.get("green")));
                } else {
                    tooltip.add(new TranslationTextComponent("pmmo.brewExtraDrop", new Object[]{0}).func_150255_a(XP.textStyle.get("red")));
                }
            }
            if (System.nanoTime() - lastTime > 900000000L) {
                lastTime = System.nanoTime();
                if (++salvageToArrayPos >= salvageToArrayLength) {
                    salvageToArrayPos = 0;
                }
                if (++salvageFromArrayPos >= salvageFromArrayLength) {
                    salvageFromArrayPos = 0;
                }
                if (++treasureToArrayPos >= treasureToArrayLength) {
                    treasureToArrayPos = 0;
                }
                if (++treasureFromArrayPos >= treasureFromArrayLength) {
                    treasureFromArrayPos = 0;
                }
            }
            if (!lastKey.equals(regKey)) {
                if (salvageInfo != null) {
                    salvageToArray = salvageInfo.keySet().toArray();
                    salvageToArrayLength = salvageToArray.length;
                    salvageToArrayPos = 0;
                }
                if (salvageFrom != null) {
                    salvageFromArray = salvageFrom.keySet().toArray();
                    salvageFromArrayLength = salvageFromArray.length;
                    salvageFromArrayPos = 0;
                }
                if (treasureInfo != null) {
                    treasureToArray = treasureInfo.keySet().toArray();
                    treasureToArrayLength = treasureToArray.length;
                    treasureToArrayPos = 0;
                }
                if (treasureFromInfo != null) {
                    treasureFromArray = treasureFromInfo.keySet().toArray();
                    treasureFromArrayLength = treasureFromArray.length;
                    treasureFromArrayPos = 0;
                }
                lastKey = regKey;
            }
            if (salvageInfo != null && salvageInfo.size() > 0) {
                try {
                    level = Skill.SMITHING.getLevel(player);
                    String key3 = (String)salvageToArray[salvageToArrayPos];
                    salvageToItemMap = salvageInfo.get(key3);
                    int reqLevel = (int)Math.floor(salvageToItemMap.get("levelReq"));
                    int finalLevel = level - reqLevel;
                    double baseChance = salvageToItemMap.get("baseChance");
                    double xpPerItem = salvageToItemMap.get("xpPerItem");
                    double chancePerLevel = salvageToItemMap.get("chancePerLevel");
                    double maxSalvageMaterialChance = salvageToItemMap.get("maxChance");
                    double chance = baseChance + chancePerLevel * (double)finalLevel;
                    if (chance > maxSalvageMaterialChance) {
                        chance = maxSalvageMaterialChance;
                    }
                    int salvageMax = (int)Math.floor(salvageToItemMap.get("salvageMax"));
                    double durabilityPercent = 1.0 - (double)itemStack.func_77952_i() / (double)itemStack.func_77958_k();
                    if (Double.isNaN(durabilityPercent)) {
                        durabilityPercent = 1.0;
                    }
                    int potentialReturnAmount = (int)Math.floor((double)salvageMax * durabilityPercent);
                    Item salvageItem = XP.getItem(key3);
                    if (finalLevel < 0) {
                        tooltip.add(new TranslationTextComponent("pmmo.cannotSalvageLackLevel", new Object[]{reqLevel}).func_150255_a(XP.textStyle.get("red")));
                    } else {
                        tooltip.add(new TranslationTextComponent("pmmo.salvagesIntoCountItem", new Object[]{potentialReturnAmount, new TranslationTextComponent(salvageItem.func_77658_a(), new Object[0])}).func_150255_a(XP.textStyle.get(potentialReturnAmount > 0 ? "green" : "red")));
                        tooltip.add(new TranslationTextComponent("pmmo.xpEachChanceEach", new Object[]{" " + DP.dp(xpPerItem), DP.dp(chance)}).func_150255_a(XP.textStyle.get(chance > 0.0 ? "green" : "red")));
                    }
                }
                catch (Exception e) {
                    LOGGER.error((Object)e);
                }
            }
            if (salvageFrom != null) {
                try {
                    tooltip.add(new TranslationTextComponent("pmmo.canBeSalvagedFrom", new Object[0]).func_150255_a(XP.textStyle.get("green")));
                    level = Skill.SMITHING.getLevel(player);
                    key = (String)salvageFromArray[salvageFromArrayPos];
                    String displayName = new TranslationTextComponent(XP.getItem(key).func_77658_a(), new Object[0]).getString();
                    Map<String, Double> salvageFromMap = salvageFrom.get(key);
                    tooltip.add(new TranslationTextComponent("pmmo.valueFromValue", new Object[]{" " + (int)salvageFromMap.get("salvageMax").doubleValue(), displayName}).func_150255_a(XP.textStyle.get(salvageFromMap.get("levelReq") > (double)level ? "red" : "green")));
                }
                catch (Exception e) {
                    LOGGER.error((Object)e);
                }
            }
            if (treasureInfo != null && treasureInfo.size() > 0) {
                try {
                    level = Skill.EXCAVATION.getLevel(player);
                    String key4 = (String)treasureToArray[treasureToArrayPos];
                    salvageToItemMap = treasureInfo.get(key4);
                    double chance = DP.mapCapped(level, salvageToItemMap.get("startLevel"), salvageToItemMap.get("endLevel"), salvageToItemMap.get("startChance"), salvageToItemMap.get("endChance"));
                    double xpPerItem = salvageToItemMap.get("xpPerItem");
                    String itemName = new TranslationTextComponent(XP.getItem(key4).func_77658_a(), new Object[0]).getString();
                    int minCount = (int)salvageToItemMap.get("minCount").doubleValue();
                    int maxCount = (int)salvageToItemMap.get("maxCount").doubleValue();
                    if (chance > 100.0) {
                        chance = 100.0;
                    }
                    if (chance <= 0.0) {
                        chance = 0.0;
                    }
                    tooltip.add(new TranslationTextComponent("pmmo.containsCountItemTreasure", new Object[]{minCount == maxCount ? Integer.valueOf(minCount) : minCount + "-" + maxCount, itemName}).func_150255_a(XP.textStyle.get("green")));
                    tooltip.add(new TranslationTextComponent("pmmo.xpEachChance", new Object[]{" " + DP.dp(xpPerItem), DP.dp(chance)}).func_150255_a(XP.textStyle.get(chance > 0.0 ? "green" : "red")));
                }
                catch (Exception e) {
                    LOGGER.error((Object)e);
                }
            }
            if (treasureFromInfo != null) {
                try {
                    tooltip.add(new TranslationTextComponent("pmmo.treasureFrom", new Object[0]).func_150255_a(XP.textStyle.get("green")));
                    level = Skill.EXCAVATION.getLevel(player);
                    key = (String)treasureFromArray[treasureFromArrayPos];
                    String displayName = new TranslationTextComponent(XP.getItem(key).func_77658_a(), new Object[0]).getString();
                    Map<String, Double> treasureFromMap = treasureFromInfo.get(key);
                    Map<String, Double> treasureToMap = JsonConfig.data2.get((Object)JType.TREASURE).get(key).get(regKey);
                    int minCount = (int)treasureFromMap.get("minCount").doubleValue();
                    int maxCount = (int)treasureFromMap.get("maxCount").doubleValue();
                    double chance = DP.mapCapped(level, treasureToMap.get("startLevel"), treasureToMap.get("endLevel"), treasureToMap.get("startChance"), treasureToMap.get("endChance"));
                    tooltip.add(new TranslationTextComponent("pmmo.valueFromValue", new Object[]{" " + (minCount == maxCount ? Integer.valueOf(minCount) : minCount + "-" + maxCount), displayName}).func_150255_a(XP.textStyle.get(chance > 0.0 ? "green" : "red")));
                }
                catch (Exception e) {
                    LOGGER.error((Object)e);
                }
            }
        }
    }

    private static void addTooltipTextSkill(String tKey, JType jType, Map<String, Double> theMap, ItemTooltipEvent event) {
        PlayerEntity player = event.getPlayer();
        List tooltip = event.getToolTip();
        Item item = event.getItemStack().func_77973_b();
        if (theMap.size() > 0) {
            tooltip.add(new TranslationTextComponent(tKey, new Object[0]).func_150255_a(XP.textStyle.get(XP.checkReq(player, item.getRegistryName(), jType) ? "green" : "red")));
            for (String key : theMap.keySet()) {
                double level = Skill.getSkill(key).getLevel(player);
                double value = theMap.get(key);
                tooltip.add(new TranslationTextComponent("pmmo.levelDisplay", new Object[]{" " + new TranslationTextComponent("pmmo." + key, new Object[0]).getString(), DP.dpSoft(value)}).func_150255_a(XP.textStyle.get(level < value ? "red" : "green")));
            }
        }
    }

    private static void addTooltipTextSkillPercentage(String tKey, Map<String, Double> theMap, ItemTooltipEvent event) {
        List tooltip = event.getToolTip();
        if (theMap.size() > 0) {
            tooltip.add(new TranslationTextComponent(tKey, new Object[0]).func_150255_a(XP.textStyle.get("green")));
            for (String key : theMap.keySet()) {
                double value = theMap.get(key);
                if (value < 0.0) {
                    tooltip.add(new TranslationTextComponent("pmmo.levelDisplayPercentage", new Object[]{" " + DP.dp(value), new TranslationTextComponent("pmmo." + key, new Object[0]).getString()}).func_150255_a(XP.textStyle.get("red")));
                    continue;
                }
                tooltip.add(new TranslationTextComponent("pmmo.levelDisplayPercentage", new Object[]{" +" + DP.dp(value), new TranslationTextComponent("pmmo." + key, new Object[0]).getString()}).func_150255_a(XP.getSkillStyle(Skill.getSkill(key))));
            }
        }
    }

    static {
        salvageToArrayPos = 0;
        treasureFromArrayPos = 0;
        treasureToArrayPos = 0;
        lastTime = System.nanoTime();
    }
}

