/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.events;

import harmonised.pmmo.config.Config;
import harmonised.pmmo.config.JType;
import harmonised.pmmo.config.JsonConfig;
import harmonised.pmmo.events.ChunkDataHandler;
import harmonised.pmmo.network.MessageUpdateBoolean;
import harmonised.pmmo.network.MessageUpdatePlayerNBT;
import harmonised.pmmo.network.NetworkHandler;
import harmonised.pmmo.skills.Skill;
import harmonised.pmmo.skills.VeinInfo;
import harmonised.pmmo.util.NBTHelper;
import harmonised.pmmo.util.XP;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WorldTickHandler {
    public static final Logger LOGGER = LogManager.getLogger();
    public static Map<PlayerEntity, VeinInfo> activeVein;
    public static Map<PlayerEntity, ArrayList<BlockPos>> veinSet;
    private static double minVeinCost;
    private static double minVeinHardness;
    private static double levelsPerHardnessMining;
    private static double levelsPerHardnessWoodcutting;
    private static double levelsPerHardnessExcavation;
    private static double levelsPerHardnessFarming;
    private static double levelsPerHardnessCrafting;
    private static double veinMaxBlocks;
    private static double maxVeinCharge;
    private static double exhaustionPerBlock;
    private static int veinMaxDistance;

    public static void refreshVein() {
        activeVein = new HashMap<PlayerEntity, VeinInfo>();
        veinSet = new HashMap<PlayerEntity, ArrayList<BlockPos>>();
        minVeinCost = Config.getConfig("minVeinCost");
        minVeinHardness = Config.getConfig("minVeinHardness");
        levelsPerHardnessMining = Config.getConfig("levelsPerHardnessMining");
        levelsPerHardnessWoodcutting = Config.getConfig("levelsPerHardnessWoodcutting");
        levelsPerHardnessExcavation = Config.getConfig("levelsPerHardnessExcavation");
        levelsPerHardnessFarming = Config.getConfig("levelsPerHardnessFarming");
        levelsPerHardnessCrafting = Config.getConfig("levelsPerHardnessCrafting");
        veinMaxDistance = (int)Math.floor(Config.forgeConfig.veinMaxDistance.get());
        exhaustionPerBlock = Config.forgeConfig.exhaustionPerBlock.get();
        veinMaxBlocks = Config.forgeConfig.veinMaxBlocks.get().intValue();
        maxVeinCharge = Config.forgeConfig.maxVeinCharge.get();
    }

    public static void handleWorldTick(TickEvent.WorldTickEvent event) {
        int veinSpeed = (int)Math.floor(Config.forgeConfig.veinSpeed.get().intValue());
        int age = -1;
        int maxAge = -2;
        if (event.world.func_73046_m() == null) {
            return;
        }
        for (PlayerEntity player : event.world.func_73046_m().func_184103_al().func_181057_v()) {
            UUID playerUUID = player.func_110124_au();
            for (int i = 0; i < veinSpeed; ++i) {
                if (activeVein.containsKey(player) && veinSet.get(player).size() > 0) {
                    VeinInfo veinInfo = activeVein.get(player);
                    World world = veinInfo.world;
                    ItemStack startItemStack = veinInfo.itemStack;
                    Item startItem = veinInfo.startItem;
                    BlockPos veinPos = veinSet.get(player).get(0);
                    BlockState veinState = world.func_180495_p(veinPos);
                    Map<String, Double> abilitiesMap = Config.getAbilitiesMap(player);
                    String regKey = veinState.func_177230_c().getRegistryName().toString();
                    double cost = WorldTickHandler.getVeinCost(veinState, veinPos, player);
                    boolean correctBlock = world.func_180495_p(veinPos).func_177230_c().equals(veinInfo.state.func_177230_c());
                    boolean correctItem = !startItem.func_77645_m() || startItemStack.func_77952_i() < startItemStack.func_77958_k();
                    boolean correctHeldItem = player.func_184614_ca().func_77973_b().equals(startItem);
                    UUID blockUUID = ChunkDataHandler.checkPos(world.field_73011_w.func_186058_p().getRegistryName(), veinPos);
                    boolean isOwner = blockUUID == null || blockUUID.equals(playerUUID);
                    Skill skill = XP.getSkill(veinState);
                    if (!(!skill.equals((Object)Skill.FARMING) || JsonConfig.data.get((Object)JType.BLOCK_SPECIFIC).containsKey(regKey) && JsonConfig.data.get((Object)JType.BLOCK_SPECIFIC).get(regKey).containsKey("growsUpwards"))) {
                        if (veinState.func_196959_b((IProperty)BlockStateProperties.field_222512_Y)) {
                            age = (Integer)veinState.func_177229_b((IProperty)BlockStateProperties.field_222512_Y);
                            maxAge = 1;
                        } else if (veinState.func_196959_b((IProperty)BlockStateProperties.field_208167_T)) {
                            age = (Integer)veinState.func_177229_b((IProperty)BlockStateProperties.field_208167_T);
                            maxAge = 2;
                        } else if (veinState.func_196959_b((IProperty)BlockStateProperties.field_208168_U)) {
                            age = (Integer)veinState.func_177229_b((IProperty)BlockStateProperties.field_208168_U);
                            maxAge = 3;
                        } else if (veinState.func_196959_b((IProperty)BlockStateProperties.field_208169_V)) {
                            age = (Integer)veinState.func_177229_b((IProperty)BlockStateProperties.field_208169_V);
                            maxAge = 5;
                        } else if (veinState.func_196959_b((IProperty)BlockStateProperties.field_208170_W)) {
                            age = (Integer)veinState.func_177229_b((IProperty)BlockStateProperties.field_208170_W);
                            maxAge = 7;
                        } else if (veinState.func_196959_b((IProperty)BlockStateProperties.field_208171_X)) {
                            age = (Integer)veinState.func_177229_b((IProperty)BlockStateProperties.field_208171_X);
                            maxAge = 15;
                        } else if (veinState.func_196959_b((IProperty)BlockStateProperties.field_208172_Y)) {
                            age = (Integer)veinState.func_177229_b((IProperty)BlockStateProperties.field_208172_Y);
                            maxAge = 25;
                        } else if (veinState.func_196959_b((IProperty)BlockStateProperties.field_208135_aj)) {
                            age = (Integer)veinState.func_177229_b((IProperty)BlockStateProperties.field_208135_aj);
                            maxAge = 4;
                        }
                        if (age >= 0 && age != maxAge) {
                            veinSet.get(player).remove(0);
                            return;
                        }
                    }
                    if ((abilitiesMap.get("veinLeft") >= cost || player.func_184812_l_()) && XP.isVeining.contains(player.func_110124_au())) {
                        veinSet.get(player).remove(0);
                        BlockEvent.BreakEvent veinEvent = new BlockEvent.BreakEvent(world, veinPos, veinState, player);
                        MinecraftForge.EVENT_BUS.post((Event)veinEvent);
                        if (veinEvent.isCanceled() || !correctBlock) continue;
                        if (player.func_184812_l_()) {
                            world.func_175655_b(veinPos, false);
                            continue;
                        }
                        if (correctItem && correctHeldItem && player.func_71024_bL().func_75116_a() > 0) {
                            if (!Config.forgeConfig.veiningOtherPlayerBlocksAllowed.get().booleanValue() && !isOwner) continue;
                            abilitiesMap.put("veinLeft", abilitiesMap.get("veinLeft") - cost);
                            WorldTickHandler.destroyBlock(world, veinPos, player, startItemStack);
                            player.func_71020_j((float)exhaustionPerBlock);
                            continue;
                        }
                        activeVein.remove(player);
                        veinSet.remove(player);
                        NetworkHandler.sendToPlayer(new MessageUpdateBoolean(false, 0), (ServerPlayerEntity)player);
                        continue;
                    }
                    activeVein.remove(player);
                    veinSet.remove(player);
                    NetworkHandler.sendToPlayer(new MessageUpdateBoolean(false, 0), (ServerPlayerEntity)player);
                    continue;
                }
                activeVein.remove(player);
                veinSet.remove(player);
                NetworkHandler.sendToPlayer(new MessageUpdateBoolean(false, 0), (ServerPlayerEntity)player);
            }
        }
    }

    public static void destroyBlock(World world, BlockPos pos, PlayerEntity player, ItemStack toolUsed) {
        BlockState blockstate = world.func_180495_p(pos);
        IFluidState ifluidstate = world.func_204610_c(pos);
        world.func_217379_c(2001, pos, Block.func_196246_j((BlockState)blockstate));
        TileEntity tileentity = blockstate.hasTileEntity() ? world.func_175625_s(pos) : null;
        Block.func_220054_a((BlockState)blockstate, (World)world, (BlockPos)pos, (TileEntity)tileentity, (Entity)player, (ItemStack)toolUsed);
        if (world.func_180501_a(pos, ifluidstate.func_206883_i(), 3) && toolUsed.func_77984_f() && !player.func_184812_l_()) {
            toolUsed.func_222118_a(1, (LivingEntity)player, a -> a.func_213334_d(Hand.MAIN_HAND));
        }
    }

    public static void scheduleVein(PlayerEntity player, VeinInfo veinInfo) {
        double veinLeft = Config.getAbilitiesMap(player).getOrDefault("veinLeft", 0.0);
        double veinCost = WorldTickHandler.getVeinCost(veinInfo.state, veinInfo.pos, player);
        String blockKey = veinInfo.state.func_177230_c().getRegistryName().toString();
        if (!(WorldTickHandler.canVeinGlobal(blockKey, player) && WorldTickHandler.canVeinDimension(blockKey, player) && XP.checkReq(player, player.func_184614_ca().func_77973_b().getRegistryName(), JType.REQ_TOOL))) {
            return;
        }
        ArrayList<BlockPos> blockPosArrayList = WorldTickHandler.getVeinShape(veinInfo, veinLeft, veinCost, player.func_184812_l_(), false);
        if (blockPosArrayList.size() > 0) {
            activeVein.put(player, veinInfo);
            veinSet.put(player, blockPosArrayList);
            NetworkHandler.sendToPlayer(new MessageUpdateBoolean(true, 0), (ServerPlayerEntity)player);
        }
    }

    public static boolean canVeinGlobal(String blockKey, PlayerEntity player) {
        if (player.func_184812_l_()) {
            return true;
        }
        Map<String, Double> globalBlacklist = null;
        if (JsonConfig.data.get((Object)JType.VEIN_BLACKLIST).containsKey("all_dimensions")) {
            globalBlacklist = JsonConfig.data.get((Object)JType.VEIN_BLACKLIST).get("all_dimensions");
        }
        return globalBlacklist == null || !globalBlacklist.containsKey(blockKey);
    }

    public static boolean canVeinDimension(String blockKey, PlayerEntity player) {
        if (player.func_184812_l_()) {
            return true;
        }
        World world = player.field_70170_p;
        if (world == null) {
            return true;
        }
        ResourceLocation dimensionKey = world.field_73011_w.func_186058_p().getRegistryName();
        if (dimensionKey == null) {
            return true;
        }
        Map<String, Double> dimensionBlacklist = null;
        if (JsonConfig.data.get((Object)JType.VEIN_BLACKLIST).containsKey(dimensionKey.toString())) {
            dimensionBlacklist = JsonConfig.data.get((Object)JType.VEIN_BLACKLIST).get(dimensionKey.toString());
        }
        return dimensionBlacklist == null || !dimensionBlacklist.containsKey(blockKey);
    }

    private static ArrayList<BlockPos> getVeinShape(VeinInfo veinInfo, double veinLeft, double veinCost, boolean isCreative, boolean isLooped) {
        BlockPos originPos;
        HashSet<BlockPos> vein = new HashSet<BlockPos>();
        ArrayList<BlockPos> outVein = new ArrayList<BlockPos>();
        ArrayList<BlockPos> curLayer = new ArrayList<BlockPos>();
        ArrayList<BlockPos> nextLayer = new ArrayList<BlockPos>();
        BlockPos highestPos = originPos = veinInfo.pos;
        curLayer.add(originPos);
        Block block = veinInfo.state.func_177230_c();
        Material material = veinInfo.state.func_185904_a();
        String regKey = block.getRegistryName().toString();
        Skill skill = XP.getSkill(material);
        int yLimit = 1;
        if (JsonConfig.data.get((Object)JType.BLOCK_SPECIFIC).containsKey(regKey) && JsonConfig.data.get((Object)JType.BLOCK_SPECIFIC).get(regKey).containsKey("growsUpwards")) {
            yLimit = 0;
        }
        while ((isCreative || veinLeft * 10.0 > veinCost * (double)vein.size() || Config.forgeConfig.veinWoodTopToBottom.get().booleanValue() && !isLooped && skill.equals((Object)Skill.WOODCUTTING)) && (double)vein.size() <= veinMaxBlocks) {
            for (BlockPos curPos : curLayer) {
                if (!curPos.func_218141_a((Vec3i)originPos, (double)veinMaxDistance)) continue;
                for (int i = yLimit; i >= -yLimit; --i) {
                    for (int j = 1; j >= -1; --j) {
                        for (int k = 1; k >= -1; --k) {
                            BlockPos curPos2 = curPos.func_177981_b(i).func_177964_d(j).func_177965_g(k);
                            if (vein.contains(curPos2) || !veinInfo.world.func_180495_p(curPos2).func_177230_c().equals(block)) continue;
                            vein.add(curPos2);
                            outVein.add(curPos2);
                            nextLayer.add(curPos2);
                            if (curPos2.func_177956_o() <= highestPos.func_177956_o()) continue;
                            highestPos = new BlockPos((Vec3i)curPos2);
                        }
                    }
                }
            }
            if (nextLayer.size() == 0) break;
            curLayer = nextLayer;
            nextLayer = new ArrayList();
        }
        if (!isLooped) {
            if (Config.forgeConfig.veinWoodTopToBottom.get().booleanValue() && material.equals(Material.field_151575_d)) {
                veinInfo.pos = highestPos;
            }
            return WorldTickHandler.getVeinShape(veinInfo, veinLeft, veinCost, isCreative, true);
        }
        return outVein;
    }

    public static double getVeinCost(BlockState state, BlockPos pos, PlayerEntity player) {
        double cost;
        Material material = state.func_185904_a();
        Skill skill = XP.getSkill(material);
        double hardness = state.func_185887_b((IBlockReader)player.field_70170_p, pos);
        if (hardness < minVeinHardness) {
            hardness = minVeinHardness;
        }
        switch (skill) {
            case MINING: {
                cost = hardness / ((double)Skill.MINING.getLevel(player) / levelsPerHardnessMining);
                break;
            }
            case WOODCUTTING: {
                cost = hardness / ((double)Skill.WOODCUTTING.getLevel(player) / levelsPerHardnessWoodcutting);
                break;
            }
            case EXCAVATION: {
                cost = hardness / ((double)Skill.EXCAVATION.getLevel(player) / levelsPerHardnessExcavation);
                break;
            }
            case FARMING: {
                cost = hardness / ((double)Skill.FARMING.getLevel(player) / levelsPerHardnessFarming);
                break;
            }
            case CRAFTING: {
                cost = hardness / ((double)Skill.CRAFTING.getLevel(player) / levelsPerHardnessCrafting);
                break;
            }
            default: {
                if (!state.func_177230_c().equals(Blocks.field_150350_a) && !skill.equals((Object)Skill.INVALID_SKILL)) {
                    LOGGER.error("WRONG SKILL AT VEIN COST: " + state.func_177230_c().getRegistryName() + " " + skill.name());
                }
                return hardness;
            }
        }
        if (cost < minVeinCost) {
            cost = minVeinCost;
        }
        return cost;
    }

    public static void updateVein(PlayerEntity player, double gap) {
        double veinLeft;
        Map<String, Double> abilitiesMap = Config.getAbilitiesMap(player);
        if (!abilitiesMap.containsKey("veinLeft")) {
            abilitiesMap.put("veinLeft", maxVeinCharge);
        }
        if ((veinLeft = abilitiesMap.get("veinLeft").doubleValue()) < 0.0) {
            veinLeft = 0.0;
        }
        if (!activeVein.containsKey(player)) {
            veinLeft += Math.min(gap, 2.0);
        }
        if (veinLeft > maxVeinCharge) {
            veinLeft = maxVeinCharge;
        }
        abilitiesMap.put("veinLeft", veinLeft);
        NetworkHandler.sendToPlayer(new MessageUpdatePlayerNBT(NBTHelper.mapStringToNbt(abilitiesMap), 1), (ServerPlayerEntity)player);
    }
}

