/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.ftb_quests;

import com.feed_the_beast.ftbquests.quest.PlayerData;
import com.feed_the_beast.ftbquests.quest.Quest;
import com.feed_the_beast.ftbquests.quest.task.BooleanTaskData;
import com.feed_the_beast.ftbquests.quest.task.Task;
import com.feed_the_beast.ftbquests.quest.task.TaskData;
import com.feed_the_beast.ftbquests.quest.task.TaskType;
import com.feed_the_beast.mods.ftbguilibrary.config.ConfigGroup;
import com.feed_the_beast.mods.ftbguilibrary.config.NameMap;
import harmonised.pmmo.config.Config;
import harmonised.pmmo.skills.Skill;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class SkillTask
extends Task {
    public static TaskType SKILL;
    public Skill skill = Skill.MINING;
    public double requiredLevel = 1.0;

    public SkillTask(Quest quest) {
        super(quest);
    }

    public TaskType getType() {
        return SKILL;
    }

    public void writeData(CompoundNBT nbt) {
        super.writeData(nbt);
        nbt.func_74778_a("skill", this.skill.toString());
        nbt.func_74780_a("requiredLevel", this.requiredLevel);
    }

    public void readData(CompoundNBT nbt) {
        super.readData(nbt);
        this.skill = Skill.getSkill(nbt.func_74779_i("skill"));
        this.requiredLevel = nbt.func_74769_h("requiredLevel");
    }

    public void writeNetData(PacketBuffer buffer) {
        super.writeNetData(buffer);
        buffer.func_211400_a(this.skill.toString(), Short.MAX_VALUE);
        buffer.writeDouble(this.requiredLevel);
    }

    public void readNetData(PacketBuffer buffer) {
        super.readNetData(buffer);
        this.skill = Skill.getSkill(buffer.func_150789_c(Short.MAX_VALUE));
        this.requiredLevel = buffer.readDouble();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void getConfig(ConfigGroup config) {
        super.getConfig(config);
        config.addEnum("skill", (Object)this.skill, input -> {
            this.skill = input;
        }, NameMap.of((Object)((Object)Skill.INVALID_SKILL), (Object[])Skill.valuesArray).create());
        config.addDouble("requiredLevel", this.requiredLevel, input -> {
            this.requiredLevel = input;
        }, 1.0, 1.0, Config.getConfig("maxLevel"));
    }

    public String getAltTitle() {
        return TextFormatting.DARK_GREEN + this.skill.toString();
    }

    public int autoSubmitOnPlayerTick() {
        return 20;
    }

    public TaskData createData(PlayerData data) {
        return new Data(this, data);
    }

    public static class Data
    extends BooleanTaskData<SkillTask> {
        private Data(SkillTask task, PlayerData data) {
            super((Task)task, data);
        }

        public boolean canSubmit(ServerPlayerEntity player) {
            return (double)((SkillTask)this.task).skill.getLevel((PlayerEntity)player) >= ((SkillTask)this.task).requiredLevel;
        }
    }
}

