/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.gui;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import harmonised.pmmo.config.JType;
import harmonised.pmmo.events.PlayerConnectedHandler;
import harmonised.pmmo.gui.CreditorScreen;
import harmonised.pmmo.gui.CreditsScrollPanel;
import harmonised.pmmo.gui.ListButtonBig;
import harmonised.pmmo.gui.MainScreen;
import harmonised.pmmo.gui.TileButton;
import harmonised.pmmo.util.XP;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class CreditsScreen
extends Screen {
    private final List<IGuiEventListener> children = Lists.newArrayList();
    private final ResourceLocation box = XP.getResLoc("pmmo", "textures/gui/screenboxy.png");
    private final ResourceLocation logo = XP.getResLoc("pmmo", "textures/gui/logo.png");
    private static boolean firstTime = true;
    private static TileButton exitButton;
    Minecraft minecraft = Minecraft.func_71410_x();
    MainWindow sr = this.minecraft.func_228018_at_();
    FontRenderer font;
    private int boxWidth;
    private int boxHeight;
    private int x;
    private int y;
    private int scrollX;
    private int scrollY;
    private JType jType;
    private UUID uuid;
    private ArrayList<ListButtonBig> listButtons;
    private CreditsScrollPanel scrollPanel;

    public CreditsScreen(UUID uuid, ITextComponent titleIn, JType jType) {
        super(titleIn);
        this.font = this.minecraft.field_71466_p;
        this.boxWidth = 256;
        this.boxHeight = 256;
        this.uuid = uuid;
        this.jType = jType;
    }

    protected void init() {
        this.listButtons = new ArrayList();
        this.x = this.sr.func_198107_o() / 2 - this.boxWidth / 2;
        this.y = this.sr.func_198087_p() / 2 - this.boxHeight / 2;
        this.scrollX = this.x + 16;
        this.scrollY = this.y + 10;
        if (firstTime) {
            CreditorScreen.initCreditors();
            firstTime = false;
        }
        exitButton = new TileButton(this.x + this.boxWidth - 24, this.y - 8, 7, 0, "pmmo.exit", JType.NONE, something -> Minecraft.func_71410_x().func_147108_a((Screen)new MainScreen(this.uuid, (ITextComponent)new TranslationTextComponent("pmmo.stats", new Object[0]))));
        PlayerConnectedHandler.lapisPatreons.forEach(a -> this.listButtons.add(new ListButtonBig(0, 0, 1, 2, "", CreditorScreen.uuidName.get(a.toString()), new TranslationTextComponent("pmmo.lapisPatreon", new Object[0]).func_150255_a(XP.textStyle.get("blue")).getString(), button -> Minecraft.func_71410_x().func_147108_a((Screen)new CreditorScreen(((ListButtonBig)button).playerName, "a", this.scrollPanel.getScroll())))));
        PlayerConnectedHandler.dandelionPatreons.forEach(a -> this.listButtons.add(new ListButtonBig(0, 0, 1, 3, "", CreditorScreen.uuidName.get(a.toString()), new TranslationTextComponent("pmmo.dandelionPatreon", new Object[0]).func_150255_a(XP.textStyle.get("yellow")).getString(), button -> Minecraft.func_71410_x().func_147108_a((Screen)new CreditorScreen(((ListButtonBig)button).playerName, "a", this.scrollPanel.getScroll())))));
        PlayerConnectedHandler.ironPatreons.forEach(a -> this.listButtons.add(new ListButtonBig(0, 0, 1, 4, "", CreditorScreen.uuidName.get(a.toString()), new TranslationTextComponent("pmmo.ironPatreon", new Object[0]).func_150255_a(XP.textStyle.get("grey")).getString(), button -> Minecraft.func_71410_x().func_147108_a((Screen)new CreditorScreen(((ListButtonBig)button).playerName, "a", this.scrollPanel.getScroll())))));
        this.listButtons.add(new ListButtonBig(0, 0, 1, 6, "ko_kr", "BusanDaek#3970", new TranslationTextComponent("pmmo.translated", new Object[]{"Korean"}).getString(), button -> Minecraft.func_71410_x().func_147108_a((Screen)new CreditorScreen(((ListButtonBig)button).playerName, "a", this.scrollPanel.getScroll()))));
        this.listButtons.add(new ListButtonBig(0, 0, 1, 6, "fr_fr", "deezer911#5693", new TranslationTextComponent("pmmo.helpedTranslating", new Object[]{"French"}).getString(), button -> Minecraft.func_71410_x().func_147108_a((Screen)new CreditorScreen(((ListButtonBig)button).playerName, "a", this.scrollPanel.getScroll()))));
        this.listButtons.add(new ListButtonBig(0, 0, 1, 6, "fr_fr", "didis54#5815", new TranslationTextComponent("pmmo.helpedTranslating", new Object[]{"French"}).getString(), button -> Minecraft.func_71410_x().func_147108_a((Screen)new CreditorScreen(((ListButtonBig)button).playerName, "a", this.scrollPanel.getScroll()))));
        this.listButtons.add(new ListButtonBig(0, 0, 1, 6, "pt_br", "TorukM4kt00#0246", new TranslationTextComponent("pmmo.translated", new Object[]{"Portuguese - Brazil"}).getString(), button -> Minecraft.func_71410_x().func_147108_a((Screen)new CreditorScreen(((ListButtonBig)button).playerName, "a", this.scrollPanel.getScroll()))));
        this.listButtons.add(new ListButtonBig(0, 0, 1, 6, "ru_ru", "starche#7569", new TranslationTextComponent("pmmo.translated", new Object[]{"Portuguese - Brazil"}).getString(), button -> Minecraft.func_71410_x().func_147108_a((Screen)new CreditorScreen(((ListButtonBig)button).playerName, "a", this.scrollPanel.getScroll()))));
        this.listButtons.add(new ListButtonBig(0, 0, 1, 6, "nl_nl", "Dawnless#1153", new TranslationTextComponent("pmmo.translated", new Object[]{"Dutch"}).getString(), button -> Minecraft.func_71410_x().func_147108_a((Screen)new CreditorScreen(((ListButtonBig)button).playerName, "a", this.scrollPanel.getScroll()))));
        this.listButtons.add(new ListButtonBig(0, 0, 1, 6, "zh_tw", "Lyla#2639", new TranslationTextComponent("pmmo.translated", new Object[]{"Chinese Traditional"}).getString(), button -> Minecraft.func_71410_x().func_147108_a((Screen)new CreditorScreen(((ListButtonBig)button).playerName, "a", this.scrollPanel.getScroll()))));
        this.listButtons.add(new ListButtonBig(0, 0, 1, 6, "zh_cn", "Lyla#2639", new TranslationTextComponent("pmmo.translated", new Object[]{"Chinese Simplified"}).getString(), button -> Minecraft.func_71410_x().func_147108_a((Screen)new CreditorScreen(((ListButtonBig)button).playerName, "a", this.scrollPanel.getScroll()))));
        this.listButtons.add(new ListButtonBig(0, 0, 1, 5, "", "Tyrius#0842", new TranslationTextComponent("pmmo.creatorOfModpack", new Object[]{"The Cosmic Tree"}).getString(), button -> Minecraft.func_71410_x().func_147108_a((Screen)new CreditorScreen(((ListButtonBig)button).playerName, "a", this.scrollPanel.getScroll()))));
        this.listButtons.add(new ListButtonBig(0, 0, 1, 5, "", "didis54#5815", new TranslationTextComponent("pmmo.creatorOfModpack", new Object[]{"Anarkhe Revolution"}).getString(), button -> Minecraft.func_71410_x().func_147108_a((Screen)new CreditorScreen(((ListButtonBig)button).playerName, "a", this.scrollPanel.getScroll()))));
        this.listButtons.add(new ListButtonBig(0, 0, 1, 5, "", "neothiamin#1798", new TranslationTextComponent("pmmo.creatorOfModpack", new Object[]{"Skillful Survival"}).getString(), button -> Minecraft.func_71410_x().func_147108_a((Screen)new CreditorScreen(((ListButtonBig)button).playerName, "a", this.scrollPanel.getScroll()))));
        this.listButtons.add(new ListButtonBig(0, 0, 1, 5, "", "Darth Revan#7341", new TranslationTextComponent("pmmo.creatorOfModpack", new Object[]{"Zombie Textiles"}).getString(), button -> Minecraft.func_71410_x().func_147108_a((Screen)new CreditorScreen(((ListButtonBig)button).playerName, "a", this.scrollPanel.getScroll()))));
        this.addButton((Widget)exitButton);
        this.scrollPanel = new CreditsScrollPanel(Minecraft.func_71410_x(), this.boxWidth - 40, this.boxHeight - 21, this.scrollY, this.scrollX, JType.CREDITS, this.listButtons);
        if (!MainScreen.scrollAmounts.containsKey((Object)this.jType)) {
            MainScreen.scrollAmounts.put(this.jType, 0);
        }
        this.scrollPanel.setScroll(MainScreen.scrollAmounts.get((Object)this.jType));
        this.children.add((IGuiEventListener)this.scrollPanel);
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(1);
        super.render(mouseX, mouseY, partialTicks);
        this.scrollPanel.render(mouseX, mouseY, partialTicks);
        this.x = this.sr.func_198107_o() / 2 - this.boxWidth / 2;
        this.y = this.sr.func_198087_p() / 2 - this.boxHeight / 2;
        for (ListButtonBig button : this.listButtons) {
            if (mouseX <= button.x + 3 || mouseY <= button.y || mouseX >= button.x + 60 || mouseY >= button.y + 64) continue;
            this.renderTooltip(new StringTextComponent(button.playerName).getString(), mouseX, mouseY);
            break;
        }
        if (this.font.func_78256_a(this.title.getString()) > 220) {
            this.drawCenteredString(this.font, this.title.getString(), this.sr.func_198107_o() / 2, this.y - 10, 0xFFFFFF);
        } else {
            this.drawCenteredString(this.font, this.title.getString(), this.sr.func_198107_o() / 2, this.y - 5, 0xFFFFFF);
        }
        MainScreen.scrollAmounts.replace(this.jType, this.scrollPanel.getScroll());
    }

    public void renderBackground(int p_renderBackground_1_) {
        if (this.minecraft != null) {
            this.fillGradient(0, 0, this.width, this.height, 0x66222222, 0x66333333);
            MinecraftForge.EVENT_BUS.post((Event)new GuiScreenEvent.BackgroundDrawnEvent((Screen)this));
        } else {
            this.renderBackground(p_renderBackground_1_);
        }
        this.boxHeight = 256;
        this.boxWidth = 256;
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this.box);
        RenderSystem.disableBlend();
        this.blit(this.x, this.y, 0, 0, this.boxWidth, this.boxHeight);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scroll) {
        if (this.listButtons.size() >= 7) {
            this.scrollPanel.mouseScrolled(mouseX, mouseY, scroll);
        }
        return super.mouseScrolled(mouseX, mouseY, scroll);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (button == 1) {
            exitButton.onPress();
            return true;
        }
        for (ListButtonBig a : this.listButtons) {
            if (!(mouseX > (double)(a.x + 3)) || !(mouseY > (double)a.y) || !(mouseX < (double)(a.x + 60)) || !(mouseY < (double)(a.y + 64))) continue;
            a.onPress();
        }
        this.scrollPanel.mouseClicked(mouseX, mouseY, button);
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        this.scrollPanel.mouseReleased(mouseX, mouseY, button);
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        this.scrollPanel.mouseDragged(mouseX, mouseY, button, deltaX, deltaY);
        return super.mouseDragged(mouseX, mouseY, button, deltaX, deltaY);
    }
}

