/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import harmonised.pmmo.config.JType;
import harmonised.pmmo.gui.ListButtonBig;
import java.util.List;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraftforge.client.gui.ScrollPanel;
import org.lwjgl.opengl.GL11;

public class CreditsScrollPanel
extends ScrollPanel {
    MainWindow sr = Minecraft.func_71410_x().func_228018_at_();
    JType jType;
    private final int boxWidth = 256;
    private final int boxHeight = 256;
    private final List<ListButtonBig> buttons;
    private final Minecraft client;
    private final int width;
    private final int height;
    private final int top;
    private final int bottom;
    private final int right;
    private final int left;
    private final int barLeft;
    private final int border = 4;
    private final int barWidth = 6;

    public CreditsScrollPanel(Minecraft client, int width, int height, int top, int left, JType jType, List<ListButtonBig> buttons) {
        super(client, width, height, top, left);
        this.jType = jType;
        this.buttons = buttons;
        this.client = client;
        this.width = width;
        this.height = height;
        this.top = top;
        this.left = left;
        this.bottom = height + this.top;
        this.right = width + this.left;
        this.barLeft = this.left + this.width - 6;
    }

    protected int getContentHeight() {
        int height = 48;
        for (int i = 0; i < this.buttons.size(); i += 3) {
            height += 92;
        }
        return height;
    }

    protected void drawPanel(int entryRight, int relativeY, Tessellator tess, int mouseX, int mouseY) {
        int accumulativeHeight = 0;
        for (int i = 0; i < this.buttons.size(); ++i) {
            ListButtonBig button = this.buttons.get(i);
            if ((i + 1) % 3 == 1) {
                button.x = this.sr.func_198107_o() / 2 - 32;
                button.y = relativeY + 12 + i / 3 * 92;
            } else {
                button.x = this.sr.func_198107_o() / 2 - 32 + ((i + 1) % 3 == 2 ? -28 : 28);
                button.y = relativeY + 12 + 46 + i / 3 * 92;
            }
            if ((float)(accumulativeHeight + this.buttons.get(i).getHeight()) > this.scrollDistance && (float)(accumulativeHeight - this.height - 32) <= this.scrollDistance) {
                button.render(mouseX, mouseY, 0.0f);
            }
            if (i % 3 != 0) continue;
            accumulativeHeight += 92;
        }
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scroll) {
        return super.mouseScrolled(mouseX, mouseY, scroll);
    }

    public int getScroll() {
        return (int)this.scrollDistance;
    }

    public void setScroll(int scroll) {
        this.scrollDistance = scroll;
    }

    public int getTop() {
        return this.top;
    }

    public int getBottom() {
        return this.bottom;
    }

    public int getRelativeY() {
        return this.top + this.border - (int)this.scrollDistance;
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        Tessellator tess = Tessellator.func_178181_a();
        BufferBuilder worldr = tess.func_178180_c();
        double scale = this.client.func_228018_at_().func_198100_s();
        GL11.glEnable((int)3089);
        GL11.glScissor((int)((int)((double)this.left * scale)), (int)((int)((double)this.client.func_228018_at_().func_198091_l() - (double)this.bottom * scale)), (int)((int)((double)this.width * scale)), (int)((int)((double)this.height * scale)));
        int baseY = this.top + 4 - (int)this.scrollDistance;
        this.drawPanel(this.right, baseY, tess, mouseX, mouseY);
        RenderSystem.disableDepthTest();
        int extraHeight = this.getContentHeight() + 4 - this.height;
        if (extraHeight > 0) {
            int barHeight = this.getBarHeight();
            int barTop = (int)this.scrollDistance * (this.height - barHeight) / extraHeight + this.top;
            if (barTop < this.top) {
                barTop = this.top;
            }
            RenderSystem.disableTexture();
            worldr.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            worldr.func_225582_a_((double)this.barLeft, (double)this.bottom, 0.0).func_225583_a_(0.0f, 1.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
            worldr.func_225582_a_((double)(this.barLeft + 6), (double)this.bottom, 0.0).func_225583_a_(1.0f, 1.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
            worldr.func_225582_a_((double)(this.barLeft + 6), (double)this.top, 0.0).func_225583_a_(1.0f, 0.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
            worldr.func_225582_a_((double)this.barLeft, (double)this.top, 0.0).func_225583_a_(0.0f, 0.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
            tess.func_78381_a();
            worldr.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            worldr.func_225582_a_((double)this.barLeft, (double)(barTop + barHeight), 0.0).func_225583_a_(0.0f, 1.0f).func_225586_a_(128, 128, 128, 255).func_181675_d();
            worldr.func_225582_a_((double)(this.barLeft + 6), (double)(barTop + barHeight), 0.0).func_225583_a_(1.0f, 1.0f).func_225586_a_(128, 128, 128, 255).func_181675_d();
            worldr.func_225582_a_((double)(this.barLeft + 6), (double)barTop, 0.0).func_225583_a_(1.0f, 0.0f).func_225586_a_(128, 128, 128, 255).func_181675_d();
            worldr.func_225582_a_((double)this.barLeft, (double)barTop, 0.0).func_225583_a_(0.0f, 0.0f).func_225586_a_(128, 128, 128, 255).func_181675_d();
            tess.func_78381_a();
            worldr.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            worldr.func_225582_a_((double)this.barLeft, (double)(barTop + barHeight - 1), 0.0).func_225583_a_(0.0f, 1.0f).func_225586_a_(192, 192, 192, 255).func_181675_d();
            worldr.func_225582_a_((double)(this.barLeft + 6 - 1), (double)(barTop + barHeight - 1), 0.0).func_225583_a_(1.0f, 1.0f).func_225586_a_(192, 192, 192, 255).func_181675_d();
            worldr.func_225582_a_((double)(this.barLeft + 6 - 1), (double)barTop, 0.0).func_225583_a_(1.0f, 0.0f).func_225586_a_(192, 192, 192, 255).func_181675_d();
            worldr.func_225582_a_((double)this.barLeft, (double)barTop, 0.0).func_225583_a_(0.0f, 0.0f).func_225586_a_(192, 192, 192, 255).func_181675_d();
            tess.func_78381_a();
        }
        RenderSystem.enableTexture();
        RenderSystem.shadeModel((int)7424);
        RenderSystem.enableAlphaTest();
        RenderSystem.disableBlend();
        GL11.glDisable((int)3089);
    }

    private int getBarHeight() {
        int barHeight = this.height * this.height / this.getContentHeight();
        if (barHeight < 32) {
            barHeight = 32;
        }
        if (barHeight > this.height - 8) {
            barHeight = this.height - 8;
        }
        return barHeight;
    }
}

