/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.gui;

import com.google.common.collect.Lists;
import harmonised.pmmo.config.JType;
import harmonised.pmmo.config.JsonConfig;
import harmonised.pmmo.gui.ListScreen;
import harmonised.pmmo.gui.MainScreen;
import harmonised.pmmo.gui.TileButton;
import harmonised.pmmo.util.XP;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class GlossaryScreen
extends Screen {
    private final List<IGuiEventListener> children = Lists.newArrayList();
    private final ResourceLocation box = XP.getResLoc("pmmo", "textures/gui/screenboxy.png");
    private static TileButton exitButton;
    Minecraft minecraft = Minecraft.func_71410_x();
    MainWindow sr = this.minecraft.func_228018_at_();
    FontRenderer font;
    private int boxWidth;
    private int boxHeight;
    private int x;
    private int y;
    public static List<TileButton> defaultTileButtons;
    public static List<TileButton> currentTileButtons;
    private String creativeText;
    private UUID uuid;
    public static List<Character> history;
    private static String[] weaster;
    private static Random rand;
    private static String transKey;
    private boolean loadDefaultButtons;

    public GlossaryScreen(UUID uuid, ITextComponent titleIn, boolean loadDefaultButtons) {
        super(titleIn);
        this.font = this.minecraft.field_71466_p;
        this.boxWidth = 256;
        this.boxHeight = 256;
        this.uuid = uuid;
        this.loadDefaultButtons = loadDefaultButtons;
    }

    public static void initButtons() {
        defaultTileButtons = new ArrayList<TileButton>();
        TileButton wearButton = new TileButton(0, 0, 3, 9, "pmmo.wearTitle", JType.REQ_WEAR, button -> GlossaryScreen.onGlossaryButtonPress((TileButton)button));
        TileButton toolButton = new TileButton(0, 0, 3, 10, "pmmo.toolTitle", JType.REQ_TOOL, button -> GlossaryScreen.onGlossaryButtonPress((TileButton)button));
        TileButton weaponButton = new TileButton(0, 0, 3, 11, "pmmo.weaponTitle", JType.REQ_WEAPON, button -> GlossaryScreen.onGlossaryButtonPress((TileButton)button));
        TileButton useButton = new TileButton(0, 0, 3, 12, "pmmo.useTitle", JType.REQ_USE, button -> GlossaryScreen.onGlossaryButtonPress((TileButton)button));
        TileButton placeButton = new TileButton(0, 0, 3, 13, "pmmo.placeTitle", JType.REQ_PLACE, button -> GlossaryScreen.onGlossaryButtonPress((TileButton)button));
        TileButton breakButton = new TileButton(0, 0, 3, 14, "pmmo.breakTitle", JType.REQ_BREAK, button -> GlossaryScreen.onGlossaryButtonPress((TileButton)button));
        TileButton craftButton = new TileButton(0, 0, 3, 29, "pmmo.craftTitle", JType.REQ_CRAFT, button -> GlossaryScreen.onGlossaryButtonPress((TileButton)button));
        TileButton biomeButton = new TileButton(0, 0, 3, 8, "pmmo.biomeTitle", JType.REQ_BIOME, button -> GlossaryScreen.onGlossaryButtonPress((TileButton)button));
        TileButton oreButton = new TileButton(0, 0, 3, 15, "pmmo.oreTitle", JType.INFO_ORE, button -> GlossaryScreen.onGlossaryButtonPress((TileButton)button));
        TileButton logButton = new TileButton(0, 0, 3, 16, "pmmo.logTitle", JType.INFO_LOG, button -> GlossaryScreen.onGlossaryButtonPress((TileButton)button));
        TileButton plantButton = new TileButton(0, 0, 3, 17, "pmmo.plantTitle", JType.INFO_PLANT, button -> GlossaryScreen.onGlossaryButtonPress((TileButton)button));
        TileButton smeltButton = new TileButton(0, 0, 3, 30, "pmmo.smeltTitle", JType.INFO_SMELT, button -> GlossaryScreen.onGlossaryButtonPress((TileButton)button));
        TileButton cookButton = new TileButton(0, 0, 3, 32, "pmmo.cookTitle", JType.INFO_COOK, button -> GlossaryScreen.onGlossaryButtonPress((TileButton)button));
        TileButton brewButton = new TileButton(0, 0, 3, 36, "pmmo.brewTitle", JType.INFO_BREW, button -> GlossaryScreen.onGlossaryButtonPress((TileButton)button));
        TileButton heldXpButton = new TileButton(0, 0, 3, 19, "pmmo.heldTitle", JType.XP_BONUS_HELD, button -> GlossaryScreen.onGlossaryButtonPress((TileButton)button));
        TileButton wornXpButton = new TileButton(0, 0, 3, 18, "pmmo.wornTitle", JType.XP_BONUS_WORN, button -> GlossaryScreen.onGlossaryButtonPress((TileButton)button));
        TileButton breedXpButton = new TileButton(0, 0, 3, 20, "pmmo.breedXpTitle", JType.XP_VALUE_BREED, button -> GlossaryScreen.onGlossaryButtonPress((TileButton)button));
        TileButton tameXpButton = new TileButton(0, 0, 3, 21, "pmmo.tameXpTitle", JType.XP_VALUE_TAME, button -> GlossaryScreen.onGlossaryButtonPress((TileButton)button));
        TileButton craftXpButton = new TileButton(0, 0, 3, 22, "pmmo.craftXpTitle", JType.XP_VALUE_CRAFT, button -> GlossaryScreen.onGlossaryButtonPress((TileButton)button));
        TileButton breakXpButton = new TileButton(0, 0, 3, 23, "pmmo.breakXpTitle", JType.XP_VALUE_BREAK, button -> GlossaryScreen.onGlossaryButtonPress((TileButton)button));
        TileButton smeltXpButton = new TileButton(0, 0, 3, 31, "pmmo.smeltXpTitle", JType.XP_VALUE_SMELT, button -> GlossaryScreen.onGlossaryButtonPress((TileButton)button));
        TileButton cookXpButton = new TileButton(0, 0, 3, 33, "pmmo.cookXpTitle", JType.XP_VALUE_COOK, button -> GlossaryScreen.onGlossaryButtonPress((TileButton)button));
        TileButton brewXpButton = new TileButton(0, 0, 3, 37, "pmmo.brewXpTitle", JType.XP_VALUE_BREW, button -> GlossaryScreen.onGlossaryButtonPress((TileButton)button));
        TileButton growXpButton = new TileButton(0, 0, 3, 35, "pmmo.growXpTitle", JType.XP_VALUE_GROW, button -> GlossaryScreen.onGlossaryButtonPress((TileButton)button));
        TileButton dimensionButton = new TileButton(0, 0, 3, 8, "pmmo.dimensionTitle", JType.DIMENSION, button -> GlossaryScreen.onGlossaryButtonPress((TileButton)button));
        TileButton fishPoolButton = new TileButton(0, 0, 3, 24, "pmmo.fishPoolTitle", JType.FISH_POOL, button -> GlossaryScreen.onGlossaryButtonPress((TileButton)button));
        TileButton mobButton = new TileButton(0, 0, 3, 26, "pmmo.mobTitle", JType.REQ_KILL, button -> GlossaryScreen.onGlossaryButtonPress((TileButton)button));
        TileButton fishEnchantButton = new TileButton(0, 0, 3, 25, "pmmo.fishEnchantTitle", JType.FISH_ENCHANT_POOL, button -> GlossaryScreen.onGlossaryButtonPress((TileButton)button));
        TileButton salvageToButton = new TileButton(0, 0, 3, 27, "pmmo.salvagesToTitle", JType.SALVAGE, button -> GlossaryScreen.onGlossaryButtonPress((TileButton)button));
        TileButton salvageFromButton = new TileButton(0, 0, 3, 28, "pmmo.salvagesFromTitle", JType.SALVAGE_FROM, button -> GlossaryScreen.onGlossaryButtonPress((TileButton)button));
        TileButton treasureToButton = new TileButton(0, 0, 3, 38, "pmmo.treasureToTitle", JType.TREASURE, button -> GlossaryScreen.onGlossaryButtonPress((TileButton)button));
        TileButton treasureFromButton = new TileButton(0, 0, 3, 39, "pmmo.treasureFromTitle", JType.TREASURE_FROM, button -> GlossaryScreen.onGlossaryButtonPress((TileButton)button));
        defaultTileButtons.add(wearButton);
        defaultTileButtons.add(toolButton);
        defaultTileButtons.add(weaponButton);
        defaultTileButtons.add(useButton);
        defaultTileButtons.add(placeButton);
        defaultTileButtons.add(breakButton);
        defaultTileButtons.add(craftButton);
        defaultTileButtons.add(oreButton);
        defaultTileButtons.add(logButton);
        defaultTileButtons.add(plantButton);
        defaultTileButtons.add(smeltButton);
        defaultTileButtons.add(cookButton);
        defaultTileButtons.add(brewButton);
        defaultTileButtons.add(heldXpButton);
        defaultTileButtons.add(wornXpButton);
        defaultTileButtons.add(breedXpButton);
        defaultTileButtons.add(tameXpButton);
        defaultTileButtons.add(craftXpButton);
        defaultTileButtons.add(breakXpButton);
        defaultTileButtons.add(smeltXpButton);
        defaultTileButtons.add(cookXpButton);
        defaultTileButtons.add(brewXpButton);
        defaultTileButtons.add(growXpButton);
        defaultTileButtons.add(dimensionButton);
        defaultTileButtons.add(biomeButton);
        defaultTileButtons.add(mobButton);
        defaultTileButtons.add(fishPoolButton);
        defaultTileButtons.add(fishEnchantButton);
        defaultTileButtons.add(salvageToButton);
        defaultTileButtons.add(salvageFromButton);
        defaultTileButtons.add(treasureToButton);
        defaultTileButtons.add(treasureFromButton);
    }

    protected void init() {
        this.x = this.sr.func_198107_o() / 2 - this.boxWidth / 2;
        this.y = this.sr.func_198087_p() / 2 - this.boxHeight / 2;
        this.creativeText = new TranslationTextComponent("pmmo.creativeWarning", new Object[0]).getString();
        exitButton = new TileButton(this.x + this.boxWidth - 24, this.y - 8, 7, 0, "", JType.NONE, button -> {
            history = new ArrayList<Character>();
            Minecraft.func_71410_x().func_147108_a((Screen)new MainScreen(this.uuid, (ITextComponent)new TranslationTextComponent("pmmo.potato", new Object[0])));
        });
        if (this.loadDefaultButtons) {
            GlossaryScreen.setButtonsToDefault();
        }
        this.addButton((Widget)exitButton);
        int col = 0;
        int row = 0;
        for (TileButton button2 : currentTileButtons) {
            button2.index = row * 6 + col;
            button2.x = this.x + 22 + col * 36;
            button2.y = this.y + 22 + row * 36;
            this.addButton((Widget)button2);
            if (++col <= 5) continue;
            col = 0;
            ++row;
        }
    }

    public static void onGlossaryButtonPress(TileButton button) {
        GlossaryScreen.updateHistory(button.index);
        Minecraft.func_71410_x().func_147108_a((Screen)new ListScreen(Minecraft.func_71410_x().field_71439_g.func_110124_au(), (ITextComponent)new TranslationTextComponent(button.transKey, new Object[0]), "", button.jType, (PlayerEntity)Minecraft.func_71410_x().field_71439_g));
    }

    public static void updateHistory(int index) {
        if (index >= 10) {
            history = new ArrayList<Character>();
            return;
        }
        boolean combo = false;
        for (char c : Integer.toString(index + 1).toCharArray()) {
            if (combo) continue;
            combo = GlossaryScreen.updateHistory(c);
        }
        if (combo) {
            Minecraft.func_71410_x().field_71439_g.func_213823_a(SoundEvents.field_187909_gi, SoundCategory.MASTER, 0.8f + rand.nextFloat() * 0.4f, 0.9f + rand.nextFloat() * 0.15f);
        }
    }

    public static boolean updateHistory(char index) {
        history.add(Character.valueOf(index));
        int historyLength = history.size();
        for (String pass : weaster) {
            int passLength = pass.length();
            if (historyLength < passLength) continue;
            boolean passed = true;
            int pos = 0;
            int startPos = historyLength - passLength;
            for (char c : pass.toCharArray()) {
                if (history.get(startPos + pos).charValue() != c) {
                    passed = false;
                }
                ++pos;
            }
            if (!passed) continue;
            Minecraft.func_71410_x().field_71439_g.func_213823_a(SoundEvents.field_203258_fv, SoundCategory.AMBIENT, 5.0f + rand.nextFloat() * 0.4f, -5.0f - rand.nextFloat() * 0.15f);
            return true;
        }
        return false;
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(1);
        super.render(mouseX, mouseY, partialTicks);
        this.x = this.sr.func_198107_o() / 2 - this.boxWidth / 2;
        this.y = this.sr.func_198087_p() / 2 - this.boxHeight / 2;
        for (TileButton button : currentTileButtons) {
            if (mouseX <= button.x || mouseY <= button.y || mouseX >= button.x + 32 || mouseY >= button.y + 32) continue;
            this.renderTooltip(new TranslationTextComponent(button.transKey, new Object[0]).func_150254_d(), mouseX, mouseY);
        }
        if (Minecraft.func_71410_x().field_71439_g.func_184812_l_()) {
            if (this.font.func_78256_a(this.creativeText) > 220) {
                this.drawCenteredString(Minecraft.func_71410_x().field_71466_p, transKey, this.sr.func_198107_o() / 2, this.y - 18, 0xFFFFFF);
                this.drawCenteredString(Minecraft.func_71410_x().field_71466_p, this.creativeText, this.sr.func_198107_o() / 2, this.y - 10, 0xFFFF00);
            } else {
                this.drawCenteredString(Minecraft.func_71410_x().field_71466_p, transKey, this.sr.func_198107_o() / 2, this.y - 13, 0xFFFFFF);
                this.drawCenteredString(Minecraft.func_71410_x().field_71466_p, this.creativeText, this.sr.func_198107_o() / 2, this.y - 5, 0xFFFF00);
            }
        } else {
            this.drawCenteredString(Minecraft.func_71410_x().field_71466_p, transKey, this.sr.func_198107_o() / 2, this.y - 5, 0xFFFFFF);
        }
    }

    public void renderBackground(int p_renderBackground_1_) {
        if (this.minecraft != null) {
            this.fillGradient(0, 0, this.width, this.height, 0x66222222, 0x66333333);
            MinecraftForge.EVENT_BUS.post((Event)new GuiScreenEvent.BackgroundDrawnEvent((Screen)this));
        }
        this.boxHeight = 256;
        this.boxWidth = 256;
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this.box);
        this.blit(this.x, this.y, 0, 0, this.boxWidth, this.boxHeight);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scroll) {
        return super.mouseScrolled(mouseX, mouseY, scroll);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (button == 1) {
            exitButton.onPress();
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        return super.mouseDragged(mouseX, mouseY, button, deltaX, deltaY);
    }

    public static void setButtonsToDefault() {
        currentTileButtons = defaultTileButtons;
        transKey = new TranslationTextComponent("pmmo.glossary", new Object[0]).getString();
    }

    public static void setButtonsToKey(String regKey) {
        currentTileButtons = new ArrayList<TileButton>();
        for (TileButton button : defaultTileButtons) {
            if ((!JsonConfig.data.containsKey((Object)button.jType) || !JsonConfig.data.get((Object)button.jType).containsKey(regKey)) && (!JsonConfig.data2.containsKey((Object)button.jType) || !JsonConfig.data2.get((Object)button.jType).containsKey(regKey))) continue;
            currentTileButtons.add(button);
        }
        if (currentTileButtons.size() == 0) {
            GlossaryScreen.setButtonsToDefault();
            transKey = new TranslationTextComponent("pmmo.glossary", new Object[0]).getString();
        } else {
            transKey = new TranslationTextComponent(XP.getItem(regKey).func_77658_a(), new Object[0]).getString();
        }
    }

    static {
        defaultTileButtons = new ArrayList<TileButton>();
        currentTileButtons = new ArrayList<TileButton>();
        history = new ArrayList<Character>();
        weaster = new String[]{"1523", "3251", "911"};
        rand = new Random();
    }
}

