/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import harmonised.pmmo.config.JType;
import harmonised.pmmo.gui.GlossaryScreen;
import harmonised.pmmo.gui.ListScreen;
import harmonised.pmmo.skills.Skill;
import harmonised.pmmo.util.XP;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.Quaternion;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.ModDimension;
import net.minecraftforge.registries.ForgeRegistries;

public class ListButton
extends Button {
    private final ResourceLocation items = XP.getResLoc("pmmo", "textures/gui/items.png");
    private final ResourceLocation buttons = XP.getResLoc("pmmo", "textures/gui/buttons.png");
    public int elementOne;
    public int elementTwo;
    public int offsetOne;
    public int offsetTwo;
    public double mobWidth;
    public double mobHeight;
    public double mobScale;
    public boolean unlocked = true;
    public ItemStack itemStack;
    public String regKey;
    public String title;
    public String buttonText;
    public List<String> text = new ArrayList<String>();
    public List<String> tooltipText = new ArrayList<String>();
    Entity testEntity = null;
    LivingEntity entity = null;
    ItemRenderer itemRenderer = Minecraft.func_71410_x().func_175599_af();

    public ListButton(int posX, int posY, int elementOne, int elementTwo, String regKey, JType jType, String buttonText, Button.IPressable onPress) {
        super(posX, posY, 32, 32, "", onPress);
        this.regKey = regKey;
        this.buttonText = buttonText;
        this.itemStack = new ItemStack((IItemProvider)XP.getItem(regKey));
        this.elementOne = elementOne * 32;
        this.elementTwo = elementTwo * 32;
        if (ForgeRegistries.ENTITIES.containsKey(XP.getResLoc(regKey))) {
            this.testEntity = ((EntityType)ForgeRegistries.ENTITIES.getValue(XP.getResLoc(regKey))).func_200721_a((World)Minecraft.func_71410_x().field_71441_e);
        }
        if (this.testEntity instanceof LivingEntity) {
            this.entity = (LivingEntity)this.testEntity;
        }
        switch (jType) {
            case FISH_ENCHANT_POOL: {
                this.title = new TranslationTextComponent(((Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(XP.getResLoc(regKey))).func_200305_d(1).getString().replace(" I", ""), new Object[0]).getString();
                break;
            }
            case XP_VALUE_BREED: 
            case XP_VALUE_TAME: 
            case REQ_KILL: {
                this.title = new TranslationTextComponent(((EntityType)ForgeRegistries.ENTITIES.getValue(XP.getResLoc(regKey))).func_210760_d(), new Object[0]).getString();
                break;
            }
            case DIMENSION: {
                if (regKey.equals("all_dimensions")) {
                    this.title = new TranslationTextComponent("pmmo.allDimensions", new Object[0]).func_150254_d();
                    break;
                }
                if (regKey.equals("minecraft:overworld") || regKey.equals("minecraft:the_nether") || regKey.equals("minecraft:the_end")) {
                    this.title = new TranslationTextComponent(regKey, new Object[0]).func_150254_d();
                    break;
                }
                if (!ForgeRegistries.MOD_DIMENSIONS.containsKey(XP.getResLoc(regKey))) break;
                this.title = new TranslationTextComponent(((ModDimension)ForgeRegistries.MOD_DIMENSIONS.getValue(XP.getResLoc(regKey))).getRegistryName().toString(), new Object[0]).func_150254_d();
                break;
            }
            case STATS: {
                this.title = new TranslationTextComponent("pmmo." + regKey, new Object[0]).func_150255_a(XP.getSkillStyle(Skill.getSkill(regKey))).func_150254_d();
                break;
            }
            case REQ_BIOME: {
                this.title = new TranslationTextComponent(regKey, new Object[0]).getString();
                break;
            }
            default: {
                this.title = new TranslationTextComponent(this.itemStack.func_77977_a(), new Object[0]).getString();
            }
        }
        switch (regKey) {
            case "pmmo.otherCrafts": 
            case "pmmo.otherAnimals": 
            case "pmmo.otherPassiveMobs": 
            case "pmmo.otherAggresiveMobs": {
                this.title = new TranslationTextComponent(new TranslationTextComponent(regKey, new Object[0]).func_150254_d(), new Object[0]).getString();
            }
        }
        this.offsetOne = elementOne > 23 ? 192 : (elementOne > 15 ? 128 : (elementOne > 7 ? 64 : 0));
        this.offsetTwo = elementTwo > 23 ? 192 : (elementTwo > 15 ? 128 : (elementTwo > 7 ? 64 : 0));
    }

    public int getHeight() {
        int height = 11;
        for (String a : this.text) {
            height += 9;
        }
        if (height > 32) {
            return height;
        }
        return 32;
    }

    public void clickActionGlossary() {
        GlossaryScreen.setButtonsToKey(this.regKey);
        Minecraft.func_71410_x().func_147108_a((Screen)new GlossaryScreen(Minecraft.func_71410_x().field_71439_g.func_110124_au(), (ITextComponent)new TranslationTextComponent("pmmo.glossary", new Object[0]), false));
    }

    public void clickActionSkills() {
        if (!Skill.getSkill(this.regKey).equals((Object)Skill.INVALID_SKILL)) {
            Minecraft.func_71410_x().func_147108_a((Screen)new ListScreen(Minecraft.func_71410_x().field_71439_g.func_110124_au(), (ITextComponent)new TranslationTextComponent("", new Object[0]), this.regKey, JType.HISCORE, (PlayerEntity)Minecraft.func_71410_x().field_71439_g));
        }
    }

    public void renderButton(int x, int y, float partialTicks) {
        Minecraft minecraft = Minecraft.func_71410_x();
        FontRenderer fontrenderer = minecraft.field_71466_p;
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)this.alpha);
        int i = this.getYImage(this.isHovered());
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        minecraft.func_110434_K().func_110577_a(this.buttons);
        this.blit(this.x, this.y, this.offsetOne + (this.isHovered() ? 32 : 0), this.elementOne, this.width, this.height);
        minecraft.func_110434_K().func_110577_a(this.items);
        this.blit(this.x, this.y, this.offsetTwo + (this.isHovered() ? 32 : 0), this.elementTwo, this.width, this.height);
        if (!this.itemStack.func_77973_b().equals(Items.field_190931_a) && this.entity == null) {
            this.itemRenderer.func_175042_a(this.itemStack, this.x + 8, this.y + 8);
        }
        if (this.entity != null) {
            this.mobHeight = this.entity.func_213305_a((Pose)Pose.STANDING).field_220316_b;
            this.mobWidth = this.entity.func_213305_a((Pose)Pose.STANDING).field_220315_a;
            this.mobScale = 27.0;
            if (this.mobHeight > 0.0) {
                this.mobScale /= Math.max(this.mobHeight, this.mobWidth);
            }
            ListButton.drawEntityOnScreen(this.x + this.width / 2, this.y + this.height - 2, (int)this.mobScale, this.entity);
        }
        this.renderBg(minecraft, x, y);
        int j = this.getFGColor();
        this.drawCenteredString(fontrenderer, this.buttonText, this.x + this.width / 2, this.y + (this.height - 8) / 2, j | MathHelper.func_76123_f((float)(this.alpha * 255.0f)) << 24);
    }

    public static void drawEntityOnScreen(int posX, int posY, int scale, LivingEntity p_228187_5_) {
        float f = (float)((double)System.currentTimeMillis() / 25.0 % 360.0);
        float f1 = 0.0f;
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)posX, (float)posY, (float)1050.0f);
        RenderSystem.scalef((float)1.0f, (float)1.0f, (float)-1.0f);
        MatrixStack matrixstack = new MatrixStack();
        matrixstack.func_227861_a_(0.0, 0.0, 1000.0);
        matrixstack.func_227862_a_((float)scale, (float)scale, (float)scale);
        Quaternion quaternion = Vector3f.field_229183_f_.func_229187_a_(180.0f);
        Quaternion quaternion1 = Vector3f.field_229179_b_.func_229187_a_(f1 * 20.0f);
        quaternion.func_195890_a(quaternion1);
        matrixstack.func_227863_a_(quaternion);
        float f2 = p_228187_5_.field_70761_aq;
        float f3 = p_228187_5_.field_70177_z;
        float f4 = p_228187_5_.field_70125_A;
        float f5 = p_228187_5_.field_70758_at;
        float f6 = p_228187_5_.field_70759_as;
        p_228187_5_.field_70761_aq = f;
        p_228187_5_.field_70177_z = f;
        p_228187_5_.field_70125_A = -f1 * 20.0f;
        p_228187_5_.field_70759_as = f;
        p_228187_5_.field_70758_at = 0.0f;
        EntityRendererManager entityrenderermanager = Minecraft.func_71410_x().func_175598_ae();
        quaternion1.func_195892_e();
        entityrenderermanager.func_229089_a_(quaternion1);
        entityrenderermanager.func_178633_a(false);
        IRenderTypeBuffer.Impl irendertypebuffer$impl = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
        entityrenderermanager.func_229084_a_((Entity)p_228187_5_, 0.0, 0.0, 0.0, 0.0f, 1.0f, matrixstack, (IRenderTypeBuffer)irendertypebuffer$impl, 0xF000F0);
        irendertypebuffer$impl.func_228461_a_();
        entityrenderermanager.func_178633_a(true);
        p_228187_5_.field_70761_aq = f2;
        p_228187_5_.field_70177_z = f3;
        p_228187_5_.field_70125_A = f4;
        p_228187_5_.field_70758_at = f5;
        p_228187_5_.field_70759_as = f6;
        RenderSystem.popMatrix();
    }
}

