/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.gui;

import com.google.common.collect.Lists;
import harmonised.pmmo.config.Config;
import harmonised.pmmo.config.JType;
import harmonised.pmmo.config.JsonConfig;
import harmonised.pmmo.events.BlockBrokenHandler;
import harmonised.pmmo.gui.GlossaryScreen;
import harmonised.pmmo.gui.ListButton;
import harmonised.pmmo.gui.ListScrollPanel;
import harmonised.pmmo.gui.MainScreen;
import harmonised.pmmo.gui.TileButton;
import harmonised.pmmo.skills.Skill;
import harmonised.pmmo.util.DP;
import harmonised.pmmo.util.XP;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Items;
import net.minecraft.potion.Effect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.registries.ForgeRegistries;

public class ListScreen
extends Screen {
    private final List<IGuiEventListener> children = Lists.newArrayList();
    private final ResourceLocation box = XP.getResLoc("pmmo", "textures/gui/screenboxy.png");
    private static final Style greenColor = XP.textStyle.get("green");
    private static Button exitButton;
    MainWindow sr = Minecraft.func_71410_x().func_228018_at_();
    private int boxWidth = 256;
    private int boxHeight = 256;
    private int x;
    private int y;
    private int scrollX;
    private int scrollY;
    private int buttonX;
    private int buttonY;
    private int accumulativeHeight;
    private int buttonsSize;
    private int buttonsLoaded;
    private int futureHeight;
    private int minCount;
    private int maxCount;
    private ListScrollPanel scrollPanel;
    private final PlayerEntity player;
    private final JType jType;
    private final double baseXp = Config.getConfig("baseXp");
    private ArrayList<ListButton> listButtons = new ArrayList();
    private UUID uuid;
    private ITextComponent title;
    private String type;

    public ListScreen(UUID uuid, ITextComponent titleIn, String type, JType jType, PlayerEntity player) {
        super(titleIn);
        this.title = titleIn;
        this.player = player;
        this.jType = jType;
        this.uuid = uuid;
        this.type = type;
    }

    protected void init() {
        ArrayList<String> keyWords = new ArrayList<String>();
        keyWords.add("helmet");
        keyWords.add("chestplate");
        keyWords.add("leggings");
        keyWords.add("boots");
        keyWords.add("pickaxe");
        keyWords.add("axe");
        keyWords.add("shovel");
        keyWords.add("hoe");
        keyWords.add("sword");
        this.x = this.sr.func_198107_o() / 2 - this.boxWidth / 2;
        this.y = this.sr.func_198087_p() / 2 - this.boxHeight / 2;
        this.scrollX = this.x + 16;
        this.scrollY = this.y + 10;
        this.buttonX = this.scrollX + 4;
        exitButton = new TileButton(this.x + this.boxWidth - 24, this.y - 8, 7, 0, "", JType.NONE, button -> {
            switch (this.jType) {
                case STATS: {
                    Minecraft.func_71410_x().func_147108_a((Screen)new MainScreen(this.uuid, (ITextComponent)ListScreen.getTransComp("pmmo.potato", new Object[0])));
                    break;
                }
                default: {
                    Minecraft.func_71410_x().func_147108_a((Screen)new GlossaryScreen(this.uuid, (ITextComponent)ListScreen.getTransComp("pmmo.skills", new Object[0]), false));
                }
            }
        });
        Map<String, Map<String, Double>> reqMap = JsonConfig.data.get((Object)this.jType);
        Map<String, Map<String, Map<String, Double>>> reqMap2 = JsonConfig.data2.get((Object)this.jType);
        ArrayList<ListButton> tempList = new ArrayList<ListButton>();
        this.listButtons = new ArrayList();
        switch (this.jType) {
            case REQ_BIOME: {
                Map<String, Map<String, Double>> bonusMap = JsonConfig.data.get((Object)JType.XP_BONUS_BIOME);
                Map<String, Map<String, Double>> map = JsonConfig.data.get((Object)JType.BIOME_MOB_MULTIPLIER);
                ArrayList<String> arrayList = new ArrayList<String>();
                if (reqMap != null) {
                    for (Map.Entry<String, Map<String, Double>> entry : reqMap.entrySet()) {
                        if (arrayList.contains(entry.getKey())) continue;
                        arrayList.add(entry.getKey());
                    }
                }
                if (bonusMap != null) {
                    for (Map.Entry<String, Map<String, Double>> entry : bonusMap.entrySet()) {
                        if (arrayList.contains(entry.getKey())) continue;
                        arrayList.add(entry.getKey());
                    }
                }
                if (map != null) {
                    for (Map.Entry<String, Map<String, Double>> entry : map.entrySet()) {
                        if (arrayList.contains(entry.getKey())) continue;
                        arrayList.add(entry.getKey());
                    }
                }
                arrayList.sort(Comparator.comparingInt(b -> ListScreen.getReqCount(b, JType.REQ_BIOME)));
                for (String string : arrayList) {
                    if (ForgeRegistries.BIOMES.getValue(XP.getResLoc(string)) == null) continue;
                    tempList.add(new ListButton(0, 0, 3, 8, string, this.jType, "", button -> ((ListButton)button).clickActionGlossary()));
                }
                break;
            }
            case DIMENSION: {
                Map<String, Map<String, Double>> veinBlacklist = JsonConfig.data.get((Object)JType.VEIN_BLACKLIST);
                if (veinBlacklist == null) break;
                if (veinBlacklist.containsKey("all_dimensions")) {
                    tempList.add(new ListButton(0, 0, 3, 8, "all_dimensions", this.jType, "", button -> ((ListButton)button).clickActionGlossary()));
                }
                if (veinBlacklist.containsKey("minecraft:overworld")) {
                    tempList.add(new ListButton(0, 0, 3, 8, "minecraft:overworld", this.jType, "", button -> ((ListButton)button).clickActionGlossary()));
                }
                if (veinBlacklist.containsKey("minecraft:the_nether")) {
                    tempList.add(new ListButton(0, 0, 3, 8, "minecraft:the_nether", this.jType, "", button -> ((ListButton)button).clickActionGlossary()));
                }
                if (veinBlacklist.containsKey("minecraft:the_end")) {
                    tempList.add(new ListButton(0, 0, 3, 8, "minecraft:the_end", this.jType, "", button -> ((ListButton)button).clickActionGlossary()));
                }
                for (Map.Entry<String, Map<String, Double>> entry : veinBlacklist.entrySet()) {
                    if (ForgeRegistries.MOD_DIMENSIONS.getValue(XP.getResLoc(entry.getKey())) == null) continue;
                    tempList.add(new ListButton(0, 0, 3, 8, entry.getKey(), this.jType, "", button -> ((ListButton)button).clickActionGlossary()));
                }
                break;
            }
            case REQ_KILL: {
                Iterator<Map.Entry<String, Map<String, Double>>> killXpMap = JsonConfig.data.get((Object)JType.REQ_KILL);
                Map<String, Map<String, Double>> map = JsonConfig.data.get((Object)JType.MOB_RARE_DROP);
                ArrayList<String> arrayList = new ArrayList<String>();
                if (reqMap != null) {
                    for (Map.Entry<String, Map<String, Double>> entry : reqMap.entrySet()) {
                        if (arrayList.contains(entry.getKey())) continue;
                        arrayList.add(entry.getKey());
                    }
                }
                if (killXpMap != null) {
                    for (Map.Entry<String, Map<String, Double>> entry : killXpMap.entrySet()) {
                        if (arrayList.contains(entry.getKey())) continue;
                        arrayList.add(entry.getKey());
                    }
                }
                if (map != null) {
                    for (Map.Entry<String, Map<String, Double>> entry : map.entrySet()) {
                        if (arrayList.contains(entry.getKey())) continue;
                        arrayList.add(entry.getKey());
                    }
                }
                for (String string : arrayList) {
                    if (!ForgeRegistries.ENTITIES.containsKey(XP.getResLoc(string))) continue;
                    tempList.add(new ListButton(0, 0, 3, 0, string, this.jType, "", button -> ((ListButton)button).clickActionGlossary()));
                }
                break;
            }
            case XP_VALUE_BREED: 
            case XP_VALUE_TAME: {
                if (reqMap == null) break;
                for (Map.Entry<String, Map<String, Double>> entry : reqMap.entrySet()) {
                    if (!ForgeRegistries.ENTITIES.containsKey(XP.getResLoc(entry.getKey()))) continue;
                    tempList.add(new ListButton(0, 0, 3, 0, entry.getKey(), this.jType, "", button -> ((ListButton)button).clickActionGlossary()));
                }
                break;
            }
            case FISH_ENCHANT_POOL: {
                if (reqMap == null) break;
                for (Map.Entry<String, Map<String, Double>> entry : reqMap.entrySet()) {
                    if (!ForgeRegistries.ENCHANTMENTS.containsKey(XP.getResLoc(entry.getKey()))) continue;
                    tempList.add(new ListButton(0, 0, 3, 25, entry.getKey(), this.jType, "", button -> ((ListButton)button).clickActionGlossary()));
                }
                break;
            }
            case STATS: {
                Set<Skill> skills = XP.getOfflineXpMap(this.uuid).keySet();
                for (Skill skill : skills) {
                    this.listButtons.add(new ListButton(0, 0, 3, 6, skill.toString(), this.jType, "", button -> ((ListButton)button).clickActionSkills()));
                }
                break;
            }
            case HISCORE: {
                Skill theSkill = Skill.getSkill(this.type);
                if (theSkill.equals((Object)Skill.INVALID_SKILL)) break;
                System.out.println("Yegurl");
                break;
            }
            case SALVAGE: 
            case SALVAGE_FROM: 
            case TREASURE: 
            case TREASURE_FROM: {
                if (reqMap2 == null) break;
                for (Map.Entry entry : reqMap2.entrySet()) {
                    tempList.add(new ListButton(0, 0, 3, 0, (String)entry.getKey(), this.jType, "", button -> ((ListButton)button).clickActionGlossary()));
                }
                break;
            }
            default: {
                if (reqMap == null) {
                    return;
                }
                for (Map.Entry entry : reqMap.entrySet()) {
                    if (XP.getItem((String)entry.getKey()) == Items.field_190931_a) continue;
                    tempList.add(new ListButton(0, 0, 3, 0, (String)entry.getKey(), this.jType, "", button -> ((ListButton)button).clickActionGlossary()));
                }
            }
        }
        for (String string : keyWords) {
            for (ListButton button2 : tempList) {
                if (!button2.regKey.contains(string) || this.listButtons.contains((Object)button2)) continue;
                this.listButtons.add(button2);
            }
        }
        for (ListButton listButton : tempList) {
            if (this.listButtons.contains((Object)listButton)) continue;
            this.listButtons.add(listButton);
        }
        for (ListButton listButton : this.listButtons) {
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<String> scaleText = new ArrayList<String>();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            switch (this.jType) {
                case DIMENSION: {
                    Map<String, Map<String, Double>> veinBlacklist = JsonConfig.data.get((Object)JType.VEIN_BLACKLIST);
                    Map<String, Double> dimensionBonusMap = JsonConfig.data.get((Object)JType.XP_BONUS_DIMENSION).get(listButton.regKey);
                    if (veinBlacklist != null) {
                        listButton.text.add("");
                        listButton.text.add(ListScreen.getTransComp("pmmo.veinBlacklist", new Object[0]).func_150255_a(XP.textStyle.get("red")).getString());
                        for (Map.Entry<String, Double> entry : veinBlacklist.get(listButton.regKey).entrySet()) {
                            listButton.text.add(new StringTextComponent(" " + ListScreen.getTransComp(XP.getItem(entry.getKey()).func_77658_a(), new Object[0]).getString()).func_150255_a(XP.textStyle.get("red")).getString());
                        }
                    }
                    if (dimensionBonusMap == null) break;
                    for (Map.Entry<String, Double> entry : dimensionBonusMap.entrySet()) {
                        if (entry.getValue() > 0.0) {
                            arrayList.add(new StringTextComponent(" " + ListScreen.getTransComp("pmmo.levelDisplay", ListScreen.getTransComp("pmmo." + entry.getKey(), new Object[0]), "+" + entry.getValue() + "%").getString()).func_150255_a(XP.getSkillStyle(Skill.getSkill(entry.getKey()))).getString());
                        }
                        if (!(entry.getValue() < 0.0)) continue;
                        arrayList.add(new StringTextComponent(" " + ListScreen.getTransComp("pmmo.levelDisplay", ListScreen.getTransComp("pmmo." + entry.getKey(), new Object[0]), entry.getValue() + "%").getString()).func_150255_a(XP.getSkillStyle(Skill.getSkill(entry.getKey()))).getString());
                    }
                    break;
                }
                case REQ_BIOME: {
                    if (reqMap.containsKey(listButton.regKey)) {
                        ListScreen.addLevelsToButton(listButton, reqMap.get(listButton.regKey), this.player, false);
                    }
                    Map<String, Double> biomeBonusMap = JsonConfig.data.get((Object)JType.XP_BONUS_BIOME).get(listButton.regKey);
                    Map<String, Double> biomeMobMultiplierMap = JsonConfig.data.get((Object)JType.BIOME_MOB_MULTIPLIER).get(listButton.regKey);
                    Map<String, Double> biomeEffectsMap = JsonConfig.data.get((Object)JType.BIOME_EFFECT_NEGATIVE).get(listButton.regKey);
                    if (biomeBonusMap != null) {
                        for (Map.Entry<String, Double> entry : biomeBonusMap.entrySet()) {
                            if (entry.getValue() > 0.0) {
                                arrayList.add(" " + ListScreen.getTransComp("pmmo.levelDisplay", ListScreen.getTransComp("pmmo." + entry.getKey(), new Object[0]), "+" + entry.getValue() + "%").func_150255_a(XP.getSkillStyle(Skill.getSkill(entry.getKey()))).func_150254_d());
                            }
                            if (!(entry.getValue() < 0.0)) continue;
                            arrayList.add(" " + ListScreen.getTransComp("pmmo.levelDisplay", ListScreen.getTransComp("pmmo." + entry.getKey(), new Object[0]), entry.getValue() + "%").func_150255_a(XP.getSkillStyle(Skill.getSkill(entry.getKey()))).func_150254_d());
                        }
                    }
                    if (biomeMobMultiplierMap != null) {
                        for (Map.Entry<String, Double> entry : biomeMobMultiplierMap.entrySet()) {
                            Style styleColor = new Style();
                            if (entry.getValue() > 1.0) {
                                styleColor = XP.textStyle.get("red");
                            } else if (entry.getValue() < 1.0) {
                                styleColor = XP.textStyle.get("green");
                            }
                            switch (entry.getKey()) {
                                case "damageBonus": {
                                    scaleText.add(" " + ListScreen.getTransComp("pmmo.enemyScaleDamage", DP.dp(entry.getValue() * 100.0)).func_150255_a(styleColor).func_150254_d());
                                    break;
                                }
                                case "hpBonus": {
                                    scaleText.add(" " + ListScreen.getTransComp("pmmo.enemyScaleHp", DP.dp(entry.getValue() * 100.0)).func_150255_a(styleColor).func_150254_d());
                                    break;
                                }
                                case "speedBonus": {
                                    scaleText.add(" " + ListScreen.getTransComp("pmmo.enemyScaleSpeed", DP.dp(entry.getValue() * 100.0)).func_150255_a(styleColor).func_150254_d());
                                }
                            }
                        }
                    }
                    if (biomeEffectsMap == null) break;
                    for (Map.Entry<String, Double> entry : biomeEffectsMap.entrySet()) {
                        Effect effect;
                        if (!ForgeRegistries.POTIONS.containsKey(XP.getResLoc(entry.getKey())) || (effect = (Effect)ForgeRegistries.POTIONS.getValue(XP.getResLoc(entry.getKey()))) == null) continue;
                        arrayList2.add(" " + ListScreen.getTransComp(effect.func_199286_c().func_150254_d() + " " + (int)(entry.getValue() + 1.0), new Object[0]).func_150255_a(XP.textStyle.get("red")).func_150254_d());
                    }
                    break;
                }
                case INFO_ORE: 
                case INFO_LOG: 
                case INFO_PLANT: 
                case INFO_SMELT: 
                case INFO_COOK: 
                case INFO_BREW: {
                    listButton.text.add("");
                    Map<String, Double> breakMap = JsonConfig.data.get((Object)JType.REQ_BREAK).get(listButton.regKey);
                    Map<String, Double> infoMap = XP.getReqMap(listButton.regKey, this.jType);
                    ArrayList<String> infoText = new ArrayList<String>();
                    String transKey = "pmmo." + this.jType.toString().replace("info_", "") + "ExtraDrop";
                    double extraDroppedPerLevel = infoMap.get("extraChance") / 100.0;
                    double extraDropped = XP.getExtraChance(this.player.func_110124_au(), listButton.regKey, this.jType, true) / 100.0;
                    if (extraDropped <= 0.0) {
                        infoText.add(ListScreen.getTransComp(transKey, DP.dp(extraDropped)).func_150255_a(XP.textStyle.get("red")).func_150254_d());
                    } else {
                        infoText.add(ListScreen.getTransComp(transKey, DP.dp(extraDropped)).func_150255_a(XP.textStyle.get("green")).func_150254_d());
                    }
                    if (extraDroppedPerLevel <= 0.0) {
                        infoText.add(ListScreen.getTransComp("pmmo.extraPerLevel", DP.dpCustom(extraDroppedPerLevel, 4)).func_150255_a(XP.textStyle.get("red")).func_150254_d());
                    } else {
                        infoText.add(ListScreen.getTransComp("pmmo.extraPerLevel", DP.dpCustom(extraDroppedPerLevel, 4)).func_150255_a(XP.textStyle.get("green")).func_150254_d());
                    }
                    if (infoText.size() > 0) {
                        listButton.text.addAll(infoText);
                    }
                    if (breakMap == null || !this.jType.equals((Object)JType.INFO_ORE) && !this.jType.equals((Object)JType.INFO_LOG) && !this.jType.equals((Object)JType.INFO_PLANT)) break;
                    if (XP.checkReq(this.player, listButton.regKey, JType.REQ_BREAK)) {
                        listButton.text.add(ListScreen.getTransComp("pmmo.break", new Object[0]).func_150255_a(XP.textStyle.get("green")).func_150254_d());
                    } else {
                        listButton.text.add(ListScreen.getTransComp("pmmo.break", new Object[0]).func_150255_a(XP.textStyle.get("red")).func_150254_d());
                    }
                    ListScreen.addLevelsToButton(listButton, breakMap, this.player, false);
                    break;
                }
                case XP_BONUS_WORN: {
                    listButton.text.add("");
                    ListScreen.addPercentageToButton(listButton, reqMap.get(listButton.regKey), XP.checkReq(this.player, listButton.regKey, JType.REQ_WEAR));
                    break;
                }
                case XP_BONUS_HELD: {
                    listButton.text.add("");
                    ListScreen.addPercentageToButton(listButton, reqMap.get(listButton.regKey), true);
                    break;
                }
                case XP_VALUE_BREED: 
                case XP_VALUE_TAME: 
                case XP_VALUE_SMELT: 
                case XP_VALUE_COOK: 
                case XP_VALUE_BREW: {
                    ListScreen.addXpToButton(listButton, reqMap.get(listButton.regKey));
                    break;
                }
                case XP_VALUE_BREAK: {
                    ListScreen.addXpToButton(listButton, reqMap.get(listButton.regKey), JType.REQ_BREAK, this.player);
                    break;
                }
                case XP_VALUE_CRAFT: {
                    ListScreen.addXpToButton(listButton, reqMap.get(listButton.regKey), JType.REQ_CRAFT, this.player);
                    break;
                }
                case XP_VALUE_GROW: {
                    ListScreen.addXpToButton(listButton, reqMap.get(listButton.regKey), JType.REQ_PLACE, this.player);
                    break;
                }
                case FISH_ENCHANT_POOL: {
                    double curChance;
                    Map<String, Double> enchantMap = reqMap.get(listButton.regKey);
                    double fishLevel = Skill.FISHING.getLevelDecimal(this.player);
                    double levelReq = enchantMap.get("levelReq");
                    double chancePerLevel = enchantMap.get("chancePerLevel");
                    double maxChance = enchantMap.get("maxChance");
                    double maxLevel = (int)enchantMap.get("maxLevel").doubleValue();
                    double levelsPerTier = enchantMap.get("levelPerLevel");
                    double maxLevelAvailable = levelsPerTier == 0.0 ? maxLevel : Math.floor((fishLevel - levelReq) / levelsPerTier);
                    if (maxLevelAvailable < 0.0) {
                        maxLevelAvailable = 0.0;
                    }
                    if (maxLevelAvailable > maxLevel) {
                        maxLevelAvailable = maxLevel;
                    }
                    if ((curChance = (fishLevel - levelReq) * chancePerLevel) > maxChance) {
                        curChance = maxChance;
                    }
                    if (curChance < 0.0) {
                        curChance = 0.0;
                    }
                    listButton.unlocked = maxLevelAvailable > 0.0;
                    Style color = XP.textStyle.get(listButton.unlocked ? "green" : "red");
                    listButton.text.add("");
                    listButton.text.add(" " + ListScreen.getTransComp("pmmo.currentChance", DP.dpSoft(curChance)).func_150255_a(color).func_150254_d());
                    listButton.text.add(" " + ListScreen.getTransComp("pmmo.startLevel", DP.dpSoft(levelReq)).func_150255_a(color).func_150254_d());
                    listButton.text.add(" " + ListScreen.getTransComp("pmmo.maxEnchantLevel", (int)maxLevelAvailable).func_150255_a(color).func_150254_d());
                    listButton.text.add("");
                    listButton.text.add(" " + ListScreen.getTransComp("pmmo.chancePerLevel", DP.dpSoft(chancePerLevel)).func_150254_d());
                    if (maxLevel > 1.0) {
                        listButton.text.add(" " + ListScreen.getTransComp("pmmo.levelsPerTier", DP.dpSoft(levelsPerTier)).func_150254_d());
                    }
                    listButton.text.add(" " + ListScreen.getTransComp("pmmo.maxEnchantLevel", (int)maxLevel).func_150254_d());
                    break;
                }
                case REQ_KILL: {
                    Map<String, Double> killXpMap = JsonConfig.data.get((Object)JType.REQ_KILL).get(listButton.regKey);
                    Map<String, Double> rareDropMap = JsonConfig.data.get((Object)JType.MOB_RARE_DROP).get(listButton.regKey);
                    listButton.unlocked = XP.checkReq(this.player, listButton.regKey, this.jType);
                    Style color = XP.textStyle.get(listButton.unlocked ? "green" : "red");
                    if (reqMap.containsKey(listButton.regKey)) {
                        listButton.text.add("");
                        listButton.text.add(ListScreen.getTransComp("pmmo.toHarm", new Object[0]).func_150255_a(color).func_150254_d());
                        ListScreen.addLevelsToButton(listButton, reqMap.get(listButton.regKey), this.player, false);
                    }
                    listButton.text.add("");
                    listButton.text.add(ListScreen.getTransComp("pmmo.xpValue", new Object[0]).func_150255_a(color).func_150254_d());
                    if (killXpMap != null) {
                        ListScreen.addXpToButton(listButton, killXpMap, this.jType, this.player);
                    } else if (listButton.entity instanceof AnimalEntity) {
                        listButton.text.add(" " + ListScreen.getTransComp("pmmo.xpDisplay", ListScreen.getTransComp("pmmo.hunter", new Object[0]), DP.dpSoft(Config.forgeConfig.passiveMobHunterXp.get())).func_150255_a(color).func_150254_d());
                    } else if (listButton.entity instanceof MobEntity) {
                        listButton.text.add(" " + ListScreen.getTransComp("pmmo.xpDisplay", ListScreen.getTransComp("pmmo.slayer", new Object[0]), DP.dpSoft(Config.forgeConfig.aggresiveMobSlayerXp.get())).func_150255_a(color).func_150254_d());
                    }
                    if (rareDropMap == null) break;
                    listButton.text.add("");
                    listButton.text.add(ListScreen.getTransComp("pmmo.rareDrops", new Object[0]).func_150255_a(color).func_150254_d());
                    for (Map.Entry<String, Double> entry : rareDropMap.entrySet()) {
                        listButton.text.add(" " + new StringTextComponent(ListScreen.getTransComp(XP.getItem(entry.getKey()).func_77658_a(), new Object[0]).func_150254_d() + ": " + ListScreen.getTransComp("pmmo.dropChance", DP.dpSoft(entry.getValue())).func_150254_d()).func_150255_a(color).func_150254_d());
                    }
                    break;
                }
                case FISH_POOL: {
                    Map<String, Double> fishPoolMap = reqMap.get(listButton.regKey);
                    double level = Skill.FISHING.getLevelDecimal(this.player);
                    double weight = XP.getWeight((int)level, fishPoolMap);
                    listButton.unlocked = weight > 0.0;
                    Style color = XP.textStyle.get(listButton.unlocked ? "green" : "red");
                    this.minCount = (int)fishPoolMap.get("minCount").doubleValue();
                    this.maxCount = (int)fishPoolMap.get("maxCount").doubleValue();
                    listButton.text.add("");
                    listButton.text.add(" " + ListScreen.getTransComp("pmmo.currentWeight", weight).func_150255_a(color).func_150254_d());
                    if (this.minCount == this.maxCount) {
                        listButton.text.add(" " + ListScreen.getTransComp("pmmo.caughtAmount", this.minCount).func_150255_a(color).func_150254_d());
                    } else {
                        listButton.text.add(" " + ListScreen.getTransComp("pmmo.caughtAmountRange", this.minCount, this.maxCount).func_150255_a(color).func_150254_d());
                    }
                    listButton.text.add(" " + ListScreen.getTransComp("pmmo.xpEach", DP.dpSoft((double)fishPoolMap.get("xp"))).func_150255_a(color).func_150254_d());
                    if (listButton.itemStack.func_77956_u()) {
                        if (fishPoolMap.get("enchantLevelReq") <= level && listButton.unlocked) {
                            listButton.text.add(" " + ListScreen.getTransComp("pmmo.enchantLevelReq", DP.dpSoft((double)fishPoolMap.get("enchantLevelReq"))).func_150255_a(XP.textStyle.get("green")).func_150254_d());
                        } else {
                            listButton.text.add(" " + ListScreen.getTransComp("pmmo.enchantLevelReq", DP.dpSoft((double)fishPoolMap.get("enchantLevelReq"))).func_150255_a(XP.textStyle.get("red")).func_150254_d());
                        }
                    }
                    listButton.text.add("");
                    listButton.text.add(" " + ListScreen.getTransComp("pmmo.startWeight", DP.dpSoft((double)fishPoolMap.get("startWeight"))).func_150254_d());
                    listButton.text.add(" " + ListScreen.getTransComp("pmmo.startLevel", DP.dpSoft((double)fishPoolMap.get("startLevel"))).func_150254_d());
                    listButton.text.add(" " + ListScreen.getTransComp("pmmo.endWeight", DP.dpSoft((double)fishPoolMap.get("endWeight"))).func_150254_d());
                    listButton.text.add(" " + ListScreen.getTransComp("pmmo.endLevel", DP.dpSoft((double)fishPoolMap.get("endLevel"))).func_150254_d());
                    break;
                }
                case REQ_WEAR: 
                case REQ_TOOL: 
                case REQ_WEAPON: 
                case REQ_USE: 
                case REQ_BREAK: 
                case REQ_CRAFT: 
                case REQ_PLACE: {
                    listButton.text.add("");
                    listButton.text.add(ListScreen.getTransComp("pmmo." + this.jType.toString().replace("req_", ""), new Object[0]).func_150255_a(XP.textStyle.get(XP.checkReq(this.player, listButton.regKey, this.jType) ? "green" : "red")).func_150254_d());
                    ListScreen.addLevelsToButton(listButton, reqMap.get(listButton.regKey), this.player, false);
                    break;
                }
                case SALVAGE: 
                case SALVAGE_FROM: {
                    Style color;
                    if (reqMap2 == null) {
                        return;
                    }
                    int smithLevel = (int)Skill.SMITHING.getLevelDecimal(this.player);
                    listButton.unlocked = false;
                    int i = 0;
                    ArrayList<String> toItemsList = new ArrayList<String>(reqMap2.get(listButton.regKey).keySet());
                    toItemsList.sort(Comparator.comparingInt(key -> (int)((Double)((Map)((Map)reqMap2.get(button.regKey)).get(key)).get("levelReq")).doubleValue()));
                    for (String salvageToItemKey : toItemsList) {
                        Map<String, Double> salvageToItemMap = reqMap2.get(listButton.regKey).get(salvageToItemKey);
                        String outputName = ListScreen.getTransComp(XP.getItem(salvageToItemKey).func_77658_a(), new Object[0]).getString();
                        double levelReq = salvageToItemMap.get("levelReq");
                        double salvageMax = salvageToItemMap.get("salvageMax");
                        double baseChance = salvageToItemMap.get("baseChance");
                        double chancePerLevel = salvageToItemMap.get("chancePerLevel");
                        double maxChance = salvageToItemMap.get("maxChance");
                        double xpPerItem = salvageToItemMap.get("xpPerItem");
                        double chance = baseChance + chancePerLevel * ((double)smithLevel - levelReq);
                        if (chance < 0.0) {
                            chance = 0.0;
                        }
                        if (chance > maxChance) {
                            chance = maxChance;
                        }
                        color = XP.textStyle.get(chance > 0.0 ? "green" : "red");
                        if (chance > 0.0 && (double)smithLevel >= levelReq) {
                            listButton.unlocked = true;
                        }
                        if (i++ == 0) {
                            listButton.text.add(new TranslationTextComponent(this.jType == JType.SALVAGE ? "pmmo.salvagesInto" : "pmmo.canBeSalvagedFrom", new Object[0]).getString());
                        }
                        listButton.text.add(new StringTextComponent("____________________________").getString());
                        listButton.text.add(new StringTextComponent("").getString());
                        listButton.text.add(new StringTextComponent(ListScreen.getTransComp(this.jType == JType.SALVAGE ? "pmmo.valueValue" : "pmmo.valueFromValue", DP.dpSoft(salvageMax), outputName).getString()).func_150255_a(color).getString());
                        listButton.text.add(ListScreen.getTransComp("pmmo.canBeSalvagedFromLevel", DP.dpSoft(levelReq)).func_150255_a(color).getString());
                        listButton.text.add(new StringTextComponent("").getString());
                        listButton.text.add(ListScreen.getTransComp("pmmo.xpPerItem", DP.dpSoft(xpPerItem)).func_150255_a(color).getString());
                        listButton.text.add(ListScreen.getTransComp("pmmo.chancePerItem", DP.dpSoft(chance)).func_150255_a(color).getString());
                        listButton.text.add(new StringTextComponent("").getString());
                        listButton.text.add(ListScreen.getTransComp("pmmo.baseChance", DP.dpSoft(baseChance)).func_150255_a(color).getString());
                        listButton.text.add(ListScreen.getTransComp("pmmo.chancePerLevel", DP.dpSoft(chancePerLevel)).func_150255_a(color).getString());
                        listButton.text.add(ListScreen.getTransComp("pmmo.maxChancePerItem", DP.dpSoft(maxChance)).func_150255_a(color).getString());
                    }
                    break;
                }
                case TREASURE: 
                case TREASURE_FROM: {
                    if (reqMap2 == null) {
                        return;
                    }
                    int excavationLevel = (int)Skill.EXCAVATION.getLevelDecimal(this.player);
                    listButton.unlocked = false;
                    int i = 0;
                    ArrayList<String> toItemsList = new ArrayList<String>(reqMap2.get(listButton.regKey).keySet());
                    toItemsList.sort(Comparator.comparingDouble(key -> BlockBrokenHandler.getTreasureItemChance(excavationLevel, (Map)((Map)reqMap2.get(button.regKey)).get(key))));
                    for (String treasureToItemKey : toItemsList) {
                        Map<String, Double> treasureToItemMap = reqMap2.get(listButton.regKey).get(treasureToItemKey);
                        String outputName = ListScreen.getTransComp(XP.getItem(treasureToItemKey).func_77658_a(), new Object[0]).getString();
                        int startLevel = (int)treasureToItemMap.get("startLevel").doubleValue();
                        int endLevel = (int)treasureToItemMap.get("endLevel").doubleValue();
                        double startChance = treasureToItemMap.get("startChance");
                        double endChance = treasureToItemMap.get("endChance");
                        double xpPerItem = treasureToItemMap.get("xpPerItem");
                        int minCount = (int)treasureToItemMap.get("minCount").doubleValue();
                        int maxCount = (int)treasureToItemMap.get("maxCount").doubleValue();
                        double chance = BlockBrokenHandler.getTreasureItemChance(excavationLevel, treasureToItemMap);
                        Style color = XP.textStyle.get(chance > 0.0 ? "green" : "red");
                        if (chance > 0.0) {
                            listButton.unlocked = true;
                        }
                        if (i++ == 0) {
                            listButton.text.add(new TranslationTextComponent(this.jType == JType.TREASURE ? "pmmo.containsTreasure" : "pmmo.treasureFrom", new Object[0]).getString());
                        }
                        listButton.text.add(new StringTextComponent("____________________________").getString());
                        listButton.text.add(new StringTextComponent("").getString());
                        listButton.text.add(new StringTextComponent(outputName).func_150255_a(color).getString());
                        listButton.text.add(ListScreen.getTransComp("pmmo.xpPerItem", DP.dpSoft(xpPerItem)).func_150255_a(color).getString());
                        listButton.text.add(ListScreen.getTransComp("pmmo.chancePerItem", DP.dpSoft(chance)).func_150255_a(color).getString());
                        listButton.text.add(new StringTextComponent("").getString());
                        listButton.text.add(ListScreen.getTransComp("pmmo.minCount", minCount).func_150255_a(color).getString());
                        listButton.text.add(ListScreen.getTransComp("pmmo.maxCount", maxCount).func_150255_a(color).getString());
                        listButton.text.add(new StringTextComponent("").getString());
                        listButton.text.add(ListScreen.getTransComp("pmmo.startChance", startChance).func_150255_a(color).getString());
                        listButton.text.add(ListScreen.getTransComp("pmmo.startLevel", startLevel).func_150255_a(color).getString());
                        listButton.text.add(ListScreen.getTransComp("pmmo.endChance", endChance).func_150255_a(color).getString());
                        listButton.text.add(ListScreen.getTransComp("pmmo.endLevel", endLevel).func_150255_a(color).getString());
                    }
                    break;
                }
                case STATS: {
                    Skill skill = Skill.getSkill(listButton.regKey);
                    double curXp = XP.getOfflineXp(skill, this.uuid);
                    double nextXp = XP.xpAtLevel(XP.levelAtXp(curXp) + 1);
                    listButton.title = ListScreen.getTransComp("pmmo.levelDisplay", ListScreen.getTransComp("pmmo." + listButton.regKey, new Object[0]), DP.dpSoft(XP.levelAtXpDecimal(curXp))).func_150255_a(XP.getSkillStyle(Skill.getSkill(listButton.regKey))).func_150254_d();
                    listButton.text.add(" " + ListScreen.getTransComp("pmmo.currentXp", DP.dpSoft(curXp)).func_150254_d());
                    if ((double)skill.getLevel(this.player) == Config.getConfig("maxLevel")) break;
                    listButton.text.add(" " + ListScreen.getTransComp("pmmo.nextLevelXp", DP.dpSoft(nextXp)).func_150254_d());
                    listButton.text.add(" " + ListScreen.getTransComp("pmmo.RemainderXp", DP.dpSoft(nextXp - curXp)).func_150254_d());
                    break;
                }
            }
            if (arrayList.size() > 0) {
                listButton.text.add("");
                arrayList.sort(Comparator.comparingInt(ListScreen::getTextInt).reversed());
                listButton.text.add(ListScreen.getTransComp("pmmo.xpModifiers", new Object[0]).func_150254_d());
                listButton.text.addAll(arrayList);
            }
            if (scaleText.size() > 0) {
                if (arrayList.size() > 0) {
                    listButton.text.add("");
                }
                scaleText.sort(Comparator.comparingInt(ListScreen::getTextInt).reversed());
                listButton.text.add(ListScreen.getTransComp("pmmo.enemyScaling", new Object[0]).func_150254_d());
                listButton.text.addAll(scaleText);
            }
            if (arrayList2.size() > 0) {
                if (arrayList.size() > 0 || scaleText.size() > 0) {
                    listButton.text.add("");
                }
                arrayList2.sort(Comparator.comparingInt(ListScreen::getTextInt).reversed());
                listButton.text.add(ListScreen.getTransComp("pmmo.biomeEffects", new Object[0]).func_150255_a(XP.textStyle.get("red")).func_150254_d());
                listButton.text.addAll(arrayList2);
            }
            switch (this.jType) {
                case INFO_ORE: 
                case INFO_LOG: 
                case INFO_PLANT: 
                case XP_VALUE_BREAK: {
                    listButton.unlocked = XP.checkReq(this.player, listButton.regKey, JType.REQ_BREAK);
                    break;
                }
                case XP_BONUS_WORN: {
                    listButton.unlocked = XP.checkReq(this.player, listButton.regKey, JType.REQ_WEAR);
                    break;
                }
                case FISH_POOL: {
                    break;
                }
                case REQ_BIOME: 
                case REQ_WEAR: 
                case REQ_TOOL: 
                case REQ_WEAPON: 
                case REQ_USE: 
                case REQ_BREAK: 
                case REQ_CRAFT: 
                case REQ_PLACE: {
                    listButton.unlocked = XP.checkReq(this.player, listButton.regKey, this.jType);
                    break;
                }
                case XP_VALUE_CRAFT: {
                    listButton.unlocked = XP.checkReq(this.player, listButton.regKey, JType.REQ_CRAFT);
                    break;
                }
                case XP_VALUE_GROW: {
                    listButton.unlocked = XP.checkReq(this.player, listButton.regKey, JType.REQ_PLACE);
                    break;
                }
            }
        }
        switch (this.jType) {
            case INFO_ORE: 
            case INFO_LOG: 
            case INFO_PLANT: 
            case XP_VALUE_BREAK: {
                this.listButtons.sort(Comparator.comparingInt(b -> XP.getHighestReq(b.regKey, JType.REQ_BREAK)));
                break;
            }
            case REQ_WEAR: {
                this.listButtons.sort(Comparator.comparingInt(b -> XP.getHighestReq(b.regKey, JType.REQ_WEAR)));
                break;
            }
            case SALVAGE: 
            case SALVAGE_FROM: {
                this.listButtons.sort(Comparator.comparingDouble(b -> ListScreen.getLowestSalvageReq((Map)reqMap2.get(b.regKey))));
                break;
            }
            case STATS: {
                this.listButtons.sort(Comparator.comparingDouble(b -> XP.getOfflineXp(Skill.getSkill(((ListButton)((Object)((Object)((Object)b)))).regKey), this.uuid)).reversed());
                break;
            }
            default: {
                this.listButtons.sort(Comparator.comparingInt(b -> XP.getHighestReq(b.regKey, this.jType)));
            }
        }
        switch (this.jType) {
            case XP_VALUE_BREED: {
                ListButton otherAnimalsBreedButton = new ListButton(0, 0, 3, 20, "pmmo.otherAnimals", this.jType, "", button -> ((ListButton)button).clickActionGlossary());
                otherAnimalsBreedButton.text.add(" " + ListScreen.getTransComp("pmmo.xpDisplay", ListScreen.getTransComp("pmmo.farming", new Object[0]), DP.dpSoft(Config.forgeConfig.defaultBreedingXp.get())).func_150255_a(greenColor).func_150254_d());
                this.listButtons.add(otherAnimalsBreedButton);
                break;
            }
            case XP_VALUE_TAME: {
                ListButton listButton = new ListButton(0, 0, 3, 21, "pmmo.otherAnimals", this.jType, "", button -> ((ListButton)button).clickActionGlossary());
                listButton.text.add(" " + ListScreen.getTransComp("pmmo.xpDisplay", ListScreen.getTransComp("pmmo.taming", new Object[0]), DP.dpSoft(Config.forgeConfig.defaultTamingXp.get())).func_150255_a(greenColor).func_150254_d());
                this.listButtons.add(listButton);
                break;
            }
            case REQ_KILL: {
                ListButton listButton = new ListButton(0, 0, 3, 26, "pmmo.otherAggresiveMobs", this.jType, "", button -> ((ListButton)button).clickActionGlossary());
                listButton.text.add(" " + ListScreen.getTransComp("pmmo.xpDisplay", ListScreen.getTransComp("pmmo.slayer", new Object[0]), DP.dpSoft(Config.forgeConfig.aggresiveMobSlayerXp.get())).func_150255_a(greenColor).func_150254_d());
                this.listButtons.add(listButton);
                ListButton listButton2 = new ListButton(0, 0, 3, 26, "pmmo.otherPassiveMobs", this.jType, "", button -> ((ListButton)button).clickActionGlossary());
                listButton2.text.add(" " + ListScreen.getTransComp("pmmo.xpDisplay", ListScreen.getTransComp("pmmo.hunter", new Object[0]), DP.dpSoft(Config.forgeConfig.passiveMobHunterXp.get())).func_150255_a(greenColor).func_150254_d());
                this.listButtons.add(listButton2);
                break;
            }
            case XP_VALUE_CRAFT: {
                ListButton listButton = new ListButton(0, 0, 3, 22, "pmmo.otherCrafts", this.jType, "", button -> ((ListButton)button).clickActionGlossary());
                listButton.text.add(" " + ListScreen.getTransComp("pmmo.xpDisplay", ListScreen.getTransComp("pmmo.crafting", new Object[0]), DP.dpSoft(Config.forgeConfig.defaultCraftingXp.get())).func_150255_a(greenColor).func_150254_d());
                this.listButtons.add(listButton);
            }
        }
        this.scrollPanel = new ListScrollPanel(Minecraft.func_71410_x(), this.boxWidth - 40, this.boxHeight - 21, this.scrollY, this.scrollX, this.jType, this.player, this.listButtons);
        if (!MainScreen.scrollAmounts.containsKey((Object)this.jType)) {
            MainScreen.scrollAmounts.put(this.jType, 0);
        }
        this.scrollPanel.setScroll(MainScreen.scrollAmounts.get((Object)this.jType));
        this.children.add((IGuiEventListener)this.scrollPanel);
        this.addButton((Widget)exitButton);
    }

    private static void addLevelsToButton(ListButton button, Map<String, Double> map, PlayerEntity player, boolean ignoreReq) {
        ArrayList<String> levelsToAdd = new ArrayList<String>();
        for (Map.Entry<String, Double> inEntry : map.entrySet()) {
            if (!ignoreReq && Skill.getSkill(inEntry.getKey()).getLevelDecimal(player) < inEntry.getValue()) {
                levelsToAdd.add(" " + ListScreen.getTransComp("pmmo.levelDisplay", ListScreen.getTransComp("pmmo." + inEntry.getKey(), new Object[0]), DP.dpSoft((double)inEntry.getValue())).func_150255_a(XP.textStyle.get("red")).func_150254_d());
                continue;
            }
            levelsToAdd.add(" " + ListScreen.getTransComp("pmmo.levelDisplay", ListScreen.getTransComp("pmmo." + inEntry.getKey(), new Object[0]), DP.dpSoft((double)inEntry.getValue())).func_150255_a(XP.textStyle.get("green")).func_150254_d());
        }
        levelsToAdd.sort(Comparator.comparingInt(ListScreen::getTextInt).reversed());
        button.text.addAll(levelsToAdd);
    }

    private static void addXpToButton(ListButton button, Map<String, Double> map) {
        ArrayList<String> xpToAdd = new ArrayList<String>();
        for (Map.Entry<String, Double> inEntry : map.entrySet()) {
            xpToAdd.add(" " + ListScreen.getTransComp("pmmo.xpDisplay", ListScreen.getTransComp("pmmo." + inEntry.getKey(), new Object[0]), DP.dpSoft((double)inEntry.getValue())).func_150255_a(XP.textStyle.get("green")).func_150254_d());
        }
        xpToAdd.sort(Comparator.comparingInt(ListScreen::getTextInt).reversed());
        button.text.addAll(xpToAdd);
    }

    private static void addXpToButton(ListButton button, Map<String, Double> map, JType jType, PlayerEntity player) {
        ArrayList<String> xpToAdd = new ArrayList<String>();
        for (Map.Entry<String, Double> inEntry : map.entrySet()) {
            xpToAdd.add(" " + ListScreen.getTransComp("pmmo.xpDisplay", ListScreen.getTransComp("pmmo." + inEntry.getKey(), new Object[0]), DP.dpSoft((double)inEntry.getValue())).func_150255_a(XP.textStyle.get(XP.checkReq(player, button.regKey, jType) ? "green" : "red")).func_150254_d());
        }
        xpToAdd.sort(Comparator.comparingInt(ListScreen::getTextInt).reversed());
        button.text.addAll(xpToAdd);
    }

    private static void addPercentageToButton(ListButton button, Map<String, Double> map, boolean metReq) {
        ArrayList<String> levelsToAdd = new ArrayList<String>();
        for (Map.Entry<String, Double> inEntry : map.entrySet()) {
            double value = inEntry.getValue();
            if (metReq) {
                if (value > 0.0) {
                    levelsToAdd.add(" " + ListScreen.getTransComp("pmmo.levelDisplay", ListScreen.getTransComp("pmmo." + inEntry.getKey(), new Object[0]), "+" + value + "%").func_150255_a(XP.textStyle.get("green")).func_150254_d());
                    continue;
                }
                if (!(value < 0.0)) continue;
                levelsToAdd.add(" " + ListScreen.getTransComp("pmmo.levelDisplay", ListScreen.getTransComp("pmmo." + inEntry.getKey(), new Object[0]), value + "%").func_150255_a(XP.textStyle.get("red")).func_150254_d());
                continue;
            }
            levelsToAdd.add(" " + ListScreen.getTransComp("pmmo.levelDisplay", ListScreen.getTransComp("pmmo." + inEntry.getKey(), new Object[0]), value + "%").func_150255_a(XP.textStyle.get("red")).func_150254_d());
        }
        levelsToAdd.sort(Comparator.comparingInt(ListScreen::getTextInt).reversed());
        button.text.addAll(levelsToAdd);
    }

    private static int getTextInt(String comp) {
        String number = comp.replaceAll("\\D+", "");
        if (number.length() > 0 && !Double.isNaN(Double.parseDouble(number))) {
            return (int)Double.parseDouble(number);
        }
        return 0;
    }

    private static int getReqCount(String regKey, JType jType) {
        Map<String, Double> map = XP.getReqMap(regKey, jType);
        if (map == null) {
            return 0;
        }
        return map.size();
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(1);
        if (this.jType.equals((Object)JType.STATS)) {
            this.title = ListScreen.getTransComp("pmmo.playerStats", XP.playerNames.get(this.uuid));
        }
        if (this.font.func_78256_a(this.title.getString()) > 220) {
            this.drawCenteredString(this.font, this.title.func_150254_d(), this.sr.func_198107_o() / 2, this.y - 10, 0xFFFFFF);
        } else {
            this.drawCenteredString(this.font, this.title.func_150254_d(), this.sr.func_198107_o() / 2, this.y - 5, 0xFFFFFF);
        }
        this.x = this.sr.func_198107_o() / 2 - this.boxWidth / 2;
        this.y = this.sr.func_198087_p() / 2 - this.boxHeight / 2;
        this.scrollPanel.render(mouseX, mouseY, partialTicks);
        this.accumulativeHeight = 0;
        this.buttonsSize = this.listButtons.size();
        super.render(mouseX, mouseY, partialTicks);
        for (ListButton button : this.listButtons) {
            this.buttonX = mouseX - button.x;
            this.buttonY = mouseY - button.y;
            if (mouseY >= this.scrollPanel.getTop() && mouseY <= this.scrollPanel.getBottom() && this.buttonX >= 0 && this.buttonX < 32 && this.buttonY >= 0 && this.buttonY < 32) {
                if (this.jType.equals((Object)JType.REQ_BIOME) || this.jType.equals((Object)JType.REQ_KILL) || this.jType.equals((Object)JType.XP_VALUE_BREED) || this.jType.equals((Object)JType.XP_VALUE_TAME) || this.jType.equals((Object)JType.DIMENSION) || this.jType.equals((Object)JType.FISH_ENCHANT_POOL) || this.jType.equals((Object)JType.STATS) || button.regKey.equals("pmmo.otherCrafts")) {
                    this.renderTooltip(button.title, mouseX, mouseY);
                } else if (button.itemStack != null) {
                    this.renderTooltip(button.itemStack, mouseX, mouseY);
                }
            }
            this.accumulativeHeight += button.getHeight();
        }
        MainScreen.scrollAmounts.replace(this.jType, this.scrollPanel.getScroll());
    }

    public static double getLowestSalvageReq(Map<String, Map<String, Double>> map) {
        Integer lowestReq = null;
        for (Map.Entry<String, Map<String, Double>> entry : map.entrySet()) {
            int levelReq = (int)entry.getValue().get("levelReq").doubleValue();
            if (lowestReq != null && levelReq >= lowestReq) continue;
            lowestReq = levelReq;
        }
        return lowestReq.intValue();
    }

    public void renderBackground(int p_renderBackground_1_) {
        if (this.minecraft != null) {
            this.fillGradient(0, 0, this.width, this.height, 0x66222222, 0x66333333);
            MinecraftForge.EVENT_BUS.post((Event)new GuiScreenEvent.BackgroundDrawnEvent((Screen)this));
        }
        this.boxHeight = 256;
        this.boxWidth = 256;
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this.box);
        this.blit(this.x, this.y, 0, 0, this.boxWidth, this.boxHeight);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scroll) {
        this.accumulativeHeight = 0;
        for (ListButton listButton : this.listButtons) {
            this.accumulativeHeight += listButton.getHeight();
            if (this.accumulativeHeight <= this.scrollPanel.getBottom() - this.scrollPanel.getTop()) continue;
            this.scrollPanel.mouseScrolled(mouseX, mouseY, scroll);
            break;
        }
        return super.mouseScrolled(mouseX, mouseY, scroll);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (button == 1) {
            exitButton.onPress();
            return true;
        }
        for (ListButton a : this.listButtons) {
            int buttonX = (int)mouseX - a.x;
            int buttonY = (int)mouseY - a.y;
            if (!(mouseY >= (double)this.scrollPanel.getTop()) || !(mouseY <= (double)this.scrollPanel.getBottom()) || buttonX < 0 || buttonX >= 32 || buttonY < 0 || buttonY >= 32) continue;
            a.onClick(mouseX, mouseY);
        }
        this.scrollPanel.mouseClicked(mouseX, mouseY, button);
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        this.scrollPanel.mouseReleased(mouseX, mouseY, button);
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        this.scrollPanel.mouseDragged(mouseX, mouseY, button, deltaX, deltaY);
        return super.mouseDragged(mouseX, mouseY, button, deltaX, deltaY);
    }

    public static TranslationTextComponent getTransComp(String translationKey, Object ... args) {
        return new TranslationTextComponent(translationKey, args);
    }
}

